package undermind.micropacket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.MicroManager;
import undermind.intelligence.Hotspot;
import undermind.intelligence.RegionStatus;

import edu.berkeley.nlp.starcraft.util.UnitUtils;

public class TankSquad {
	double LAG_BUFFER = 3.0;
	int threatLevel = 0;
	//int siegednum = 0;
	double leap_frog_const = 0.9;
	TileTracker tile_tracker = new TileTracker();
	Set<TilePosition> barrier;
	TilePosition mostStaleTile;
	Map<Unit, HashSet<TilePosition>> tank_to_bartile_map;
	Set<TilePosition> tanks_siege_targets_positions = new HashSet<TilePosition>();
	
	M3chSquad msquad;
	Set<Unit> myTanks = new HashSet<Unit>();
	public TankSquad(M3chSquad mechSquad) {
		msquad = mechSquad;
	}
	public void addUnit(Unit u){
		myTanks.add(u);
	}
	public void removeUnit(Unit u){
		myTanks.remove(u);
	}
	
	void update_leapfrog_const(){
		for (Unit tank : myTanks){
			if (tank.getGroundWeaponCooldown() > 0){
				leap_frog_const = Math.sqrt(leap_frog_const+0.01);
			} else {
				if (Game.getInstance().getFrameCount() % 20 == 0){
					leap_frog_const = Math.max(0.0, leap_frog_const - 0.005);
				}
			}
		}
	}
	
	public void onFrame() {
		for (Unit t : myTanks) {
			Position position = t.getPosition();
			if (t.isLoaded() || position == Position.INVALID)
				return;
		}
		updateState();
		update_leapfrog_const();
		double buffer = Math.min(msquad.confidence, 1.0)*2;
		Game.getInstance().drawTextMap(new Position(getMedian().x(),getMedian().y()+20), "leap_frog "+leap_frog_const);
		Game.getInstance().drawTextMap(new Position(getMedian().x(),getMedian().y()+40), "buffer "+buffer);
		leapFrogMove();
	}
	

	void updateState(){
		barrier = tile_tracker.getBarrierTiles(getBarrierGoal(), myTanks);
		tile_tracker.drawTiles(barrier);
		//oldest tile of the barrier

		set_Ebay();
		tank_to_bartile_map = tile_tracker.tank_to_tile_map(barrier, myTanks);
	}
	
	private void set_Ebay() {
		Set<TilePosition> together = new HashSet<TilePosition>();
		together.addAll(barrier);
		together.addAll(tanks_siege_targets_positions);
		TilePosition oldest = tile_tracker.getOldest(together); 
		if (oldest != null){
			msquad.master.pleaseEbayHere = new Position(oldest);
		} else {
			msquad.master.pleaseEbayHere = msquad.getAverage();
		}
	}
	//TODO: pick a better barrier goal
	private TilePosition getBarrierGoal() {
		if (msquad.mover.pathToGoal != null && msquad.mover.pathToGoal.size() > 11){
			Game.getInstance().drawLineMap(new Position(msquad.mover.pathToGoal.get(10)), msquad.getAverage(), Color.ORANGE);
			return msquad.mover.pathToGoal.get(10);
		}
		if (msquad.goal != null){
			return new TilePosition(msquad.goal);
		}
		return null;
	}
	
	public Position getMedian(){
		return UnitUtils.medianPos(myTanks);
	}
	
	HashMap<Unit, HashSet<ROUnit>> tank_to_close_enemies(){
		HashMap<Unit, HashSet<ROUnit>> ret = new HashMap<Unit,HashSet<ROUnit>>();
		for (Unit tank : myTanks){
			HashSet<ROUnit> toAdd = new HashSet<ROUnit>();
			ret.put(tank, toAdd);
			for (ROUnit enemy : msquad.everyNearbyGroundUnits()){
				if (tank.getPosition().getDistance(enemy.getPosition()) < 500){
					toAdd.add(enemy);
				}
			}
		}
		return ret;
	}
	ArrayList<Unit> sorted_tank_by_distance_to_goal(){
		Map<Integer,HashSet<Unit>> crap = new HashMap<Integer,HashSet<Unit>>();
		ArrayList<Integer> crapp = new ArrayList<Integer>();
		for (Unit tank : myTanks){
			Integer key = (int) tank.getPosition().getDistance(msquad.goal);
			if (!crap.containsKey(key)){
				crap.put(key, new HashSet<Unit>());
			}
			crapp.add(key);
			crap.get(key).add(tank);
		}
		Integer[] crappp = new Integer[crapp.size()];
		for (int i = 0; i < crapp.size(); i++){
			crappp[i] = crapp.get(i);
		}
		Arrays.sort(crappp);
		ArrayList<Unit> ret = new ArrayList<Unit>();
		for (Integer i : crappp){
			for (Unit u : crap.get(i)){
				ret.add(u);
			}
		}
		return ret;
	}
	
	//Do the frog move!
	public void leapFrogMove(){
		HashMap<Unit, HashSet<ROUnit>> tank_enemy = tank_to_close_enemies();
		ArrayList<Unit> tank_rank = sorted_tank_by_distance_to_goal();
		for (Unit tank : myTanks){
			//if i am flanked by melee units, hard unsiege
			if (allTooClose(tank_enemy.get(tank),tank) || allMelee(tank_enemy.get(tank))){
				Game.getInstance().drawTextMap(tank.getPosition().add(0, 10), "1");
				siegeDown(tank);
				continue;
			}
			//if I have a closeby ranged enemy, hard siege up
			if(hardSiegeReasonable(tank, tank_enemy.get(tank))){
				Game.getInstance().drawTextMap(tank.getPosition().add(0, 10), "2");
				siegeUp(tank);
				continue;
			}
			//if none of the hard condition is true, it depends on the battlefield condition
			//suppose our constant is small enough, i.e. not a lot of battle, we 
			//try to leapfrog forward
			int rank = get_rank(tank, tank_rank);
			//if he is sufficiently (indicated by rank) in the back, try to go forward
			if (rank <= ((double) myTanks.size())*leap_frog_const && sufficientlyFar(tank)){
				Game.getInstance().drawTextMap(tank.getPosition().add(0, 10), "3");
				siegeUp(tank);
				continue;
			}
			//if he is not sufficiently in the back, indicated by rank, siege up
			else {
				Game.getInstance().drawTextMap(tank.getPosition().add(0, 10), "4");
				unsiege_and_move(tank, msquad.goal);
			}
		}
	}

	private boolean allMelee(HashSet<ROUnit> hashSet) {
		if (hashSet.size() == 0) return false;
		for (ROUnit rou : hashSet){
			if (rou.getGroundRange() > 3*32) return false;
		}
		return true;
	}
	private boolean sufficientlyFar(Unit tank) {
		return (tank.getPosition().getDistance(msquad.getAverage()) > 1.0 / (0.5 + msquad.confidence) * 200);
	}
	boolean shouldSiegeUnit(Unit tank, ROUnit enemy){
		//Game.getInstance().drawCircleMap(enemy.getLastKnownPosition(), enemy.getGroundRange(), Color.RED, false);
		//when confidence is good, i.e. < 0.5, the buffer becomes 1 or less, 
		//as a result, we siege right at the finge of the enemy. Otherwise we don't try to get too close
		double buffer = Math.min(msquad.confidence, 1.3)*(4+LAG_BUFFER)-1;
		
		double hit_radius = enemy.getType().diagonalLength();
		Position p = enemy.isVisible() ? enemy.getPosition() : enemy.getLastKnownPosition();
		//if he is too close, definitely don't siege
		if (tank.getDistance(p) < 5*32 || enemy.getGroundRange() < 3*32) return false;
		//otherwise, take a look at the other guy's attack range...
		//if it is a tank mode tank, use it's sieged mode range, otherwise, use normal range of what it is
		int range = enemy.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE) ? 12*32 : enemy.getGroundRange();
		//if enemy has inferior range, siege up so we can just hit him ;)
		if (range < 12*32){
			return tank.getDistance(p) <= 12*32+hit_radius;
		}
		//if enemy is of superior range, we should siege with a buffer...
		else if (tank.getDistance(p) <= 12*32+hit_radius*buffer){
			return true;
		}
		return false;
	}
	
	private ROUnit getClosest(Unit tank) {
		ROUnit ret = null;
		double dist = Integer.MAX_VALUE;
		for (ROUnit u : msquad.everyNearbyGroundUnits()){
			Position p = u.isVisible()? u.getPosition() : u.getLastKnownPosition();
			if (p.getDistance(tank.getPosition()) < dist){
				ret = u;
				dist = u.getPosition().getDistance(tank.getPosition());
			}
		}
		return ret;
	}
	
	private boolean hardSiegeReasonable(Unit tank, HashSet<ROUnit> hashSet) {
		double slack = -400*msquad.confidence+2000;
		//if we have nearby barrier tiles that are unsafe (i.e. too stale), siege up...
		boolean nearbyUnseenTilesSafe = tile_tracker.areTilesSafe(tank, tank_to_bartile_map, (int) Math.max(0,slack));
		if (!nearbyUnseenTilesSafe) return true;
		for (ROUnit u : hashSet){
			if (shouldSiegeUnit(tank,u)){
				Position p = u.isVisible() ? u.getPosition() : u.getLastKnownPosition();
				tanks_siege_targets_positions.add(new TilePosition(p));
				Game.getInstance().drawLineMap(tank.getPosition(),u.getLastKnownPosition(),Color.RED);
				return true;
			}
		}
		return false;
	}
	private boolean allTooClose(HashSet<ROUnit> enemy, Unit tank) {
		if (enemy.size() == 0) return false;
		boolean ret = true;
		for (ROUnit ene : enemy){
			Position p = ene.isVisible() ? ene.getPosition() : ene.getLastKnownPosition();
			if (p.getDistance(tank.getPosition()) > 96){
				ret = false;
			}
		}
		return ret;
	}
	private void unsiege_and_move(Unit tank, Position p) {
		if (tank.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)){
			siegeDown(tank);
		} else {
			tank.attackMove(p);
		}
	}
	private int get_rank(Unit tank, ArrayList<Unit> tank_rank) {
		for (int i = 0; i < tank_rank.size(); i++){
			if (tank == tank_rank.get(i)) {
				//Game.getInstance().drawTextMap(tank.getPosition(), ""+i);
				return i;
			}
		}
		return 0;
	}
	private void siegeUp(Unit u){
		if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)){
			u.useTech(TechType.TANK_SIEGE_MODE);
		}
	}
	private void siegeDown(Unit u){
		if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)){
			u.useTech(TechType.TANK_SIEGE_MODE);
		}
	}
	public void groupSiege(){
		for (Unit tank : myTanks){
			if (tank.getPosition().getDistance(msquad.goal)< 150){
				siegeUp(tank);
			} else {
				unsiege_and_move(tank,msquad.goal);
			}
		}
	}
	public Position getAverage() {
		return UnitUtils.avePos(myTanks);
	}
}
