package undermind.micropacket;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.MicroManager;


public class Squad {
	public List<Unit> myUnits;
	public Position goal;
	MicroManager master;
	public Set<UnitType> unitTypes;
	public boolean locked;
	public static int lockThreshold;
	public String type;
	
	public Squad(MicroManager micro) {
		myUnits = new ArrayList<Unit>();
		master = micro;
		locked = false;

		unitTypes = new HashSet<UnitType>();
	}
	
	public void onFrame() {
		
	}
	
	
	public void addUnit(Unit u) {
		myUnits.add(u);
	}
	
	
	public void removeUnit(Unit u) {
		Unit removeme = null;
		for (Unit unit : myUnits) {
			if (unit.getID() == u.getID()) {
				removeme = unit;
				break;
			}
		}
		
		if (removeme != null) myUnits.remove(removeme);
	}
	
	public void setGoal(Position g) {
		goal = g;
	}
	
	public int size() {
		return myUnits.size();
	}
	
	public boolean acceptsType(UnitType t) {
		return unitTypes.contains(t) && !locked;
	}
	
	public boolean hasUnit(Unit u) {
		for (Unit unit : myUnits) {
			if (unit.getID() == u.getID()) {
				return true;
			}
		}
		return false;
	}

}
