//Particle class, supports interactions with force, etc
//This is somewhat how marines communicate to each other, with these fields...
//Each marine, depend on condition (moving, stopping, got stuck, turning...), will exert
//different kind of field on its neighbors, hopefully these fields make pathing better
//contains ghetto function pointers ;(

package undermind.micropacket;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Random;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.Unit;
import edu.berkeley.nlp.starcraft.util.Vector;

public class Particle {
	
	private Random random = new Random();
	
	public Set<String> fields = new HashSet<String>();
	public Vector net_force = Vector.ZERO;
	public Vector location = null;
	public Vector prev_location = null;
	public Vector goal_location = null;
	
	public void updateLocation(Unit u){
		location = new Vector(u.getPosition());
	}
	public void updateLocation(Position p){
		location = new Vector(p);
	}
	
	public Vector getNetForce(Collection<Particle> particles){
		Vector ret = new Vector(0,0);
		
		for (Particle p : particles){
			if (p != this){
				ret = ret.add(p.exertField(this));
			}
		}
		net_force = ret;
		return ret;
	}

	//ghetto function pointer lul
	//exert a my field as a force on another particle
	public Vector exertField(Particle particle) {
		Vector ret = Vector.ZERO;
		for (String func : fields){
			if (func.equals("attract")) ret = ret.add(exertAttractionField(particle));
			if (func.equals("beacon")) ret = ret.add(exertBeaconField(particle));
			if (func.equals("jitter")) ret = ret.add(exertJitterField(particle));
			if (func.equals("sheep")) ret = ret.add(exertSheepField(particle));
		}
		return ret;
	}
	
	//Attraction field, make them cluster but not overly compact
	public void setAttactionField(){fields.add("attract");}
	public void unsetAttractionField(){fields.remove("attract");}
	public Vector exertAttractionField(Particle particle){
		//tune-able
		double min_dist  = 50;
		double repulse  = 2.5;
		double attract  = 100.0;
		double magnify2  = 1.0;
		
		Vector direction = new Vector(particle.location.toPosition(), location.toPosition()).normalize();
		double distance  = new Vector(particle.location.toPosition(), location.toPosition()).length();
		double strength1 = repulse * (distance - min_dist);
		double strength2 = attract * 1.0 / distance;
		double strength  = magnify2 * Math.min(strength1, strength2);
		
		return direction.scale(strength);
	}
	
	//Beacon field, makes the particles want to move toward a particular location(beacon)
	public void setBeaconField(){fields.add("beacon");}
	public void unsetBeaconField(){fields.remove("beacon");}
	public Vector exertBeaconField(Particle particle){
		//tune-able
		double magnify1   = 50.0;
		Vector direction  = new Vector(particle.location.toPosition(), location.toPosition()).normalize();
		//Game.getInstance().printf("omg", null);
		return direction.scale(magnify1);
	}
	
	//Jitter field, makes stuff jitter around :)
	public void setJitterField(){fields.add("jitter");}
	public void unsetJitterField(){fields.remove("jitter");}
	public Vector exertJitterField(Particle particle){
		//tune-able
		double magnify1   = - 10.0;
		double frequency = 0.01;
		
		if (location.equals(prev_location)){
			magnify1 -= 50;
			frequency += 0.01;
			Game.getInstance().drawCircleMap(location.toPosition(), 2, Color.RED, true);
		} else {
			prev_location = location;
		}
		boolean fire = random.nextDouble() < frequency;
		if (fire){
			Vector direction  = new Vector(particle.location.toPosition(), location.toPosition()).normalize();
			return direction.scale(magnify1);
		} else {
			return Vector.ZERO;
		}
	}
	
	//Sheep field, makes marine a herd of sheeps...
	public void setSheepField(Position goal){
		if (goal != null){
			fields.add("sheep");
			this.goal_location = new Vector(goal);
		}
	}
	public void unsetSheepField(){fields.remove("sheep");}
	public Vector exertSheepField(Particle particle){
		//tune-able
		double magnify1   = 150;
		//stupid stuff...
		if (particle.location == null){
			Game.getInstance().printf("O M G!!!", null);
		}
		Position p1 = particle.location.toPosition();
		Position p2 = location.toPosition();
		double distance  = new Vector(p1,p2).length();

		double scaling  = 1.0 / Math.sqrt(distance);
		Vector ret = net_force.normalize().scale(scaling).scale(magnify1);
		if (location.distanceTo(goal_location) < particle.location.distanceTo(goal_location)){
			return ret;
		}
		return Vector.ZERO;
	}
	
	//Entropy, the particles want to bounce around at random...
	public Vector brownianMotion(){
		//tune-able
		double magnify1  = 300.0;
		return new Vector(1,0).rotateCCW(Math.PI*2 * random.nextDouble());
	}
}
