package undermind.micropacket;

import java.util.Collection;
import java.util.HashMap;

import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;

import edu.berkeley.nlp.starcraft.util.UnitUtils;

public class MicroUtil {
    public static final int ORDERGAP = 30;
    private HashMap<Unit, Integer> lastOrderFrame = new HashMap<Unit, Integer>();
	public void rightClickWrapper(Unit unit, TilePosition pos){
        int frame = Game.getInstance().getFrameCount();
        if(lastOrderFrame.containsKey(unit)){
            if(lastOrderFrame.get(unit).intValue() - ORDERGAP > frame){
                lastOrderFrame.put(unit, frame);
                unit.rightClick(pos);
            }
        }else{
            lastOrderFrame.put(unit, frame);
            unit.rightClick(pos);
        }
    }
	//simple code to decide if a squad of marine should stim or not
	//a squad wants to stim if more than half of its memebers want to stim
	public static boolean shouldStimSimple (Collection<Unit> our_marines, Collection<Unit> our_medics, Collection<ROUnit> enemies){
		//if (! isThreat(enemies)) return false;
		long starttime = System.currentTimeMillis();
		int total = our_marines.size();
		int cand = 0;
		int alreadystimmed = 0;
		
		Position median = UnitUtils.medianPos(our_marines);
		if (enemies.size() == 0) return false;
		double d = UnitUtils.getClosest(median, enemies).getDistance(median);
		
		if (d < 300) {
			for (Unit marine : our_marines){
				if (marine.isStimmed()) alreadystimmed++;
				
				/*boolean canAttack = false;
				for (ROUnit enemy : enemies){
					if (marine.getDistance(enemy) < 200) {
						canAttack = true;
						break;
					}
				} */
				
				//if (canAttack)
					for (Unit medic : our_medics){
						if (marine.getDistance(medic) < 80 && marine.getHitPoints() >= 30){
							cand += 1;
							break;
						}
						
					}
			}
		}
		else return false;

		if (System.currentTimeMillis()-starttime > 5) Game.getInstance().printf("Stim took" + (System.currentTimeMillis()-starttime));
		return cand > total / 2 && alreadystimmed <= total/2.0;
	}
	
	//if this buddy can attack, and is not a worker, definitely threat (right? t_T)
	private static boolean isThreat(Collection<ROUnit> possible_threats){
		for (ROUnit u : possible_threats){
			if (!u.getType().isWorker() && u.getType().canAttack()){
				return true;
			}
		}
		return false;
	}
}
