package undermind.micropacket;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;

import undermind.AStarSearch;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Vector;

public class MedicCombatMovement {
	Player me = Game.getInstance().self();
	HashSet<Unit> medics = new HashSet<Unit>();
	
	public void moveMedics(Collection<Unit> marines){
		Map<Position,Unit> hurt_pos = new HashMap<Position,Unit>();
		Set<Position> poss = new HashSet<Position>();
		Position avg = UnitUtils.avePos(marines);
		for (Unit marine : marines){
			poss.add(marine.getPosition());
			if (marine.getHitPoints() < 40){
				hurt_pos.put(marine.getPosition(),marine);
			}
		}
		for (Unit medic : medics){
			if (hurt_pos.size() > 0){
				Position closest = UnitUtils.getClosestPosition(medic.getPosition(), hurt_pos.keySet());
				hurt_pos.remove(closest);
				if (medic.getPosition().getDistance(closest) < 50) continue;
				medic.move(closest);
				Game.getInstance().drawLineMap(closest, medic.getPosition(), Color.BLACK);
			} else {
				if (marines.size() > 0){
					Position closest = UnitUtils.getClosestPosition(medic.getPosition(), poss);
					if (medic.getPosition().getDistance(closest) < 50) continue;
					medic.move(closest);
					Game.getInstance().drawLineMap(closest, medic.getPosition(), Color.BLACK);
				}
			}
		}
	}
	
	public void addMedic(Unit medic) {
		medics.add(medic);
	}
	
	public void removeMarine(Unit medic) {
		medics.remove(medic);
	}
}
