package undermind.micropacket;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.MicroManager;

import edu.berkeley.nlp.starcraft.util.UnitUtils;

public class MechSquad extends Squad {
	
	int lastSiege;
	Game mGame;
	Random rgen;
	Position medianpos;
	public static int siegeRange = 12;
	
	VultureSquad vulture_squad; 
	
	/* a clumsy way to share stuff between functions so as to avoid copypasta */
	double nearestDistance;
	ROUnit closestEnemy;
	double closestEnemyd;
	Set<Unit> myTanks = new HashSet<Unit>();
	Set<ROUnit> ground_enemies_close_to_tank = new HashSet<ROUnit>();
	Set<ROUnit> air_enemies_close_to_tank = new HashSet<ROUnit>();
	
	public MechSquad(MicroManager micro) {
		super(micro);
		type = "mech";
		unitTypes.add(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
		unitTypes.add(UnitType.TERRAN_SIEGE_TANK_TANK_MODE);
		unitTypes.add(UnitType.TERRAN_GOLIATH);
		unitTypes.add(UnitType.TERRAN_VULTURE);
		lastSiege = 0;
		mGame = Game.getInstance();
		rgen = new Random();
		//vulture_squad = new VultureSquad(this);
	}
	
	public void synchStates(){
		//update tanks
		myTanks.clear();
		for (Unit u : myUnits){
			if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) ||
				u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)){
				myTanks.add(u);
			}
		}
		//update closest enemies to the tanks, air and ground
		Set<ROUnit> enemy_air = new HashSet<ROUnit>();
		Set<ROUnit> enemy_ground = new HashSet<ROUnit>();
		for (ROUnit rou: master.allVisibleEnemies){
			if (rou.isFlying()) enemy_air.add(rou);
			if (!rou.isFlying()) enemy_ground.add(rou);
		}
		for (Unit tank : myTanks){
			ROUnit closest_air = UnitUtils.getClosest(tank, enemy_air);
			ROUnit closest_ground = UnitUtils.getClosest(tank, enemy_ground);
			if (closest_air != null && tank.getPosition().getDistance(closest_air.getPosition()) < 13*32) air_enemies_close_to_tank.add(closest_air);
			if (closest_ground != null && tank.getPosition().getDistance(closest_ground.getPosition()) < 12*32) air_enemies_close_to_tank.add(closest_ground);
		}
		//stuff
		lastSiege++;
		computeMedianPosition();
		mGame.drawTextMap(medianpos, "avepos");
		
	}
	
	public void onFrame() {
		synchStates();
		for (Unit unit : myUnits) {
			Position p = unit.getPosition();
			if (p == Position.INVALID) {
				mGame.printf("WARNING -- dead unit in a squad!");
				continue;
			}

			nearestDistance = Double.POSITIVE_INFINITY;
			closestEnemy = UnitUtils.getClosest(unit,
					master.allVisibleEnemies);
			closestEnemyd = UnitUtils.getClosestDistance(unit,
					master.allVisibleEnemies);
			if (closestEnemy != null
					&& (closestEnemy.isCloaked() || closestEnemy
							.isBurrowed())) {
				master.pleaseScanHere = closestEnemy.getPosition();
			}
			if (closestEnemy != null)
				nearestDistance = unit.getTilePosition().getDistance(
						closestEnemy.getPosition());

		
			if (unit.getType().equals(UnitType.TERRAN_VULTURE)) vulture_squad.onFrame();
			tankMicro(unit);
			goliathMicro(unit);
			
			// TODO: missing -- don't impale self on photon cannons and similar devilries
		}
	}

	
	public void tankMicro(Unit unit) {
		if (unit.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE
				|| unit.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) {
			
			boolean notjustair = false;
			for (ROUnit en : master.allVisibleEnemies) {
				if (!en.isFlying() && unit
							.getTilePosition().getDistance(en.getTilePosition()) < 16) {
					notjustair = true;
					break;
				}
			}
			
			
			double distance = Double.POSITIVE_INFINITY;
			if (closestEnemy != null)
				distance = unit.getTilePosition().getDistance(closestEnemy.getTilePosition());
			double hdist = Double.POSITIVE_INFINITY;
			 
			if (master.hotspot != null && master.hotspot.pos != Position.INVALID) {
				hdist = unit.getTilePosition().getDistance(master.hotspot.pos);
			}
			
			if ((unit.isIdle() && unit.getTilePosition().getDistance(goal) < 6) || (hdist < siegeRange) || (master.allVisibleEnemies.size() != 0
					&& closestEnemy != null
					&& ((!closestEnemy.getType().isBuilding() && distance < 15) || (closestEnemy
							.getType().isBuilding()
							&& (closestEnemy.getType().canAttack() || closestEnemy
									.getType() == UnitType.TERRAN_BUNKER || closestEnemy
									.getType().isSpellcaster()) && distance < siegeRange)))
					&& notjustair
					) {
				if (!unit.isSieged()) unit.siege();
				int k = unit.getHitPoints();
				lastSiege = 0;
			} else if (unit.getTargetPosition() != goal
					&& unit.getTilePosition().getDistance(goal) > 6
					) {
				if (unit.isSieged() && !unit.isAttacking()
						&& unit.isIdle() && lastSiege >= 100) {
					unit.unsiege();
				} else if (!unit.isSieged()) {

					double dist = unit.getTilePosition().getDistance(
							medianpos);
					double d2 = unit.getTargetPosition().getDistance(
							medianpos);
					if (dist > 12) {
						if (d2 > 600)
							unit.attackMove(medianpos);
					} else
						unit.attackMove(goal);

				}

			}
		}
	}
	
	public void goliathMicro(Unit unit) {

		if ((unit.getType() == UnitType.TERRAN_GOLIATH)) {
			if (master.allVisibleEnemies.size() != 0
					&& closestEnemy != null
					&& ((!closestEnemy.getType().isBuilding() && unit
							.getTilePosition().getDistance(
									closestEnemy.getPosition()) < 7) || (closestEnemy
							.getType().isBuilding()
							&& (closestEnemy.getType().canAttack() || closestEnemy
									.getType() == UnitType.TERRAN_BUNKER) && unit
							.getTilePosition().getDistance(
									closestEnemy.getPosition()) < 9))
					&& (closestEnemy.getType().canAttack() || closestEnemy
							.getType().isSpellcaster())) {

				ROUnit targ = null;
				int bestprio = -1000;
				for (ROUnit ue : master.allVisibleEnemies) {
					if (ue.getDistance(unit) < 450
							&& master.getGPriority(ue, unit, false) > bestprio
							&& ue.getDistance(unit) < 300) {
						bestprio = master.getGPriority(ue, unit, false);
						targ = ue;
					}
				}
				for (ROUnit ue : master.enemyBuildings) {
					if (ue.getDistance(unit) < 550
							&& master.getGPriority(ue, unit, false) > bestprio
							&& ue.getDistance(unit) < 300) {
						bestprio = master.getGPriority(ue, unit, false);
						targ = ue;
					}
				}

				ROUnit k = unit.getTarget();
				if (targ != null && bestprio >= 0
						&& unit.getTarget() != null
						&& unit.getTarget().getID() != targ.getID()
						&& unit.getOrderTarget() != null
						&& unit.getOrderTarget().getID() != targ.getID()) {
					unit.rightClick(targ);
				} else if (targ == null && k == null
						&& unit.getOrderTarget() == null
						&& closestEnemyd > 280) {
					unit.attackMove(goal);
				}

			} else {
				double dist = unit.getTilePosition().getDistance(
						medianpos);
				double d2 = unit.getTargetPosition().getDistance(
						medianpos);
				Unit closestTank = null;
				double closestTankD = Double.NEGATIVE_INFINITY;
				double orderDistanceToTank = 0;
				for (Unit u2 : myUnits) {
					if ((u2.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || u2.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE)
							&& u2.getDistance(unit) > closestTankD) {
						closestTank = u2;
						closestTankD =  u2.getDistance(unit);
						orderDistanceToTank = unit.getTargetPosition().getDistance(u2.getPosition());
					}
				}
				/*if (closestTankD > 7 && orderDistanceToTank > 150 && closestTank != null)
					unit.patrol(closestTank.getPosition());
				*/
				if (dist > 4 && medianpos != null && medianpos != Position.INVALID) {
					if (d2 > 70)
						unit.attackMove(medianpos);
				} else
					unit.attackMove(goal);
			}
		}

	}
	
	
	
	public void addUnit(Unit unit) {
		myUnits.add(unit);
		//if (myUnits.size() >= lockThreshold) locked = true;
	}
	
	
	/* Set up the median position of the army, this is usually pretty useful. 
	 * We don't count loaded units (bunkers, drops) for the purposes of median.
	 */
	public void computeMedianPosition() {
		medianpos = null;
		ArrayList<Unit> alist = new ArrayList<Unit>();

		for (Unit unit : myUnits) {
			if (!unit.isLoaded() && (unit.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE ||  unit.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE))
				alist.add(unit);
		}
		medianpos = UnitUtils.medianPos(alist);
		
		if (medianpos == null || medianpos == Position.INVALID) {
			ArrayList<Unit> alist2 = new ArrayList<Unit>();
			for (Unit unit : myUnits) {
				if (!unit.isLoaded() )
					alist2.add(unit);
			}
			medianpos = UnitUtils.medianPos(alist2);
			
		}
			//medianPos(alist);

		/* Don't use the actual median position if there are too few units 
		int spec = 0;
		for (Unit uz : myUnits) {
			if (uz.getType() == UnitType.TERRAN_MARINE && uz.isLoaded())
				continue;
			else
				spec++;
		}
		if (spec < 2)
			medianpos = Position.centerOfTile(mGame.self().getStartLocation());
			
			*/

	}
	
	
}
