package undermind.micropacket;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.AStarSearch;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Vector;

public class MarineTargetSelection implements Cerebrate {
	
	Player me = Game.getInstance().self();
	HashSet<Unit> marines = new HashSet<Unit>();
	HashMap<ROUnit, EnemyUnit> unit_to_hp_map = new HashMap<ROUnit, EnemyUnit>();
	HashMap<Unit, Integer> cooldown_map = new HashMap<Unit, Integer>();

	Unit tank = null;
	@Override
	public void onStart() {
	}

	@Override
	public void onFrame() {
		if (Game.getInstance().getFrameCount() % 5 == 0){
			//update the set
			for (ROUnit u : unit_to_hp_map.keySet()){
				unit_to_hp_map.get(u).synch();
				unit_to_hp_map.get(u).print();
			}
			for (Unit marine : marines){
				Game.getInstance().drawTextMap(marine.getPosition(), ""+ marine.getDamagePerShot(marine));
				ROUnit target = targetSelectSimple(marine, unit_to_hp_map);
				if (!marine.isAttackFrame()){
					int cur = cooldown_map.get(marine) - 1;
					cooldown_map.remove(marine);
					cooldown_map.put(marine, cur);
				}
				if (target != null && cooldown_map.get(marine) <= 0){
					Game.getInstance().drawLineMap(marine.getPosition(), target.getPosition(), Color.RED);
					marine.attack(target);
					cooldown_map.remove(marine);
					cooldown_map.put(marine, 3);
				}
			}
		}
	}

	//Simple, attack the unit in range that has the lowest HP
	private ROUnit targetSelectSimple(Unit marine,
			HashMap<ROUnit, EnemyUnit> unit_to_hp_map2) {
		//pick the best enemy to attack, i.e. lowest total hp yet not dead
		ROUnit ret = null;
		double bestLife = Integer.MAX_VALUE;
		for (ROUnit enemy : unit_to_hp_map2.keySet()){
			if (marine.isInRange(enemy)){
				double life = unit_to_hp_map2.get(enemy).getLife();
				if (life > 0 && life < bestLife){
					ret = enemy;
					bestLife = life;
				}
			}
		}
		if (ret == null) return ret;
		//tag a hit on that enemey
		unit_to_hp_map2.get(ret).getHit(marine);
		return ret;
	}

	@Override
	public void onEnd(boolean isWinnerFlag) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSendText(String text) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onReceiveText(Player player, String text) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onPlayerLeft(Player player) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onNukeDetect(Position position) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitCreate(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}
	


	@Override
	public void onUnitDestroy(ROUnit unit) {
		if (unit.getPlayer() == me && unit.getType().equals(UnitType.TERRAN_MARINE)) {
			marines.remove(unit);
			cooldown_map.remove(unit);
		}
		if (!unit.getPlayer().equals(me)){
			unit_to_hp_map.remove(unit);
		}
	}

	@Override
	public void onUnitHide(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitShow(ROUnit unit) {
		if (unit.getPlayer() == me && unit.getType().equals(UnitType.TERRAN_MARINE)) {
			Unit marine = UnitUtils.assumeControl(unit);
			marines.add(marine);
			cooldown_map.put(marine, 3);
		}
		if (!unit.getPlayer().equals(me)){
			unit_to_hp_map.put(unit, new EnemyUnit(unit));
		}
	}

	@Override
	public void onUnitMorph(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitRenegade(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onDroppedConnection() {
		// TODO Auto-generated method stub
		
	}

}
