package undermind.micropacket;

import java.util.ArrayList;

import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.MicroManager;
import edu.berkeley.nlp.starcraft.util.UnitUtils;

public class MarineSquad extends Squad {
	MarineMovement mover;
	MedicCombatMovement medic_mover;
	public ArrayList<Unit> marines = new ArrayList<Unit>();
	public ArrayList<Unit> medics = new ArrayList<Unit>();
	public ArrayList<Unit> vessels = new ArrayList<Unit>();
	public ArrayList<Unit> tanks = new ArrayList<Unit>();
	public long time = 0;
	
	public MarineSquad(MicroManager micro) {
		super(micro);
		type = "bio";
		mover = new MarineMovement();
		medic_mover = new MedicCombatMovement();
		unitTypes.add(UnitType.TERRAN_MARINE);
		unitTypes.add(UnitType.TERRAN_MEDIC);
		if (!master.mechStrat) unitTypes.add(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
		if (!master.mechStrat) unitTypes.add(UnitType.TERRAN_SIEGE_TANK_TANK_MODE);
		if (!master.mechStrat) unitTypes.add(UnitType.TERRAN_SCIENCE_VESSEL);
	}
	
	public void onFrame() {
		time++;
		if (goal != null && goal != Position.INVALID) mover.setGoalPosition(new TilePosition(goal));
		
		Position ave = UnitUtils.avePos(myUnits);
		ROUnit closestEnemy = UnitUtils.getClosest(ave, master.allVisibleEnemies);
		double closestD = Double.POSITIVE_INFINITY;
		if (closestEnemy != null) {
			closestD = UnitUtils.pairDistance(myUnits, master.allVisibleEnemies);
		}
		for (ROUnit bldg : master.enemyBuildings) {
			double d = bldg.getDistance(ave);
			if (bldg.isVisible() && d < closestD) {
				closestD = d;
				closestEnemy = bldg;
			}
			
		}
		
		// Remove bunkered units
		Unit tr = null;
		for (Unit u : myUnits) {
			if (u.isLoaded()) 
				tr = u;
		}
		if (tr != null) {
			removeUnit(tr);
		}

		
		/* Do actual micro */
		
		//if no enemies in sight, we should move
		if (closestEnemy == null || closestD > 150 || master.shouldforceFlee(myUnits)){
			mover.onFrame();
			for (Unit t : tanks) {
				if (t.isSieged())
					t.unsiege();
			}
		}
		//if we need to stim, stim
		else if (MicroUtil.shouldStimSimple(marines, medics, master.allVisibleEnemies)) {
			//Game.getInstance().printf("stimmmmm!");
			for (Unit u : marines) {
				if (u.getHitPoints() >= 30) u.useTech(TechType.STIM_PACKS);
			}
		}
		//COMBAT! 
		//TODO: simple for now, will add some marine combat movement later
		else {
			for (Unit u : marines) {
				if (u.isIdle())
					u.attackMove(closestEnemy.getPosition());
			} 
			medic_mover.moveMedics(marines);
			
			for (Unit t : tanks) {
				if (closestD < 32*10 && !t.isSieged())
					t.siege();
			}
		}
		
		
		doVesselMicro();

	}
	
	
	
	public void doVesselMicro() {
		Position medianpos = UnitUtils.medianPos(myUnits);
		if (myUnits.size() != 0 && (medianpos == null || medianpos == Position.INVALID))
			medianpos = myUnits.get(0).getLastKnownPosition();
		for (Unit v : vessels) {
			boolean good = false;
			for (ROUnit e : master.allVisibleEnemies) {
				if (e.isCloaked() && medianpos != null
						&& e.getDistance(medianpos) < 450) {
					v.move(e.getPosition());
					good = true;
					break;
				}
			}
			if (!good && medianpos != null)
				v.move(medianpos);
			if (v.getEnergy() > 110) {
				for (Unit u : myUnits) {
					if (u.getPlayer() == master.mGame.self() && u.getDistance(v) < 200
							&& u.getHitPoints() < u.getType()
									.maxHitPoints()-20)
						v.useTech(TechType.DEFENSIVE_MATRIX, u);
				}

			if (v.getEnergy() > 75 && Game.getInstance().self().hasResearched(TechType.IRRADIATE)) {
				ROUnit bestTarget = null;
				int bestValue = 0;
				for (ROUnit e : master.allVisibleEnemies) {
					if (e.getDistance(v) < 450) {
						int value = 0;
						if (UnitUtils.getClosestDistance(e, myUnits) < 60)
							continue;
						if (e.getType() == UnitType.ZERG_DEFILER || e.getType() == UnitType.ZERG_ULTRALISK)
							value += 3;
						if (e.getType() == UnitType.ZERG_LURKER || e.getType() == UnitType.ZERG_MUTALISK)
							value += 2;
						for (ROUnit e2 : master.allVisibleEnemies) {
							if (e2.getDistance(e) < 50 && e2.getType().isOrganic())
								value++;
						}
						if (value > bestValue) {
							bestValue = value;
							bestTarget = e;
						}
							
					}
				}
				
				if (bestTarget != null && bestValue > 2)
					v.useTech(TechType.IRRADIATE, bestTarget);
			}

			}
		}
	}
	
	public void addUnit(Unit u) {
		myUnits.add(u);
		UnitType type = u.getType();
		if (type == UnitType.TERRAN_MARINE) marines.add(u);
		else if (type == UnitType.TERRAN_MEDIC){
			medic_mover.addMedic(u);
			medics.add(u);
		}
		if (type == UnitType.TERRAN_MARINE || type == UnitType.TERRAN_MEDIC || type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) 
			mover.addMarine(u);
		if (type == UnitType.TERRAN_SCIENCE_VESSEL) vessels.add(u);
		if (type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) tanks.add(u);
		//if (myUnits.size() >= lockThreshold) locked = true;
	}
	
	
	public void removeUnit(Unit u) {
		Unit removeme = null;
		for (Unit unit : myUnits) {
			if (unit.getID() == u.getID()) {
				removeme = unit;
				break;
			}
		}
		
		if (removeme != null) {
			vessels.remove(removeme);
			myUnits.remove(removeme);
			mover.removeMarine(removeme);
			marines.remove(removeme);
			medics.remove(removeme);
			tanks.remove(removeme);
		}

	}
	
}
