package undermind.micropacket;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.AStarSearch;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Vector;

public class MarineClusterMovement implements Cerebrate {
	
	Player me = Game.getInstance().self();
	HashSet<Unit> marines = new HashSet<Unit>();
	HashMap<Unit, Particle> marine_particle_map = new HashMap<Unit, Particle>();
	Set<Particle> allParticles = new HashSet<Particle>();

	//where the cluster is
	Position center = null;
	TilePosition centerTile = null;

	//where we want to be in the long run
	TilePosition goalTile = null;
	//where we want to be in the short run
	TilePosition curGoalTile = null;
	
	//Things for pathing
	public AStarSearch pathfinder = new AStarSearch();;
	public List<TilePosition> pathToGoal;
	
	//Unit cursor = null;
	BeaconParticle cursorParticle = new BeaconParticle();

	public MarineClusterMovement(){
		allParticles.add(cursorParticle);
	}
	@Override
	public void onStart() {
	}

	//set a new place to go, also does some work itself
	public void setGoalPosition(TilePosition p){
		//replan pathing if goal has changed
		if (centerTile == null) return;
		//When should we recompute a path? If there is no path or the goal changed.
		if (pathToGoal == null || (p != null && !p.equals(goalTile))){
			goalTile = p;
			pathToGoal = pathfinder.getPath(centerTile, goalTile);
		}
	}
	
	//for testing only
	//private TilePosition getNeare 
	@Override
	public void onFrame() {
		
		if (centerTile != null) Game.getInstance().drawCircleMap(Position.centerOfTile(centerTile), 2, Color.ORANGE, true);
		if (Game.getInstance().getFrameCount() % 5 == 0){
			
			//for testing...
			//setGoalPosition(new TilePosition(cursor.getPosition()));
			
			//these 2 methods below will set up the right potential field...
			updateParticles();
			updatePathing();			
			//now we ENACT the potential field into a movement
			moveMarines();
		}
	}

	private void updatePathing() {
		Set<Unit> realmarines = new HashSet<Unit>();
		for (Unit marine : marines){
			if (marine.isCompleted()){
				realmarines.add(marine);
			}
		}
		center = UnitUtils.closestWalkableAvePos(realmarines);
		centerTile = new TilePosition(center);
		if (pathToGoal == null){
			return;
		}
		if (pathToGoal.size() == 0){
			//Game.getInstance().printf("no path available due to 0", null);
			return;
		}
		curGoalTile = pathToGoal.get(0);
		if (curGoalTile == null) return;
		pathfinder.drawPath(pathToGoal);
		if (center.getDistance(new Position(curGoalTile)) < 150){
			pathToGoal.remove(0);
			if (pathToGoal.size() == 0) return;
			curGoalTile = pathToGoal.get(0);
		}
		cursorParticle.updateLocation(new Position(curGoalTile));
		cursorParticle.updateCenter(center);
		cursorParticle.setParallelField();
	}

	private void updateParticles() {
		for (Unit marine : marine_particle_map.keySet()){
			marine_particle_map.get(marine).updateLocation(marine);
			marine_particle_map.get(marine).setAttactionField();
			marine_particle_map.get(marine).setJitterField();
			marine_particle_map.get(marine).setSheepField(center);
		}
	}

	private void moveMarines(){
		if (curGoalTile == null) return;
		for (Unit marine : marines){
			Vector force    = marine_particle_map.get(marine).getNetForce(allParticles);
			Vector v_toGo   = new Vector(marine.getPosition()).add(force);
			Position p_toGo = v_toGo.toPosition();
			//try to pull far away marines back...
			if (marine.getPosition().getDistance(new Position(curGoalTile)) > 400){
				p_toGo = new Position(curGoalTile);
			}
			marine.move(p_toGo);
		}
	}
	@Override
	public void onEnd(boolean isWinnerFlag) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSendText(String text) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onReceiveText(Player player, String text) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onPlayerLeft(Player player) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onNukeDetect(Position position) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitCreate(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitDestroy(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitHide(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitShow(ROUnit unit) {
		
	}
	


	@Override
	public void onUnitMorph(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onUnitRenegade(ROUnit unit) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onDroppedConnection() {
		// TODO Auto-generated method stub
		
	}
	
	
	public void addMarine(Unit marine) {
		Particle particle = new Particle();
		marines.add(marine);
		marine_particle_map.put(marine, particle);
		allParticles.add(particle);
	}
	
	public void removeMarine(Unit marine) {
		marines.remove(marine);
		allParticles.remove(marine_particle_map.get(marine));
		marine_particle_map.remove(marine);

	}

}
