package undermind.micropacket;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.MicroManager;
import undermind.intelligence.RegionStatus;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;

public class M3chSquad extends Squad{
	
	public VultureSquad vulture_squad;
	public TankSquad tank_squad;
	public GoliathSquad goliath_squad;
	public ArrayList<Unit> vessels = new ArrayList<Unit>();
	public MarineMovement mover;
	public Unit sacrificeVulture;
	boolean is_confident = true;
	
	//a ratio of nearby enemie's value to our value, the bigger the more dangerous
	double confidence = 1.0;
	double alpha = 1.0;
	
	public M3chSquad(MicroManager micro) {
		super(micro);
		type = "mech";
		unitTypes.add(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
		unitTypes.add(UnitType.TERRAN_SIEGE_TANK_TANK_MODE);
		unitTypes.add(UnitType.TERRAN_GOLIATH);
		unitTypes.add(UnitType.TERRAN_VULTURE);
		unitTypes.add(UnitType.TERRAN_SCIENCE_VESSEL);
		
		tank_squad = new TankSquad(this);
		vulture_squad = new VultureSquad(this);
		goliath_squad = new GoliathSquad(this);
		mover = new MarineMovement();
	}
	
	private boolean isConfident(){
		if (is_confident){
			if (update_and_get_confidence() > 0.2){
				is_confident = false;
			}
		}
		if (!is_confident){
			if (update_and_get_confidence() < 0.1){
				is_confident = true;
			}
		}
		return is_confident;
	}
	public void onFrame() {
		//Game.getInstance().drawLineMap(getAverage(), goal, Color.GREEN);
		//update confidence
		//if dangerous, let tank squad decide what to do
		if (!isConfident()){
			Game.getInstance().drawTextMap(getMedian(), "danger "+confidence);
			tank_squad.onFrame();
			vulture_squad.onFrame();
			goliath_squad.onFrame();
		}
		//otherwise, move toward the goal and siege there
		else {
			if (goal != null && getAverage().getDistance(goal) < 150){
				Game.getInstance().drawTextMap(getMedian(), "safe, goal reached"+confidence);
				tank_squad.groupSiege();
				vulture_squad.moveTo(getAverage());
				goliath_squad.moveTo(getAverage());
			}
			else {
				Game.getInstance().drawTextMap(getMedian(), "safe, on the move"+confidence);
				mover.setGoalPosition(new TilePosition(goal));
				mover.onFrame();
			}
		}

		
		doVesselMicro();
	}
	
	public Position getAverage() {
		return tank_squad.myTanks.size() > 0 ? UnitUtils.avePos(tank_squad.myTanks) : UnitUtils.avePos(myUnits);
	}

	private double update_and_get_confidence() {
		Set <ROUnit> close_enemies = everyNearbyGroundUnits();
		double theirVal = Utils.getValueRO(close_enemies);
		double ourVal = Utils.getValue(myUnits);
		double ratio = (theirVal / (ourVal+0.1));
		confidence = alpha * ratio + (1-alpha) * confidence;
		return confidence;
	}
	
	public boolean canBust() {
		Set<ROUnit> theirMen = everyNearbyUnits();
		double myVal = Utils.getValue(myUnits);
		double theirVal = Utils.getValueRO(theirMen);
		return myVal > 8 * theirVal;
	}
	
	public Position getMedian(){
		return tank_squad.myTanks.size() > 0 ? tank_squad.getMedian() : UnitUtils.medianPos(myUnits);
	}
	
	public Set<ROUnit> everyNearbyUnits(){
		Position median = getMedian();
		Set<ROUnit> ret = new HashSet<ROUnit>();
		for (RegionStatus rs : master.regionStatuses){
			for (ROUnit rou : rs.enemies){
				Position rou_pos = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
				if (rou_pos.getDistance(median) < 800){
					ret.add(rou);
				}
			}
		}
		return ret;
	}
	
	public Set<ROUnit> everyNearbyGroundUnits(){
		Set<ROUnit> enemies = everyNearbyUnits();
		Set<ROUnit> ret = new HashSet<ROUnit>();
		for (ROUnit rou : enemies){
			if (!rou.isFlying()){
				ret.add(rou);
			}
		}
		return ret;
	}
	
	public Set<ROUnit> everyNearbyAirUnits(){
		Set<ROUnit> enemies = everyNearbyUnits();
		Set<ROUnit> ret = new HashSet<ROUnit>();
		for (ROUnit rou : enemies){
			if (rou.isFlying()){
				ret.add(rou);
			}
		}
		return ret;
	}
	
	public boolean tankThreat() {
		for (ROUnit u : everyNearbyUnits()){
			if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) ||
					u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)){
				return true;
			}
		}
		return false;
	}

	public void addUnit(Unit u) {
		myUnits.add(u);
		mover.addMarine(u);
		//if (myUnits.size() >= lockThreshold) locked = true;
		if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) ||
			u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)){
			tank_squad.addUnit(u);
		}
		if (u.getType().equals(UnitType.TERRAN_VULTURE)){
				vulture_squad.addUnit(u);
			}
		
		if (u.getType().equals(UnitType.TERRAN_GOLIATH)){
			goliath_squad.addUnit(u);
		}

		if (u.getType() == UnitType.TERRAN_SCIENCE_VESSEL) vessels.add(u);
		
		
	}
	public void removeUnit(Unit u) {
		myUnits.remove(u);
		mover.removeMarine(u);
		
		if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) ||
				u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)){
				tank_squad.removeUnit(u);
			}
		if (u.getType().equals(UnitType.TERRAN_VULTURE)){
			vulture_squad.removeUnit(u);
		}
		if (u.getType().equals(UnitType.TERRAN_VULTURE)){
			goliath_squad.removeUnit(u);
		}
		vessels.remove(u);
	}
	
	
	public void doVesselMicro() {
		Position medianpos = UnitUtils.medianPos(myUnits);
		if (myUnits.size() != 0 && (medianpos == null || medianpos == Position.INVALID))
			medianpos = myUnits.get(0).getLastKnownPosition();
		for (Unit v : vessels) {
			boolean good = false;
			for (ROUnit e : master.allVisibleEnemies) {
				if (medianpos != null
						&& e.getDistance(medianpos) < 450 && !e.isDetected()) {
					v.move(e.getPosition());
					good = true;
					break;
				}
			}
			if (!good && medianpos != null)
				v.move(medianpos);
			if (v.getEnergy() > 120) {
				for (Unit u : myUnits) {
					if (u.getPlayer() == master.mGame.self() && u.getDistance(v) < 200
							&& u.getHitPoints() < u.getType()
									.maxHitPoints()-20)
						v.useTech(TechType.DEFENSIVE_MATRIX, u);
				}

			if (v.getEnergy() > 75 && Game.getInstance().self().hasResearched(TechType.EMP_SHOCKWAVE)) {
				ROUnit bestTarget = null;
				int bestValue = 0;
				for (ROUnit e : master.allVisibleEnemies) {
					if (e.getDistance(v) < 500) {
						int value = 0;
						if (e.getType() == UnitType.PROTOSS_HIGH_TEMPLAR && e.getEnergy() > 50)
							value += 3;
						else if (e.getType().isSpellcaster() && e.getEnergy() > 50)
							value += 1;
						for (ROUnit e2 : master.allVisibleEnemies) {
							if (e2.getDistance(e) < 50 && ((e2.getType().getRace() == Race.PROTOSS && e2.getShields() > 30) || e2.getType().isSpellcaster()))
								value++;
						}
						if (value > bestValue) {
							bestValue = value;
							bestTarget = e;
						}
							
					}
				}
				
				if (bestTarget != null && bestValue > 2)
					v.useTech(TechType.EMP_SHOCKWAVE, bestTarget);
			}

			}
		}
	}
	

}
