package undermind.micropacket;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import edu.berkeley.nlp.starcraft.util.UnitUtils;

public class GoliathSquad {
	public static int acquisitionBonus = 0;
	Set<Unit> myGoliaths = new HashSet<Unit>();
	M3chSquad msquad;
	public void addUnit(Unit u){
		myGoliaths.add(u);
	}
	public void removeUnit(Unit u){
		myGoliaths.remove(u);
	}
	public GoliathSquad(M3chSquad m3chSquad) {
		msquad = m3chSquad;
	}
	
	public void onFrame(){
		for (Unit unit : myGoliaths) {
			double nearestDistance = Double.POSITIVE_INFINITY;
			ROUnit closestEnemy = UnitUtils.getClosest(unit,
						msquad.everyNearbyUnits());
			double closestEnemyd = UnitUtils.getClosestDistance(unit,
						msquad.everyNearbyUnits());
			Position medianpos = msquad.getMedian();
			
		if (msquad.everyNearbyUnits().size() != 0
				&& closestEnemy != null
				&& ((!closestEnemy.getType().isBuilding() && unit
						.getTilePosition().getDistance(
								closestEnemy.getPosition()) < 7+acquisitionBonus/32) || (closestEnemy
						.getType().isBuilding()
						&& (closestEnemy.getType().canAttack() || closestEnemy
								.getType() == UnitType.TERRAN_BUNKER) && unit
						.getTilePosition().getDistance(
								closestEnemy.getPosition()) < 9))
				&& (closestEnemy.getType().canAttack() || closestEnemy
						.getType().isSpellcaster())) {

			ROUnit targ = null;
			int bestprio = -1000;
			for (ROUnit ue : msquad.everyNearbyUnits()) {
				if (ue.getDistance(unit) < 450+acquisitionBonus
						&& msquad.master.getGPriority(ue, unit, false) > bestprio
						&& ue.getDistance(unit) < 300+acquisitionBonus) {
					bestprio = msquad.master.getGPriority(ue, unit, false);
					targ = ue;
				}
			}
			for (ROUnit ue : msquad.master.enemyBuildings) {
				if (ue.getDistance(unit) < 550
						&& msquad.master.getGPriority(ue, unit, false) > bestprio
						&& ue.getDistance(unit) < 300) {
					bestprio = msquad.master.getGPriority(ue, unit, false);
					targ = ue;
				}
			}

			ROUnit k = unit.getTarget();
			if (targ != null && msquad.master.time % 20 == 0 && (unit.getTarget() == null && unit.getOrderTarget() == null) || (targ != null && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID())) {
				unit.rightClick(targ);
			} else if (targ == null && k == null
					&& unit.getOrderTarget() == null
					&& closestEnemyd > 280) {
				unit.attackMove(msquad.goal);
			}

		} else {
			double dist = unit.getTilePosition().getDistance(
					medianpos);
			double d2 = unit.getTargetPosition().getDistance(
					medianpos);

			/*if (closestTankD > 7 && orderDistanceToTank > 150 && closestTank != null)
				unit.patrol(closestTank.getPosition());
			*/
			if (dist > 4 && medianpos != null && medianpos != Position.INVALID) {
				if (d2 > 70)
					unit.attackMove(medianpos);
			} else
				unit.attackMove(msquad.goal);
		}
	}
	
		
		
		
		/*
		Set<ROUnit> close_enemies = msquad.everyNearbyAirUnits();
		Set<EnemyUnit> filteredEnemies = doFilter(close_enemies);
		Map<Unit,EnemyUnit> hitmap = TargetSelectors.getTarget_ranged_simple(myGoliaths, filteredEnemies);
		if (hitmap != null){
			for (Unit goliath : myGoliaths){
				if (hitmap.containsKey(goliath) && hitmap.get(goliath) != null){
					goliath.attackUnit(hitmap.get(goliath).unit);
				}
				else {
					goliath.attackMove(msquad.getAverage());
				}
			}
		} */
}

	private Set<EnemyUnit> doFilter(Set<ROUnit> close_enemies) {
		Set<EnemyUnit> ret = new HashSet<EnemyUnit>();
		for (ROUnit rou : close_enemies){
			Position p = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
			double dist = UnitUtils.getClosestDistance(p, msquad.tank_squad.myTanks);
			if (dist < 8.5*32 || rou.getGroundRange() <= dist){
				if (!rou.getType().equals(UnitType.PROTOSS_INTERCEPTOR)){
					ret.add(new EnemyUnit(rou));
				}
			}
		}
		return ret;
	}

	public void moveTo(Position p){
		for (Unit goliath : myGoliaths){
			goliath.attackMove(p);
		}
	}
}
