package undermind.micropacket;

import org.bwapi.proxy.model.DamageType;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitSizeType;
import org.bwapi.proxy.model.WeaponType;

public class EnemyUnit {
	double hp = 0;
	double sh = 0;
	double armor_hp = 0;
	double armor_sh = 0;
	ROUnit unit = null;
	
	public EnemyUnit(ROUnit unit){
		this.unit = unit;
		synch();
	}
	
	public ROUnit getUnit() {return unit;}

	public void synch() {
		hp = unit.getHitPoints();
		sh = unit.getShields();
		armor_hp = unit.getArmor();
		armor_sh = unit.getShieldUpgradeLevel();
	}
	
	public void print(){
		//Game.getInstance().drawTextMap(unit.getPosition(), "hp "+hp+" sh "+sh+" ahp "+armor_hp+" ash "+armor_sh);
	}
	
	public double getLife(){
		return hp + sh;
	}
	
	//unit u attacks the unit here...
	public void getHit(Unit u){
		double[] dmg = damageDealt(u);
		sh -= dmg[0];
		hp -= dmg[1];
	}
	
	//return a tuple of {dmg_to_shield, dmg_to_hp}
	public double[] damageDealt(Unit u){
		double rawDamage = 0;
		WeaponType weapon = null;
		if (unit.isFlying()) weapon = u.getType().airWeapon();
		if (!unit.isFlying()) weapon = u.getType().groundWeapon();
		rawDamage = weapon.damageAmount();
		
		if (sh > 0){
			double dmg_to_shield, dmg_to_hp;
			double dmg_to_shield1 = Math.max(rawDamage - armor_sh, 0.5);
			if (dmg_to_shield1 < sh) return new double[] {dmg_to_shield1, 0};
			else {
				dmg_to_shield = sh;
				double discount = 1;
				double remaining_damage = dmg_to_shield1 - dmg_to_shield;
				if (unit.getType().size().equals(UnitSizeType.LARGE)){
					if (weapon.damageType().equals(DamageType.EXPLOSIVE)) discount = 1.0;
					if (weapon.damageType().equals(DamageType.NORMAL)) discount = 1.0;
					if (weapon.damageType().equals(DamageType.CONCUSSIVE)) discount = 0.25;
				}
				if (unit.getType().size().equals(UnitSizeType.MEDIUM)){
					if (weapon.damageType().equals(DamageType.EXPLOSIVE)) discount = 0.75;
					if (weapon.damageType().equals(DamageType.NORMAL)) discount = 1.0;
					if (weapon.damageType().equals(DamageType.CONCUSSIVE)) discount = 0.5;
				}
				if (unit.getType().size().equals(UnitSizeType.SMALL)){
					if (weapon.damageType().equals(DamageType.EXPLOSIVE)) discount = 0.5;
					if (weapon.damageType().equals(DamageType.NORMAL)) discount = 1.0;
					if (weapon.damageType().equals(DamageType.CONCUSSIVE)) discount = 1.0;
				}
				dmg_to_hp = Math.max(0.5,remaining_damage * discount - armor_hp);
				return new double[] {dmg_to_shield, dmg_to_hp};
			}
		}
		else {
			return new double[] {0.0, u.getDamagePerShot(unit)};
		}
	}
}
