package undermind.micropacket;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.MicroManager;
import undermind.intelligence.RegionStatus;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;

public class DroppedUnits extends Squad {
	public Unit dropship;
	public List<Vulture> vulture_squad;
	public List<Unit> tank_squad;
	public List<Unit> marine_squad;
	public List<Unit> medic_squad;
	public boolean suicidal = false;
	public Random rgen = new Random();

	public DroppedUnits(MicroManager m,  Unit drop) {
		super(m);
		master = m;
		dropship = drop;
		tank_squad = new ArrayList<Unit>();
		vulture_squad =new ArrayList<Vulture>();
		marine_squad = new ArrayList<Unit>();
		medic_squad = new ArrayList<Unit>();
	}

	public void onFrame() {
		Game.getInstance().drawCircleMap(goal, 8, Color.RED, true);
		
		if (Utils.getValueRO(everyNearbyUnits()) > Utils.getValue(myUnits)*1.2) {
			suicidal = true;
		}
		else suicidal = false;

		vultureMicro();
		tankMicro();
		marineMicro();
	}

	public void vultureMicro() {
		vultloop: for (Vulture vulture : vulture_squad) {
			vulture.timeNeeded--;
			if (vulture.timeNeeded > 0)
				continue;
			Unit unit = vulture.unit;
			/*
			double nearestDistance = Double.POSITIVE_INFINITY;
			ROUnit closestEnemy = UnitUtils.getClosest(unit,
					everyNearbyUnits());
			Position medianpos = getMedian();*/
			if (unit.getSpiderMineCount() > 1) 
			{
				Position minePlace = unit.getPosition();
				double d;
				int tries = 0;
				//master.mGame.drawCircleMap(minePlace, 3, Color.RED, false);
				unit.useTech(TechType.SPIDER_MINES, minePlace);
				vulture.timeNeeded = 35;
			}
			else {
				ROUnit targ = null;
				int bestprio = -1000;
				int tolerance = 250;
				for (ROUnit u : master.allVisibleEnemies) {
					if (u.getDistance(goal) < tolerance && getPriority(u, vulture_squad.get(0).unit, false) > bestprio) {
						bestprio = getPriority(u, vulture_squad.get(0).unit, false);
						targ = u;
					}
				}
				for (ROUnit u : master.enemyBuildings) {
					if (u.getDistance(goal) < tolerance && getPriority(u, vulture_squad.get(0).unit, false) > bestprio) {
						bestprio = getPriority(u, vulture_squad.get(0).unit, false);
						targ = u;
					}
				}
				if (targ != null && master.time % 20 == 0 && (unit.getTarget() == null && unit.getOrderTarget() == null) || (targ != null && bestprio >= 0 && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID())) {
					unit.rightClick(targ);
				}
				else if (master.time % 20 == 0 && (unit.getDistance(goal) > 450 || targ == null)) {
					unit.move(goal);
				}
					
			}
		}

	}


	public void marineMicro() {
		if (marine_squad.size() == 0) return;
		ROUnit targ = null;
		int bestprio = -1000;
		int tolerance = 250;
		for (ROUnit u : master.allVisibleEnemies) {
			if (u.getDistance(goal) < tolerance && getPriority(u, marine_squad.get(0), false) > bestprio) {
				bestprio = getPriority(u, marine_squad.get(0), false);
				targ = u;
			}
		}
		for (ROUnit u : master.enemyBuildings) {
			if (u.getDistance(goal) < tolerance && getPriority(u, marine_squad.get(0), false) > bestprio) {
				bestprio = getPriority(u, marine_squad.get(0), false);
				targ = u;
			}
		}
		for (Unit u : marine_squad) {
			if (u.getHitPoints() > 30 && !u.isStimmed() && master.time % 20 == 0) {
				u.useTech(TechType.STIM_PACKS);
			}

			if (targ != null && master.time % 20 == 0 && (u.getTarget() == null && u.getOrderTarget() == null) || (targ != null && bestprio >= 0 && u.getTarget() != null && u.getTarget().getID() != targ.getID() && u.getOrderTarget() != null && u.getOrderTarget().getID() != targ.getID())) {
				u.rightClick(targ);
			}
			else if (master.time % 20 == 0 && (u.getDistance(goal) > 350 || targ == null)) {
				u.attackMove(goal);
			}
		}

		for (Unit m : medic_squad) {
			if (m.isIdle()) {
				m.patrol(UnitUtils.getClosest(m.getPosition(), marine_squad).getPosition());
			}
		}
	}

	public void tankMicro() {
		for (Unit t : tank_squad) {
			if (!t.isSieged())
				t.siege();
		}
	}



	public void addUnit(Unit u) {
		myUnits.add(u);
		//if (myUnits.size() >= lockThreshold) locked = true;
		if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) ||
				u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)){
			tank_squad.add(u);
		}
		if (u.getType().equals(UnitType.TERRAN_VULTURE)){
			vulture_squad.add(new Vulture(u));
		}
		if (u.getType().equals(UnitType.TERRAN_MARINE)){
			marine_squad.add(u);
		}

		if (u.getType().equals(UnitType.TERRAN_MEDIC)){
			medic_squad.add(u);
		}


	}
	public void removeUnit(Unit u) {
		if (u == null) return; 
		myUnits.remove(u);

		if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) ||
				u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)){
			tank_squad.remove(u);
		}
		if (u.getType().equals(UnitType.TERRAN_MEDIC)){
			medic_squad.remove(u);
		}
		if (u.getType().equals(UnitType.TERRAN_VULTURE)){
			Vulture tr = null;
			for (Vulture v : vulture_squad) {
				if (v.unit.getID() == u.getID()) {
					tr = v;
					break;
				}

			}

			if (tr != null) vulture_squad.remove(tr);
		}
	}


	public Position getMedian(){
		return tank_squad.size() > 0 ? UnitUtils.medianPos(tank_squad) : UnitUtils.medianPos(myUnits);
	}

	public Set<ROUnit> everyNearbyUnits(){
		Position median = getMedian();
		Set<ROUnit> ret = new HashSet<ROUnit>();
		for (RegionStatus rs : master.regionStatuses){
			for (ROUnit rou : rs.enemies){
				Position rou_pos = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
				if (rou_pos.getDistance(median) < 800){
					ret.add(rou);
				}
			}
		}
		return ret;
	}


	public int getPriority(ROUnit u, Unit me, boolean harass) {

		if (suicidal) {
			UnitType t = u.getType();
			if (t.isWorker() || t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) return 10;

			if (t == UnitType.PROTOSS_INTERCEPTOR) return -10;
			if (t.isResourceDepot()) return 6;
			if (t.isBuilding()) return 1;

			if (t == UnitType.ZERG_SUNKEN_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) return -10;

			if (u.canAttack(me)) return  4;
			if (t.canAttack()) return 2;
			return 0;
		}
		else {
			UnitType t = u.getType();
			if (t.isWorker() || t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) return 7;
			if (t == UnitType.ZERG_SUNKEN_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) return -10;

			if (t == UnitType.PROTOSS_INTERCEPTOR) return -10;
			if (t.isResourceDepot()) return 5;

			if (u.canAttack(me)) return  8;
			if (t.canAttack()) return 2;
			if (t.isBuilding()) return 1;
			return 0;
		}
	}

}
