package undermind.micropacket;

import java.util.List;

import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.MicroManager;
import undermind.intelligence.RegionStatus;
import edu.berkeley.nlp.starcraft.util.Counter;
import edu.berkeley.nlp.starcraft.util.Utils;

public class DropSquad {
	public Unit dropship;
	public Squad squad;
	public int dropsize = 2;
	public int droptime = 0;
	public boolean beenfull = false;
	public boolean loaded;
	public int oldhp;
	TilePosition originalDropSpot = new TilePosition(1,1);
	TilePosition dropSpot = new TilePosition(1,1);
	public static int frags = 0;
	public static double fails = 0;
	MicroManager master;
	TilePosition currentGoal;
	List<TilePosition> pathToGoal;
	Region targetRegion;
	Bwta myBwta;



	public DropSquad(Unit d, MicroManager m, Squad s) {
		dropship = d;
		master = m;
		squad = s;
		myBwta = Bwta.getInstance();
	}

	public void onFrame() {
		if (beenfull) droptime++;
		adjustGoal();
		if ((pathToGoal == null || master.time % 10 == 0 || pathToGoal.size() == 0) && dropship.getLoadedUnits().size() != 0) {
			pathToGoal = master.dropSearch.getPath(dropship.getTilePosition(), dropSpot);
		}
		if (pathToGoal != null && dropship.getLoadedUnits().size() != 0) {
			master.dropSearch.drawPath(pathToGoal);
			master.mGame.drawCircleMap(new Position(dropSpot), 11, Color.PURPLE, false);
		}
		



		/* Do dropship micro */


		
		if (pathToGoal != null) {
			
			ROUnit nextBomb = null;
			if (dropship.getLoadedUnits().size() != 0) {
				nextBomb = dropship.getLoadedUnits().iterator().next();
				if (dropship.getLoadedUnits().size() >= dropsize) {
					loaded = true;
					beenfull = true;
				}
			}
			else {
				loaded = false;
			}

			if (loaded) {
				if (pathToGoal.size() > 1) 
					currentGoal = pathToGoal.get(1);
				else 
					currentGoal = pathToGoal.get(0);

				Game.getInstance().drawCircleMap(Position.centerOfTile(currentGoal), 9, Color.RED, false);
				
				if (currentGoal.equals(dropSpot))
					dropship.unload(nextBomb);
				else if (dropship.getHitPoints() < 20 
						|| (dropship.getHitPoints() < oldhp && dropship.getHitPoints() < 70 && targetRegion.contains(dropship.getTilePosition())))
					dropship.unload(nextBomb);
				else if (dropship.getLoadedUnits().size() > 0) {
					if (dropship.getTilePosition().getDistance(currentGoal) < 6) {
						pathToGoal.remove(0);
						if (pathToGoal.size() > 1) 
							currentGoal = pathToGoal.get(1);
						else if (pathToGoal.size() > 0)
							currentGoal = pathToGoal.get(0);
					}
					dropship.move(currentGoal);
				}
	
			}
		}
		oldhp = dropship.getHitPoints();


		/* Unit micro */

		for (Unit u : squad.myUnits) {
			if (u.getTilePosition().getDistance(dropSpot) < 8) {
				squad.onFrame();
				break;
			}
		}




	}


	public void setDropSpot(TilePosition tp) {
		originalDropSpot = tp;
		dropSpot = tp;

		for (Region r : myBwta.getRegions()) {
			if (r.contains(dropSpot)) {
				targetRegion = r;
				break;
			}
		}
	}

	public TilePosition getDropSpot() {
		return dropSpot;
	}

	public int getPriority(ROUnit u, Unit me, boolean harass) {
		UnitType t = u.getType();
		if (t.isWorker() || t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) return 10;

		if (t == UnitType.PROTOSS_INTERCEPTOR) return -10;


		if (t == UnitType.ZERG_SUNKEN_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) return -1;

		if (u.canAttack(me)) return  4;
		if (t.canAttack()) return 2;
		return 0;
	}

	public void adjustGoal() {
		if (dropSpot == null)
			return;

		else {
			TilePosition newpos = getBestDrop(originalDropSpot);
			if (newpos.getDistance(dropSpot) > 3) {
				dropSpot = newpos;
			}
		}
	}



	public TilePosition getBestDrop(TilePosition tp) {
		Counter<TilePosition> threats = new Counter<TilePosition>();
		int tolerance = 4;
		
		for (int dx = -tolerance; dx < tolerance; dx++) {
			for (int dy = -tolerance; dy < tolerance; dy++) {
				TilePosition newtp = new TilePosition(tp.x() + dx, tp.y() + dy);
				threats.setCount(newtp, 1);
			}
		}
		
		double threat = 0;
		for (ROUnit bldg : master.enemyBuildings) {
			if ((bldg.getType().canAttack() || bldg.getType() == UnitType.TERRAN_BUNKER)) {
				for (TilePosition tp2 : threats.keySet()) {
					threats.incrementCount(tp2 ,15.0/(1+bldg.getLastKnownTilePosition().getDistance(tp2)));
				}
			}
		}

		for (RegionStatus rs : master.regionStatuses) {
			for (ROUnit en : rs.enemies) {
				if (en.getType().canAttack() && !en.getType().isWorker()) {
					for (TilePosition tp2 : threats.keySet()) {
						threats.incrementCount(tp2 ,15.0/(1+en.getLastKnownTilePosition().getDistance(tp2)));
					}
				}

			}

		}
		
		TilePosition best = null;
		double lowest = Double.POSITIVE_INFINITY;
		for (TilePosition eligible : threats.keySet()) {
			if (!Utils.isWalkable(eligible) || !Utils.tileClear(eligible))
				continue;
			if (threats.getCount(eligible) < lowest) {
				lowest = threats.getCount(eligible);
				best = eligible;
			}
		}
		if (best == null) best = tp;
		return best;
	}


}
