package undermind.micropacket;

import java.util.ArrayList;
import java.util.Random;

import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.MicroManager;
import edu.berkeley.nlp.starcraft.util.UnitUtils;

/* A group of units assigned to defend some place in the base */
public class DefensiveSquad extends Squad {
	public Game mGame;
	public int lastSiege = 0;
	public Random rgen;
	public ArrayList<Unit> marines = new ArrayList<Unit>();
	public ArrayList<Unit> medics = new ArrayList<Unit>();
	MarineMovement mover;
	MedicCombatMovement medic_mover;

	public DefensiveSquad(MicroManager m, Position dp) {
		super(m);
		goal = dp;
		mGame = Game.getInstance();
		rgen = new Random();
		
		mover = new MarineMovement();
		medic_mover = new MedicCombatMovement();
	}

	public void onFrame() {
		long starttime = System.currentTimeMillis();
		mover.setGoalPosition(new TilePosition(goal));
		lastSiege++;
		
		Position ave = UnitUtils.avePos(myUnits);
		ROUnit closestE = UnitUtils.getClosest(ave, master.allVisibleEnemies);
		double closestD = Double.POSITIVE_INFINITY;
		if (closestE != null) {
			closestD = UnitUtils.pairDistance(myUnits, master.allVisibleEnemies);
		}
		for (ROUnit bldg : master.enemyBuildings) {
			double d = bldg.getDistance(ave);
			if (bldg.isVisible() && d < closestD) {
				closestD = d;
				closestE = bldg;
			}
			
		}
		
		
		
		if (closestE == null || closestD > 150) {
			for (Unit unit : myUnits) {
				if (unit.isIdle()) unit.attackMove(goal);
			}
		}
		else {
			/* Marine/medic micro is done in one chunk */
			if (MicroUtil.shouldStimSimple(marines, medics, master.allVisibleEnemies)) {
				//Game.getInstance().printf("stimmmmm!");
				for (Unit u : marines) {
					if (u.getHitPoints() >= 30) u.useTech(TechType.STIM_PACKS);
				}
			}
			else { 
				for (Unit u : marines) {
					if (u.isIdle())
						u.attackMove(closestE.getPosition());
				} 
				medic_mover.moveMedics(marines);
			}
		
			/* Rest of the units done separately */
			for (Unit unit : myUnits) {
				UnitType type = unit.getType();
				if (type == UnitType.TERRAN_MARINE || type== UnitType.TERRAN_MEDIC)
					continue;
				ROUnit closestEnemy = UnitUtils.getClosest(unit,
						master.allVisibleEnemies);
				if (closestEnemy != null
						&& (!closestEnemy.isDetected())) {
					master.pleaseScanHere = closestEnemy.getPosition();
				}
	

				
				if (type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE ||
						type == UnitType.TERRAN_GOLIATH || type == UnitType.TERRAN_VULTURE) {
					
					defensiveMechMicro(unit, closestEnemy);
				}
	
				
			}
		}

	}
	
	
	
	
	
	public void defensiveMechMicro(Unit unit, ROUnit closestEnemy) {


			Position p = unit.getPosition();

			double nearestDistance = Double.POSITIVE_INFINITY;
			double closestEnemyd = UnitUtils.getClosestDistance(unit,
					master.allVisibleEnemies);
			if (closestEnemy != null
					&& (!closestEnemy.isDetected())) {
				master.pleaseScanHere = closestEnemy.getPosition();
			}
			if (closestEnemy != null)
				nearestDistance = unit.getTilePosition().getDistance(
						closestEnemy.getPosition());

			if (unit.getType() == UnitType.TERRAN_VULTURE
					&& master.allVisibleEnemies.size() != 0
					&& nearestDistance < 10) {
				TilePosition moveTo = null;

				if (nearestDistance < 4.5 || unit.isAttacking()) {
					TilePosition myPosition = unit.getTilePosition();
					int x = myPosition.x();
					int y = myPosition.y();
					double biggest = nearestDistance;
					for (int dx = -4; dx <= 4; dx++) {
						for (int dy = -4; dy <= 4; dy++) {
							if (x + dx < 0 || x + dx >= mGame.getMapWidth()
									|| y + dy >= mGame.getMapHeight()
									|| y + dy < 0)
								continue;
							TilePosition newPosition = new TilePosition(x
									+ dx, y + dy);
							double newDist = newPosition
									.getDistance(closestEnemy.getPosition());
							Position center = Position
									.centerOfTile(newPosition);
							int xl = center.x() / 8;
							int yl = center.y() / 8;

							int s = mGame.unitsOnTile(newPosition).size();
							boolean canWalk = mGame.isWalkable(xl, yl)
									&& (s == 0 || mGame
											.unitsOnTile(newPosition)
											.iterator().next().getID() == unit
											.getID());
							if (newDist >= biggest && canWalk) {
								biggest = newDist;
								moveTo = newPosition;
							}
						}
					}
					if (moveTo == null) {
						unit.attack(closestEnemy);
					} else
						unit.move(moveTo);
				} else if (nearestDistance < 10)
					unit.attack(closestEnemy);
			} else if (unit.getType() == UnitType.TERRAN_VULTURE
					&& (unit.getTargetPosition() != goal || unit
							.isIdle())) {
				if (unit.getTilePosition().getDistance(goal) > 8) {
					double dist = unit.getTilePosition().getDistance(
							master.medianpos);
					double d2 = unit.getTargetPosition().getDistance(
							master.medianpos);
					if (dist > 28) {
						if (d2 > 500)
							unit.attackMove(master.medianpos);
					} else
						unit.attackMove(goal);
				} else if (unit.getSpiderMineCount() != 0
						&& !unit.isMoving()) {
					Position minePlace = new Position((unit.getPosition()
							.x() + rgen.nextInt(300) - 150), (unit
							.getPosition().y() + rgen.nextInt(300) - 150));
					
					double nearestBase = Bwta.getInstance().getNearestBaseLocation(new TilePosition(minePlace)).getPosition().getDistance(minePlace);
					double d;
					d = goal.getDistance(minePlace);
					while (d < 100 && !mGame.isWalkable(minePlace.x() / 8,
							minePlace.y() / 8) && nearestBase < 180) {
						minePlace = new Position(
								(unit.getPosition().x() + rgen.nextInt(300) - 150),
								(unit.getPosition().y() + rgen.nextInt(300) - 150));
						d = goal.getDistance(minePlace);
					}
					//mGame.drawCircleMap(minePlace, 3, Color.RED, false);

					unit.useTech(TechType.SPIDER_MINES, minePlace);
				}
			}

			if (unit.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE
					|| unit.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) {
				
				
				boolean notjustair = false;
				for (ROUnit en : master.allVisibleEnemies) {
					if (!en.isFlying() && unit
								.getTilePosition().getDistance(en.getTilePosition()) < 16) {
						notjustair = true;
						break;
					}
				}
				
				int siegeRange = 12;
				if (closestEnemy != null && (closestEnemy.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || closestEnemy.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE))
					siegeRange = 13;
				if (master.allVisibleEnemies.size() != 0
						&& closestEnemy != null
						&& ((!closestEnemy.getType().isBuilding() && unit
								.getTilePosition().getDistance(
										closestEnemy.getPosition()) < siegeRange) || (closestEnemy
								.getType().isBuilding()
								&& (closestEnemy.getType().canAttack() || closestEnemy
										.getType() == UnitType.TERRAN_BUNKER || closestEnemy
										.getType().isSpellcaster()) && unit
								.getTilePosition().getDistance(
										closestEnemy.getPosition()) < 11))
						&& notjustair
						) {
					if (!unit.isSieged()) unit.siege();
					lastSiege = 0;
				} else if (unit.getTargetPosition() != goal
						&& unit.getTilePosition().getDistance(goal) > 6
						|| unit.isIdle()) {
					if (unit.isSieged() && !unit.isAttacking()
							&& unit.isIdle() && lastSiege >= 200 && unit.getTilePosition().getDistance(
									master.medianpos) >= 6) {
						unit.unsiege();
					} else if (!unit.isSieged()) {

						double dist = unit.getTilePosition().getDistance(
								master.medianpos);
						double d2 = unit.getTargetPosition().getDistance(
								master.medianpos);
						if (dist > 28) {
							if (d2 > 800)
								unit.attackMove(master.medianpos);
						} else {
							if (dist < 6 && unit.isIdle())
								unit.siege();
							else
								unit.attackMove(goal);
						}
						
						

					}

				}
			}

			if ((unit.getType() == UnitType.TERRAN_GOLIATH)) {
				if (master.allVisibleEnemies.size() != 0
						&& closestEnemy != null
						&& ((!closestEnemy.getType().isBuilding() && unit
								.getTilePosition().getDistance(
										closestEnemy.getPosition()) < 16) || (closestEnemy
								.getType().isBuilding()
								&& (closestEnemy.getType().canAttack() || closestEnemy
										.getType() == UnitType.TERRAN_BUNKER) && unit
								.getTilePosition().getDistance(
										closestEnemy.getPosition()) < 12))
						&& (closestEnemy.getType().canAttack() || closestEnemy
								.getType().isSpellcaster())) {

					ROUnit targ = null;
					int bestprio = -1000;
					for (ROUnit ue : master.allVisibleEnemies) {
						if (ue.getDistance(unit) < 450+GoliathSquad.acquisitionBonus
								&& master.getGPriority(ue, unit, false) > bestprio
								&& ue.getDistance(unit) < 300+GoliathSquad.acquisitionBonus) {
							bestprio = master.getGPriority(ue, unit, false);
							targ = ue;
						}
					}
					for (ROUnit ue : master.enemyBuildings) {
						if (ue.getDistance(unit) < 550
								&& master.getGPriority(ue, unit, false) > bestprio
								&& ue.getDistance(unit) < 300) {
							bestprio = master.getGPriority(ue, unit, false);
							targ = ue;
						}
					}

					ROUnit k = unit.getTarget();
					if (targ != null && master.time % 20 == 0 && (unit.getTarget() == null && unit.getOrderTarget() == null) || (targ != null && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID())) {
						unit.rightClick(targ);
					} else if (targ == null && k == null
							&& unit.getOrderTarget() == null
							&& closestEnemyd > 280) {
						unit.attackMove(goal);
					}

				} else {
					double dist = unit.getTilePosition().getDistance(
							master.medianpos);
					double d2 = unit.getTargetPosition().getDistance(
							master.medianpos);
					if (dist > 28) {
						if (d2 > 800)
							unit.attackMove(master.medianpos);
					} else
						unit.attackMove(goal);
				}
			}

			
			// TODO: missing -- don't impale self on photon cannons and similar devilries


		}
	
	
	public void addUnit(Unit u) {
		mover.addMarine(u);
		myUnits.add(u);
		if (u.getType() == UnitType.TERRAN_MARINE) {
			marines.add(u);
			mover.addMarine(u);
		}
		else if (u.getType() == UnitType.TERRAN_MEDIC) {
			medics.add(u);
			medic_mover.addMedic(u);
		}
	}
	
	
	public void removeUnit(Unit u) {
		Unit removeme = null;
		for (Unit unit : myUnits) {
			if (unit.getID() == u.getID()) {
				removeme = unit;
				break;
			}
		}
		
		if (removeme != null) {
			myUnits.remove(removeme);
			marines.remove(removeme);
			medics.remove(removeme);
			mover.removeMarine(removeme);
		}

	}
	
	
}
