package undermind.micropacket;

import org.bwapi.proxy.model.Position;

import edu.berkeley.nlp.starcraft.util.Vector;

public class BeaconParticle extends Particle {
	Position mass_center = null;
	public void updateCenter(Position p){
		mass_center = p;
	}
	
	//ghetto function pointer lul
	//exert a my field as a force on another particle
	public Vector exertField(Particle particle) {
		Vector ret = Vector.ZERO;
		for (String func : fields){
			if (func.equals("attract")) ret = ret.add(exertAttractionField(particle));
			if (func.equals("beacon")) ret = ret.add(exertBeaconField(particle));
			if (func.equals("jitter")) ret = ret.add(exertJitterField(particle));
			if (func.equals("sheep")) ret = ret.add(exertSheepField(particle));
			if (func.equals("parallel")) ret = ret.add(exertParallelField(particle));
		}
		return ret;
	}
	
	//Parallel field, makes marine a herd of sheeps...
	public void setParallelField(){fields.add("parallel");}
	public void unsetParallelField(){fields.remove("parallel");}
	public Vector exertParallelField(Particle particle){
		//tune-able
		double overall_strength    = 300.0;
		double relative_point = 1.0;
		double relative_mass = 1.0;
		
		double mass_distance  = new Vector(this.mass_center, location.toPosition()).length();
		Vector mass_direction = new Vector(mass_center, location.toPosition()).normalize();
		double point_distance = new Vector(particle.location.toPosition(), location.toPosition()).length();
		Vector point_direction  = new Vector(particle.location.toPosition(), location.toPosition()).normalize();

		double difference = point_direction.dot(mass_direction);
		Vector adjusted_mass_v  = mass_direction.scale(difference).scale(relative_mass);
		Vector adjusted_point_v = point_direction.scale(1.0 - Math.abs(difference)).scale(relative_point);
		
		return adjusted_mass_v.add(adjusted_point_v).scale(overall_strength);
	}
}
