package undermind.macro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.python.google.common.collect.ArrayListMultimap;

import undermind.WorkerStatus;
import undermind.WorkerStatus.WorkerState;
import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.util.FastPriorityQueue;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;

/**
 * Created by IntelliJ IDEA.
 * User: Ibrahim
 * Date: 6/21/11
 * Time: 12:33 AM
 * To change this template use File | Settings | File Templates.
 */
public class WorkerManager extends AbstractCerebrate {
	public boolean scoutSent = false;
	public TilePosition enemyMain;
	List<TilePosition> enemyBaseTiles;
	private WorkerStatus myDefender;
	private WorkerStatus scout = null;
	private Player me;
	private Game mGame;
	private MacroManager macroManager;
	public final List<WorkerStatus> workerStatuses = new ArrayList<WorkerStatus>();
	public int workersCreated;
	protected HashMap<ROUnit, LinkedList<WorkerStatus>> mineralmap = new HashMap<ROUnit, LinkedList<WorkerStatus>>();
	protected ArrayListMultimap<ROUnit, WorkerStatus> refineryToGuys = ArrayListMultimap.create();

	public WorkerManager(MacroManager macroManager) {
		this.macroManager = macroManager;
	}

	public void onStart() {
		mGame = Game.getInstance();
		me = mGame.self();
		for (ROUnit u : macroManager.myBaseLocation.getMinerals()) {
			mineralmap.put(u, new LinkedList<WorkerStatus>());
		}
	}

	void assignNewWorker(Unit worker) {
		if(getWorkerStatus(worker) != null){
			//System.out.println("X_X guy being added twice, stop.");
			Thread.dumpStack();
			return;
		}
		if (worker.getType().isWorker()) {
			//System.out.println("Trying to assign a job to worker ID "+worker.getID());
			WorkerStatus workerStatus = new WorkerStatus(worker);
			workerStatuses.add(workerStatus);
			if (!saturatedGas()) {
				assignGasMiner(workerStatus);
			} else {
				assignMiner(workerStatus);
			}
		} else {
			//System.out.println("Why is a " + worker + " masquerading as a worker?");
		}
	}

	private void assignGasMiner(WorkerStatus workerStatus) {

		if (workerStatus.getState() == WorkerState.SCOUTING)
			return; //yay hacks
		Unit worker = workerStatus.unit;
		//System.out.println("Worker ID "+worker.getID() + " should mine gas");
		workerStatus.setState(WorkerState.REFINING);
		for (BuildingStatus bs : macroManager.myRefineries) {
			Unit refinery = bs.myUnit;
			if (refineryToGuys.get(refinery).size() >= 3)
				continue;
			refineryToGuys.put(refinery, workerStatus);
			workerStatus.target = refinery;
			if (refinery != null && refinery.getRemainingBuildTime() > 0) {
			}
		}
	}

	private void assignMiner(WorkerStatus workerStatus) {
		if (workerStatus.getState() == WorkerState.SCOUTING)
			return; //yay hacks
		Unit worker = workerStatus.unit;
		workerStatus.setState(WorkerState.MINING);
		ROUnit closestPatch = choosePatchForMiner(worker);
		//System.out.println("Worker ID "+worker.getID() + " should mine minerals at"
		//		+closestPatch.getPosition().toString());
		assignWorkerToPatch(workerStatus, closestPatch);
		worker.rightClick(closestPatch);
	}

	private void assignWorkerToPatch(WorkerStatus worker, ROUnit closestPatch) {
		mineralmap.get(closestPatch).add(worker);
		worker.target = closestPatch;
	}

	/**
	 * Assigns a worker to the closest unsaturated mineral patch
	 *
	 * @param worker
	 * @return
	 */
	private ROUnit choosePatchForMiner(Unit worker) {
		//1. Get a list of the unsaturated mineral patches.
		//2. Find the closest one.
		Position workerpos = worker.getPosition();
		FastPriorityQueue<ROUnit> minerals = new FastPriorityQueue<ROUnit>();
		for (Map.Entry<ROUnit, LinkedList<WorkerStatus>> min : mineralmap.entrySet()) {
			minerals.setPriority(min.getKey(), (2 - min.getValue().size()) * 20000 + min.getKey().getDistance(workerpos));
		}
		return minerals.getFirst();
	}

	private void reassignWorkers(){
		//mGame.printf("Fixing worker stuff");
		List<ROUnit> workeries = UnitUtils.getAllMy(UnitType.TERRAN_SCV);
		List<ROUnit> refineries = UnitUtils.getAllMy(UnitType.TERRAN_REFINERY);
        Iterator<WorkerStatus> witer = workerStatuses.iterator();
        while(witer.hasNext()){//Purge dead workers
            if(!witer.next().unit.exists()){
                witer.remove();
            }
        }
		for (ROUnit unit : workeries){//This should make sure there are no idlers, not positive though.
			Unit w = UnitUtils.assumeControl(unit);
			WorkerStatus workerStatus = getWorkerStatus(w);
			if(workerStatus == null){//Assign unassigned workers as if they just appeared.
				assignNewWorker(w);
			}
			else if(workerStatus.idleCycles > 100 && workerStatus.getState() != WorkerState.SCOUTING){
				//System.out.println(w+" is idle, not sure why, because he has a job. Telling him to mine again.");
				removeMiner(workerStatus);
				assignMiner(workerStatus);
			}
		}
		for (ROUnit r: refineries){//This makes sure refineries are saturated
			if(!refineryToGuys.keySet().contains(r) || refineryToGuys.get(r).size()<3){
				WorkerStatus w = getWorker();
				removeMiner(w);
				assignGasMiner(w);
			}
		}
		Iterator<Map.Entry<ROUnit, WorkerStatus>> refineryIter = refineryToGuys.entries().iterator();
		while(refineryIter.hasNext()){
			Map.Entry<ROUnit, WorkerStatus> entry = refineryIter.next();
			ROUnit r = entry.getKey();
			WorkerStatus ws = entry.getValue();
			if(ws.target != null && !ws.target.equals(r)){
				refineryIter.remove();
			}
		}
		LinkedList<WorkerStatus> extramin = new LinkedList<WorkerStatus>();
		for(LinkedList<WorkerStatus> miners : mineralmap.values()){
			if(miners.size()>3){
                //System.out.println("[W] Removing extra workers from mineral patch");
				int i = 0;
				Iterator<WorkerStatus> mm = miners.iterator();
				while(mm.hasNext()){
                    WorkerStatus ws = mm.next();
					i++;
					if (i > 3){
						extramin.add(ws);
						//removeMiner(ws);//This was unnecessary?
						mm.remove();
					}
				}
			}
		}
        //System.out.println("[W] Found " + extramin.size() + " oversaturating workers");
		for(WorkerStatus ws : extramin){
			assignMiner(ws);
		}
		if(!extramin.isEmpty()){
			//mGame.printf("Removed %d extra miners and reassigned them", extramin.size());
		}
	}

	/**
	 * When expanding, call this function to assign workers to the new base.
	 *
	 * @param base
	 */
	protected void addBase(BaseLocation base) {
        boolean invalid = false;
		for (ROUnit u : base.getStaticMinerals()) {
            if(u.getPosition().equals(Position.INVALID)){
                //System.out.println("Base location has invalid minerals!??" + base.getTilePosition());
                invalid = true;//TODO: Do something smart when this happens?
                
                continue;
            }
			mineralmap.put(u, new LinkedList<WorkerStatus>());
			//System.out.println("Added new minerals");
		}
		

		transferWorkers(base);
	}

	/**
	 * Transfers 7 workers to a new base.
	 *
	 * @param base
	 */
	private void transferWorkers(BaseLocation base) {
		int unitsLeft = 7;
		Iterator<? extends ROUnit> iter = base.getMinerals().iterator();
		//if(base.getMinerals().isEmpty()) mGame.printf("WHERE ARE MY MINERALS T_T");
		for (LinkedList<WorkerStatus> wStatuses : mineralmap.values()) {
			if (!wStatuses.isEmpty()) {
				WorkerStatus ws = wStatuses.pop();//Remove worker from the old patch
				//System.out.println("Removed "+ws.unit+" from patch");
				unitsLeft--;
				if (!iter.hasNext())
					iter = base.getMinerals().iterator();
				ROUnit min = iter.next();
				if (mineralmap.get(min) != null && ws != null) mineralmap.get(min).add(ws);
				ws.unit.rightClick(min);
			}
			if (unitsLeft <= 0) break;
		}
	}

	protected boolean saturatedGas() {
		int count = 0;
		for (BuildingStatus r : macroManager.myRefineries) {
			if (r.status == BuildingStatus.BUILT)
				count++;
		}

		return refineryToGuys.values().size() >= count * 3;
	}

	public void workerManagement() {
		handleSparkies();

		/* Repairs */
		doRepairs();

		/* Worker status update, basically just bookkeeping */
		workerBookkeeping();


		/* Gas management */
		gasManagement();

		/* Worker orders */
		for (int i = 0; i < numWorkers(); i++) {
			WorkerStatus currentworkerStatus = workerStatuses.get(i);
			Unit u = currentworkerStatus.unit;
			int id = u.getID();
			//Tell idle workers to mine
			WorkerState state = currentworkerStatus.getState();
			if (isWorkerUnemployed(currentworkerStatus) && u.isCompleted()) {
                if(currentworkerStatus.getState() == WorkerState.BUILDING){
                    //System.out.println("WADSAWDASDHSDAWDASDSD");
                }
				currentworkerStatus.setState(WorkerState.MINING);
				ROUnit closestPatch = currentworkerStatus.target;
				if (closestPatch != null && currentworkerStatus.idleCycles >= 3){
                    if(closestPatch.getPosition().equals(Position.INVALID)){
                        u.rightClick(closestPatch.getLastKnownPosition());
                    }else{
                        u.rightClick(closestPatch);
                    }
                }
				else if(currentworkerStatus.idleCycles>=3 && currentworkerStatus.unit.exists()){//Maybe this is the right thing to do.
                    //System.out.println("Removing and reassigning Worker["+currentworkerStatus.getID()+"] since he seems to have become lazy");
					removeMiner(currentworkerStatus);
					assignMiner(currentworkerStatus);
				}else if(!currentworkerStatus.unit.exists()){
                   //System.out.println("[X] This worker seems to have disappeared");
                }
			}
//            if (state == WorkerState.MINING && u.getOrder() != null && u.getOrder().equals(Order.MOVE_TO_MINERALS)
//                    && u.getTarget() != null && !u.getTarget().equals(currentworkerStatus.target)) {// For miners moving to the wrong minerals
//                u.rightClick(currentworkerStatus.target);
//            }
			if (state == WorkerState.SCOUTING) {
				scoutSent = true;
				boolean targetted = false;
				ArrayList<ROUnit> enemies = new ArrayList<ROUnit>();
				for (ROUnit un : mGame.getAllUnits()) {
					if (un.getPlayer() != me
							&& (un.getType() == UnitType.TERRAN_SCV
									|| un.getType() == UnitType.ZERG_DRONE || un.getType() == UnitType.PROTOSS_PROBE)) {
						enemies.add(un);
						if ((un.getTarget() != null && un.getTarget().getID() == u.getID())
								|| (un.getOrderTarget() != null && un.getOrderTarget().getID() == u.getID()))
							targetted = true;
					}
				}


				ROUnit closestEnemy = UnitUtils.getClosest(
						currentworkerStatus.unit, enemies);

				if (closestEnemy != null
						&& (closestEnemy.isAttacking() || targetted)
						&& macroManager.eligibleEnemyStarts.size() == 1) {
					TilePosition moveTo = null;
					TilePosition myPosition = u.getTilePosition();
					int x = myPosition.x();
					int y = myPosition.y();
					double biggest = u.getTilePosition().getDistance(
							closestEnemy.getPosition());
					for (int dx = -16; dx <= 16; dx++) {
						for (int dy = -16; dy <= 16; dy++) {
							if (x + dx < 0 || x + dx >= mGame.getMapWidth()
									|| y + dy >= mGame.getMapHeight()
									|| y + dy < 0)
								continue;
							TilePosition newPosition = new TilePosition(x + dx,
									y + dy);
							double newDist = newPosition.getDistance(UnitUtils
									.medianPos(enemies));
							Position center = Position
									.centerOfTile(newPosition);
							int xl = center.x() / 8;
							int yl = center.y() / 8;

							int s = mGame.unitsOnTile(newPosition).size();
							boolean canWalk = mGame.isWalkable(xl, yl)
									&& (s == 0 || mGame.unitsOnTile(newPosition)
											.iterator().next().getID() == u.getID());
							if (newDist >= biggest && canWalk) {
								biggest = newDist;
								moveTo = newPosition;
							}
						}
					}
					if (moveTo == null) {
						u.move(new Position(1, 1));
					} else
						u.move(moveTo);

				} else if (macroManager.eligibleEnemyStarts.size() == 1
						&& macroManager.enemyBaseRegion.contains(u.getPosition())) {

					if (enemyBaseTiles == null) {
						enemyBaseTiles = new ArrayList<TilePosition>();
						Region baseRegion = null;
						for (Region r : macroManager.myBwta.getRegions()) {
							if (r.contains(macroManager.eligibleEnemyStarts.get(0))) {
								baseRegion = r;
								break;
							}
						}

						TilePosition orig = macroManager.eligibleEnemyStarts
								.get(0);
						for (int dx = -30; dx < 31; dx++) {
							for (int dy = -30; dy < 31; dy++) {
								TilePosition tp = new TilePosition(orig.x()
										+ dx, orig.y() + dy);
								if (!mGame.isBuildable(tp.x(), tp.y())
										|| !Utils.isWalkable(tp)
										|| !baseRegion.contains(tp))
									continue;
								enemyBaseTiles.add(tp);

							}
						}
					}

					else {
						List<TilePosition> tr = new ArrayList<TilePosition>();
						for (TilePosition tp : enemyBaseTiles) {
							if (mGame.isVisible(tp))
								tr.add(tp);
						}
						enemyBaseTiles.removeAll(tr);
					}

					/*
					 * for (TilePosition tp : enemyBaseTiles) {
					 * mGame.drawCircleMap(Position.centerOfTile(tp), 5,
					 * Color.RED, true); }
					 */
					if (enemyBaseTiles.size() != 0)
						currentworkerStatus.unit.move(enemyBaseTiles.get(0));
					else if (closestEnemy != null && enemyBaseTiles.size() == 0)
						currentworkerStatus.unit.attack(closestEnemy);
					else currentworkerStatus.unit.move(macroManager.eligibleEnemyStarts.get(0));

					// TODO: Harass toggle on/off here
					// if (closestEnemy != null)
					// currentworkerStatus.unit.attack(closestEnemy);
				} else {
					Position g;

					if (macroManager.eligibleEnemyStarts.size() == 1) {
						g = Utils.nearestChoke(new Position(
								macroManager.eligibleEnemyStarts.get(0)));
						if (currentworkerStatus.unit.getDistance(g) < 500)
							currentworkerStatus.unit.rightClick(macroManager.eligibleEnemyStarts.get(0));
						else
							currentworkerStatus.unit.rightClick(g);
					} else {
						g = Utils.nearestChoke(new Position(macroManager.target));
						if (currentworkerStatus.unit.getDistance(g) < 1200)
							currentworkerStatus.unit.rightClick(macroManager.target);
						else
							currentworkerStatus.unit.rightClick(g);
					}
				}
			}

		}

		if (numWorkers() < 9) {
			macroManager.scouting = false;
		} else macroManager.scouting = true;
		if (macroManager.scouting) {
			Set<TilePosition> positions = mGame.getStartLocations();
			for (TilePosition p : positions) {
				if (!p.equals(macroManager.myHome) && !mGame.isExplored(p)) {
					macroManager.target = p;
				}
			}
			if (scout == null && !scoutSent) {
				scout = getWorker();
				scout.setState(WorkerState.SCOUTING);
			}
			if (!scoutSent && scout != null) { 
				scout.unit.rightClick(Position.centerOfTile(macroManager.target));


			}
		}
	}

	private void gasManagement() {
		if(me.gas() < (me.minerals()+30)*2 || (macroManager.mech && me.gas() < (me.minerals()+30)*3)){//If we don't have enough gas
			for (BuildingStatus r : macroManager.myRefineries) {
				if (r.status == BuildingStatus.BUILT && numWorkers() != 0) {
					for (WorkerStatus ws : refineryToGuys.get(r.myUnit)){
						Unit worker = ws.unit;
						if(!worker.isCarryingGas() && ! worker.isGatheringGas() && !worker.isCarryingMinerals()){
							worker.rightClick(r.myUnit);
						}
					}
				}
			}
		}else{//If we have too much gas
			for(WorkerStatus ws : refineryToGuys.values()){
				Unit u = ws.unit;
				if(!u.isCarryingGas() && !u.isCarryingMinerals() && !u.isGatheringMinerals()){
					//TODO: Restrict to minerals in the same base as the worker; should be fairly easy
					ROUnit closest = UnitUtils.getClosest(u, mGame.getMinerals());
					if (closest != null)
						u.rightClick(closest);
				}
			}
		}
	}

	private void workerBookkeeping() {
		for (int i = 0; i < numWorkers(); i++) {
			WorkerStatus workerStatus = workerStatuses.get(i);
			Unit unit = workerStatus.unit;
			Unit w = unit;
			int id = w.getID();
			if (w.isConstructing()){
                workerStatus.setState(WorkerState.BUILDING);
            }

			if (w.isGatheringMinerals() && !(workerStatus.getState() == WorkerState.BUILDING || workerStatus.getState() == WorkerState.REFINING)) { // That second check is kind of a cheap workaround... The underlying bug/issue is that a worker can get assigned different statuses in the same frame...
				workerStatus.setState(WorkerState.MINING);
			}
			if (w.isGatheringGas() && workerStatus.getState() != WorkerState.BUILDING) {// That second check is kind of a cheap workaround... The underlying bug/issue is that a worker can get assigned different statuses in the same frame...
				workerStatus.setState(WorkerState.REFINING);
				ROUnit r = w.getTarget();
				if(!refineryToGuys.containsEntry(r, workerStatus))
					refineryToGuys.put(r, workerStatus);
			}
			if (workerStatus.idleCycles>5 && !(workerStatus.getState() == WorkerState.SCOUTING || workerStatus.getState() == WorkerState.BUILDING)
                    && w.isCompleted()) {
				workerStatus.setState(WorkerState.NONE);
			}
			if (macroManager.defense != 0 && i < macroManager.defense) {
				if (workerStatus.getState() == WorkerState.SCOUTING) {
					continue;
				}
				//mGame.printf("Defending with " + macroManager.defense);
				ArrayList<ROUnit> en = new ArrayList<ROUnit>();
				ArrayList<ROUnit> enbldg = new ArrayList<ROUnit>();

				List<ROUnit> bunkers = UnitUtils.getAllMy(UnitType.TERRAN_BUNKER);

				Region baseRegion = null;
				for (Region r : macroManager.myBwta.getRegions()) {
					if (r.contains(macroManager.myHome)) {
						baseRegion = r;
						break;
					}
				}

				for (ROUnit u : mGame.getAllUnits()) {
					double p = u.getDistance(Position.centerOfTile(macroManager.myHome));
					if (!u.getPlayer().isEnemy(me))
						continue;
					double bunkdist = Double.POSITIVE_INFINITY;
					for (ROUnit bunk : bunkers) {
						if (u.getDistance(bunk) < bunkdist)
							bunkdist = u.getDistance(bunk);
					}
					if (baseRegion.contains(u.getPosition()) && ((u.getType() == UnitType.PROTOSS_PYLON || u.getType() == UnitType.TERRAN_BUNKER)))
						enbldg.add(u);
					else if ((baseRegion.contains(u.getPosition()) || bunkdist < 200 || u.getDistance(unit) < 100) && u.getType().canAttack()) en.add(u);
				}
				workerStatus.setState(WorkerState.FIGHTING);
				if (unit.getTarget() == null || unit.isGatheringMinerals()) {
					ROUnit closeBunker = null;
					double dist = Double.POSITIVE_INFINITY;

					for (ROUnit bunka : bunkers) {
						if (unit.getDistance(bunka) < dist && bunka.getLoadedUnits().size() != 0) {
							dist = unit.getDistance(bunka);
							closeBunker = bunka;
						}
					}

					if (i % 2 == 0 && closeBunker != null && closeBunker.getDistance(unit) < 100 && closeBunker.getHitPoints() < closeBunker.getType().maxHitPoints() && closeBunker.getHitPoints() > 0)
						unit.repair(closeBunker);
					else if (!baseRegion.contains(unit.getPosition()))
						unit.move(baseRegion.getCenter());
					else if ((i % 2 == 0 || enbldg.size() == 0) && en.size() != 0)
						unit.attack(UnitUtils.getClosest(unit, en));
					else if (UnitUtils.getClosest(unit, enbldg) != null)
						unit.attack(UnitUtils.getClosest(unit, enbldg));
					else unit.move(macroManager.natChoke.getCenter());

				}
			} else {
				if (workerStatus.getState() == WorkerState.FIGHTING) {
					if (unit.isStopped()) workerStatus.setState(WorkerState.NONE);
					else unit.stop();
				}
			}
			if (macroManager.defense == 0 && workerStatus.getState() == WorkerState.FIGHTING && myDefender != workerStatus) {
				workerStatus.setState(WorkerState.NONE);
			}
			if (macroManager.debug) {
				mGame.drawTextMap(new Position(w.getPosition().x(), w.getPosition().y() + 30), workerStatus.getState() + "");
				mGame.drawTextMap(new Position(w.getPosition().x(), w.getPosition().y()), unit.getID() + "");
			}
		}
		Iterator<ROUnit> iter = refineryToGuys.keySet().iterator();
		while(iter.hasNext()){
			ROUnit r = iter.next();
			if (r == null || !r.getType().equals(UnitType.TERRAN_REFINERY)){
				iter.remove();//I don't know why this would happen, but catch it just in case.
			}
		}
	}

	private void doRepairs() {
		for (BuildingStatus c : macroManager.myBuildings) {
			if (c.myUnit != null && c.myUnit.isCompleted() && c.myUnit.getHitPoints() < c.myUnit.getType().maxHitPoints() && c.myUnit.getHitPoints() > 0 
					&& (c.myUnit.getType() != UnitType.TERRAN_ENGINEERING_BAY || !c.myUnit.isLifted())) {
				WorkerStatus w = getWorker(c.spot);
				if (w != null && w.unit != null && (w.unit.isIdle() || w.unit.isGatheringMinerals())) {
					w.setState(WorkerState.FIGHTING);
					w.unit.repair(c.myUnit);
				}

				if (c.type == UnitType.TERRAN_BUNKER) {
					WorkerStatus w2 = getWorker(c.spot);
					if (w2 != null && w2.unit != null && (w2.unit.isIdle() || w2.unit.isGatheringMinerals())) {
						w2.setState(WorkerState.FIGHTING);
						w2.unit.repair(c.myUnit);
					}
				}
			}
		}
	}

	private void handleSparkies() {
		if (macroManager.enemySparky != null) {
			if (myDefender == null || myDefender.getState() == WorkerState.BUILDING) {
				myDefender = getWorker();
				myDefender.setState(WorkerState.FIGHTING);
			} else myDefender.unit.attack(macroManager.enemySparky);
		} else {
			if (myDefender != null) {
				myDefender.setState(WorkerState.NONE);
				myDefender.unit.stop();
				if (myDefender.unit.isStopped())
					myDefender = null;
			}
		}
	}

	private boolean isWorkerUnemployed(WorkerStatus workerStatus) {
		Unit u = workerStatus.unit;
		return (u.isIdle() || u.isStopped() || workerStatus.getState() == WorkerState.NONE ||
				(workerStatus.getState() == WorkerState.MINING && !u.isCarryingMinerals() && u.getTarget() == null && u.getOrderTarget() == null))
				&& workerStatus.getState() != WorkerState.BUILDING && workerStatus.getState() != WorkerState.SCOUTING
				&& workerStatus.getState() != WorkerState.FIGHTING;
	}

	@Override
	public void onUnitShow(ROUnit unit) {
		if (unit == null) {
			return;
		}
		if (unit.getType() == null) return;
		if (unit.getType().isWorker() && unit.getPlayer() == me) {
			workersCreated++;
			assignNewWorker(UnitUtils.assumeControl(unit));//Does all the magic, handles status stuff
			BuildingStatus best = closestBuilding(unit);
			if (best != null) {
				best.unitsproduced++;
			}
		}
	}

	private BuildingStatus closestBuilding(ROUnit unit) {
		double closest = Double.POSITIVE_INFINITY;
		BuildingStatus best = null;
		for (BuildingStatus cc : macroManager.getMyCCs()) {
			if (cc.myUnit == null) continue;
			double d = unit.getLastKnownPosition().getDistance(cc.myUnit.getLastKnownPosition());
			if (d < closest) {
				closest = d;
				best = cc;
			}
		}
		return best;
	}

	@Override
	public void onUnitDestroy(ROUnit unit) {
		if (unit == null) return;
		if (unit.getType() == null) return;
		int id = unit.getID();
		if (unit.getPlayer() == me && unit.getType() == UnitType.TERRAN_SCV) {
			WorkerStatus ws = null;
			for (int i = 0; i < numWorkers(); i++) {
				if (id == workerStatuses.get(i).unit.getID()) {
					ws =workerStatuses.remove(i);
					if (myDefender != null && id == myDefender.unit.getID()) {
						myDefender = null;
					}
					break;
				}
			}

			if (scout != null && scout.unit != null && scout.unit.getID() == unit.getID()) {
				scout = null;
			}

			double closest = Double.POSITIVE_INFINITY;
			BuildingStatus best = null;
			for (BuildingStatus cc : macroManager.getMyCCs()) {
				if (cc.myUnit == null) continue;
				double d = unit.getLastKnownPosition().getDistance(cc.myUnit.getLastKnownPosition());
				if (d < closest) {
					closest = d;
					best = cc;
				}
			}
			if (best != null) best.unitsproduced--;

			//Update bookkeeping structures

			removeMiner(ws);
			refineryToGuys.remove(ws.target, ws);
		}else if(unit.getType().equals(UnitType.RESOURCE_MINERAL_FIELD)){
			//Remove the workers assigned and reassign them
			LinkedList<WorkerStatus> bums = mineralmap.get(unit);
			mineralmap.remove(unit);
			if (bums != null) for(WorkerStatus worker: bums){
				assignWorkerToPatch(worker, choosePatchForMiner(worker.unit));
			}
			//TODO: Handle minerals disappearing.
		}
	}

	/**
	 * @return the number of workers
	 */
	protected int numWorkers() {
		return workerStatuses.size();
	}


	/**
	 * Get a worker for some task.
	 * IMPORTANT -- YOU ARE RESPONSIBLE FOR SETTING THE WORKER STATUS AFTER USING HIM!
	 */
	protected WorkerStatus getWorker() {
		if (numWorkers() == 0) return null;
		WorkerStatus worker = workerStatuses.get(0);
		for (int z = 0; z < numWorkers(); z++) {
			WorkerStatus workerStats = workerStatuses.get(z);
			if (workerStats.unit != null && workerBuilding(workerStats.unit))
				continue;
			if ((workerStats.getState() == WorkerState.MINING)
					&& workerStats.unit.isCompleted()) {
				worker = workerStats;
				break;
			}
		}
		return worker;

	}

	/**
	 * Same as getWorker(), but gets the available worker closest to the given tileposition.
	 */
	WorkerStatus getWorker(TilePosition p) {
		if (numWorkers() == 0) return null;
		WorkerStatus bestworker = workerStatuses.get(0);
		double bestdistance = Double.POSITIVE_INFINITY;
		for (int z = 0; z < numWorkers(); z++) {
			WorkerStatus workerStats = workerStatuses.get(z);
			if (workerStats.unit != null && workerBuilding(workerStats.unit))
				continue;
			if ((workerStats.getState() == WorkerState.MINING) && workerStats.unit.isCompleted()) {
				if (p == null) {
					//mGame.printf("Uh oh... getWorker got a null position");
					return workerStats;
				}
				if (workerStats.unit.getPosition().getDistance(Position.centerOfTile(p)) < bestdistance) {
					bestdistance = workerStats.unit.getPosition().getDistance(Position.centerOfTile(p));
					bestworker = workerStats;
				}

			}
		}
		return bestworker;

	}


	public boolean workerBuilding(Unit worker) {
		for (BuildingStatus bs : macroManager.myBuildings) {
			if ((bs.status == BuildingStatus.SCHEDULED || bs.status == BuildingStatus.BUILDING) && bs.myBuilder != null && bs.myBuilder.getID() == worker.getID())
				return true;
		}
		return false;
	}

	/**
	 * Draw some helpful diagnostics on the screen.
	 */
	protected void drawDiagnostics() {
		for (Map.Entry<ROUnit, LinkedList<WorkerStatus>> entry : mineralmap.entrySet()) {
			ROUnit min = entry.getKey();
			for (WorkerStatus w : entry.getValue()) {
				mGame.drawLineMap(new Position(min.getLastKnownTilePosition()), w.getPosition(), Color.PURPLE);
				mGame.drawTextMap(w.getPosition(), String.valueOf(w.getID()));
				mGame.drawTextMap(w.getPosition().add(-10,-10), "M " + w.getState());
			}
            String t = "";
            if(min.getPosition().equals(Position.INVALID)) t = " I";
			mGame.drawTextMap(min.getLastKnownPosition(), "M " + entry.getValue().size() + t);
		}
		for(Map.Entry<ROUnit, WorkerStatus> entry : refineryToGuys.entries()){
			ROUnit r = entry.getKey();
			WorkerStatus ws = entry.getValue();
			Unit w = ws.unit;
			mGame.drawTextMap(w.getPosition().add(-10,-10), "G "+ ws.getState());
			if(w != null && r != null)
				mGame.drawLineMap(r.getPosition(), w.getPosition(), Color.GREEN);
		}
		mGame.drawTextScreen(500, 100, "AvgMiners: " + String.format("%.2f", mineralSaturation()));
		mGame.drawTextScreen(500, 120, "AvgGas: " + String.format("%.2f", gasSaturation()));
	}

	@Override
	public void onFrame() {
        idleTracking();
		workerManagement();
		drawDiagnostics();
		if(mGame.getFrameCount()%1000 == 0){
			reassignWorkers();
		}
	}

	private void idleTracking() {
		for(WorkerStatus ws : workerStatuses){
			if(ws.unit.isIdle()){
				ws.idleCycles++;
			}else{
				ws.idleCycles = 0;
			}
		}
	}

	void removeMiner(WorkerStatus worker) {
		ROUnit patch = worker.target;
		if (patch != null && mineralmap.get(patch) != null) mineralmap.get(patch).remove(worker);
		if(patch != null && patch.getType().equals(UnitType.TERRAN_REFINERY)){
			//System.out.println("WTF this guy is supposed to be a miner not a gas miner");
		}else if (patch == null){
			//System.out.println("Removing this miner ["+worker.getID()+"] the hard way, he got lost or something.");
			for(LinkedList<WorkerStatus> miners : mineralmap.values()){
				miners.remove(worker);
			}
		}
		worker.target = null;
	}
	private WorkerStatus getWorkerStatus(Unit worker){
		for(WorkerStatus ws : workerStatuses){
			if(ws.unit.equals(worker)){
				return ws;
			}
		}
		return null;
	}
	public double mineralSaturation(){
		double avg = 0;
		for(LinkedList<WorkerStatus> miners : mineralmap.values()){
			avg += miners.size();
		}
		avg /= mineralmap.size();
		return avg;
	}
	public double gasSaturation(){
		return (double)refineryToGuys.values().size() / (double) refineryToGuys.keySet().size();
	}
}
