package undermind.macro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;

import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.UpgradeType;

import undermind.AStarSearch;
import undermind.ValuedUnitType;
import undermind.WorkerStatus;
import undermind.WorkerStatus.WorkerState;
import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.scripting.Command;
import edu.berkeley.nlp.starcraft.scripting.JythonInterpreter;
import edu.berkeley.nlp.starcraft.scripting.Thunk;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
public class MacroManager extends AbstractCerebrate implements Strategy {

	public boolean lurkers = false;
	ArrayList<ROUnit> basestr = new ArrayList<ROUnit>();
	public boolean wantsToLift = false;
	public Unit wallDoor;
	public Region natRegion;
	public List<TilePosition> chokeBuffer;
	public Region baseRegion;
	public Region enemyBaseRegion = null;
	public List<TilePosition> wall;
	public long lastInject = -10000;
	public List<TilePosition> eligibleEnemyStarts;
	public List<ROUnit> enemyBuildings; // A dirty way to let macro access micro's enemy buildings list (for determining ineligible expansions)
	public boolean mech;
    public ArrayList<ROUnit> unitsBeingCreated = new ArrayList<ROUnit>();
    ROUnit enemySparky;
    public int mins, gas;
    int defense = 0;
    boolean AAinject = false;
    boolean ASinject = false;
    boolean rushinject = false;
    boolean FEinject = false;
    boolean GSinject = false;
    public int lastsched;
    JythonInterpreter jython = new JythonInterpreter();
    public TilePosition myStart;
    public TilePosition myHome;
    private Unit myBase;
    TilePosition expansionLoc;
    BuildingPlacer buildingPlacer;
    public PriorityQueue<ValuedUnitType> unitPriorities;
    public final ArrayList<BuildingStatus> myBuildings = new ArrayList<BuildingStatus>();
    public final ArrayList<BuildingStatus> myRefineries = new ArrayList<BuildingStatus>();
    public final ArrayList<BuildingStatus> myCCs = new ArrayList<BuildingStatus>();
    public final ArrayList<BaseLocation> myBases = new ArrayList<BaseLocation>();

    public int height;
    public int width;
    public TilePosition corner = new TilePosition(1, 1);

    public final ArrayList<TilePosition> expansionLocs = new ArrayList<TilePosition>();

    int lastscan = 0;
    protected Player me;
    protected TilePosition target;//TODO: Maybe share this in a better way
    public List<ROUnit> enemyBases;
    public List<UnitType> buildOrder;
    protected boolean scouting = true;//TODO: This should be shared in some better way
    private int CCs;
    protected int refineries;
    public Player enemyPlayer;
    public boolean debug = false;
    List<TilePosition> path;

    int time;
    int scoutcountdown;

    Unit sc = null;
    Hashtable<UnitType, Integer> bldgCounts;
    Random rgenerator = new Random();
    Bwta myBwta;
    Set<Region> regions;
    Set<Chokepoint> chokepoints;
    public Chokepoint baseChoke;
    public Chokepoint natChoke;
    protected Game mGame;

    public AStarSearch pathfinder;
    public Set<BaseLocation> bls;
    public int[] bldists;
    public List<TilePosition>[] blpaths;

    WorkerManager workerManager;
    public LinkedList<Unit> extractors = new LinkedList<Unit>();
    protected BaseLocation myBaseLocation;


    public MacroManager() {
        lastsched = 0;
        buildOrder = new ArrayList<UnitType>();
        mGame = Game.getInstance();


        height = mGame.mapHeight() - 1;
        width = mGame.mapWidth() - 1;
        enemyBases = new ArrayList<ROUnit>();
        scoutcountdown = 3000;

        pathfinder = new AStarSearch();
        time = 0;
    }


    @Override
    public List<Cerebrate> getTopLevelCerebrates() {
        return null;
    }

    public void setWorkerManager(WorkerManager workerManager) {
        this.workerManager = workerManager;
    }

    @Override
    public void onFrame() {
    	long starttime = System.currentTimeMillis();
        mGame.drawTextScreen(0, 290, "starts: " + eligibleEnemyStarts.toString());
    	mGame.drawTextScreen(300,320, "CCs in bo: " + BOCount(UnitType.TERRAN_COMMAND_CENTER));
    	if (debug) mGame.drawTextScreen(10, 30, "next:" + nextBldg());
    	if (debug) for (BaseLocation b : bls) {
        	mGame.drawTextMap(b.getPosition(), b.getTilePosition().x() + "," + b.getTilePosition().y());
        }

    	//BOInject(UnitType.TERRAN_BARRACKS);
        super.onFrame();

    	if (debug) mGame.drawTextMap(baseChoke.getCenter(), "base choke");
    	if (debug) mGame.drawTextMap(natChoke.getCenter(), "nat choke");
    	
    	
    	for (BuildingStatus bs : myBuildings) {
    		if (bs.status == BuildingStatus.SCHEDULED) {
    			mGame.drawTextMap(Position.centerOfTile(bs.spot), bs.type.toString());
    			mGame.drawLineMap(Position.centerOfTile(bs.spot), bs.myBuilder.getPosition(), Color.WHITE);
    			if (bs.myBuilder.getPosition() == Position.INVALID) {
    				WorkerStatus w = workerManager.getWorker(bs.spot);
    				if (w != null) bs.myBuilder = w;
    			}
    		}
    		if (bs.status == BuildingStatus.DEAD) {
    			if (debug) mGame.drawTextMap(Position.centerOfTile(bs.spot), "dead" + bs.type.toString());
    		}
    	}
    	
        ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
        for (ROUnit u : unitsBeingCreated) {
        	if (u.isCompleted()) {
        		this.onUnitSpawn(u);
        		tr.add(u);
        	}
        }
        
        for (ROUnit removeMe : tr) {
        	unitsBeingCreated.remove(removeMe);
        }
        
        /* Random bookkeeping */
        lastsched--;
        time++;
        if (lastscan != 0) lastscan--;
        if (myCCs.size() != 0 && myCCs.get(myCCs.size() - 1).status == BuildingStatus.BUILT) {
            if (myBuildings.size() < 15) myHome = myCCs.get(0).myUnit.getTilePosition();
            else myHome = myCCs.get(myCCs.size() - 1).myUnit.getTilePosition();
        }
        
        
    	List<TilePosition> turrets = new ArrayList<TilePosition>();
    	for (BuildingStatus bs : myBuildings) {
    		if (bs.type == UnitType.TERRAN_MISSILE_TURRET && bs.status != BuildingStatus.DEAD) {
    			turrets.add(bs.spot);
    		}
    	}
        if (time % 100 == 0) for (BuildingStatus cc : myCCs) {
        	if (cc.turreted) {
    			TilePosition centerpos = new TilePosition(cc.spot.x()+2, cc.spot.y()+1);
        		boolean reallyTurreted = false;
        		for (TilePosition t : turrets) {
        			if (t.getDistance(cc.spot) <= 6)
        				reallyTurreted = true;
        		}
        		if (!reallyTurreted)
        			cc.turreted = false;
        	}
        }
        
        if (time % 6000 == 0 && time > 8000) {
        	for (BuildingStatus cc : myCCs) {
            	if (!cc.turreted && (AAinject || ASinject) && !BOIncoming(UnitType.TERRAN_MISSILE_TURRET)) {
            		mGame.printf("Unturreted cc -- turreting!" );
            		BOInject(UnitType.TERRAN_MISSILE_TURRET);
            	}
        	}
        }
        
        

        /* Extra buildings to match excess resources */
        if (me.minerals() > 300) {//TODO: This seems a little low, but it also seems to not work as expected?
        	if (!mech) {
        		if (nextBldg() != UnitType.TERRAN_BARRACKS && nextBldg() != UnitType.TERRAN_COMMAND_CENTER && !beingConstructed(UnitType.TERRAN_BARRACKS) && !BOIncoming(UnitType.TERRAN_BARRACKS) && UnitUtils.getAllMy(UnitType.TERRAN_BARRACKS).size() < 12) 
                    BOInject(UnitType.TERRAN_BARRACKS);
        	}
        	else {
        		if (nextBldg() != UnitType.TERRAN_FACTORY && nextBldg() != UnitType.TERRAN_COMMAND_CENTER && me.gas() > 90 && me.minerals() > 400 && !beingConstructed(UnitType.TERRAN_FACTORY) && !BOIncoming(UnitType.TERRAN_FACTORY) && UnitUtils.getAllMy(UnitType.TERRAN_FACTORY).size() <= 10) 
                    BOInject(UnitType.TERRAN_FACTORY);
        	}
        	
        }

        
        buildingBookkeeping();
        unitProduction();
        research();
        buildingPlacer.drawBuildingStuffs();
        buildingPlacer.getChokeDots(baseChoke);
        drawMacroIndicators();
    	handleDoor();
    	enemyStartStuff();
    	
    	//System.out.println("macro took " + (System.currentTimeMillis() - starttime));
    }

    @Override
    /* Basic initialization, mostly towards the horrible building placement system. */
    public void onStart() {

        mGame = Game.getInstance();
        myBwta = Bwta.getInstance();
        regions = myBwta.getRegions();
        chokepoints = myBwta.getChokepoints();
        me = mGame.self();
        
        System.out.println("This map is " + mGame.getMapHash());
        //System.out.println("AKA " + mGame.getMapName());
        Iterator<Player> playit = mGame.getPlayers().iterator();
        while (playit.hasNext()) {
            Player p = playit.next();
            if (p != me) {
                enemyPlayer = p;
                break;
            }
        }

        myHome = mGame.self().getStartLocation();
        myStart = mGame.self().getStartLocation();
        
        for (Region r : myBwta.getRegions()) {
        	if (r.contains(myHome))
        		baseRegion = r;
        }
        
        for (ROUnit u : mGame.self().getUnits()) {
            if (u.getType().isResourceDepot()) {
                myBase = UnitUtils.assumeControl(u);
            }
            if (isTerranBldg(u) && u.getPlayer() == me) {
                myBuildings.add(new BuildingStatus(BuildingStatus.BUILT,
                        UnitUtils.assumeControl(u)));
                if (u.getType() == UnitType.TERRAN_COMMAND_CENTER)
                    myCCs.add(new BuildingStatus(BuildingStatus.BUILT,
                            UnitUtils.assumeControl(u)));
            }
        }
        
        eligibleEnemyStarts = new ArrayList<TilePosition>();
        for (TilePosition tp : mGame.getStartLocations()) {
        	if (tp.equals(myHome))
        		continue;
        	eligibleEnemyStarts.add(tp);
        }

        

        bls = myBwta.getBaseLocations();
        bldists = new int[bls.size()];
        blpaths = new List[bls.size()];
        int i = 0;
        for (BaseLocation b : bls) {
            if (myHome.equals(b.getTilePosition())) {
                myBaseLocation = b;
                myBases.add(b);
            }
            List<TilePosition> path = pathfinder.getPath(myHome, b.getTilePosition());
            blpaths[i] = path;
            if (path != null) {
                int d = path.size();
                bldists[i] = d;
            } else bldists[i] = 9999999;
            i++;
        }


        
        expansionLoc = nextExpansion(false);
        Iterator<Region> regionIterator = regions.iterator();
        while (regionIterator.hasNext()) {
            Region r = regionIterator.next();
            if (r.contains(myHome)) {
                Iterator<Chokepoint> it = r.getChokepoints().iterator();
                double smallestDistance = Double.POSITIVE_INFINITY;
                while (it.hasNext()) {
                    Chokepoint c = it.next();
                    double d = myHome.getDistance(c.getCenter());
                    if (d < smallestDistance && (c.getRegions().getKey().contains(expansionLoc) || c.getRegions().getValue().contains(expansionLoc))) {
                        smallestDistance = d;
                        baseChoke = c;
                    }
                }
                break;
            }
        }
        
        
        natRegion = null;
      
        
        Entry<Region,Region> baseAndNat = baseChoke.getRegions();
        if (baseAndNat.getKey().contains(myHome)) {
        	natRegion = baseAndNat.getValue();
        }
        else if (baseAndNat.getValue().contains(myHome)) {
        	natRegion = baseAndNat.getKey();
        }
        
        Set<Chokepoint> natchokes = natRegion.getChokepoints();
        

        double biggestwidth = 0;
        for (Chokepoint c : natchokes) {
        	if (biggestwidth < c.getWidth() && !c.equals(baseChoke)) biggestwidth = c.getWidth();
        	else continue;
        	natChoke = c;
        	
        }
     
        
        
        
        
        
        if (debug) System.out.println("My Home: " + myHome.x() + ", " + myHome.y());
        if (debug) System.out.println("Map: " + mGame.getMapHash());

        //path = pathfinder.getPath(myHome, new TilePosition(5,1));
        //List<TilePosition> path2 = pathfinder.getPath(new TilePosition(1,1), new TilePosition(5,1));
        buildingPlacer = new BuildingPlacer(mGame, this);

        unitPriorities = new PriorityQueue<ValuedUnitType>(16,
                new Comparator<ValuedUnitType>() {
                    public int compare(ValuedUnitType t1, ValuedUnitType t2) {
                        if (t2.value == t1.value) return 0;
                        if (t1.value < t2.value) return -1;
                        else return 1;
                    }
                });
        
        
    	ArrayList<Block> blocks = new ArrayList<Block>();
    	int startwidth = 4;
    	int startheight = 3;
    	blocks.add(new Block(startwidth,startheight));
    	blocks.add(new Block(3,2));
    	blocks.add(new Block(3,2));
    	
    	ArrayList<Block> blocks2 = new ArrayList<Block>();
    	blocks2.add(new Block(startwidth,startheight));
    	blocks2.add(new Block(3,2));
    	
    	ArrayList<TilePosition> eligible = new ArrayList<TilePosition>();
    	int spread = 7;
    	TilePosition seed = new TilePosition(baseChoke.getCenter());
    	Set<TilePosition> grid = new HashSet<TilePosition>();
    	buildingPlacer.basicEligible = new ArrayList<TilePosition>();
    	/* Positions where we can place the initial building */
    	for (int dx = -spread; dx < spread; dx++) {
    		tileloop:
    		for (int dy = -spread; dy < spread; dy++) {
    			TilePosition newpos = new TilePosition(seed.x() + dx, seed.y() + dy);
        		if (!baseRegion.contains(newpos))
        			continue;
    			for (int shiftx = 0; shiftx < startwidth; shiftx++) {
    				for (int shifty = 0; shifty < startheight; shifty++) {
    					if (!(mGame.isBuildable(newpos.x()+shiftx, newpos.y()+shifty)))
    						continue tileloop;
    				}
    			}
    			eligible.add(newpos);
    			buildingPlacer.basicEligible.add(newpos);
    				
    		}
    	}
    	
    	int otherwidth = 3;
    	int otherheight = 2;
    	for (int dx = -spread; dx < spread; dx++) {
    		tileloop:
    		for (int dy = -spread; dy < spread; dy++) {
    			TilePosition newpos = new TilePosition(seed.x() + dx, seed.y() + dy);
        		if (!baseRegion.contains(newpos))
        			continue;
    			for (int shiftx = 0; shiftx < otherwidth; shiftx++) {
    				for (int shifty = 0; shifty < otherheight; shifty++) {
    					if (!(mGame.isBuildable(newpos.x()+shiftx, newpos.y()+shifty)))
    						continue tileloop;
    				}
    			}
    			if (!buildingPlacer.basicEligible.contains(newpos)) buildingPlacer.basicEligible.add(newpos);
    				
    		}
    	}
    	
    	spread = spread + 9;
    	for (int dx = -spread; dx < spread; dx++) {
    		for (int dy = -spread; dy < spread; dy++) {
    			TilePosition newpos = new TilePosition(seed.x() + dx, seed.y() + dy);
    			grid.add(newpos);
    		}
    	}
    	
    	pathfinder.grid = grid;
    	
    	double closest = Double.POSITIVE_INFINITY;
    	TilePosition best = null;
    	for (TilePosition tp : grid)
    	{
    		double d = tp.getDistance(myHome);
    		if (d < closest && baseRegion.contains(tp) && mGame.isBuildable(tp.x(), tp.y())) {
    			best = tp;
    			closest = d;
    		}

    	}
    	chokeBuffer = new ArrayList<TilePosition>();
    	TilePosition choke = new TilePosition(baseChoke.getCenter());
    	for (int dx = -1; dx <= 1; dx++) {
    		for (int dy = -1; dy <= 1; dy++) {
    			TilePosition newpos = new TilePosition(choke.x() + dx, choke.y() + dy);
    			chokeBuffer.add(newpos);
    		}
    	}
    	
    	for (TilePosition tp : chokeBuffer) {
			mGame.drawCircleMap(new Position(tp), 6, Color.YELLOW, false);
    	}
    	
    	buildingPlacer.wallPathStart = best;
    	pathfinder.chokeBuffer = chokeBuffer;

    	
    	wall = null;
    	int tol = -1;
    	while (wall == null && tol < 12) {
    		tol++;
    		pathfinder.walkableTolerance = tol;
    		
    		if (mGame.getMapHash().equals("6f8da3c3cc8d08d9cf882700efa049280aedca8c") || mGame.getMapHash().equals("cb39a180c36de73e887e8430c5f32197c52c18ba")) {
    			buildingPlacer.doWall(new TilePosition(baseChoke.getCenter()), blocks, eligible, new ArrayList<TilePosition>());
    			if (wall == null) wall = buildingPlacer.doWall(new TilePosition(baseChoke.getCenter()), blocks2, eligible, new ArrayList<TilePosition>());
            	
    		}
    		else {
            	wall = buildingPlacer.doWall(new TilePosition(baseChoke.getCenter()), blocks2, eligible, new ArrayList<TilePosition>());
            	if (wall == null) buildingPlacer.doWall(new TilePosition(baseChoke.getCenter()), blocks, eligible, new ArrayList<TilePosition>());
    		}
    	}
    	
    	
    	
    }


    @Override
    public void onUnitCreate(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
        int id = unit.getID();
        if (unit.getPlayer() != me && isMainBldg(unit)) {
            for (int i = 0; i < enemyBases.size(); i++) {
                if (enemyBases.get(i).getID() == id) {
                    enemyBases.remove(i);
                    break;
                }
            }
        } else if (isMainBldg(unit) && unit.getPlayer() == me) {
            for (int i = 0; i < myCCs.size(); i++) {
                if (myCCs.get(i) != null && id == myCCs.get(i).myUnit.getID()) {
                    myCCs.remove(i);
                    for (int j = 0; j < myBuildings.size(); j++) {
                        BuildingStatus bldg = myBuildings.get(j);
                        if (bldg.myUnit != null && id == bldg.myUnit.getID()) {
                            myBuildings.remove(j);
                        }
                    }
                }
            }
        } else if (unit.getPlayer() == me && unit.getType().isBuilding()) {
            for (int i = 0; i < myBuildings.size(); i++) {
                BuildingStatus bldg = myBuildings.get(i);
                if (bldg.myUnit != null && id == bldg.myUnit.getID()) {
                    if (bldg.type == UnitType.TERRAN_FACTORY && bldg.myUnit.getAddon() != null) {
                        for (int z = 0; z < myBuildings.size(); z++) {
                            if (myBuildings.get(z).myUnit != null && myBuildings.get(z).myUnit.getID() == bldg.myUnit.getAddon().getID()) {
                                myBuildings.remove(z);
                                break;
                            }
                        }
                    }
                    myBuildings.remove(i);
                    if (unit.getType() == UnitType.TERRAN_REFINERY) {
                        int ref = -1;
                        for (int z = 0; z < myRefineries.size(); z++) {
                            if (myRefineries.get(z).myUnit != null && myRefineries.get(z).myUnit.getID() == id) ref = z;
                        }
                        if (ref != -1) myRefineries.remove(ref);
                    }
                    break;
                }
            }
            
            if (wallDoor != null && wallDoor.getID() == unit.getID())
            	wallDoor = null;
        }

    }

    @Override
    public void onUnitHide(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
        if (unit.getType() == UnitType.TERRAN_REFINERY && unit.getPlayer() == me) {
            for (BuildingStatus r : myRefineries) {
                if (r.myUnit != null) {
                    if (r.myUnit.getID() == unit.getID()) {
                        myRefineries.remove(r);
                        break;
                    }
                }
            }
            for (BuildingStatus r : myRefineries) {
                if (r.myUnit == null) {
                    r.status = BuildingStatus.BUILDING;
                    r.myUnit = UnitUtils.assumeControl(unit);
                    break;
                }
            }


        }
    }

	@Override
	public void onUnitRenegade(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
		super.onUnitRenegade(unit);
		onUnitDestroy(unit);
	}
    
    @Override
    public void onUnitShow(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
        if(unit.getPlayer().equals(me)){
            unitsBeingCreated.add(unit);
            if (isTerranBldg(unit)) {
                boolean found = false;
                for (BuildingStatus b : myBuildings) {
                    if (b.myUnit == null && b.type == unit.getType()) {
                        b.myUnit = UnitUtils.assumeControl(unit);
                        b.status = BuildingStatus.BUILDING;
                        found = true;
                        break;
                    }
                }

                if (!found && isTerranAddon(unit)) {
                    //System.out.println(unit);
                    myBuildings.add(new BuildingStatus(BuildingStatus.BUILDING, UnitUtils.assumeControl(unit)));
                }
            }
        }

        if (unit.getPlayer() != me) {
            if (isMainBldg(unit)) {
                ROUnit closest = UnitUtils.getClosest(unit, enemyBases);
                if (!enemyBases.contains(unit) && (closest == null || closest.getDistance(unit) > 180)) { // That second/third check is to ignore macro hatches
                    enemyBases.add(unit);
                    if (enemyBases.size() == 1) {
                        TilePosition[] eligible = new TilePosition[4];
                        eligible[0] = new TilePosition(1, 1);
                        eligible[1] = new TilePosition(1, height);
                        eligible[2] = new TilePosition(width, height);
                        eligible[3] = new TilePosition(width, 1);

                        double best = Double.POSITIVE_INFINITY;
                        for (int i = 0; i < 4; i++) {
                            if (eligible[i].getDistance(unit.getTilePosition()) < best) {
                                best = eligible[i].getDistance(unit.getTilePosition());
                                corner = eligible[i];
                            }
                        }

                    }
                }
            } else {

            }
        }
        
        
        List<ROUnit> tr = new ArrayList<ROUnit>();
        
        for (ROUnit b : basestr) { // make sure the bases to remove are actually not visible...
        	if (b.getID() == unit.getID())
        		tr.add(b);
        }
        
        basestr.removeAll(tr);

    }
    
    public void onUnitSpawn(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
    	if(unit.getType().equals(UnitType.TERRAN_COMMAND_CENTER) && unit.getPlayer() == me){
            for(BaseLocation b: bls){
                if(b.getRegion().contains(unit.getPosition()) && ! myBases.contains(b)){
                    addBase(b);
                    break;
                }
            }
        }
    }

    @Override
    public void onEnd(boolean isWinnerFlag) {

    }

    // Feel free to add command and things here.
    // bindFields will bind all member variables of the object
    // commands should be self explanatory...
    protected void initializeJython() {
        jython.bindFields(this);
        jython.bind("game", mGame);
        jython.bindIntCommand("speed", new Command<Integer>() {
            @Override
            public void call(Integer arg) {
                mGame.printf("Setting speed to %d", arg);
                mGame.setLocalSpeed(arg);
            }
        });
        jython.bindThunk("debug", new Thunk() {
            @Override
            public void call() {
                debug = !debug;
            }
        });
        jython.bindThunk("reset", new Thunk() {

            @Override
            public void call() {
                initializeJython();

            }

        });

    }


    /* Produce all kinds of units (buildings included) */
    public void unitProduction() {
        /*
        * Construct scheduled pending buildings Also do updates for finished
        * buildings, etc.
        */
        int mineralsReserved = 0;
        int gasReserved = 0;

        for (BuildingStatus b : myBuildings) {
            if (b.status == BuildingStatus.SCHEDULED) {
                construct(b);
                mineralsReserved += b.type.mineralPrice();
                gasReserved += b.type.gasPrice();
            }
        }


        refineries = myRefineries.size();
        long starttime = System.currentTimeMillis();

        mins = mGame.self().minerals() - mineralsReserved;
        gas = mGame.self().gas() - gasReserved;

        for (int i = 0; i < myCCs.size(); i++) {
            if (shouldIBuildSCV(i)) {
                myCCs.get(i).myUnit.train(UnitType.TERRAN_SCV);
                mins += -50;
            }
        }

        if (shouldISupplyDepot()) {
            scheduleBuild(UnitType.TERRAN_SUPPLY_DEPOT);
            //mGame.printf("depot scheduled @ " + time);
            mins += -100;
            /*
            if (mins >= 500 && me.supplyTotal() > 100) {
                scheduleBuild(UnitType.TERRAN_SUPPLY_DEPOT);
                mGame.printf("depot scheduled @ " + time);
                mins += -100;
            } */
        }


        /* Find and schedule next building in build order, if possible */
        ArrayList<BuildingStatus> bldgs = (ArrayList<BuildingStatus>) myBuildings.clone();
        for (int i = 0; i < buildOrder.size(); i++) {
            UnitType next = buildOrder.get(i);
            boolean found = false;
            for (BuildingStatus b : bldgs) {
                if (b.type.equals(next) && (b.status == BuildingStatus.BUILDING || b.status == BuildingStatus.BUILT || b.status == BuildingStatus.SCHEDULED)) {
                    bldgs.remove(b);
                    found = true;
                    break;
                }
            }
            if (!found) {
                if (mins >= next.mineralPrice() && gas >= next.gasPrice() // && !beingConstructed(next) 
                       && lastsched <= 0) {
                    //System.out.println("Scheduling a " + next + "at frame " + time);
                    scheduleBuild(next);
                    if (!nextBldg().canProduce() && nextBldg() != UnitType.TERRAN_BUNKER && nextBldg() != UnitType.TERRAN_MISSILE_TURRET && nextBldg() != UnitType.TERRAN_COMMAND_CENTER && time-lastInject > 800) lastsched = 800;
                    if (nextBldg() == UnitType.TERRAN_STARPORT)
                    	lastsched = 1500;
                    
                    mins += -next.mineralPrice();
                    gas += -next.gasPrice();
                }
                break;
            }
        }


        if (nextBldg() == UnitType.TERRAN_COMMAND_CENTER) {
        	mins -= 400;
        }


    	CCs = 0;
        for (BuildingStatus cc : myCCs) {
        	if (cc.status == BuildingStatus.BUILT)
        		CCs++;
        }
        if (mins >= 100 && refineries < CCs && (myCCs.size() > 1 || (me.supplyUsed() >= 24 && mech) || (me.supplyUsed() >= 32 && !mech))
                && nextRefinery() != TilePosition.INVALID) {
            scheduleBuild(UnitType.TERRAN_REFINERY);
            mins += -100;
        }
        ValuedUnitType[] a = new ValuedUnitType[1];
        a = unitPriorities.toArray(a);
        Arrays.sort(a);

        /* Unit production, that kind of silly order queued thing is so we don't queue several unit types */
        for (BuildingStatus b : myBuildings) {
        //Can we schedule this as part of the build order? don't need machine shop or seige mode for drops
        	// Fixed for now with a workaround (no machine shops if not doing mech strategy)
            if (b.status == BuildingStatus.BUILT && b.type == UnitType.TERRAN_FACTORY && b.myUnit.getTrainingQueue().size() < 1
                    && b.myUnit.getAddon() == null && (mech || lurkers))
                b.myUnit.buildAddon(UnitType.TERRAN_MACHINE_SHOP);
            if (b.status == BuildingStatus.BUILT && b.type == UnitType.TERRAN_STARPORT&& b.myUnit.getTrainingQueue().size() < 1
                    && b.myUnit.getAddon() == null){
                b.myUnit.buildAddon(UnitType.TERRAN_CONTROL_TOWER);
            }
            b.orderqueued = false;
        }
        for (ValuedUnitType v : a) {
            if (v != null) makeUnit(v.type);
        }
        for (BuildingStatus b : myBuildings) {
            b.orderqueued = false;
        }
    }

    private boolean shouldISupplyDepot() {
        return mins >= 100 && ((me.supplyTotal() - me.supplyUsed() < 8) 
        					    || (me.supplyTotal() - me.supplyUsed() < 16 && me.supplyTotal() > 120)
        					    || (me.supplyTotal() - me.supplyUsed() < 12 && me.supplyTotal() > 50))
                && !beingConstructed(UnitType.TERRAN_SUPPLY_DEPOT) && me.supplyTotal() < 400;
    }

    private boolean shouldIBuildSCV(int i) {
        return time % 10 == 0 && mins >= 50 && workerManager.numWorkers() < 80 && (myCCs.get(i).status == BuildingStatus.BUILT && (myCCs.get(i).unitsproduced < 28
                || workerManager.numWorkers() < (28 * (myCCs.size())))) && myCCs.get(i).myUnit.getTrainingQueue().size() < 1;
    }

    public void research() {
        for (BuildingStatus b : myBuildings) {
            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_ACADEMY && !mech) {
                b.myUnit.research(TechType.STIM_PACKS);
                b.myUnit.upgrade(UpgradeType.U_238_SHELLS);
            }

            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_ENGINEERING_BAY && !mech) {
                b.myUnit.upgrade(UpgradeType.TERRAN_INFANTRY_WEAPONS);
                b.myUnit.upgrade(UpgradeType.TERRAN_INFANTRY_ARMOR);

            }
            
            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_ARMORY) {
                b.myUnit.upgrade(UpgradeType.TERRAN_VEHICLE_WEAPONS);
                b.myUnit.upgrade(UpgradeType.TERRAN_VEHICLE_PLATING);

            }
            
            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_FACTORY && b.myUnit.getAddon() != null && b.myUnit.getAddon().isCompleted()) {
            	Unit machineshop = UnitUtils.assumeControl(b.myUnit.getAddon());
            	if (mech || lurkers) machineshop.research(TechType.TANK_SIEGE_MODE);
            	if (mech) {
	            	if (UnitUtils.getAllMy(UnitType.TERRAN_VULTURE).size() > 3 && me.hasResearched(TechType.TANK_SIEGE_MODE)) machineshop.research(TechType.SPIDER_MINES);
	            	if (UnitUtils.getAllMy(UnitType.TERRAN_VULTURE).size() > 3 && me.hasResearched(TechType.TANK_SIEGE_MODE)) machineshop.upgrade(UpgradeType.ION_THRUSTERS);
	            	machineshop.upgrade(UpgradeType.CHARON_BOOSTER);
            	}
            }
            
            if (b.myUnit != null && b.myUnit.getType() == UnitType.TERRAN_SCIENCE_FACILITY) {
            	if (UnitUtils.getAllMy(UnitType.TERRAN_SCIENCE_VESSEL).size() >= 2 && !mech)
            		UnitUtils.assumeControl(b.myUnit).research(TechType.IRRADIATE);
            	else if (UnitUtils.getAllMy(UnitType.TERRAN_SCIENCE_VESSEL).size() >= 2 && mech)
            		UnitUtils.assumeControl(b.myUnit).research(TechType.EMP_SHOCKWAVE);
            	if (mins > 1000 && gas > 800)
            		UnitUtils.assumeControl(b.myUnit).upgrade(UpgradeType.TITAN_REACTOR);
            }
        }
    }
    


    public void makeUnit(UnitType u) {
    	if (time % 10 != 0) return; // Avoid spamming train button (might queue with lag)
        for (BuildingStatus b : myBuildings) {
            if (mins >= u.mineralPrice() && gas >= u.gasPrice() && b.status == BuildingStatus.BUILT && b.myUnit != null && b.myUnit.getTrainingQueue().size() < 1 
            		&& (mGame.canMake(b.myUnit, u) || (b.type == UnitType.TERRAN_STARPORT && b.myUnit.getAddon() != null && b.myUnit.getAddon().exists() && (u.equals(UnitType.TERRAN_DROPSHIP) || u.equals(UnitType.TERRAN_SCIENCE_VESSEL)))||(b.type == UnitType.TERRAN_FACTORY && u == UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) && !b.orderqueued) {
                if (wallDoor != null && u.getID() == wallDoor.getID() && wantsToLift) continue;
            	b.myUnit.train(u);
                mins -= u.mineralPrice();
                gas -= u.gasPrice();
                b.orderqueued = true;
            }
        }
    }

    public void buildingBookkeeping() {
        List<TilePosition> toRemove = new ArrayList<TilePosition>();
        List<BuildingStatus> toRemove2 = new ArrayList<BuildingStatus>();
        for (BuildingStatus b : myBuildings) {
            if (b.status == BuildingStatus.BUILDING && b.myUnit.isCompleted()) {
                b.status = BuildingStatus.BUILT;

                if (!isTerranAddon(b.myUnit)){
                    b.myBuilder.setState(WorkerState.NONE);
                }
            }
            // ORDERING IS VERY IMPORTANT HERE!
            if (b.status == BuildingStatus.BUILDING && !b.myUnit.isBeingConstructed()) {
                WorkerStatus worker = workerManager.getWorker(b.spot);
                worker.unit.rightClick(b.myUnit);
                worker.setState(WorkerState.BUILDING);
                //System.out.println("[B] Worker id " + worker.getID() + " should be going to build");
            }
            if (b.type == UnitType.TERRAN_COMMAND_CENTER && b.status == BuildingStatus.BUILT) {
                if (me.minerals() > 50 && me.gas() > 50)
                    b.myUnit.buildAddon(UnitType.TERRAN_COMSAT_STATION);
            }
            if (b.status == BuildingStatus.SCHEDULED) {
                b.age++;
            }
            if ((b.age > 1100 && b.type != UnitType.TERRAN_COMMAND_CENTER) || b.age > 2500) {
                //mGame.printf("**a building expired ** " + b.type);
                toRemove.add(b.spot);
                b.myBuilder.setState(WorkerState.NONE);
                if (b.type == UnitType.TERRAN_REFINERY) {
                    myRefineries.remove(b);
                }
                if (b.type == UnitType.TERRAN_COMMAND_CENTER) {
                    myCCs.remove(b);
                }
                toRemove2.add(b);

            }
//            if (b.status == BuildingStatus.BUILT && b.myBuilder != null && (b.myBuilder.getState() == WorkerState.BUILDING)) {
//                //This tells workers who are done building to go back to mining
//                b.myBuilder.setState(WorkerState.NONE);
//
//            }


        }

        for (BuildingStatus b : toRemove2) {
            myBuildings.remove(b);
        }


        /* This is awkward. happens because the tiles can be visible without the unit being visible for a frame...? */
        for (ROUnit b : basestr) {
        	enemyBases.remove(b);
        }
        
        basestr = new ArrayList<ROUnit>();
        for (ROUnit b : enemyBases) {
            if (Utils.fullVisible(b.getLastKnownTilePosition(), UnitType.PROTOSS_NEXUS)
                    && !b.isVisible()) {
                basestr.add(b);
            }
        }
        


    }


    /* Schedule a building to be built */
    private void scheduleBuild(UnitType bldg) {

        BuildingStatus b;

        if (bldg == UnitType.TERRAN_REFINERY) { // This is no longer fishy.
            TilePosition buildpos = nextRefinery();
            
            if (buildpos == TilePosition.INVALID)
            	return;
            
            WorkerStatus builder = workerManager.getWorker(buildpos);
            builder.setState(WorkerState.BUILDING);
            b = new BuildingStatus(builder, bldg, buildpos);
            workerManager.refineryToGuys.put(b.myUnit, builder);
            builder.target = b.myUnit;
            workerManager.removeMiner(builder);
        } else {
            TilePosition spot = buildingPlacer.placeBuilding(bldg);
            WorkerStatus builder = workerManager.getWorker(spot);
            b = new BuildingStatus(builder, bldg, spot);
        }
        

        if (b.spot != TilePosition.INVALID) {
            //System.out.println("New building status for " + b.myBuilder.unit + " making a " + bldg);
        	myBuildings.add(b);
            if (bldg == UnitType.TERRAN_REFINERY){
                myRefineries.add(b);

            }

            if (bldg == UnitType.TERRAN_COMMAND_CENTER)
                myCCs.add(b);
        }

    }
    
    TilePosition nextRefinery() {
        TilePosition buildpos = TilePosition.INVALID;
        Set<ROUnit> g = (Set<ROUnit>) mGame.getGeysers();
        outer:
        for (BuildingStatus cc : myCCs) {
                for (ROUnit geyser : g) {
	            	if (mGame.isVisible(geyser.getTilePosition()) && cc.spot.getDistance(geyser.getLastKnownTilePosition()) < 10) {
	            		buildpos = geyser.getLastKnownTilePosition();
	            		break outer;
	            	}
            }
        }
        
        return buildpos;
    }


    /* Make the SCV actually construct the building, lots of messy order spamming */
    private void construct(BuildingStatus bldg) {
        if (debug) mGame.drawCircleMap(Position.centerOfTile(bldg.spot), 5, Color.RED, true);
        Unit builder = bldg.myBuilder.unit;
        bldg.myBuilder.setState(WorkerState.BUILDING);
        int tries = 0;

        double clb = Double.POSITIVE_INFINITY;

        /* Find closest building distance */
        for (int i = 0; i < myBuildings.size(); i++) {
            if (myBuildings.get(i).spot == bldg.spot) break;
            if (myBuildings.get(i).spot == null) {
                if (debug) mGame.printf("null thing");
                myBuildings.get(i).spot = buildingPlacer.placeBuilding(myBuildings.get(i).type);
            }
            if (bldg.spot == null) {
                bldg.spot = buildingPlacer.placeBuilding(myBuildings.get(i).type);
            }
            if (myBuildings.get(i).spot != null && bldg.spot != null && (myBuildings.get(i).spot).getDistance(bldg.spot) < clb) {
                clb = (myBuildings.get(i).spot).getDistance(bldg.spot);
            }
        }

        /*while (((mGame.fullVisible(bldg.spot) && !builder.canBuildHere(bldg.spot, bldg.type) || bldg.spot == TilePosition.INVALID)) && bldg.type != UnitType.TERRAN_COMMAND_CENTER) {
            if (bldg.type == UnitType.TERRAN_REFINERY || bldg.type == UnitType.TERRAN_ENGINEERING_BAY ||
                    bldg.type == UnitType.TERRAN_SUPPLY_DEPOT || bldg.type == UnitType.TERRAN_BUNKER ||
                    bldg.type == UnitType.TERRAN_MISSILE_TURRET || bldg.type.isAddon()) {
                break;
            }
            
            if (tries > 0) {
            	break;
            } 
            if (debug) mGame.printf("bldg.spot" + bldg.spot);
            bldg.spot = buildingPlacer.placeBuilding(bldg.type);
            tries++;
            mGame.printf("Tries++ for " + bldg.type);
        }*/

        if (!Utils.fullVisible(bldg.spot,bldg.type)) {
        	if (time % 5 == 0) {
        		bldg.myBuilder.setState(WorkerState.BUILDING);
        		pathfinder.makeUnitPath(builder, (bldg.spot));
        	}
        } else {
            double closestBldg = Double.POSITIVE_INFINITY;
            for (int i = 0; i < myBuildings.size(); i++) {
                if (myBuildings.get(i).spot != null && bldg.spot != null &&
                        (myBuildings.get(i).spot).getDistance(bldg.spot) < closestBldg) {
                    closestBldg = (myBuildings.get(i).spot).getDistance(bldg.spot);
                }
            }

            if ((builder.canBuildHere(bldg.spot, bldg.type) || bldg.type == UnitType.TERRAN_REFINERY) && (closestBldg >= 3 || closestBldg == 0.0)) { // Not sure why we need that refinery check, canbuildhere seems bugged for this
                // builder.stop();
            	builder.build(bldg.spot, bldg.type);
            } else if (bldg.type != UnitType.TERRAN_COMMAND_CENTER) { 
                bldg.spot = buildingPlacer.placeBuilding(bldg.type);
            }
        }

    }

    private boolean beingConstructed(UnitType bldg) {
        if (bldg == UnitType.TERRAN_SUPPLY_DEPOT) {
            if (UnitUtils.getAllMy(UnitType.TERRAN_SUPPLY_DEPOT).size() > 5 && UnitUtils.getAllMy(UnitType.TERRAN_SUPPLY_DEPOT).size() <= 10) {
                int dcount = 0;
                for (int i = 0; i < myBuildings.size(); i++) {
                    if ((myBuildings.get(i).status == BuildingStatus.SCHEDULED || myBuildings
                            .get(i).status == BuildingStatus.BUILDING)
                            && myBuildings.get(i).type == bldg) {
                        dcount++;
                    }
                }
                if (dcount > 2)
                    return true;
                else return false;
            } else if (UnitUtils.getAllMy(UnitType.TERRAN_SUPPLY_DEPOT).size() > 10) {
                int dcount = 0;
                for (int i = 0; i < myBuildings.size(); i++) {
                    if ((myBuildings.get(i).status == BuildingStatus.SCHEDULED || myBuildings
                            .get(i).status == BuildingStatus.BUILDING)
                            && myBuildings.get(i).type == bldg) {
                        dcount++;
                    }
                }
                if (dcount > 4)
                    return true;
                else return false;
            }
        }
        for (int i = 0; i < myBuildings.size(); i++) {
            if ((myBuildings.get(i).status == BuildingStatus.SCHEDULED || myBuildings
                    .get(i).status == BuildingStatus.BUILDING)
                    && myBuildings.get(i).type == bldg) {
                return true;
            }
        }
        return false;
    }
    
    private boolean isScheduled(UnitType bldg) {
        for (int i = 0; i < myBuildings.size(); i++) {
            if ((myBuildings.get(i).status == BuildingStatus.SCHEDULED)
                    && myBuildings.get(i).type == bldg) {
                return true;
            }
        }
        return false;
    }


    /* Build order stuff.
    * Will probably be reworked. For now the build order is fixed, with
    * certain buildings "injected" into it as a response to a few situations.
    */

    public void resetBuildOrder() {
        buildOrder = new ArrayList<UnitType>();
    }


    /* Make bldg the next building in the build order */
    public void BOInject(UnitType bldg) {
        int j = -1;
        ArrayList<BuildingStatus> bldgs = (ArrayList<BuildingStatus>) myBuildings
                .clone();
        for (int i = 0; i < buildOrder.size(); i++) {
            UnitType next = buildOrder.get(i);
            for (BuildingStatus b : bldgs) {
                if (b.type.equals(next)) {
                    bldgs.remove(b);
                    j = i + 1;
                    break;
                }
            }
        }
        if (j == -1) {
            buildOrder.add(bldg);

        } else buildOrder.add(j, bldg);
        
        
        //mGame.printf("a " + bldg + " was injected");
        lastInject = time;
    }
    
    

    public void BOset(List<UnitType> order) {
    	buildOrder = order;
    }
    
   
    public void BORemove(UnitType bldg) {
    	/*
        int i = 0;
        while (i != buildOrder.size()) {
            UnitType next = buildOrder.get(i);
            if (next.equals(bldg)) {
                buildOrder.remove(i);
                i = 0;
                continue;
            } else i++;
        } */
        

        ArrayList<BuildingStatus> bldgs = (ArrayList<BuildingStatus>) myBuildings
        .clone();
        int farthest = 0;
        for (int i = 0; i < buildOrder.size(); i++) {
            UnitType next = buildOrder.get(i);
            boolean found = false;
            for (BuildingStatus b : bldgs) {
                if (b.type.equals(next) && (b.status == BuildingStatus.BUILDING || b.status == BuildingStatus.BUILT || b.status == BuildingStatus.SCHEDULED)) {
                    bldgs.remove(b);
                    found = true;
                    break;
                }
            }
        	farthest = i;
            if (!found) {
            	break;
            }

        }
        
        int remove = -1;
        for (int i = farthest; i < buildOrder.size(); i++) {
        	if (buildOrder.get(i) == bldg) {
        		remove = i;
        		break;
        	}
        }
        
        if (remove != -1) {
        	buildOrder.remove(remove);
        }
    }

    public int BOCount(UnitType bldg) {
        int c = 0;
        for (int i = 0; i < buildOrder.size(); i++) {
            if (buildOrder.get(i).equals(bldg))
                c++;
        }
        return c;
            
    }
    
    /* Is bldg coming up in the build order? */
    public boolean BOIncoming(UnitType bldg) {
        ArrayList<BuildingStatus> bldgs = (ArrayList<BuildingStatus>) myBuildings
        .clone();
        int farthest = 0;
        for (int i = 0; i < buildOrder.size(); i++) {
            UnitType next = buildOrder.get(i);
            boolean found = false;
            for (BuildingStatus b : bldgs) {
                if (b.type.equals(next) && (b.status == BuildingStatus.BUILDING || b.status == BuildingStatus.BUILT || b.status == BuildingStatus.SCHEDULED)) {
                    bldgs.remove(b);
                    found = true;
                    break;
                }
            }
        	farthest = i;
            if (!found) {
            	break;
            }

        }
        
        for (int i = farthest; i < buildOrder.size(); i++) {
        	if (buildOrder.get(i) == bldg) {
        		return true;
        	}
        }
        return false;
        
        
    }

    public int bcount(UnitType bldg) {
        int c = 0;
        for (int i = 0; i < myBuildings.size(); i++) {
            if (myBuildings.get(i).type.equals(bldg))
                c++;
        }
        return c;
    }

    /* Next unscheduled building in the build order */
    public UnitType nextBldg() {
        ArrayList<BuildingStatus> bldgs = (ArrayList<BuildingStatus>) myBuildings
                .clone();
        for (int i = 0; i < buildOrder.size(); i++) {
            UnitType next = buildOrder.get(i);
            boolean found = false;
            for (BuildingStatus b : bldgs) {
                if (b.type.equals(next) && (b.status == BuildingStatus.BUILDING || b.status == BuildingStatus.BUILT || b.status == BuildingStatus.SCHEDULED)) {
                    bldgs.remove(b);
                    found = true;
                    break;
                }
            }
            if (!found) {
                return next;
            }

        }
        return UnitType.TERRAN_PHYSICS_LAB;


    }

    
    /* For building calls from the dispatcher */
    public void makeBuilding(UnitType bldg) {
    	scheduleBuild(bldg);
    }

    /* Responses/counters */

    public void stealthResponse() {
        if (!ASinject) {
            mGame.printf("Potential stealth units detected -- Engineering bay, turrets, and comsats on the way!");

            BORemove(UnitType.TERRAN_MISSILE_TURRET);
            BOInject(UnitType.TERRAN_MISSILE_TURRET);
            BOInject(UnitType.TERRAN_MISSILE_TURRET);
            if (bcount(UnitType.TERRAN_ACADEMY) == 0 && nextBldg() != UnitType.TERRAN_ACADEMY) {
                BORemove(UnitType.TERRAN_ACADEMY);
                BOInject(UnitType.TERRAN_ACADEMY);
            }
            BOInject(UnitType.TERRAN_MISSILE_TURRET);
            if (bcount(UnitType.TERRAN_ENGINEERING_BAY) == 0 && nextBldg() != UnitType.TERRAN_ENGINEERING_BAY) {
                BORemove(UnitType.TERRAN_ENGINEERING_BAY);
                BOInject(UnitType.TERRAN_ENGINEERING_BAY);
            }

            ASinject = true;
        }
    }

    public void airResponse() {
        if (!AAinject) {
            mGame.printf("Air units suspected: building turrets!");
            if (mech && !ihavetech(UnitType.TERRAN_ARMORY)) {
                BORemove(UnitType.TERRAN_ARMORY);
                BOInject(UnitType.TERRAN_ARMORY);
            }
            BORemove(UnitType.TERRAN_MISSILE_TURRET);
            BOInject(UnitType.TERRAN_MISSILE_TURRET);
            BOInject(UnitType.TERRAN_MISSILE_TURRET); 
            if (bcount(UnitType.TERRAN_ENGINEERING_BAY) == 0 && nextBldg() != UnitType.TERRAN_ENGINEERING_BAY) {
                BORemove(UnitType.TERRAN_ENGINEERING_BAY);
                BOInject(UnitType.TERRAN_ENGINEERING_BAY);
            }

            AAinject = true;
        }
    }

    public void gasStealResponse() {
        if (!GSinject) {
        	BOInject(UnitType.TERRAN_BARRACKS);
            GSinject = true;
        }
    }

    public void rushResponse() {
        if (!rushinject)
            if (bcount(UnitType.TERRAN_BUNKER) == 0 && nextBldg() != UnitType.TERRAN_BUNKER) {
                if (enemyPlayer.getRace() == Race.PROTOSS) {
                    mGame.printf("Early gateway rush suspected -- Adding a bunker.");
                    BOInject(UnitType.TERRAN_BUNKER);
                } else if (enemyPlayer.getRace() == Race.ZERG) {
                    mGame.printf("Early zergling rush suspected -- Adding a bunker.");
                    BOInject(UnitType.TERRAN_BUNKER);
                } else if (enemyPlayer.getRace() == Race.TERRAN) {
                    mGame.printf("Early marine rush suspected -- Adding a bunker");
                    BOInject(UnitType.TERRAN_BUNKER);
                }

                rushinject = true;
            }
    }

    public void FEresponse() {
        if (!FEinject && (myCCs.size() < 2) && nextBldg() != UnitType.TERRAN_COMMAND_CENTER) {
            /* Fast expand detected, no reaction for now */
        	BORemove(UnitType.TERRAN_BUNKER);
            FEinject = true;
        }

    }


    /* Miscellaneous utilities */


    public void debugging() {
        if (debug) {
            for (BuildingStatus b : myCCs) {
                mGame.drawCircleMap(Position.centerOfTile(b.spot), 6, Color.YELLOW, false);
            }
            for (List<TilePosition> pth : blpaths) {
                if (pth == null) continue;
                for (TilePosition tp : pth) {
                    mGame.drawCircleMap(Position.centerOfTile(tp), 3, Color.WHITE, true);
                    mGame.drawTextMap(Position.centerOfTile(tp), "" + tp.x() + " " + tp.y());
                }
                mGame.drawTextMap(Position.centerOfTile(pth.get(pth.size() - 1)), "" + pth.size());
            }
        }
        if (debug) mGame.drawCircleMap(Position.centerOfTile(expansionLoc), 5, Color.PURPLE, true);
    }

    public void scan(Position p) {
        if (lastscan != 0) return;
        
        ROUnit best = null;
        int bestE = 0;
        for (BuildingStatus b : myCCs) {
            if (b.status == BuildingStatus.BUILT && b.myUnit.getAddon() != null
                    && b.myUnit.getAddon().getType() == UnitType.TERRAN_COMSAT_STATION
                    && b.myUnit.getAddon().isCompleted()) {
                if (b.myUnit.getAddon().getEnergy() >= bestE) {
                	bestE = b.myUnit.getAddon().getEnergy();
                	best = b.myUnit.getAddon();

                }
            }
        }
        
        if (best != null && bestE > 50) {
            UnitUtils.assumeControl(best).useTech(TechType.SCANNER_SWEEP, p);
            lastscan = 200;
        }
    }


    public boolean isMainBldg(ROUnit unit) {
        return (unit.getType() == UnitType.PROTOSS_NEXUS
                || unit.getType() == UnitType.ZERG_HATCHERY
                || unit.getType() == UnitType.ZERG_LAIR
                || unit.getType() == UnitType.ZERG_HIVE || unit.getType() == UnitType.TERRAN_COMMAND_CENTER);

    }

    public boolean isTerranBldg(ROUnit unit) {
        UnitType t = unit.getType();
        return (t == UnitType.TERRAN_ACADEMY || t == UnitType.TERRAN_ARMORY
                || t == UnitType.TERRAN_BARRACKS || t == UnitType.TERRAN_BUNKER
                || t == UnitType.TERRAN_COMMAND_CENTER
                || t == UnitType.TERRAN_COMSAT_STATION
                || t == UnitType.TERRAN_CONTROL_TOWER
                || t == UnitType.TERRAN_COVERT_OPS
                || t == UnitType.TERRAN_ENGINEERING_BAY
                || t == UnitType.TERRAN_FACTORY
                || t == UnitType.TERRAN_MACHINE_SHOP
                || t == UnitType.TERRAN_MISSILE_TURRET
                || t == UnitType.TERRAN_NUCLEAR_SILO
                || t == UnitType.TERRAN_PHYSICS_LAB
                || t == UnitType.TERRAN_REFINERY
                || t == UnitType.TERRAN_SCIENCE_FACILITY
                || t == UnitType.TERRAN_STARPORT || t == UnitType.TERRAN_SUPPLY_DEPOT);
    }

    public boolean isTerranAddon(ROUnit unit) {
        UnitType t = unit.getType();
        return (
                t == UnitType.TERRAN_COMSAT_STATION
                        || t == UnitType.TERRAN_CONTROL_TOWER
                        || t == UnitType.TERRAN_COVERT_OPS
                        || t == UnitType.TERRAN_MACHINE_SHOP
                        || t == UnitType.TERRAN_NUCLEAR_SILO
                        || t == UnitType.TERRAN_PHYSICS_LAB);
    }


    /* Calls from the dispatcher */

    public void defend(int value) {
        defense = value;
    }

    public void stopDefend() {
        defense = 0;
    }

    public void antisparky(ROUnit value) {
        enemySparky = value;
    }


    public boolean ihavetech(UnitType bldg) {
        for (BuildingStatus b : myBuildings) {
            if (b.myUnit != null && b.myUnit.getType().equals(bldg) && b.myUnit.isCompleted()) return true;
        }
        return false;
    }
    
    public int buildingCount(UnitType bldg) {
    	int count = 0;
        for (BuildingStatus b : myBuildings) {
            if (b.myUnit != null && b.myUnit.getType().equals(bldg) && b.myUnit.isCompleted()) count++;
        }
        return count;
    }

    public void expand() {
        /* Adds a CC to the build order, expansion should take care of itself with the building placer */
        if (nextBldg() != UnitType.TERRAN_COMMAND_CENTER && !BOIncoming(UnitType.TERRAN_COMMAND_CENTER) && !beingConstructed(UnitType.TERRAN_COMMAND_CENTER)) {
        	BOInject(UnitType.TERRAN_COMMAND_CENTER);
        	mGame.printf("Expansion injected into build");
        }
    }
    
    public void cancelExpand() {
    	if (myCCs.size() == 0) return;
    	if (BOIncoming(UnitType.TERRAN_COMMAND_CENTER)) {
	    	int removeIndex = -1;
	        for (int x = buildOrder.size() -1; x >= 0; x--) {
	        	if (buildOrder.get(x) == UnitType.TERRAN_COMMAND_CENTER) {
	        		removeIndex = x;
	        		break;
	        	}
	        }
	        if (removeIndex != -1) 
	        	buildOrder.remove(removeIndex);  
    	}
    	if (!isScheduled(UnitType.TERRAN_COMMAND_CENTER) && !beingConstructed(UnitType.TERRAN_COMMAND_CENTER)) return;
    	
    	mGame.printf("CANCELLING scheduled expansion...");
        
        ArrayList<BuildingStatus> tr = new ArrayList<BuildingStatus>();
        for (BuildingStatus bs : myBuildings) {
        	if (bs.type == UnitType.TERRAN_COMMAND_CENTER && (bs.status == BuildingStatus.SCHEDULED || bs.status == BuildingStatus.BUILDING)) {
        		tr.add(bs);
        		if (bs.status == BuildingStatus.BUILDING)
        			bs.myUnit.cancelConstruction();
        	}
        }
        
        myBuildings.removeAll(tr);
        
        tr = new ArrayList<BuildingStatus>();
        
        for (BuildingStatus cc : myCCs) {
        	if (cc.status == BuildingStatus.SCHEDULED || cc.status == BuildingStatus.BUILDING)
        		tr.add(cc);
        }
        
        myCCs.removeAll(tr);
        
    	if (BOIncoming(UnitType.TERRAN_COMMAND_CENTER)) {
	    	int removeIndex = -1;
	        for (int x = buildOrder.size() -1; x >= 0; x--) {
	        	if (buildOrder.get(x) == UnitType.TERRAN_COMMAND_CENTER) {
	        		removeIndex = x;
	        		break;
	        	}
	        }
	        if (removeIndex != -1) 
	        	buildOrder.remove(removeIndex);  
    	}
        
        
    }

    public void safeExpand() {
        /* Adds a CC plus bunker to the build order, expansion should take care of itself with the building placer */
        if (nextBldg() != UnitType.TERRAN_COMMAND_CENTER && nextBldg() != UnitType.TERRAN_BUNKER 
        		&& !BOIncoming(UnitType.TERRAN_COMMAND_CENTER) && !beingConstructed(UnitType.TERRAN_COMMAND_CENTER)
        		&& !BOIncoming(UnitType.TERRAN_BUNKER) && !beingConstructed(UnitType.TERRAN_BUNKER)) {
            BOInject(UnitType.TERRAN_BUNKER);
            BOInject(UnitType.TERRAN_COMMAND_CENTER);
        	mGame.printf("Safe Expansion injected into build");
        }
    }
    
    public TilePosition nextExpansion(boolean withGas) {
    	
    	long start = System.currentTimeMillis();
        TilePosition best = null;
        double min = Double.POSITIVE_INFINITY;

        int j = -1;
        for (BaseLocation b : bls) {
            boolean skip = false;
            j++;
        	if (mGame.getMapHash().equals("6f8da3c3cc8d08d9cf882700efa049280aedca8c") && b.getTilePosition().x() == 19) {
        		skip = true;
        	}
        	
        	if (b.isIsland())
        		skip = true;

            TilePosition tp = b.getTilePosition();
            for (BuildingStatus bs : myCCs) {
                if ((bs.spot.equals(tp) || bs.spot.getDistance(tp) < 10) && bs.status != BuildingStatus.SCHEDULED && bs.status != BuildingStatus.DEAD)
                    skip = true;
            }
            
            boolean hasGeyser = false;
            for (ROUnit geyser : mGame.getStaticGeysers()) {
            	if (geyser.getDistance(b.getPosition()) < 32*10) {
            		hasGeyser = true;
            		break;
            	}
            }
            if (!hasGeyser && withGas)
            	skip = true;
            
            for (TilePosition tile : TilePosition.getTilePositions(b.getTilePosition(), 4, 3)) {
            	for (ROUnit u : mGame.unitsOnTile(tile)) {
            		if (u.getType().isBuilding() || u.getType() == UnitType.TERRAN_VULTURE_SPIDER_MINE)
            			skip = true;
            	}
            	
            	if (enemyBuildings != null) 
            		for (ROUnit bldg : enemyBuildings) {
            		if (bldg.getLastKnownTilePosition().getDistance(b.getTilePosition()) < 7)
            			skip = true;
            		}
            }
            
            
            
            if (skip) continue;
            if (bldists[j] <= min) {
                min = bldists[j];
                best = b.getTilePosition();
            }
        }
        
        if (best != null) mGame.drawCircleMap(Position.centerOfTile(best), 2, Color.GREEN, true);
        if (best == null && withGas)
        	return nextExpansion(false);
        
        //mGame.printf("expo " + (System.currentTimeMillis()-start));
        return best;
    }

    public int numWorkers() {
        return workerManager.numWorkers();
    }

    public WorkerStatus getWorker() {
        return workerManager.getWorker();
    }

    protected ArrayList<BuildingStatus> getMyCCs() {
        return myCCs;
    }

    public void addBase(BaseLocation base) {
        System.out.println("Added a base");
        workerManager.addBase(base);
        myBases.add(base);
        buildingPlacer.addBase(base);
    }

    public boolean minedOutAllBases(){
        for(BaseLocation b: myBases){
            if(!b.getMinerals().isEmpty()){
                return false;
            }
        }
        return true;
    }
    public int idleBuildings(){
        int i = 0;
        for(BuildingStatus bs : myBuildings){
            if(bs.myUnit != null && bs.myUnit.getType().canProduce() && bs.status == BuildingStatus.BUILT &&
                    !bs.myUnit.isTraining()) i++;
        }
        return i;
    }
    public void drawMacroIndicators(){
    	if (debug)   mGame.drawTextScreen(20, 40, "Idle buildings: "+ idleBuildings());
    }
    
    public void handleDoor() {

    	if (wall != null) for (int i = 0; i < wall.size(); i ++) {
    		TilePosition tp = wall.get(i);
    		if (i == 0) mGame.drawCircleMap(new Position(tp), 2, Color.ORANGE, true);
    		if (i == 1) mGame.drawCircleMap(new Position(tp), 2, Color.GREEN, true);
    		if (i == 2) mGame.drawCircleMap(new Position(tp), 2, Color.BLUE, true);

        	if (wallDoor == null) for (BuildingStatus bs : myBuildings) {
        		if (wall.get(0).equals(bs.spot)) {
        			wallDoor = bs.myUnit;
        			break;
        		}
        		
        	}
    	}
    	
    	if (wallDoor != null) {
    		if (BOCount(UnitType.TERRAN_COMMAND_CENTER) > 1 || me.supplyUsed() > 95) {
    			if (!wallDoor.isLifted() && wallDoor.getTilePosition().getDistance(wall.get(0)) < 3) { 
    				wallDoor.lift();
    				wantsToLift = true;
    			}
    			else if (wallDoor.isIdle() && wallDoor.isLifted()) {
    				wallDoor.land(buildingPlacer.placeBuilding(UnitType.TERRAN_FACTORY));
    				wantsToLift = false;
    			}
    		}
    		
    		if (BOCount(UnitType.TERRAN_COMMAND_CENTER) == 1 && !wallDoor.getTilePosition().equals(wall.get(0))) {
    			if (!wallDoor.isLifted()) {
    				wallDoor.lift();
    				wantsToLift = true;
    			}
    				
    			else if (wallDoor.isIdle()) {
    				wallDoor.land(wall.get(0));
    				wantsToLift = false;
    			}
    		}
    	}
    }
    
    public void enemyStartStuff() {

    	if (eligibleEnemyStarts.size() != 1 && enemyBuildings != null) {
    		TilePosition confirmedStart = null;
    		outer: 
    		for (ROUnit bldg : enemyBuildings) {
    			for (TilePosition tp : eligibleEnemyStarts) {
    				if (tp.getDistance(bldg.getPosition()) < 10) {
    					confirmedStart = tp;
    					break outer;
    				}
    			}
    		} 		
    		if (confirmedStart != null) {
    			eligibleEnemyStarts = new ArrayList<TilePosition>();
    			eligibleEnemyStarts.add(confirmedStart);
    		}
    		
    	}
    	if (eligibleEnemyStarts.size() != 1) {
    		ArrayList<TilePosition> tr = new ArrayList<TilePosition>();
    		outer: 
    		for (TilePosition tp : eligibleEnemyStarts) {
    			if (mGame.isVisible(tp)) {
    				for (ROUnit u : mGame.unitsOnTile(tp)) {
    					if (u.getType().isResourceDepot()) {
    		    			eligibleEnemyStarts = new ArrayList<TilePosition>();
    		    			eligibleEnemyStarts.add(tp);
    		    			break outer;
    					}
    				}
    				tr.add(tp);
    			}
    		}
    		
    		eligibleEnemyStarts.removeAll(tr);
    	}
    	
    	if (eligibleEnemyStarts.size() == 1 && enemyBaseRegion == null) {
    		for (Region r : myBwta.getRegions()) {
    			if (r.contains(eligibleEnemyStarts.get(0)))
    				enemyBaseRegion = r;
    		}
    	}
    	
    }
}
