package undermind.macro;

import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.WorkerStatus;

public class BuildingStatus {
	public boolean turreted = false;
	public static final int SCHEDULED = 0;
    public static final int BUILDING = 1;
    public static final int BUILT = 2;
    public static final int DEAD = 3;
    public int age; // How long has this building been scheduled?
    public int status;
    public UnitType type;
    public WorkerStatus myBuilder;
    public Unit myUnit;
    public TilePosition spot;
    public int myHarvesters = 0; //refineries only
    public int unitsproduced;
    
    public boolean orderqueued;
    
    public BuildingStatus(WorkerStatus u, UnitType t, TilePosition p) {
    	status = SCHEDULED;
    	myBuilder = u;
    	type = t;
    	spot = p;
    	unitsproduced = 0;
    }
    
    public BuildingStatus(UnitType t) {
    	status = SCHEDULED;
    	type = t;
     	unitsproduced = 0;
    }
    
    public BuildingStatus(int status, Unit u) {
    	this.status = status;
    	myUnit = u;
    	type = u.getType();
    	spot = u.getTilePosition();
     	unitsproduced = 0;
    }

}
