package undermind.macro;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import edu.berkeley.nlp.starcraft.util.ConvexHull;
import edu.berkeley.nlp.starcraft.util.Utils;

public class BuildingPlacer {
	public TilePosition wallPathStart;
	Game mGame;
	MacroManager master;
    TilePosition buildSpot1;
    private List<ConvexHull> noBuildies = new LinkedList<ConvexHull>();
    BuildTilesState bt_state;
    public List<TilePosition> wtf;
    public List<TilePosition> basicEligible;

	public BuildingPlacer(Game g, MacroManager m) {
		master = m;
		mGame = g;
		buildSpot1 = ExtendedTerrainAnalyzer.inFrontOfCC(master.myBaseLocation);
		bt_state = new BuildTilesState(m);
	}

	
    public void addBase(BaseLocation b){
        //bt_state.buildable_regions.add(b);
    }
	/**
     * A not bad building placement funciton.
	 */
	public TilePosition placeBuilding(UnitType bldg) {
		if (master.numWorkers() == 0) return new TilePosition(1,1);
		Unit builder = master.getWorker().unit;
		long starttime = System.currentTimeMillis();

		if (bldg == UnitType.TERRAN_REFINERY)
			return master.nextRefinery();
		if (bldg == UnitType.TERRAN_COMMAND_CENTER) {
            return placeCC();
		}
		else if (bldg == UnitType.TERRAN_BUNKER) {
            return placeBunker(builder);
		}
		else if (bldg == UnitType.TERRAN_MISSILE_TURRET) {
            return placeTurret(builder);
		}
		else {
			if (master.wall != null && master.time < 10000) {
				int s = master.wall.size();
				TilePosition rax = master.wall.get(0);

				if (master.wallDoor == null && bldg == UnitType.TERRAN_BARRACKS && (!Utils.fullVisible(rax, bldg) || mGame.canBuildHere(builder, rax, bldg))) {
					return rax;
				}
				else if (bldg == UnitType.TERRAN_SUPPLY_DEPOT && s > 1) {
					if (!Utils.fullVisible(master.wall.get(1), bldg) || mGame.canBuildHere(builder, master.wall.get(1), bldg))
						return master.wall.get(1);
					else if (s > 2 && (!Utils.fullVisible(master.wall.get(2), bldg) || mGame.canBuildHere(builder, master.wall.get(2), bldg)))
						return master.wall.get(2);
				}
			}
			
			
			TilePosition spot = bt_state.place(bldg, new HashSet<TilePosition>());
			//mGame.printf("normal place took " + ((System.currentTimeMillis()-starttime)));
			if (spot != null) return spot;
			/*
            Queue<TilePosition> q = new LinkedList<TilePosition>();
            Set<TilePosition> visited = new HashSet<TilePosition>();
            for(BaseLocation b:master.myBases){
                q.add(ExtendedTerrainAnalyzer.inFrontOfCC(b));
            }
            int tries = 0;
            //if(!mGame.isVisible(pos))return null;
            while(!q.isEmpty()){
                TilePosition tp = q.poll();
                tries++;
                if(tries>1500)break;
                visited.add(tp);
                Position p = new Position(tp);
                if(builder.canBuildHere(tp, bldg) && eligibleBuildSpot(p)){
                    System.out.println("[+] Building a " + bldg + " at " + tp);
                    mGame.drawLineMap(builder.getPosition(), Position.centerOfTile(tp), Color.YELLOW);
                    return tp;
                }else{
                    for(TilePosition succ : Arrays.asList(tp.add(0, 3),tp.add(6, 0),tp.add(0, -3),tp.add(-6, 0))){
                        if(!visited.contains(succ)){
                            q.add(succ);
                        }
                    }
                }
            } */
        }
        System.out.println("DERP");
        return null;//TODO: THis is probably bad
	}

    private TilePosition placeTurret(Unit builder) {
        UnitType bldg = UnitType.TERRAN_MISSILE_TURRET;

        for (int i = master.myCCs.size()-1; i >= 0; i--) {

            BuildingStatus cc = master.myCCs.get(i);
            if (cc.turreted) continue;
            TilePosition ccpos = cc.spot;
			ROUnit closestPatch = null;
            
            outer:
        	for (BaseLocation bl : master.myBases){
        		if (bl.getTilePosition().equals(ccpos)) {
        			double closestDistance = Double.POSITIVE_INFINITY;
        			Set<? extends ROUnit> patches = bl.getMinerals();
        			if (patches.size() == 0) break outer;
        			for (ROUnit patch : patches) {
        				if (patch.getDistance(bl.getPosition()) < closestDistance) {
        					closestDistance = patch.getDistance(bl.getPosition());
        					closestPatch = patch;
        				}
        			}
        		}
        	}
            
			if (closestPatch == null)
		        return placeBuilding(UnitType.TERRAN_COMSAT_STATION);
			
			
			double best = Double.POSITIVE_INFINITY;
			TilePosition bestpos = null;
			
			TilePosition centerpos = new TilePosition(ccpos.x()+2, ccpos.y()+1);
			for (int dx = -5; dx < 5; dx++) {
				for (int dy = -5; dy < 5; dy++) {
					TilePosition tp = new TilePosition(closestPatch.getTilePosition().x()+dx, closestPatch.getTilePosition().y()+dy);
	            	double distance = tp.getDistance(centerpos);
	            	if (distance < 3 || distance > 6) continue;
					if (distance < best && builder.canBuildHere(tp, bldg)) {
	            		best = distance;
	            		bestpos = tp;
	            	}
				}
			}
			


            
            
            if (bestpos != null) {
                cc.turreted = true;
                return bestpos;      
            }

        }
        
        
        
        return bt_state.placeTurret(UnitType.TERRAN_MISSILE_TURRET, new HashSet<TilePosition>());

    }

    private TilePosition placeBunker(Unit builder) {
        UnitType bldg = UnitType.TERRAN_BUNKER;
        Unit cc = null;
        if (master.myCCs.size() > 0) cc= master.myCCs.get(master.myCCs.size() - 1).myUnit;
        if (cc == null) return placeBuilding(UnitType.TERRAN_ARMORY);
        TilePosition pos = cc.getTilePosition();
        TilePosition newpos = new TilePosition(pos.x()-3, pos.y());

        
        TilePosition choke;
        TilePosition ccSpot;
        Region r;
        boolean wall = false;
        
        if (master.myCCs.size() == 0)
            return placeBuilding(UnitType.TERRAN_ARMORY);
        
        else if (master.myCCs.size() == 1 && !master.BOIncoming(UnitType.TERRAN_COMMAND_CENTER)) {
        	
        	if (master.wall != null && master.wallDoor != null && !master.wallDoor.isLifted() && master.wallDoor.getTilePosition().equals(master.wall.get(0))) {
        		choke = master.wall.get(0);
        		wall = true;
        	}
        	else choke = new TilePosition(master.baseChoke.getCenter());
        	ccSpot = master.myCCs.get(0).spot;
        	r = master.baseRegion;
        }
        else {
        	if (master.myCCs.size() > 1) ccSpot = master.myCCs.get(1).spot;
        	else ccSpot = master.nextExpansion(true);
        	choke = new TilePosition(master.natChoke.getCenter());
        	r = master.natRegion;
        }
        

        
        double bestDistance = Double.POSITIVE_INFINITY;
        TilePosition bestpos = null;
        
        
        int tolerance = 4;
        if (wall) tolerance = 7;
        for (int i = -tolerance; i < tolerance; i++) {
        	for (int j = -tolerance; j < tolerance; j++) {
        		TilePosition newpos2 = new TilePosition(choke.x()+i, choke.y() + j);
        		double closestBldg = Double.POSITIVE_INFINITY;
        		
        		for (BaseLocation b : master.bls) {
        			if (b.getTilePosition().getDistance(newpos2) < 4)
        				continue;
        		}



        		double d = ccSpot.getDistance(newpos2);
        		
        		
        		
        		if (!wall) {
            		for (int v = 0; v < master.myBuildings.size(); v++) {
            			if (master.wall != null && master.wall.contains(newpos2))
            			if ((master.myBuildings.get(v).spot).getDistance(newpos2) < closestBldg) {
            				closestBldg = (master.myBuildings.get(v).spot)
            				.getDistance(newpos2);
            			}
            		}
        			
        			if (closestBldg > 3 && (!Utils.fullVisible(newpos2, bldg) || builder.canBuildHere(newpos2, bldg)) && fitbuildable(newpos2, UnitType.TERRAN_BUNKER)
        				&& d < bestDistance && choke.getDistance(newpos2) > 3 && r.contains(newpos2)) {
	        			bestpos = newpos2;
	        			bestDistance = d;
	        		}
        		}
        		else {
        			
            		double choked = newpos2.getDistance(master.baseChoke.getCenter());
        			if (mGame.getMapHash().equals("de2ada75fbc741cfa261ee467bf6416b10f9e301") && newpos2.y() > 123)
        				continue;
        			if (choked > 5 && (choked) < bestDistance && (!Utils.fullVisible(newpos2, bldg) || builder.canBuildHere(newpos2, bldg)) && fitbuildable(newpos2, UnitType.TERRAN_BUNKER)
            				&& r.contains(newpos2)) {
    	        			bestpos = newpos2;
    	        			bestDistance = choked;
    	        		}
        		}
        	}
        }

        
        /* Yes, this is horribly ugly */
        if (bestpos != null)
        	return bestpos;
        else {
            for (int i = -7; i < 7; i++) {
            	for (int j = -7; j < 7; j++) {
            		TilePosition newpos2 = new TilePosition(choke.x()+i, choke.y() + j);
            		double closestBldg = Double.POSITIVE_INFINITY;

            		for (int v = 0; v < master.myBuildings.size(); v++) {
            			if ((master.myBuildings.get(v).spot).getDistance(newpos2) < closestBldg) {
            				closestBldg = (master.myBuildings.get(v).spot)
            				.getDistance(newpos2);
            			}
            		}

            		double d = ccSpot.getDistance(newpos2);
            		if (closestBldg > 5 && (!Utils.fullVisible(newpos2, bldg) || builder.canBuildHere(newpos2, bldg)) && fitbuildable(newpos2, UnitType.TERRAN_BUNKER) && d < bestDistance) {
            			bestpos = newpos2;
            			bestDistance = d;
            		}
            	}
            }
        }
        
        if (bestpos != null)
        	return bestpos;

        if (builder.canBuildHere(newpos, bldg)) {
            return newpos;
        }
        newpos = new TilePosition(pos.x()+4, pos.y()-1);
        if (builder.canBuildHere(newpos, bldg)) {
            return newpos;
        }
        newpos = new TilePosition(pos.x()-7, pos.y());
        if (builder.canBuildHere(newpos, bldg)) {
            return newpos;
        }
        newpos = new TilePosition(pos.x()+7, pos.y());
        if (builder.canBuildHere(newpos, bldg)) {
            return newpos;
        }

        return placeBuilding(UnitType.TERRAN_ARMORY);
    }

    private TilePosition placeCC() {
    	TilePosition best;
        if (master.mech && !mGame.getMapHash().equals("1e983eb6bcfa02ef7d75bd572cb59ad3aab49285")) best = master.nextExpansion(true);
        else best = master.nextExpansion(false);
        if (best != null) return best;
        else {
            master.cancelExpand();
            mGame.printf("uh oh... no more expansions?");
            return new TilePosition(5,5);
        }
    }


    public boolean superbuildable(TilePosition p) {
		int x = p.x();
		int y = p.y();

		if (x < 3 || x > master.width-5) {
			return false;
		}
		if (y < 3 || y > master.height-4) {
			return false;
		}


		if (mGame.isBuildable(x, y) && mGame.isBuildable(x+1, y) && mGame.isBuildable(x, y+1) && mGame.isBuildable(x+1, y+1)) {
			if (mGame.unitsOnTile(x, y).size() == 0 && mGame.unitsOnTile(x+1, y).size() == 0 && mGame.unitsOnTile(x, y+1).size() == 0 && mGame.unitsOnTile(x+1, y+1).size() == 0)
				return true;
		}


		return false;
	}


	public boolean fitbuildable(TilePosition p, UnitType bldg) {
		for (int i = 0; i < bldg.tileWidth(); i++) {
			for (int j = 0; j < bldg.tileHeight(); j++) {
				if (!mGame.isBuildable(p.x()+i, p.y()+j))
					return false;
			}
		}
		return true;
	}
	
	public List<TilePosition> getTilesAround(Unit bldg) {
		List<TilePosition> surrounding = new ArrayList<TilePosition>();
		int height = bldg.getType().tileHeight();
		int width = bldg.getType().tileWidth();
		int x = bldg.getTilePosition().x();
		int y = bldg.getTilePosition().y();
		
		for (int dx = -1; dx < width+1; dx++) {
			surrounding.add(new TilePosition(x+dx, y-1));
			surrounding.add(new TilePosition(x+dx, y+height));
		}

		for (int dy = 0; dy < height; dy++) {
			surrounding.add(new TilePosition(x-1, y+dy));
			surrounding.add(new TilePosition(x+width, y+dy));
		}
		
		
		return surrounding;
	}
	
	public List<TilePosition> getTurretTiles(ROUnit bldg) {
		List<TilePosition> surrounding = new ArrayList<TilePosition>();
		int height = bldg.getType().tileHeight();
		int width = bldg.getType().tileWidth();
		int x = bldg.getTilePosition().x();
		int y = bldg.getTilePosition().y();
		
		for (int dx = -1; dx < width+1; dx++) {
			surrounding.add(new TilePosition(x+dx, y-2));
			surrounding.add(new TilePosition(x+dx, y+height));
		}

		for (int dy = 0; dy < height; dy++) {
			surrounding.add(new TilePosition(x-2, y+dy));
			surrounding.add(new TilePosition(x+width, y+dy));
		}
		
		
		return surrounding;
	}
	
	public ArrayList<TilePosition> getOffsetTiles(ROUnit bldg, int widthNeeded, int heightNeeded) {
		ArrayList<TilePosition> surrounding = new ArrayList<TilePosition>();
		int height = bldg.getType().tileHeight();
		int width = bldg.getType().tileWidth();
		int x = bldg.getTilePosition().x();
		int y = bldg.getTilePosition().y();
		
		//bottom
		for (int dx = 1-widthNeeded; dx < width+1; dx++) {
			TilePosition tilePosition = new TilePosition(x+dx, y+height);
			if (canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) surrounding.add(tilePosition);
		}
		//right
		for (int dy = 1-heightNeeded; dy < height; dy++) {
			TilePosition tilePosition = new TilePosition(x+width, y+dy);
			if (canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) surrounding.add(tilePosition);
		}
		//top
		for (int dx = -widthNeeded; dx < width+1; dx++) {
			TilePosition tilePosition = new TilePosition(x+dx, y-heightNeeded);
			if (canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) surrounding.add(tilePosition);
		}
		//left
		for (int dy = -heightNeeded; dy < height+1; dy++) {
			TilePosition tilePosition = new TilePosition(x-widthNeeded, y+dy);
			if (canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) surrounding.add(tilePosition);
		}
		
		
		return surrounding;
	}
	
	public ArrayList<TilePosition> getOffsetTiles(int x, int y, int width, int height, int widthNeeded, int heightNeeded) {
		ArrayList<TilePosition> surrounding = new ArrayList<TilePosition>();
		
		//bottom
		for (int dx = 1-widthNeeded; dx < width+1; dx++) {
			TilePosition tilePosition = new TilePosition(x+dx, y+height);
			if (canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) surrounding.add(tilePosition);
		}
		//right
		for (int dy = 1-heightNeeded; dy < height; dy++) {
			TilePosition tilePosition = new TilePosition(x+width, y+dy);
			if (canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) surrounding.add(tilePosition);
		}
		//top
		for (int dx = -widthNeeded; dx < width+1; dx++) {
			TilePosition tilePosition = new TilePosition(x+dx, y-heightNeeded);
			if (canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) surrounding.add(tilePosition);
		}
		//left
		for (int dy = -heightNeeded; dy < height+1; dy++) {
			TilePosition tilePosition = new TilePosition(x-widthNeeded, y+dy);
			if (canBuildRaw(tilePosition.x(), tilePosition.y(), widthNeeded, heightNeeded)) surrounding.add(tilePosition);
		}
		
		
		return surrounding;
	}
	
	public boolean canBuildRaw(int x, int y, int width, int height) {
    	for (int dx = 0; dx < width; dx++) {
    		for (int dy = 0; dy < height; dy++) {
    			if (!mGame.isBuildable(x + dx, y + dy))
    				return false;
    				
    		}
    	}
    	
    	return true;
	}
	
	
	
    private boolean eligibleBuildSpot(Position p){
        for(ConvexHull c : noBuildies){
            if(c.withinHull(p))
                return false;
        }
        return true;
    }
    public void addNoBuildZone(ConvexHull zone){
        noBuildies.add(zone);
    }
    
    public void drawBuildingStuffs(){
//        for(TilePosition tp: bt_state.filterTiles(bt_state.myBaseTiles())){
//            mGame.drawCircleMap(new Position(tp), 2, Color.ORANGE, true);
//        }
//        for (BuildingStatus bs : master.myBuildings){
//            mGame.drawCircleMap(new Position(bs.spot), 4, Color.RED, true);
//            int hight1 = bs.type.tileHeight() + 1;
//            int width1 = bs.type.tileWidth() + 1;
//            TilePosition spot = bs.spot;
//            TilePosition diag = new TilePosition(spot.x() + width1, spot.y() + hight1);
//            mGame.drawLineMap(new Position(spot), new Position(diag), Color.RED);
//        }
    	
    	//TilePosition tp = bt_state.place(UnitType.TERRAN_BARRACKS, new HashSet<TilePosition>());
    	//mGame.drawCircleMap(new Position(tp), 4, Color.BLUE, true); 
    	
    	
    	//bt_state.test();
    	
    	//bt_state.grow();
    	/*
    	for (TilePosition tp : bt_state.myBaseTiles()) {
    		if (!bt_state.filter_out_min_gas(tp))
    			mGame.drawCircleMap(new Position(tp), 2, Color.CYAN, true);
    	} */
    	
    	/*if (bt_state.banned != null)
	    	for (TilePosition ban : bt_state.banTiles(bt_state.myBaseTiles())){
	    		mGame.drawCircleMap(new Position(ban), 2, Color.RED, true);
	    	}
    	*/
    	


    	
    	

    }
    
    
    
    public void getChokeDots(Chokepoint c) {
    	TilePosition center = new TilePosition(c.getCenter());
    	mGame.drawCircleMap(Position.centerOfTile(center), 3, Color.RED, true);
    	int tolerance = 6;
    	for (int dx = -tolerance; dx < tolerance; dx++) {
        	for (int dy = -tolerance; dy < tolerance; dy++) {
        		TilePosition newpos = new TilePosition(center.x() + dx, center.y() + dy);
        		//mGame.drawCircleMap(Position.centerOfTile(newpos), 2, Color.WHITE, false);
        	}
    	}
    	

    }
    
    
    public List<TilePosition> doWall(TilePosition seed, ArrayList<Block> blocks, ArrayList<TilePosition> eligible, ArrayList<TilePosition> occupied) {
    	// A rax is 4x3
    	// A depot is 3x2
    	ArrayList<Block> myBlocks = new ArrayList<Block>(blocks);
    	TilePosition start = wallPathStart;
    	Block b = myBlocks.remove(0);
    	int depotDist = 3;
    	if (mGame.getMapHash().equals("9bfc271360fa5bab3707a29e1326b84d0ff58911") || mGame.getMapHash().equals("6f8da3c3cc8d08d9cf882700efa049280aedca8c"))
    		depotDist = 4;


    	
    	/* For each those eligible positions, pretend you put down the building.
    	 * If you can't path anymore, return that tileposition.
    	 * If you can still path, but there exists a subsolution, return the tileposition plus subsolution.
    	 */
    	for (TilePosition tp : eligible) {
    		if (tp.getDistance(seed) < depotDist && b.width == 3) //HORRIBLE, but so is all of this code
    			continue;
    		
    		if (!master.baseRegion.contains(tp) || !basicEligible.contains(tp))
    			continue;
	    	ArrayList<TilePosition> blocked = new ArrayList<TilePosition>(occupied);
			for (int shiftx = 0; shiftx < b.width; shiftx++) {
				for (int shifty = 0; shifty < b.height; shifty++) {
					TilePosition newpos = new TilePosition(tp.x() + shiftx, tp.y()+shifty);
					if (!blocked.contains(newpos)) blocked.add(newpos);
				}
			}
			if (blocked.contains(seed))
				continue;
			if (master.pathfinder.getPath(start, seed, blocked) == null) {
				wtf = new ArrayList<TilePosition>(blocked);
				ArrayList<TilePosition> ret = new ArrayList<TilePosition>();
				ret.add(tp);
				return ret;
			}
			else if (myBlocks.size() != 0) {
				ArrayList<TilePosition> newEligible = getOffsetTiles(tp.x(), tp.y(), b.width, b.height, myBlocks.get(0).width, myBlocks.get(0).height);
				List<TilePosition> subsolution = doWall(seed, myBlocks, newEligible, blocked);
				if (subsolution != null) {
					subsolution.add(0, tp);
					return subsolution; 
				}
			}
			
    	  }
    	
    	return null;
    }
    	
 
}
