package undermind.macro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Chokepoint;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
import edu.berkeley.nlp.starcraft.util.Vector;

public class BuildTilesState {
	
	List<BaseLocation> extraBLs;
	MacroManager master;
	ArrayList<Region> buildable_regions;
	List<TilePosition> growTiles;
	Set<TilePosition> banned;
	int growsThisFrame;
	Region growRegion;
	
	
	public BuildTilesState (MacroManager master){
		this.master = master;
		buildable_regions = new ArrayList<Region>();
		
		growTiles = new ArrayList<TilePosition>();
		
		if (master.natChoke.getRegions().getKey().getChokepoints().contains(master.baseChoke)) {
			growRegion = master.natChoke.getRegions().getValue();
		}
		else {
			growRegion = master.natChoke.getRegions().getKey();
		}
		
		extraBLs = new ArrayList<BaseLocation>();
			
		
	}
	
	public void grow(){
		Game.getInstance().printf("GROWING!!");

		/*if (buildable_regions.size() < master.myBases.size() && master.myBases.size() <= 2){
			buildable_regions = new ArrayList<BaseLocation>(master.myBases);
		} else { */

		
		

		if (buildable_regions.contains(growRegion)) {
			List<Region> eligible = new ArrayList<Region>();
			for (Chokepoint c : growRegion.getChokepoints()) {
				Region r1 = c.getRegions().getKey();
				Region r2 = c.getRegions().getValue();
				if (!buildable_regions.contains(r1)) {
					eligible.add(r1);
				}
				if (!buildable_regions.contains(r2)) {
					eligible.add(r2);	
				}
			}
			
			Region best = null;
			double bestDist = Double.POSITIVE_INFINITY;
			for (Region r : eligible) {
				double d = r.getCenter().getDistance(new Position(master.myHome));
				if (d < bestDist) {
					bestDist = d;
					best = r;
				}
			}
			
			growRegion = best;
		}
		if (growRegion != null) {
			buildable_regions.add(growRegion);
			
			for (BaseLocation bl : master.myBwta.getBaseLocations()) {
				if (growRegion.contains(bl.getPosition()))
					extraBLs.add(bl);
			}
			
			
		}


	}
	
	public void ban_tile(TilePosition tp){
		banned.add(tp);
	}
	public void un_ban_tile(TilePosition tp){
		if (banned.contains(tp)) banned.remove(tp);
	}
	
	//get the set of raw tiles that we can build on that's in our base
    public Set<TilePosition> myBaseTiles(){
    	//Update bases
    	for (BaseLocation bl : master.myBases) {
    		for (Region r : master.myBwta.getRegions()) {
    			if (r.contains(bl.getPosition()) && !buildable_regions.contains(r)) {
    				buildable_regions.add(r);
    				break;
    			}
    				
    		}
    	}
    	
    	List<Region> regions;
    	regions = buildable_regions;
        if (buildable_regions.size() >= 3) {
        	regions = new ArrayList<Region>();
        	for (int i = 2; i < buildable_regions.size(); i++) {
            	regions.add(buildable_regions.get(i));
        	}
        }
        
        HashSet<TilePosition> tps = new HashSet<TilePosition>();
        for(Region b : regions){
            Queue<TilePosition> q = new LinkedList<TilePosition>();
            q.add(new TilePosition(b.getCenter()));
            while(!q.isEmpty()){
                TilePosition tp = q.poll();
                tps.add(tp);
                for(TilePosition succ : Arrays.asList(tp.add(0, 1),tp.add(1, 0),tp.add(0, -1),tp.add(-1, 0))){
                    if(!tps.contains(succ) && !q.contains(succ) && b.contains(succ)){
                        q.add(succ);
                    }
                }
            }
        }
        
        List<TilePosition> tr = new ArrayList<TilePosition>();
        for (TilePosition tp : tps) {
        	if (!master.mGame.isBuildable(tp.x(), tp.y()) || tp.getDistance(master.myHome) > 42)
        		tr.add(tp);
        }
        
        tps.removeAll(tr);
        
        /*if (growTiles.size() != 0) {
        	tps = new HashSet<TilePosition>();
        }
        tps.addAll(growTiles); */
        return tps;
    }
    
    //from a set of possible tiles in your base, ban the invalid placing ones
    public Set<TilePosition> banTiles(Set<TilePosition> raw_tiles){
    	Set<TilePosition> fresh_banned = new HashSet<TilePosition>();
    	//initialize some crap
    	Set<TilePosition> building_buffer = get_building_buffer();
    	
    	//do the filtering
    	for (TilePosition tp : raw_tiles){
		    filter_out_unwalkable_with_buffer(tp, fresh_banned);
    		if (filter_out_min_gas(tp) || 
    			filter_out_choke(tp) ||
    		    filter_out_building_with_buffer(tp, building_buffer)
    		){
    			fresh_banned.add(tp);
    		}
    	}
    	banned = fresh_banned;
    	return fresh_banned;
    }
    
    private boolean filter_out_unwalkable_with_buffer(TilePosition tp, Set<TilePosition> fresh_banned) {
		if (!Utils.isWalkable(tp)){
			fresh_banned.add(tp.add(-1,-1));
			fresh_banned.add(tp.add(-1,0));
			fresh_banned.add(tp.add(-1,1));
			fresh_banned.add(tp.add(0,-1));
			fresh_banned.add(tp.add(0,0));
			fresh_banned.add(tp.add(0,1));
			fresh_banned.add(tp.add(1,-1));
			fresh_banned.add(tp.add(1,0));
			fresh_banned.add(tp.add(1,1));
		}
		return false;
	}

	//give a building type, where do I put it?
    public TilePosition place(UnitType buildingtype, Collection<TilePosition> additional_ban){
    	//sync states...
    	Set<TilePosition> all_inbase_tiles = myBaseTiles();
    	int k = all_inbase_tiles.size();
    	Set<TilePosition> banned_tiles = banTiles(all_inbase_tiles);
    	/*for (TilePosition ban : banned_tiles){
    		Game.getInstance().drawCircleMap(new Position(ban), 2, Color.RED, true);
    	}*/
    	//get rid of banned, preliminary, and additionally banned
    	Set<TilePosition> after_ban1 = new HashSet<TilePosition>();
    	for (TilePosition tp : all_inbase_tiles){
    		boolean _ban = false;
    		if (banned_tiles.contains(tp)) _ban = true;
    		if (additional_ban.contains(tp)) _ban = true;
    		/*for (TilePosition tp_ban : banned_tiles){
    			if (tp.equals(tp_ban)) _ban = true;
    		}
    		for (TilePosition tp_ban_additional : additional_ban){
    			if (tp.equals(tp_ban_additional)) _ban = true;
    		}*/
    		if (!_ban) after_ban1.add(tp);
    	}
    	//get rid of more based on building type... for collision
    	Set<TilePosition> after_ban2 = new HashSet<TilePosition>();
    	for (TilePosition tp1 : after_ban1){
    		if (!filter_out_via_type(tp1, buildingtype, banned_tiles)) after_ban2.add(tp1);
    	}
    	/*for (TilePosition ban : after_ban2){
    		Game.getInstance().drawCircleMap(new Position(ban), 2, Color.GREEN, true);
    	}*/
    	//now from the set of available points pick a closest one
    	if (after_ban2.size() == 0){
    		if (growsThisFrame == 0) { 
    			grow();
    			growsThisFrame++;
    			return place(buildingtype, additional_ban);
    		}
    		else {
    	    	growsThisFrame = 0;
    			Game.getInstance().printf("UH OH... no spot to build");
    			return TilePosition.INVALID;
    		}
    	}
    	growsThisFrame = 0;
    	return find_closest_squared(after_ban2, get_building_buffer());
    }
    
    //find closest to average dist squared
    TilePosition find_closest_squared(Set<TilePosition> candidate, Set<TilePosition> stay_close_to_these){
    	TilePosition ret = null;
    	double best = Integer.MAX_VALUE;
    	for (TilePosition tp : candidate){
    		double score = 0;
    		for (TilePosition close : stay_close_to_these){
    			score += tp.getDistance(close) * tp.getDistance(close);
    		}
    		if (score < best){
    			best = score;
    			ret = tp;
    		}
    	}
    	return ret;
    }
    
    //find closest to average dist squared
    TilePosition find_closest_squared(Set<TilePosition> candidate, List<TilePosition> stay_close_to_these){
    	TilePosition ret = null;
    	double best = Integer.MAX_VALUE;
    	for (TilePosition tp : candidate){
    		double score = 0;
    		for (TilePosition close : stay_close_to_these){
    			score += tp.getDistance(close) * tp.getDistance(close);
    		}
    		if (score < best){
    			best = score;
    			ret = tp;
    		}
    	}
    	return ret;
    }
    
    //FILTER CODE BELOW
    public boolean filter_out_min_gas(TilePosition tp){
    	List<BaseLocation> bls = new ArrayList<BaseLocation>();
    	bls.addAll(master.myBases);
    	bls.addAll(extraBLs);
    	
    	for (BaseLocation bl : bls){
    		if (tp.getDistance(bl.getTilePosition()) < 3.5)
    			return true;
    		Set<ROUnit> min_gas = new HashSet<ROUnit>();
    		min_gas.addAll(bl.getGeysers());
    		
    		for (ROUnit min : bl.getMinerals()) {
    			if (min.getResources() > 0)
    				min_gas.add(min);
    		}
    		TilePosition cc_tp = bl.getTilePosition();
    		for (ROUnit mg : min_gas){
    			Position mg_pos = mg.getLastKnownPosition();
    			Position cc_pos = new Position(cc_tp);
    			double d = mg.getDistance(cc_pos);
    			if (mg.getDistance(cc_pos) > 300 || mg_pos == Position.INVALID || cc_pos == Position.INVALID) {
    				continue;
    			}
    			//Game.getInstance().drawCircleMap(cc_pos, 18, Color.RED, true);
    			Position tp_pos = new Position(tp);
    			Vector cc_to_tp = new Vector(cc_pos, tp_pos).normalize();
    			Vector mg_to_tp = new Vector(mg_pos, tp_pos).normalize();
    			if (cc_to_tp.dot(mg_to_tp) < -0.75){
    				return true;
    			}
    			if (new Position(tp).getDistance(mg_pos) < 50) return true;
    		}
    	}
    	return false;
    }

    public boolean filter_out_choke(TilePosition tp){
    	for (BaseLocation bl : master.myBases){
    		Set<Chokepoint> chokepoints = bl.getRegion().getChokepoints();
    		for (Chokepoint cp : chokepoints){
    			if (cp.getCenter().getDistance(new Position(tp)) < 200) return true;
    		}
    	}
    	return false;
    }
    
    public Set<TilePosition> get_building_buffer(){
    	HashSet<TilePosition> ret = new HashSet<TilePosition>(30);
        for (BuildingStatus bs : master.myBuildings){
        	if (bs.spot == null) {
        		Game.getInstance().printf("Something is wrong... a " + bs.type + "is null...");
        		return ret;
        	}
            int hight1 = bs.type.tileHeight() + 1;
            int width1 = bs.type.tileWidth() + 1;
            if (bs.type.equals(UnitType.TERRAN_COMMAND_CENTER)
            		|| bs.type.equals(UnitType.TERRAN_FACTORY)
            		|| bs.type.equals(UnitType.TERRAN_STARPORT)){
            	width1 += 2;
            }
            TilePosition spot = bs.spot;
            for (int x = 0; x < width1; x++){
            	for (int y = 0; y < hight1; y++){
            		TilePosition toadd = new TilePosition(spot.x()+x, spot.y()+y);
            		//Game.getInstance().drawCircleMap(new Position(toadd), 2, Color.RED, true);
            		ret.add(toadd);
            	}
            }
        }
        return ret;
    }
    
    private boolean filter_out_building_with_buffer(TilePosition tp, Set<TilePosition> building_buffer){
    	return building_buffer.contains(tp);
    }
    
    private boolean filter_out_via_type(TilePosition tp, UnitType buildingtype, Set<TilePosition> banned_tiles){
    	//first off, use the default canBuildHere method...
    	if (master.mGame.isVisible(tp) && !master.getWorker().unit.canBuildHere(tp, buildingtype)) return true;
    	//if the building is a factory or starport, try to shift it to the right and see if it can be placed
    	//if it cannot be placed, then it means addon cannot be placed
    	if (buildingtype.equals(UnitType.TERRAN_FACTORY) || buildingtype.equals(UnitType.TERRAN_STARPORT)){
    		TilePosition shifted_right = new TilePosition(tp.x()+2,tp.y());
    		if (master.mGame.isVisible(tp) && !master.getWorker().unit.canBuildHere(shifted_right, buildingtype)) return true;
    	}
    	//what is required to put down this building at this location?
    	TilePosition[] required = new TilePosition[4];
    	int width = buildingtype.tileWidth();
    	int hight = buildingtype.tileHeight();
        if (buildingtype.equals(UnitType.TERRAN_COMMAND_CENTER)
        		|| buildingtype.equals(UnitType.TERRAN_FACTORY)
        		|| buildingtype.equals(UnitType.TERRAN_STARPORT)){
        	width += 2;
        }
        required[0] = tp;
        required[1] = new TilePosition(tp.x() + width, tp.y());
        required[2] = new TilePosition(tp.x(), tp.y() + hight);
        required[3] = new TilePosition(tp.x() + width, tp.y() + hight);
    	//does the requirement conflict?
        for (TilePosition tp_req : required){
        	if (tp_req.x() < 0 || tp_req.y() < 0 || tp_req.x() > master.width-1 || tp_req.y() > master.height-1) // Don't go off-map
        		return true;
        	if (banned_tiles.contains(tp_req)) return true;
        	/*for (TilePosition tp_buff : banned_tiles){
        		if (tp_req.equals(tp_buff)) return true;
        	}*/
        }
        return false;
    }
    
    
    public void test() {
    	Set<TilePosition> raw_tiles = myBaseTiles();
    	//initialize some crap
    	Set<TilePosition> building_buffer = get_building_buffer();
    	
    	//do the filtering
    	for (TilePosition tp : raw_tiles){
    		if (!filter_out_min_gas(tp) && !filter_out_choke(tp) && !filter_out_building_with_buffer(tp, building_buffer)) {
        		Game.getInstance().drawCircleMap(new Position(tp), 2, Color.GREEN, false);  			
    		}

    		if (filter_out_min_gas(tp))
        		Game.getInstance().drawCircleMap(new Position(tp), 5, Color.BLUE, false); /*
    		if (filter_out_building_with_buffer(tp, building_buffer))
        		Game.getInstance().drawCircleMap(new Position(tp), 3, Color.RED, false);
    		} */
    	}
    }
    
    
    
    
    
    
    
    
    
    
    
	//special place for turrets
    public TilePosition placeTurret(UnitType buildingtype, Collection<TilePosition> additional_ban){
    	//sync states...
    	Set<TilePosition> all_inbase_tiles = myBaseTiles();
    	int k = all_inbase_tiles.size();
    	Set<TilePosition> banned_tiles = banTiles(all_inbase_tiles);
    	/*for (TilePosition ban : banned_tiles){
    		Game.getInstance().drawCircleMap(new Position(ban), 2, Color.RED, true);
    	}*/
    	//get rid of banned, preliminary, and additionally banned
    	Set<TilePosition> after_ban1 = new HashSet<TilePosition>();
    	for (TilePosition tp : all_inbase_tiles){
    		boolean _ban = false;
    		if (banned_tiles.contains(tp)) _ban = true;
    		if (additional_ban.contains(tp)) _ban = true;
    		/*for (TilePosition tp_ban : banned_tiles){
    			if (tp.equals(tp_ban)) _ban = true;
    		}
    		for (TilePosition tp_ban_additional : additional_ban){
    			if (tp.equals(tp_ban_additional)) _ban = true;
    		}*/
    		if (!_ban) after_ban1.add(tp);
    	}
    	//get rid of more based on building type... for collision
    	Set<TilePosition> after_ban2 = new HashSet<TilePosition>();
    	for (TilePosition tp1 : after_ban1){
    		if (!filter_out_via_type(tp1, buildingtype, banned_tiles)) after_ban2.add(tp1);
    	}
    	
    	Set<TilePosition> after_ban3 = new HashSet<TilePosition>();
    	
    	List<TilePosition> turrets = new ArrayList<TilePosition>();
    	for (BuildingStatus bs : master.myBuildings) {
    		if (bs.type == UnitType.TERRAN_MISSILE_TURRET && bs.status != BuildingStatus.DEAD) {
    			turrets.add(bs.spot);
    		}
    	}

    	outer:
    	for (TilePosition tp2 : after_ban2) {
    		for (TilePosition turr : turrets) {
    			if (turr.getDistance(tp2) < 6) {
    				continue outer;
    			}
    		}
    		after_ban3.add(tp2);
    	}

    	if (after_ban3.size() == 0) {
    		after_ban3 = new HashSet<TilePosition>();
    		outer: 
    			for (TilePosition tp2 : after_ban2) {
    				for (TilePosition turr : turrets) {
    					if (turr.getDistance(tp2) < 3) {
    						continue outer;
    					}
    					after_ban3.add(tp2);
    				}
    			}
    	}
    	
    	if (after_ban3.size() == 0) {
    		after_ban3 = after_ban2;
    	}
    	/*for (TilePosition ban : after_ban2){
    		Game.getInstance().drawCircleMap(new Position(ban), 2, Color.GREEN, true);
    	}*/
    	//now from the set of available points pick a closest one
    	if (after_ban3.size() == 0){
    		if (growsThisFrame == 0) { 
    			grow();
    			growsThisFrame++;
    			return place(buildingtype, additional_ban);
    		}
    		else {
    	    	growsThisFrame = 0;
    			Game.getInstance().printf("UH OH... no spot to build");
    			return TilePosition.INVALID;
    		}
    	}
    	growsThisFrame = 0;
    	return find_closest_squared(after_ban3, get_building_buffer());
    }
    
}
