package undermind.intelligence;

import java.util.ArrayList;
import java.util.List;

import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;

public class RegionStatus {
	public Region region;
	public int age;
	public List<ROUnit> enemies;
	public Game mGame;
	
	
	public RegionStatus(Region r) {
		region = r;
		age = 0;
		enemies = new ArrayList<ROUnit>();
		mGame = Game.getInstance();
	}
	
	
	public void addUnit(ROUnit u) {
		if (!enemies.contains(u)) 
			enemies.add(u);
	}
	
	public void removeUnit(ROUnit u) {
		ROUnit tr = null;
		for (ROUnit u2 : enemies) {
			if (u.getID() == u2.getID()) 
				tr = u2;
		}
		
		if (tr != null)
			enemies.remove(tr);
	}
	
	public void updateUnits() {
		ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
		for (ROUnit u : enemies) {
			if (mGame.isVisible(u.getLastKnownTilePosition()) && !u.isVisible()) {
				tr.add(u);
			}
		}
		enemies.removeAll(tr);
	}

}
