package undermind.intelligence;

import java.util.List;
import java.util.ArrayList;
import java.util.Collection;

import org.bwapi.proxy.model.TilePosition;

public class IntelligenceUtil {
	
	//attack_path is a path from our natural to their natural, say.
	//bases is a collection of bases, do not include main, as main is always covered by natural anyways
	//cap is tunable parameter, having cap to 0.5 means we compute the best spot up to halfway on the atk path
	public static TilePosition get_defend_position(List<TilePosition> attack_path, Collection<TilePosition> bases){
		double cap = 0.5;
		TilePosition ret = null;
		double best = Integer.MAX_VALUE;
		for (int i = 0; i < (int) attack_path.size() * cap; i++){
			TilePosition cand = attack_path.get(i);
			double cand_val = get_squared_dist(cand, bases);
			if (cand_val < best){
				best = cand_val;
				ret = cand;
			}
		}
		return ret;
	}

	private static double get_squared_dist(TilePosition cand,
			Collection<TilePosition> bases) {
		double ret = 0;
		for (TilePosition tps : bases){
			ret += tps.getDistance(cand)*tps.getDistance(cand);
		}
		return ret;
	}
}
