package undermind.intelligence;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.UnitType;

import undermind.GameEvaluator;
import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;

public class IntelManager extends AbstractCerebrate {
	public Random rgen = new Random();
	public Game mGame;
	public Player me;
	public Bwta bwta;
	public List<RegionStatus> regions;
	public List<Hotspot> hotspots;
	public List<BaseStatus> baseStatuses;
	public GameEvaluator master;
	
	public IntelManager(GameEvaluator m) {
		master = m;
		baseStatuses = new ArrayList<BaseStatus>();

	}

	@Override
	public void onFrame() {
		super.onFrame();
		
		for (RegionStatus rs : regions) {
			rs.age++;
			rs.updateUnits();
			if (mGame.isVisible(new TilePosition(rs.region.getCenter()))) 
				rs.age = 0;
			
			for (ROUnit u : rs.enemies) {
				mGame.drawTextMap(u.getLastKnownPosition(), u.getType().toString());
			}
		}
		
		computeHotspots();
		computeBaseStatus();
		
		for (BaseStatus bs : baseStatuses) {
			mGame.drawTextMap(bs.base.getPosition(), "" + bs.taken);
		}
		
		
	}

	@Override
	public void onStart() {
		super.onStart();
		mGame = Game.getInstance();
		me = mGame.self();
		bwta = Bwta.getInstance();
		regions = new ArrayList<RegionStatus>();
		hotspots = new ArrayList<Hotspot>();
		
		for (Region r : bwta.getRegions()) {
			regions.add(new RegionStatus(r));
			
		
		}
		
		
		for (BaseLocation bl : bwta.getBaseLocations()) {
			baseStatuses.add(new BaseStatus(bl));
		}
		
	}

	@Override
	public void onUnitDestroy(ROUnit unit) {
		super.onUnitDestroy(unit);
		if (unit.getPlayer() == me)
			return;
		for (RegionStatus rs : regions) {
			rs.removeUnit(unit);
		}
	}

	@Override
	public void onUnitShow(ROUnit unit) {
		super.onUnitShow(unit);
		if (unit.getPlayer().isEnemy(me)) {
			for (RegionStatus rs : regions) {
				if (rs.region.contains(unit.getPosition())) {
					//discard workers, nonvisible flyers, non_attacking buildings
					if (unit.getType().isWorker()) break;
					if (!unit.isVisible() && unit.isFlying()) break;
					if (!unit.getType().canAttack() && !unit.getType().equals(UnitType.TERRAN_BUNKER) && !unit.getType().isSpellcaster()) break;
					rs.addUnit(unit);
					break;
				}
			}
			
		}
	}
	
	
	public void computeHotspots() {
		/* Clear old hotspots */
		hotspots.clear();
		for (RegionStatus rs : regions) {
			if (rs.enemies.size() < 5)
				continue;
			
			Hotspot h = new Hotspot(UnitUtils.medianPos(rs.enemies), Utils.getValueRO(rs.enemies));
			h.region_status = rs;
			hotspots.add(h);
		}
	}
	
	public void computeBaseStatus() {
		for (BaseStatus bs : baseStatuses) {
			if (mGame.isVisible(bs.base.getTilePosition())) {
				bs.age = 0;
				bs.taken = 0;
				for (ROUnit u : mGame.unitsOnTile(bs.base.getTilePosition())) {
					if (u.getType().isResourceDepot()) {
						if (u.getPlayer() == me)
							bs.taken = 1;
						else if (u.getPlayer().isEnemy(me))
							bs.taken = -1;
					}
				}
			}
			else {
				bs.age++;
			}
			for (ROUnit u : master.myMicro.enemyBuildings) {
				if ((u.getType() == UnitType.TERRAN_BUNKER || u.getType().canAttack()) && u.getLastKnownPosition().getDistance(bs.base.getPosition()) < 500)
					bs.taken = -1;
			}
		}
	}
	
	public BaseLocation oldestBase() {
		int oldest = -1;
		BaseLocation ret = null;
		
		for (BaseStatus bs : baseStatuses) {
			if (mGame.getMapHash().equals("83320e505f35c65324e93510ce2eafbaa71c9aa1")) {

				int x = bs.base.getTilePosition().x();
				int y = bs.base.getTilePosition().y();
				
				if ((x == 7 && y == 7) || (x == 117 && y == 7) || (x == 117 && y == 118) || (x == 7 && y == 118))
					continue;
			}
			if (bs.age > oldest && !bs.base.isIsland() && bs.taken == 0) {
				oldest = bs.age;
				ret = bs.base;
			}
		}
		
		return ret;
	}
	
	public TilePosition possibleEnemyExpo() {
		if (master.myMacro.enemyBases.size() == 0) return null;
		List<TilePosition> candidates = new ArrayList<TilePosition>();
		
		for (BaseStatus bs : baseStatuses) {
			if (bs.age > 4000 && bs.taken == 0 && !mGame.isVisible(bs.base.getTilePosition()))
				candidates.add(bs.base.getTilePosition());
		}
		
		
		TilePosition chosenbase = master.myMacro.enemyBases.get(rgen.nextInt(master.myMacro.enemyBases.size())).getLastKnownTilePosition();
		
		TilePosition best = null;
		double bestd = Double.POSITIVE_INFINITY;
		for (TilePosition tp : candidates) {
			double d = tp.getDistance(chosenbase);
			if (d < bestd) {
				bestd = d;
				best = tp;
			}
		}
		
		return best;
		
		
	}
	
	public BaseLocation oldestBaseWithIslands() {
		int oldest = -1;
		BaseLocation ret = null;
		
		for (BaseStatus bs : baseStatuses) {
			if (bs.age > oldest && bs.taken == 0) {
				oldest = bs.age;
				ret = bs.base;
			}
		}
		
		return ret;
	}

	
	
}
