package undermind.intelligence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;

import edu.berkeley.nlp.starcraft.util.UnitUtils;

import undermind.AStarSearch;
import undermind.MicroManager;

public class Convoy {
	public AStarSearch pathfinder = new AStarSearch();;
	public List<TilePosition> pathToGoal;
	public Set<ROUnit> enemies = new HashSet<ROUnit>();
	public TilePosition lastEnd;
	
	//start should be our base, end however, should be the forward most squad's location, NOT the final 
	//goal location
	public void setConvoy(Position start, Position end){
		TilePosition s = new TilePosition(start);
		TilePosition t = new TilePosition(end);
		lastEnd = new TilePosition(end);
		pathToGoal = pathfinder.getPath(s, t);
		//enemies = migrate(pathToGoal, enemies);
	}
	
	public void register(ROUnit rou){
		Position p = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
		double dist = getClosest(new TilePosition(p),pathToGoal);
		if (dist < 12) enemies.add(rou);
	}
	
	public double getClosest(TilePosition tp, Collection<TilePosition> tps){
		double dist = Integer.MAX_VALUE;
		for (TilePosition tp2 : tps){
			if (tp.getDistance(tp2) < dist) dist = tp.getDistance(tp2);
		}
		return dist;
	}
	
	private Set<ROUnit> migrate(List<TilePosition> pathToGoal2,
			Set<ROUnit> old_enemies) {
		for (ROUnit rou : old_enemies){
			register(rou);
		}
		return null;
	}

	public void addUnit(ROUnit u) {
		if (!enemies.contains(u)) 
			enemies.add(u);
	}
	
	public void removeUnit(ROUnit u) {
		ROUnit tr = null;
		for (ROUnit u2 : enemies) {
			if (u.getID() == u2.getID()) 
				tr = u2;
		}
		
		if (tr != null)
			enemies.remove(tr);
	}
	
	public void updateUnits() {
		ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
		for (ROUnit u : enemies) {
			if (Game.getInstance().isVisible(u.getLastKnownTilePosition()) && !u.isVisible()) {
				tr.add(u);
			}
		}
		enemies.removeAll(tr);
	}
	
	public void onFrame(){
		updateUnits();
	}
}
