package undermind;

import org.bwapi.proxy.model.*;

public class WorkerStatus {
    public enum WorkerState{
        NONE,
        BUILDING,
        MINING,
        SCOUTING,
        REFINING,
        FIGHTING
    }
    private WorkerState state;
    public Unit unit;
    public ROUnit target;
    public int idleCycles = 0;
    private int lastStatusChange = 0;
    private String goodCaller = "";
    public WorkerStatus(Unit u) {
    	unit = u;
    	state = WorkerState.NONE;
    }
    
    public WorkerState getState() {
        return state;
    }

    public void setState(WorkerState state) {
        this.state = state;
    }
    
    public Position getPosition(){
        return unit.getPosition();
    }
    public TilePosition getTilePosition(){
        return unit.getTilePosition();
    }
    public int getID(){
        return unit.getID();
    }
}
