package undermind;

import java.util.ArrayList;
import java.util.List;

import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;

import undermind.micropacket.DefensiveSquad;
import undermind.micropacket.Squad;

public class ScoutingManager {
	public List<Unit> scouts = new ArrayList<Unit>();
	public MicroManager master;
	public BaseLocation nextBL;
	long time = 0;
	long lastDeath = 0;
	public AStarSearch pathfinder = new AStarSearch();
	
	public ScoutingManager(MicroManager m) {
		master = m;
	}
	
	public void onFrame() {
		time++;
		if (nextBL != null) master.mGame.drawTextMap(nextBL.getPosition(), "scout next");
		
		
		if (scouts.size() == 0 && master.allArmy.size() > 16 && master.time % 500 < 3 && (time-lastDeath > 5000))
			newScout();
		
		doScouting();
	}
	
	public void doScouting() {
		for (Unit s : scouts) {
			if (master.time % 5 != 0)
				return;
			master.mGame.drawCircleMap(s.getPosition(), 12, Color.PURPLE, false);
			ROUnit harassTarget = null;
			for (ROUnit e : master.allVisibleEnemies) {
				if (e.getType().isBuilding() && harassTarget == null)
					harassTarget = e;
				else if (e.getDistance(s) < 200 && (e.getType().isWorker() || (e.getType() == UnitType.ZERG_OVERLORD && s.getType() == UnitType.TERRAN_MARINE)))
					harassTarget = e;
				else if (e.getDistance(s) < 300 && e.getType().canAttack() && !e.getType().isWorker()) {
					harassTarget = null;
					break;
				}
			}
			
			boolean mine = true;
			if (master.posseexp != null && master.posseexp != TilePosition.INVALID) {
				for (ROUnit u : master.mGame.unitsOnTile(master.posseexp)) {
					if (u.getType().isBuilding())
						mine = false;
				}
			}
			
			if (master.posseexp != null && master.posseexp != TilePosition.INVALID && master.posseexp.getDistance(s.getTilePosition()) < 7 && s.getType() == UnitType.TERRAN_VULTURE && s.getSpiderMineCount() != 0 && mine) {
				s.useTech(TechType.SPIDER_MINES, Position.centerOfTile(master.posseexp));
			}
			
			else if (harassTarget != null) {	
				if (master.time % 50 == 0)
					s.attack(harassTarget);
			}
			else pathfinder.makeUnitPath(s, nextBL.getTilePosition());
		}
	}
	
	
	
	public void newScout() {
		System.out.println("got new scout");
		int a = -1;
		for (int i = master.allArmy.size() - 1; i >= 0; i--) {
			Unit u = master.allArmy.get(i);
			if (u.getType() == UnitType.TERRAN_MARINE ||  u.getType() == UnitType.TERRAN_VULTURE) {
				
				for (Squad s : master.squads) {
					s.removeUnit(u);	
				}
				for (DefensiveSquad ds : master.dSquads) {
					ds.removeUnit(u);
				}
				scouts.add(u);
				a = i;
				break;
			}
		}
		if (a != -1) master.allArmy.remove(a);
	}
	
	
	public void removeScout(ROUnit s) {
		Unit tr = null;
		for (Unit sc : scouts) {
			if (s.getID() == sc.getID()) {
				tr = sc;
			}
		}
		if (tr != null) {
			scouts.remove(tr);
			lastDeath = time;
		}
	}

}
