package undermind;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.WeaponType;
import org.bwapi.proxy.util.Pair;

import undermind.intelligence.Hotspot;
import undermind.intelligence.RegionStatus;
import undermind.micropacket.DefensiveSquad;
import undermind.micropacket.DropSquad;
import undermind.micropacket.DroppedUnits;
import undermind.micropacket.M3chSquad;
import undermind.micropacket.MarineSquad;
import undermind.micropacket.Squad;
import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;

public class MicroManager extends AbstractCerebrate implements Strategy {
	
	
	public double confidence;
	public boolean lurkers;
	public UnitType dropType = UnitType.TERRAN_VULTURE;
	public int dropQuantity = 4;
	public List<Unit> freeGuys = new ArrayList<Unit>();
	public TilePosition suggestedDropSpot = null;
	public List<Unit> idleDropships = new ArrayList<Unit>();
	public Set<ROUnit> reinforcementThreat;
	public Position pleaseEbayHere;
	ScoutingManager scouter;
	public boolean mechStrat;
    public ArrayList<ROUnit> unitsBeingCreated = new ArrayList<ROUnit>();
	final List<ROUnit> armyList = new ArrayList<ROUnit>();
	List<Unit> allArmy = new ArrayList<Unit>(); 
	public final List<ROUnit> allVisibleEnemies = new ArrayList<ROUnit>();
	public final List<ROUnit> enemyBuildings;
	final List<Unit> wraiths = new ArrayList<Unit>();
	final List<Unit> vessels = new ArrayList<Unit>();
	final ArrayList<Squad> squads = new ArrayList<Squad>();
	final ArrayList<DefensiveSquad> dSquads = new ArrayList<DefensiveSquad>();
	public Game mGame;
	public boolean debug;
	Unit dbldg;
	
	public int boccs = 0;
	public TilePosition posseexp;
	public boolean retreating = false;
	public List<DropSquad> droppers = new ArrayList<DropSquad>();
	public DropSearch dropSearch;
	public boolean fightWithTurret = false;
	public int attackersValue;
	public Unit ebay;
	public int ebaytargetted = 30;
	public int ebayoldhp;
	private Player me;
	public Position medianpos;
	Position focalPoint;
	Position defensiveFocalPoint;
	Random rgen = new Random();
	boolean defend = false;
	double defendDistance = 800;
	boolean aird;
	public long time;

	public boolean stolegas = false;
	public Hotspot hotspot;
	public List<RegionStatus> regionStatuses;
	Position dposition;
	public Position pleaseScanHere;
	int defensivesiege;
	int failsafe = 0;
	int whenattack = 30; // What army size is the minimum required to attack?
	int wao = whenattack; // Original value of whenattack, since it can be changed.


	public Unit myBunker = null;

	@Override
	public List<Cerebrate> getTopLevelCerebrates() {
		return null;
	}

	public MicroManager() {
		enemyBuildings = new ArrayList<ROUnit>();
		scouter = new ScoutingManager(this);
		dropSearch = new DropSearch(this);
	}

	@Override
	public void onFrame() {
		
		
		
		if (boccs >= 2 && time % 100 == 0) {
			for (ROUnit bunk : UnitUtils.getAllMy(UnitType.TERRAN_BUNKER)) {
				for (ROUnit mar : bunk.getLoadedUnits()) {
					assignSquad(UnitUtils.assumeControl(mar));
				}
				UnitUtils.assumeControl(bunk).unloadAll();
			}
		}
		
		
		
		//if (defensiveFocalPoint != Position.INVALID && focalPoint != Position.INVALID) 
			//dropSearch.drawPath(dropSearch.getPath(new TilePosition(defensiveFocalPoint), new TilePosition(focalPoint))); 
		if (hotspot != null && hotspot.pos != null) mGame.drawCircleMap(hotspot.pos, 10, Color.YELLOW, false);
		
        ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
        for (ROUnit u : unitsBeingCreated) {
        	if (u.isCompleted()) {
        		this.onUnitSpawn(u);
        		tr.add(u);
        	}
        }
        
        for (ROUnit removeMe : tr) {
        	unitsBeingCreated.remove(removeMe);
        }
		
		
		if (debug) {
			for (DefensiveSquad ds : dSquads) {
				mGame.drawCircleMap(ds.goal, 8, Color.YELLOW, true);
			}
			
			for (int i = 0; i < squads.size(); i++) {
				mGame.drawTextScreen(0, 100+i*15, squads.get(i).myUnits.toString());
			}
			for (int i = 0; i < dSquads.size(); i++) {
				mGame.drawTextScreen(0, 200+i*15, dSquads.get(i).myUnits.toString());
			}
			
		}
		
		squadManagement();
		setupDrops();
		time++; 
		
		if (debug && dposition != null) {
			mGame.drawTextMap(dposition, "dpos");
		}

		bookkeeping();
		computeMedianPosition();
		setParameters();
		scouter.onFrame();

		/* If there is no place to send the army (eg, no visible enemy buildings or anything),
		 * scatter all across the map until an enemy is found.
		 */
		if (focalPoint == null || focalPoint.x() == -1) {
			failsafe++;
			for (Unit u : allArmy) {
				if (u.isSieged())
					u.unsiege();
				if (failsafe > 1000)
					u.stop();
				else if ((u.getTargetPosition().equals(focalPoint) || u
						.isStopped())) {
					failsafe = 0;
					int x = rgen.nextInt(mGame.getMapWidth() * 32);
					int y = rgen.nextInt(mGame.getMapHeight() * 32);
					u.move(new Position(x, y));
					if (UnitUtils.getClosestDistance(u, allArmy) > 300)
						pleaseScanHere = new Position(x, y);
				}

			}
		}



		else {
			for (Unit u : allArmy) {
				Unit unit = u;
				ROUnit closestEnemy = UnitUtils.getClosest(unit,
						allVisibleEnemies);
				if (closestEnemy != null
						&& (!closestEnemy.isDetected())) {
					pleaseScanHere = closestEnemy.getPosition();
				}

			}
		}

		
		/* Defensive reactions */

		attackersValue = 0;
		aird = false;


		
		if (dbldg == null || dbldg.getLastKnownPosition().x() == -1) {
			DefensiveSquad removeMe = null;
			for (DefensiveSquad ds : dSquads) {
				ROUnit closestE = UnitUtils.getClosest(ds.goal, allVisibleEnemies);
				if (closestE == null || closestE.getDistance(ds.goal) > 300) {
					removeMe = ds;
				}
			}
			
			if (removeMe != null) {
				for (Unit u : removeMe.myUnits) {
					assignSquad(u);
				}
				dSquads.remove(removeMe);			
			}
		} else if (allArmy.size() != 0) {
			dposition = dbldg.getLastKnownPosition();
			DefensiveSquad defendingSquad = null;
			

			int count = 0;
			fightWithTurret = false;
			
			double airValue = 0;
			double stealthValue = 0;
			/* Assess attacking army value */
			for (ROUnit u : allVisibleEnemies) {
				if (u.getDistance(dposition) < 450) {
					count++;
					if (u.getType() == UnitType.ZERG_MUTALISK) {
						attackersValue += 150;
						airValue += 150;
					}
					else {
						if (u.getType().isFlyer() && u.getType().canAttack()) {
							airValue += u.getType().mineralPrice();
							airValue += u.getType().gasPrice() * 2;
						}
						if (u.isCloaked() && u.getType().canAttack()) {
							stealthValue += u.getType().mineralPrice();
							stealthValue += u.getType().gasPrice() * 2;
						}
						
						attackersValue += u.getType().mineralPrice();
						attackersValue += u.getType().gasPrice() * 2;
						
						if (dbldg.getType() == UnitType.TERRAN_COMMAND_CENTER) {
							attackersValue += 250;
						}
					}
				}
				if ((u.getType().canAttack() || u.getType().isSpellcaster()) && u.getType().isFlyer())
					aird = true;
				if ((stealthValue >= attackersValue/3.0 && UnitUtils.getAllMy(UnitType.TERRAN_COMSAT_STATION).size() == 0))
					fightWithTurret = true;
			}
			
			List<ROUnit> turrets = UnitUtils.getAllMy(UnitType.TERRAN_MISSILE_TURRET);
			if (turrets.size() != 0 && fightWithTurret) {
				dbldg = UnitUtils.assumeControl(UnitUtils.getClosest(dposition, turrets));
				dposition = dbldg.getLastKnownPosition();
			}
			
			/* this is horrible code gl hf */
			for (DefensiveSquad ds : dSquads) {
				ROUnit closestE = UnitUtils.getClosest(ds.goal, allVisibleEnemies);
				if (closestE == null || closestE.getDistance(ds.goal) > 300) {
					ds.setGoal(dposition);
				}
			}
			
			for (DefensiveSquad ds : dSquads) {			
				if (ds.goal.equals(dposition) || dposition.getDistance(ds.goal) < 450) {
					defendingSquad = ds;
					defendingSquad.setGoal(dposition);
					break;
				}
			}
			if (defendingSquad == null) {
				System.out.println("new defensive squad");
				defendingSquad = new DefensiveSquad(this, dposition);
				dSquads.add(defendingSquad);
			}

			for (int i = allArmy.size() - 1; i >= 0; i--) {
				boolean skip = false;
				int dValue = 0;
				Unit unit = allArmy.get(i);
				if (unit.getDistance(defendingSquad.goal) > 800)
					skip = true;
				for (DefensiveSquad ds : dSquads) {
					if (ds.hasUnit(unit)) {
						skip = true;
					}
					dValue += getValue(ds.myUnits);
				}
				if ((count > 8 && dValue  >= 1.3*attackersValue) || (count <= 8 && (defendingSquad.myUnits.size() >= 16 || getValue(defendingSquad.myUnits) >= 600)))
					break;
				if (skip || unit.isLoaded() || defendingSquad.hasUnit(unit) || unit.getDistance(dposition) > 1200 || (unit.getType().airWeapon().equals(WeaponType.NONE) && airValue >= attackersValue * 0.85))
					continue;
				defendingSquad.addUnit(unit);
				/* Remove from regular squads */
				for (Squad s : squads) {
					s.removeUnit(unit);
				}
			}
		}


		long starttime = System.currentTimeMillis();
		/* Do the actual micro for defending */
		for (DefensiveSquad ds : dSquads) {
			ds.onFrame();
		}

		//System.out.println("micro took " + (System.currentTimeMillis()-starttime));
		//TODO: uncomment this haha
		ebayMicro();


	}
	
	
	/* set important values (eg, siege range) */
	public void setParameters() {
		List<Unit> nearHotspot = new ArrayList<Unit>();
		for (Unit u : allArmy) {
			if (u.getDistance(hotspot.pos) < 700)
				nearHotspot.add(u);
		}
	}

	public void ebayMicro() {
		ebaytargetted--;
		
		if (ebay != null) {
			if (ebay.getTargetPosition() != null) 
				mGame.drawLineMap(ebay.getPosition(), ebay.getTargetPosition(), Color.WHITE);
			if (ebay.isLifted() && hotspot != null && hotspot.pos != Position.INVALID) {
				Position pos = Position.INVALID;
				for (Squad s : squads) {
					if (s.unitTypes.contains(UnitType.TERRAN_SIEGE_TANK_TANK_MODE) && s.locked && s.myUnits.size() > 1) {
						pos = UnitUtils.medianPos(s.myUnits);
						break;
					}
				}
				if (pos == Position.INVALID) {
					for (Squad s : squads) {
						if (s.unitTypes.contains(UnitType.TERRAN_SIEGE_TANK_TANK_MODE) && s.myUnits.size() > 1) {
							pos = UnitUtils.medianPos(s.myUnits);
							break;
						}
					}

				}
				
				if (pos == Position.INVALID) 
					ebay.move(defensiveFocalPoint);
				else {
					
	                for (ROUnit un : allVisibleEnemies) {
	                        if ((un.getTarget() != null && un.getTarget().getID() == ebay.getID()) || (un.getOrderTarget() != null && un.getOrderTarget().getID() == ebay.getID())
	                        		|| ebayoldhp > ebay.getHitPoints()+2)
	                            ebaytargetted = 30;
	                    }

					if (ebay.getDistance(pos) > 400 || ebaytargetted > 0)
						ebay.move(pos);
					else {
						Position target = Position.midPoint(new Pair<Position,Position>(pos,hotspot.pos));
						if (pleaseEbayHere != null && pleaseEbayHere != Position.INVALID)
							target = pleaseEbayHere;
						ebay.move(target);
					}
					

				}
					
			} else if ((allArmy.size() >= 5 || ebay.getHitPoints() < 450) && UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE).size() > 2 && mechStrat)
				ebay.lift();
			
			ebayoldhp = ebay.getHitPoints();
		}
	}
	
	public void squadManagement() {
		long starttime = System.currentTimeMillis();
		DropSquad r = null;
		for (DropSquad d : droppers) {
			if ((d.beenfull && d.squad.size() == 0) || d.droptime > 3000) {
				r = d;
				break;
			}
		}
		
		if (r != null) {
			droppers.remove(r);
		}
		
		Squad tr = null;
		for (Squad s : squads) {
			if (s.locked && s.myUnits.size() == 0)
				tr = s;
		}
		if (tr != null)
			squads.remove(tr);
		
		Squad tr2 = null;
		
		for (Squad s : dSquads) {
			if (s.locked && s.myUnits.size() == 0)
				tr2 = s;
		}
		
		if (tr2 != null)
			dSquads.remove(tr2);
		
		/* Bunker up if needed */
		if (time % 10 == 0 && !stolegas && boccs < 2) {

			for (ROUnit bunker : UnitUtils.getAllMy(UnitType.TERRAN_BUNKER)) {
				if (bunker.getLoadedUnits().size() != 4 && bunker.isCompleted()) {
					int alreadyGoing = 0;
					for (Unit u : allArmy) {
						if ((u.getTarget() != null && u.getTarget().getID() == bunker.getID()) ||  (u.getOrderTarget() != null && u.getOrderTarget().getID() == bunker.getID()))
							alreadyGoing++;
					}			
					if (alreadyGoing < 4-bunker.getLoadedUnits().size()) {
					
						for (Squad s : squads) {
							boolean gotMarine = false;
							if (!s.acceptsType(UnitType.TERRAN_MARINE))
								continue;
							for (Unit u : s.myUnits) {
								if (u.getType() == UnitType.TERRAN_MARINE && u.isCompleted() && !u.isLoaded()) {
									u.load(bunker);
									s.removeUnit(u);
									gotMarine = true;
									break;
								}
							}
							if (gotMarine)
								break;
						}
					}
				}
			}
		}
		
		
		
		/* Merge squads */
		for (int a = 0; a < squads.size(); a++) {
			for (int b = 0; b < squads.size(); b++) {
				if (a >= squads.size() || b >= squads.size()) continue;
				Squad s1 = squads.get(a);
				Squad s2 = squads.get(b);
				
				Position m1 = UnitUtils.medianPos(s1.myUnits);
				Position m2 = UnitUtils.medianPos(s2.myUnits);
				if (s1 != s2 && m1 != null && m2 != null && m1 != Position.INVALID && m2 != Position.INVALID && m1.getDistance(m2) < 300 && s1.type.equals(s2.type) && s1.size() + s2.size() < 50)
					merge(a,b);
			}
			
		}
		
		
		
		/* Run squad orders */
		if (time % 3 == 0) for (Squad s : squads) {
			if (!s.locked && dbldg != null && dbldg.getLastKnownTilePosition().x() != -1) {
				s.setGoal(dbldg.getLastKnownPosition());
			}
			else {
				int k = 0;
				if (focalPoint != null && focalPoint != Position.INVALID && s.locked) { 
					s.setGoal(Utils.nearestWalkablePosition(new TilePosition(focalPoint)));
				
					mGame.drawTextMap(focalPoint, "FOCAL");
				}
				else if (defensiveFocalPoint != null) s.setGoal(Utils.nearestWalkablePosition(new TilePosition(defensiveFocalPoint)));
			}
			s.onFrame();
		}
		
		for (DropSquad d : droppers) {
			d.onFrame();
		}

		
		/* Lock squads as needed. Do this after everything to avoid tiny squads. */
		for (int i = 0; i < squads.size(); i++) {
			Squad s = squads.get(i);
			if (s.locked == false && shouldLock(i)) {
				s.locked = true;
				System.out.println("locked squad " + i);
			}
		}
		//mGame.printf("that took " + (System.currentTimeMillis() - starttime));
	}
	
	
	public void assignSquad(Unit u) {
		boolean added = false;
		UnitType type = u.getType();
		for (int i = 0; i < squads.size(); i++) {
			Squad s = squads.get(i);
			if (s.acceptsType(type) && (u.getType() != UnitType.TERRAN_SIEGE_TANK_TANK_MODE || s.type.equals("mech"))) {
				s.addUnit(u);
				added = true;
				break;
			}
		}
		if (!added) {
			System.out.println("new O squad");
			if (type == UnitType.TERRAN_MARINE || type == UnitType.TERRAN_MEDIC || ((type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE || type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) && lurkers)) {
				MarineSquad ms = new MarineSquad(this);
				ms.addUnit(u);
				squads.add(ms);
			}
			else if ((type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE ||
					type == UnitType.TERRAN_GOLIATH || type == UnitType.TERRAN_VULTURE) && mechStrat) {
				M3chSquad ms = new M3chSquad(this);
				ms.addUnit(u);
				squads.add(ms);
			}
			if (type == UnitType.TERRAN_SCIENCE_VESSEL) {
				if (mechStrat) {
					M3chSquad ms = new M3chSquad(this);
					ms.addUnit(u);
					squads.add(ms);
				}
				else {
					MarineSquad ms = new MarineSquad(this);
					ms.addUnit(u);
					squads.add(ms);
				}
				
				
			}
		}
	}

	@Override
	public void onStart() {
		super.onStart();
		mGame = Game.getInstance();
		me = mGame.self();
		

	}

	@Override
	public void onUnitCreate(ROUnit unit) {
		if (unit == null) return;
		if (unit.getType() == null) return;
		super.onUnitCreate(unit);
	}
	
	
	

	@Override
	public void onUnitRenegade(ROUnit unit) {
		if (unit == null) return;
		if (unit.getType() == null) return;
		super.onUnitRenegade(unit);
		onUnitDestroy(unit);
	}

	@Override
	public void onUnitDestroy(ROUnit unit) {
		if (unit == null) return;
		if (unit.getType() == null) return;
		super.onUnitDestroy(unit);
		UnitType t = unit.getType();
		Unit tr = null;
		if (t == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || t == UnitType.TERRAN_SIEGE_TANK_TANK_MODE
				|| t == UnitType.TERRAN_VULTURE || t == UnitType.TERRAN_MARINE
				|| t == UnitType.TERRAN_GOLIATH || t == UnitType.TERRAN_MEDIC
				|| t == UnitType.TERRAN_SCIENCE_VESSEL) {
			for (Unit u : allArmy) {
				if (unit.getID() == u.getID()) {
					tr = u;
					break;
				}
			}
			
			scouter.removeScout(unit);
			for (DropSquad d : droppers) {
				Unit rem = null;
				for (Unit u : d.squad.myUnits) {
					if (u.getID() == unit.getID()) {
						rem = u;
						break;
					}
				}
					
				if (rem != null) d.squad.removeUnit(rem);
			}
		}
		if (tr != null) {
			allArmy.remove(tr);
			armyList.remove(tr);
			for (Squad s : squads) {
				s.removeUnit(tr);	
			}
			for (DefensiveSquad ds : dSquads) {
				ds.removeUnit(tr);
			}

		}


		if (t == UnitType.TERRAN_WRAITH && unit.getPlayer() == me) {
			Unit toRem = null;
			for (Unit s : wraiths) {
				if (s.getID() == unit.getID()) {
					toRem = s;
				}
			}
			if (toRem != null)
				wraiths.remove(toRem);
		}

		if (t == UnitType.TERRAN_SCIENCE_VESSEL && unit.getPlayer() == me) {
			Unit toRem = null;
			for (Unit s : vessels) {
				if (s.getID() == unit.getID()) {
					toRem = s;
				}
			}
			if (toRem != null)
				vessels.remove(toRem);
		}
		
		if (unit.getPlayer() == me && t == UnitType.TERRAN_DROPSHIP) {
			DropSquad r = null;
			for (DropSquad d : droppers) {
				if (d.dropship.getID() == unit.getID()) {
					r = d;
					break;
				}
			}
			
			if (r != null) {
				droppers.remove(r);
			}
			
			Unit deaddrop = null;
			for (Unit d : idleDropships) {
				if (d.getID() == unit.getID()) {
					deaddrop = d;
					break;
				}
			}
			
			if (deaddrop != null)
				idleDropships.remove(deaddrop);
		}
		
		if (t == UnitType.TERRAN_ENGINEERING_BAY && unit.getPlayer() == me && ebay != null && unit.getID() == ebay.getID())
			ebay = null;
		if (unit.getPlayer() != me) {
			for (ROUnit u : allVisibleEnemies) {
				if (unit.getID() == u.getID()) {
					allVisibleEnemies.remove(u);
					break;
				}
			}
			for (ROUnit u : enemyBuildings) {
				if (unit.getID() == u.getID()) {
					enemyBuildings.remove(u);
					break;
				}
			}

		}

	}

	@Override
	public void onUnitHide(ROUnit unit) {
		if (unit == null) return;
		if (unit.getType() == null) return;
		UnitType t = unit.getType();
		if (unit.getPlayer() != me && t.canAttack()) {
			allVisibleEnemies.remove(unit);
		}
		
	}

	@Override
	public void onUnitMorph(ROUnit unit) {
		if (unit == null) return;
		if (unit.getType() == null) return;
		UnitType t = unit.getType();
		if (unit.getPlayer() != me && t.isBuilding()
				&& !enemyBuildings.contains(unit) && !t.isNeutral() && t != UnitType.SPECIAL_PROTOSS_TEMPLE) {
			enemyBuildings.add(unit);
		}
	}

	@Override
	public void onUnitShow(ROUnit unit) {
		if (unit == null) return;
		if (unit.getType() == null) return;
        if(unit.getPlayer().equals(me)){
            unitsBeingCreated.add(unit);
        }
		UnitType t = unit.getType();
		if (unit.getPlayer() == me && t == UnitType.TERRAN_BUNKER) {
			myBunker = UnitUtils.assumeControl(unit);
		}


		if (unit.getPlayer() != me
				&& (t.canAttack() || (t == UnitType.PROTOSS_SHUTTLE || t == UnitType.TERRAN_DROPSHIP) || (t.isSpellcaster() && !t.isBuilding()) || (t == UnitType.TERRAN_BUNKER))) {
			boolean a = true;
			for (ROUnit u : allVisibleEnemies) {
				if (u.getID() == unit.getID())
					a = false;
			}
			if (a)
				allVisibleEnemies.add(unit);
		}
		if (unit.getPlayer() != me && t.isBuilding()
				&& !enemyBuildings.contains(unit) && !t.isNeutral() && t != UnitType.SPECIAL_PROTOSS_TEMPLE) {
			enemyBuildings.add(unit);
		}
		if (unit.getPlayer() == me && t == UnitType.TERRAN_WRAITH) {
			wraiths.add(UnitUtils.assumeControl(unit));
		}
		if (unit.getPlayer() == me && t == UnitType.TERRAN_SCIENCE_VESSEL) {
			vessels.add(UnitUtils.assumeControl(unit));
		}


	}

	

	public void onUnitSpawn(ROUnit unit) {
		if (unit == null) return;
		if (unit.getType() == null) return;
		UnitType t = unit.getType();
		if (unit.getPlayer() == me
				&& (t == UnitType.TERRAN_SIEGE_TANK_TANK_MODE
						|| t == UnitType.TERRAN_VULTURE
						|| t == UnitType.TERRAN_MARINE || t == UnitType.TERRAN_GOLIATH || t == UnitType.TERRAN_MEDIC 
						|| t == UnitType.TERRAN_SCIENCE_VESSEL)) {
			Unit u = UnitUtils.assumeControl(unit);
			allArmy.add(u);
			armyList.add(unit);

			assignSquad(u);
		}
		
		if (unit.getPlayer() == me && t == UnitType.TERRAN_DROPSHIP) {
			idleDropships.add(UnitUtils.assumeControl(unit));
			
		}
		
		if (unit.getPlayer() == me && t == UnitType.TERRAN_ENGINEERING_BAY && (ebay == null || ebay.getPosition().x() != -1)) {
			ebay = UnitUtils.assumeControl(unit);
		}
	}

	/* Data structure / variable management to be done on each frame */
	public void bookkeeping() {
		/* Siege tank bookkeeping */
		defensivesiege--;
		if (allVisibleEnemies.size() <= 3) {
			if (defensivesiege <= -100)
				defensivesiege = 400;
		}


		/* (Sloppy) Bookkeeping for visible enemies */
		ROUnit tre = null;
		for (ROUnit u : allVisibleEnemies) {
			if (u.getPosition().x() == -1) {
				tre = u;
				break;
			}
		}
		if (tre != null)
			allVisibleEnemies.remove(tre);



		/* Special bookeeping because vespene geysers are a pain */
		ROUnit tr2 = null;
		for (ROUnit u : enemyBuildings) {
			if (u.getType() == UnitType.RESOURCE_VESPENE_GEYSER) {
				tr2 = u;
				break;
			}
		}
		if (tr2 != null)
			enemyBuildings.remove(tr2);


			
			
		/* A precaution to make sure we don't keep dead units around */
		Unit removeMe = null;
		failsafe = 0;
		for (Unit u : allArmy) {
			Position p = u.getPosition();
			if (p.x() == -1)
				removeMe = u;
		}
		if (removeMe != null)
			allArmy.remove(removeMe);
			
			
			
		

		/* Don't count buildings that have disappeared (eg, got lifted off, burned down, etc. while we had no vision) */
		List<ROUnit> toRemove = new ArrayList<ROUnit>();
		for (ROUnit b : enemyBuildings) {
			if (mGame.isVisible(new TilePosition(b.getLastKnownPosition()))
					&& b.getPosition().x() == -1) {
				toRemove.add(b);
			}
		}
		for (ROUnit u : toRemove) {
			enemyBuildings.remove(u);
		}

	}


	/* Set up the median position of the army, this is usually pretty useful. 
	 * We don't count loaded units (bunkers, drops) for the purposes of median.
	 */
	public void computeMedianPosition() {
		medianpos = null;
		ArrayList<Unit> alist = new ArrayList<Unit>();

		for (Unit u : allArmy) {
			if (debug)
				mGame.drawTextMap(u.getPosition(), u.getID() + "");
			for (int i = 0; i < squads.size(); i ++) {
				Squad s = squads.get(i);
				if (s.myUnits.contains(u)) {
					if (s.locked) mGame.drawCircleMap(u.getPosition(), 3, Color.RED, false);
					else mGame.drawCircleMap(u.getPosition(), 3, Color.GREEN, false);
					mGame.drawTextMap(u.getPosition(), i+ "");
				}
			}
				
			if (!u.isLoaded())
				alist.add(u);
		}
		if (alist.size() > 1) {
			medianpos = UnitUtils.medianPos(alist);
		}
		if (focalPoint != null && debug)
			mGame.drawCircleMap(focalPoint, 5, Color.GREEN, true);

		/* Don't use the actual median position if there are too few units */
		int spec = 0;
		for (Unit uz : allArmy) {
			if (uz.getType() == UnitType.TERRAN_MARINE && uz.isLoaded())
				continue;
			else
				spec++;
		}
		if (spec < 2)
			medianpos = Position.centerOfTile(mGame.self().getStartLocation());

	}





	/* Various utilities, mainly unit targetting priorities */

	public int getPriority(ROUnit u, Unit me, boolean harass) {
		UnitType t = u.getType();
		int bonus = 0;
		if (u.getHitPoints() < u.getType().maxHitPoints() / 2)
			bonus = 1;
		if (harass) {
			if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE
					|| t == UnitType.PROTOSS_PROBE
					|| t == UnitType.PROTOSS_OBSERVER)
				return 10;
			return 2 + bonus;
		}

		if (t == UnitType.PROTOSS_INTERCEPTOR)
			return -10;

		if (t == UnitType.ZERG_SPORE_COLONY
				|| t == UnitType.PROTOSS_PHOTON_CANNON
				|| t == UnitType.TERRAN_BUNKER
				|| t == UnitType.TERRAN_MISSILE_TURRET)
			return -1;
		if (t.isFlyer()) {
			if (t.canAttack())
				return 8 + bonus;
			else
				return 5 + bonus;
		}
		if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE
				|| t == UnitType.PROTOSS_PROBE)
			return 2 + bonus;

		if (u.canAttack(me))
			return 4 + bonus;
		if (t.canAttack() || t.isSpellcaster())
			return 2 + bonus;
		return 0;
	}

	public int getGPriority(ROUnit u, Unit me, boolean harass) { // Priorities for goliaths
		int bonus = 0;
			bonus += 1.0/(u.getHitPoints()+2);
		UnitType t = u.getType();
		if (harass) {
			if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE
					|| t == UnitType.PROTOSS_PROBE)
				return 1;
			return 0 + bonus;
		}

		if (t == UnitType.PROTOSS_INTERCEPTOR)
			return -10;

		if (t == UnitType.ZERG_SUNKEN_COLONY
				|| t == UnitType.PROTOSS_PHOTON_CANNON
				|| t == UnitType.TERRAN_BUNKER
				|| t == UnitType.TERRAN_MISSILE_TURRET)
			return 1 + bonus;
		if (t.isFlyer()) {
			if (t.canAttack())
				return 8 + bonus;
			else
				return 5 + bonus;
		}
		if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE
				|| t == UnitType.PROTOSS_PROBE)
			return 2;

		if (u.canAttack(me))
			return 4 + bonus;
		if (t.canAttack() || t.isSpellcaster())
			return 2 + bonus;
		if (t.isBuilding())
			return 1;
		return 0 + bonus;
	}

	public double getValue(List<Unit> army) {
		int minval = 1; // fudge factor for division by 0
		int gasval = 0;
		for (Unit e : army) {
			minval += e.getType().mineralPrice();
			gasval += e.getType().gasPrice();
		}
		return minval + gasval * 2;
	}
	
	public void setHotspot(Hotspot h) {
		hotspot = h;
	}
	
	public void setFocal(Position p) {
		focalPoint = p;
	}
	
	public void setDFocal(Position p) {
		defensiveFocalPoint = p;
	}
	
	public void setDbldg(Unit d) {
		dbldg = d;
	}
	
	public void merge(int a, int b) {
		if (a > b) {
			int temp = b;
			b = a;
			a = temp;
		}
		
		System.out.println("Merging squad " + a + " and " + b);
		Squad s1 = squads.get(a);
		Squad s2 = squads.get(b);
		
		Squad newSquad;
		if (s1.type == "mech") {
			newSquad = new M3chSquad(this);
		}
		else {
			newSquad = new MarineSquad(this);
		}
		
		for (Unit u : s1.myUnits) {
			newSquad.addUnit(u);
			
		}
		s1.myUnits.clear();
		for (Unit u : s2.myUnits) {
			newSquad.addUnit(u);
		}
		s2.myUnits.clear();

		squads.remove(s1);
		squads.remove(s2);
		
		squads.add(a, newSquad);
		if (shouldLock(a))
			newSquad.locked = true;
		
	}
	
	
	public boolean shouldLock(int a) {
		Squad s = squads.get(a);
		boolean first = false;
		for (int i = 0; i < squads.size(); i ++) {
			if (s.type.equals(squads.get(i).type) && i < a)
				break;
			if (i == a) {
				first = true;
				break;
			}				
		}
		
		
		if (mechStrat && s.type.equals("bio")) {
			return s.myUnits.size() > Squad.lockThreshold+10;
		}
		
		if (first && (!mechStrat || !s.type.equals("bio"))) {
			return s.myUnits.size() >= Squad.lockThreshold;
		}
		else {
			long starttime = System.currentTimeMillis();
			
			
			if (s.myUnits.size() >= Squad.lockThreshold)
				return true;
			
			int totvalue = 0;
			int aavalue = 0;
			
			int enemyvalue = 0;
			int enemyairvalue = 0;
			
			Iterator<ROUnit> eit = reinforcementThreat.iterator();
			while (eit.hasNext()) {
				ROUnit enemy = eit.next();
				enemyvalue += enemy.getType().mineralPrice();
				enemyvalue += 2*enemy.getType().gasPrice();
				if (enemy.getType().isFlyer()) {
					enemyairvalue += enemy.getType().mineralPrice();
					enemyairvalue += 2*enemy.getType().gasPrice();
				}
				
			}
			boolean hasTank = false ;
			for (Unit u : s.myUnits) {
				if (u.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || u.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE)
					hasTank = true;
				totvalue += u.getType().mineralPrice();
				totvalue += 2*u.getType().gasPrice();
				if (u.getType() == UnitType.TERRAN_MARINE || u.getType() == UnitType.TERRAN_GOLIATH || (u.getType().isFlyer() && u.getType().canAttack())) {
					aavalue += u.getType().mineralPrice();
					aavalue += 2*u.getType().gasPrice();
				}
				
					
			}
			if (s.myUnits.size() > 13)
				hasTank = true;

			//mGame.printf("that took " + (System.currentTimeMillis() - starttime));
			if (!hasTank && !mechStrat) return false;
			
			
			int limit = 0;
			if (s.myUnits.size() < 5 && s.type.equals("bio"))
				limit = 5;
			return s.myUnits.size() > limit && (totvalue >= enemyvalue *0.8 && aavalue >= enemyairvalue * 0.8);
		}
	}
	
	
	public void setupDrops() {
		ArrayList<Unit> rem = new ArrayList<Unit>();
		for (Unit u : freeGuys) {
			if (u.isLoaded())
				rem.add(u);
			else if (u.isSieged())
				u.unsiege();
			else if (idleDropships.size() != 0) u.rightClick(idleDropships.get(0));
		}
		
		freeGuys.removeAll(rem);
				
		if (suggestedDropSpot == null) return;
		
		if (dropType == UnitType.TERRAN_VULTURE) dropQuantity = 4;
		if (dropType == UnitType.TERRAN_MARINE) dropQuantity = 8;
		if (dropType == UnitType.TERRAN_SIEGE_TANK_TANK_MODE || dropType == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) dropQuantity = 2;
		
		int medics = 0;
		List<Unit> tr = new ArrayList<Unit>();
		for (Unit dship : idleDropships) {
			Squad s = null;
			if (timeToDrop()) {
				List<Unit> expendables = new ArrayList<Unit>();
				for (int i = allArmy.size() - 1; i >= 0; i--) {
					if (expendables.size() >= dropQuantity)
						break;
					Unit u = allArmy.get(i);
					if (u.isLoaded()) 
						continue;
					if (u.getType() == dropType || (u.getType() == UnitType.TERRAN_MEDIC && dropType == UnitType.TERRAN_MARINE && medics < 2)) {
						expendables.add(u);
						if (u.getType() == UnitType.TERRAN_MEDIC) medics++;
					}
					
				}
				
				if (expendables.size() == dropQuantity) {
					allArmy.removeAll(expendables);
					s = new DroppedUnits(this, dship);
					for (Unit u : expendables) {
						freeGuys.add(u);
						s.addUnit(u);
						for (Squad sq : squads) {
							sq.removeUnit(u);
						}
						for (Squad sq : dSquads) {
							sq.removeUnit(u);
						}
						u.rightClick(dship);
						
					}
				}
			}
				
			if (s != null) {
				TilePosition dropGoal = suggestedDropSpot;
				
				DropSquad d = new DropSquad(dship, this, s);
				d.dropsize = dropQuantity;
				d.setDropSpot(dropGoal);
				s.setGoal(Position.centerOfTile(dropGoal));
				droppers.add(d);
				tr.add(dship);
			}
		}
		
		idleDropships.removeAll(tr);
	
		
		
		
	}
	
	public boolean timeToDrop() {
		int locked = 0;
		for (Squad s : squads) {
			if (s.locked && !retreating) {
				locked += s.myUnits.size();
			}
		}
		
		
		return allArmy.size() > 25 || locked > 15;
	}
	
	
	/* Should the squad force-flee (ie, just move without attacking enemies), 
	 * or act as normal (standing and fighting if necessary)? */
	public boolean shouldforceFlee(List<Unit> squad) {
		
		double ourValue = getValue(squad);
		double enemyValue = 0;
		double enemyMobileValue = 0;
		double staticValue = 0;
		
		Position p = UnitUtils.medianPos(squad);
		if (p == Position.INVALID) return false;
		for (ROUnit u : allVisibleEnemies) {
			if (u.getDistance(p) < 600 && u.getType().canAttack()) {
				enemyValue += u.getType().mineralPrice();
				enemyValue += 2*u.getType().gasPrice();
				if (u.getType().topSpeed() > 1.2*UnitType.TERRAN_MEDIC.topSpeed()) {
					enemyMobileValue += u.getType().mineralPrice();
					enemyMobileValue += 2*u.getType().gasPrice();
				}
			}
		}
		for (ROUnit u : enemyBuildings) {
			if (u.getDistance(p) < 500) {
				if (u.getType().canAttack() || u.getType() == UnitType.TERRAN_BUNKER)
					staticValue += 200;
			}
		}
		
		if (!retreating) return false; // Don't flee if you're not retreating..
		else if (staticValue > 0) // If we're retreating and near towers, run!
			return true;
		else if (enemyMobileValue > 0.5*ourValue) // If the enemy is faster than us, can't retreat -- fight to the death if necessary!
			return false;
		else if (enemyValue > 1.3*ourValue) // The enemy is slow and bulky... this would be a good time to walk away.
			return true;
		else return false;
		
	}
	


}
