package undermind;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;

import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.WeaponType;

import undermind.intelligence.Convoy;
import undermind.intelligence.Hotspot;
import undermind.intelligence.IntelManager;
import undermind.intelligence.IntelligenceUtil;
import undermind.intelligence.RegionStatus;
import undermind.macro.BuildingStatus;
import undermind.macro.MacroManager;
import undermind.micropacket.GoliathSquad;
import undermind.micropacket.Squad;
import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;

public class GameEvaluator extends AbstractCerebrate implements Strategy {
	
	public boolean needTanks;
    public ArrayList<ROUnit> unitsBeingCreated = new ArrayList<ROUnit>();
	public int oldExpoHP = 0;
	static final int TERRAN_MAXSQUAD = 13;
	static final int PROTOSS_MAXSQUAD = 22;
	static final int ZERG_MAXSQUAD = 20;
	public List<TilePosition> attackpath;
	public double confidence = 1;
	final double RETREAT_PROPORTION = 0.7;
	final double ATTACK_PROPORTION = 1.1;
	public boolean retreating = false;
	public Position previousFocal;
	Convoy myConvoy;
	public int defenseMemory;
	public IntelManager myIntel;
	Bwta myBwta = Bwta.getInstance();
	Set<BaseLocation> bases = myBwta.getBaseLocations() ;
	public Random rgenerator =  new Random();
	public int mostRecentAttack = 1000000;
	public Unit mostRecentDBldg;
	public boolean mechStrat;
	public MacroManager myMacro;
	public MicroManager myMicro;
	public int workersKilled;
	public int workersLost;
	private Player me;
	private Player enemy;
	public Game mGame;
	public List<ROUnit> enemyBuildings;
	List<EnemyUnitStatus> knownEnemies;
	List<ROUnit> myArmy;
	boolean heavyAir = false;
	public double producedArmy;
	public double valueKilled;
	boolean needAA;
	double AAproportion;
	
	boolean needAS;
	double ASproportion;
	
	boolean earlyRush;
	boolean rushindicator;
	
	boolean gasStolen;
	public ROUnit stealingRefinery;
	
	boolean FE;
	boolean feindicator;
	
	long time = 0;
	long lastReaction = -100000;
	
	int dropswanted;
	
	public GameEvaluator(MacroManager b, MicroManager m) {
		workersKilled = 0;
		workersLost = 0;
		myMacro = b;
		myMicro = m;
		enemyBuildings = myMicro.enemyBuildings;
		knownEnemies = new ArrayList<EnemyUnitStatus>();
		myArmy = new ArrayList<ROUnit>();
		dropswanted = 1;
		myConvoy = new Convoy();
	}
	
	public void onStart() {
		mGame = Game.getInstance();
		me = mGame.self();
		Set<Player> players = mGame.getPlayers();
		for (Player p : players) {
			if (p.isEnemy(me)) {
				enemy = p;
				break;
			}
		}
		mechStrat = enemy.getRace() != Race.ZERG;
		myMacro.mech = mechStrat;
		

	}
	
	@Override
	public void onUnitRenegade(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
		super.onUnitRenegade(unit);
		onUnitDestroy(unit);
	}
	
	public void onUnitSpawn(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
		if (unit.getPlayer() == me && !unit.getType().isWorker() && !unit.getType().isBuilding() && (unit.getType().canAttack() || unit.getType().isSpellcaster() || unit.getType() == UnitType.TERRAN_DROPSHIP)){
			myArmy.add(unit);
			producedArmy += unit.getType().mineralPrice();
			producedArmy += unit.getType().gasPrice() * 2;
		}
	}
	
	public void onUnitShow(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
        if(unit.getPlayer().equals(me)){
            unitsBeingCreated.add(unit);
        }
		
		if (unit.getPlayer() != me && !unit.getType().isWorker() && (unit.getType().canAttack() || (unit.getType().isSpellcaster() && !unit.getType().isBuilding()))){
			for (EnemyUnitStatus u : knownEnemies) {
				if (u.unit.getID() == unit.getID() || unit.getType() == UnitType.PROTOSS_INTERCEPTOR) return;
			}
			if (myConvoy.pathToGoal != null) myConvoy.register(unit);
			knownEnemies.add(new EnemyUnitStatus(unit));
		}
		
		if (!gasStolen && time < 4000 && unit.getPlayer() != me && (unit.getType() == UnitType.ZERG_EXTRACTOR || unit.getType() == UnitType.TERRAN_REFINERY || unit.getType() == UnitType.PROTOSS_ASSIMILATOR)
				&& unit.getLastKnownPosition().getDistance(Position.centerOfTile(myMacro.myHome)) < 12*32) {
			gasStolen = true;
			stealingRefinery = unit;
		}
		

		
	}
	
	
	public void onFrame() {
		if (enemy.getRace() == Race.PROTOSS && heavyAir) {
			GoliathSquad.acquisitionBonus = 100;
		}
		mGame.drawTextScreen(0, 100, "squadlock: " + computeLockThreshold());
		long starttime = System.currentTimeMillis();
		time++;
		
		

        ArrayList<ROUnit> tr = new ArrayList<ROUnit>();
        for (ROUnit u : unitsBeingCreated) {
        	if (u.isCompleted()) {
        		this.onUnitSpawn(u);
        		tr.add(u);
        	}
        }
        
        for (ROUnit removeMe : tr) {
        	unitsBeingCreated.remove(removeMe);
        }
		
		if ((time % 300 == 0 || attackpath == null) && myMacro.enemyBases.size() != 0) {
			attackpath = myMacro.pathfinder.getPath(new TilePosition(myMacro.natChoke.getCenter()),
					new TilePosition(previousFocal));
		}

		mGame.drawTextScreen(0,250, "Confidence : " + confidence);
		
		/* convoy setup*/
		for (Squad s : myMicro.squads) {
			if (s.locked && s.myUnits.size() > 1 && time % 100 == 0 && myConvoy.lastEnd != new TilePosition(UnitUtils.medianPos(s.myUnits))) {
				myConvoy.setConvoy(Position.centerOfTile(myMacro.myHome), UnitUtils.medianPos(s.myUnits));
			}
		}

		
		myConvoy.updateUnits();

		if (earlyRush) rushindicator = true;
		if (FE) feindicator = true;
		
		
		int airunits = 0;
		for (EnemyUnitStatus u : knownEnemies) {
			if (u.unit.isFlying() && u.unit.getType().canAttack()) {
				airunits++;
			}
		}
		if (airunits > 1 || hehastech(UnitType.ZERG_SPIRE) || hehastech(UnitType.TERRAN_STARPORT) || hehastech(UnitType.PROTOSS_FLEET_BEACON) || hehastech(UnitType.PROTOSS_ARBITER_TRIBUNAL) || hehastech(UnitType.PROTOSS_STARGATE)
				|| hehasunit(UnitType.PROTOSS_SHUTTLE) || hehasunit(UnitType.PROTOSS_REAVER)) needAA = true;
		
		if (!heavyAir && (hehastech(UnitType.ZERG_GREATER_SPIRE) || hehastech(UnitType.TERRAN_PHYSICS_LAB) || hehastech(UnitType.PROTOSS_FLEET_BEACON) || hehasunit(UnitType.TERRAN_BATTLECRUISER) || hehasunit(UnitType.ZERG_GUARDIAN)|| hehasunit(UnitType.PROTOSS_CARRIER) )) {
			heavyAir = true;
			mGame.printf("Tier 3 air detected");
			myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
			myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
			myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
			myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
			needAA = true;
		}
		if (hehastech(UnitType.PROTOSS_TEMPLAR_ARCHIVES) || hehastech(UnitType.PROTOSS_CITADEL_OF_ADUN) || hehastech(UnitType.TERRAN_COVERT_OPS) || hehastech(UnitType.TERRAN_CONTROL_TOWER) || hehastech(UnitType.TERRAN_NUCLEAR_SILO) || hehasunit(UnitType.PROTOSS_DARK_TEMPLAR) || hehasunit(UnitType.ZERG_LURKER) || hehasunit(UnitType.TERRAN_GHOST) || hehasunit(UnitType.TERRAN_WRAITH)) needAS = true;
		
		if (!earlyRush && time < 4800 && (enemyCount(UnitType.TERRAN_COMMAND_CENTER) >= 2 || enemyCount(UnitType.ZERG_HATCHERY) >= 2 || enemyCount(UnitType.PROTOSS_NEXUS) >= 2 || staticgroundd() > 1)) {
			FE = true;
		}

		if (time < 9000 && defenseNeeded() != 0) {
			earlyRush = true;
		}
		
		if (time < 5000 && enemyCount(UnitType.PROTOSS_ZEALOT) >= 2) {
			earlyRush = true;
		}
		
		if (time < 4000 && enemyCount(UnitType.PROTOSS_ZEALOT) >= 1) {
			earlyRush = true;
		}
		
		
		if (!FE && time < 4800 && (enemyCount(UnitType.TERRAN_BARRACKS) >=2 ||  enemyCount(UnitType.PROTOSS_GATEWAY) >=2 || getValue(knownEnemies,false) > 400)) {
			earlyRush = true;
		}
		if (!FE && time < 4000 && (hehascompletedtech(UnitType.ZERG_SPAWNING_POOL))) earlyRush = true;
		if (!FE && time < 4800 && myMicro.defend) earlyRush = true;

		

		if (myMacro.debug) {
		mGame.drawTextScreen(5,0, "AP: " + airproportion(knownEnemies));
		mGame.drawTextScreen(5, 40, "enemy bldgs " + myMicro.enemyBuildings);
		mGame.drawTextScreen(5, 60, "enemy units " + knownEnemies.toString());
		mGame.drawTextScreen(5, 80, "Evaluation: " + evaluate());
		mGame.drawTextScreen(5, 90, "A Evaluation: " + armyEval());
		mGame.drawTextScreen(300,0, "Frame: " + time); 
		

		mGame.drawTextScreen(500, 20, "Gas Stolen: " + gasStolen);
		mGame.drawTextScreen(500, 30, "Early rush: " + rushindicator);
		mGame.drawTextScreen(500, 90, "Early expand: " + feindicator);
		mGame.drawTextScreen(500, 50, "Possible Stealth: " + needAS);
		mGame.drawTextScreen(500, 60, "Possible Air: " + needAA);
		
		}
		
		
		ArrayList<EnemyUnitStatus> toRemove = new ArrayList<EnemyUnitStatus>();
		
		
		double airvalue = 0;
		for (EnemyUnitStatus u : knownEnemies) {
			u.age++;
			if (u.age >= 10000) toRemove.add(u);
			
			
			UnitType type = u.unit.getType();
			if (type.isFlyer() && type.canAttack()) {
				airvalue += type.mineralPrice();
				airvalue += type.gasPrice();
			}
			
			
		}
		
		if (myBldgCount(UnitType.TERRAN_MISSILE_TURRET) < 10 && myBldgCount(UnitType.TERRAN_MISSILE_TURRET) < airvalue/700.0 && time % 800 == 0) {
			myMacro.BOInject(UnitType.TERRAN_MISSILE_TURRET);
		}
		
		for (EnemyUnitStatus u : toRemove) {
			knownEnemies.remove(u);
		}
		//mGame.printf("eval took " + (System.currentTimeMillis() - starttime));
		updateConfidence();
	}
	

	
	public List<Cerebrate> getTopLevelCerebrates() {
		return null;
	}
	
	

	
	@Override
	public void onUnitDestroy(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
		if (unit.getType().isWorker()) {
			if (unit.getPlayer() == me) {
				workersLost++;
			}
			else {
				workersKilled++;
			}
		}

		if (unit.getPlayer() != me && !unit.getType().isWorker() && (unit.getType().canAttack() || unit.getType().isSpellcaster())) {
			int i = 0;
			while (i != knownEnemies.size()) {
				if (unit.getID() == knownEnemies.get(i).unit.getID()) {
					knownEnemies.remove(i);
					i = 0;
					continue;
				}
				else i++;
			}
			
			valueKilled += unit.getType().gasPrice() * 2;
			valueKilled += unit.getType().mineralPrice();

		}
		
		if (unit.getPlayer() == me && !unit.getType().isWorker() && (unit.getType().canAttack() || unit.getType().isSpellcaster() || unit.getType() == UnitType.TERRAN_DROPSHIP)) {
			int i = 0;
			while (i != myArmy.size()) {
				if (unit.getID() == myArmy.get(i).getID()) {
					myArmy.remove(i);
					i = 0;
					continue;
				}
				else i++;
			}
		}
		
		if (gasStolen && unit.getPlayer() != me && (unit.getType() == UnitType.ZERG_EXTRACTOR || unit.getType() == UnitType.TERRAN_REFINERY || unit.getType() == UnitType.PROTOSS_ASSIMILATOR)
				&& unit.getLastKnownPosition().getDistance(Position.centerOfTile(myMacro.myHome)) < 12*32) {
			gasStolen = false;
			stealingRefinery = null;
		}

	}




	@Override
	public void onUnitMorph(ROUnit unit) {
		if (unit == null) return;

		if (unit.getType() == null) return;
		if (time < 4000 && unit.getPlayer() != me && (unit.getType() == UnitType.ZERG_EXTRACTOR || unit.getType() == UnitType.TERRAN_REFINERY || unit.getType() == UnitType.PROTOSS_ASSIMILATOR)
				&& unit.getLastKnownPosition().getDistance(Position.centerOfTile(myMacro.myHome)) < 12*32) {
			gasStolen = true;
			stealingRefinery = unit;
			
		}
	}




	public double evaluate() {
		
		double myBases = myMacro.myCCs.size();
		double enemyBases = 0;
		
		for (ROUnit e : enemyBuildings) {
			if (isMainBldg(e)) {
				enemyBases++;
				if (e.getType() == UnitType.ZERG_HATCHERY) enemyBases -= 0.25;
			}
		}
		
		double baseAdvantage = 0;
		if (myBases >= enemyBases+1) {
			baseAdvantage = 0.5;
		}
		else if (myBases <= enemyBases-1) {
			baseAdvantage = -0.5;
		}
		
		
		double workerAdvantage = (workersKilled - workersLost)/(workersKilled+20.0);
		if (workerAdvantage < 0 && workerAdvantage < -1) {
			workerAdvantage = -1;
		}
		if (workerAdvantage > 0 && workerAdvantage > 1) {
			workerAdvantage = 1;
		}
		if (workersKilled <= 3 && workersLost <= 3) {
			workerAdvantage = 0;
		}
		
		return workerAdvantage+baseAdvantage+(getValueRO(myArmy) - getValue(knownEnemies, false))/(getValueRO(myArmy));
	}
	

	
	/* Interaction with dispatcher */
	
	/* Determine the base build order we're using (basically, bio or mech) */
	public List<UnitType> initialBuildOrder() {
		ArrayList<UnitType> BO = new ArrayList<UnitType>();
		
		if (!mechStrat) {
	        BO.add(UnitType.TERRAN_COMMAND_CENTER);
	        BO.add(UnitType.TERRAN_BARRACKS); 
	        BO.add(UnitType.TERRAN_BARRACKS);
	        BO.add(UnitType.TERRAN_ACADEMY);
	        BO.add(UnitType.TERRAN_BARRACKS);
	        BO.add(UnitType.TERRAN_ENGINEERING_BAY);
	        BO.add(UnitType.TERRAN_BARRACKS); 
	        BO.add(UnitType.TERRAN_BARRACKS);
            BO.add(UnitType.TERRAN_FACTORY);//TODO: This is just so I can test dropships
            BO.add(UnitType.TERRAN_STARPORT);
            BO.add(UnitType.TERRAN_SCIENCE_FACILITY);
	        BO.add(UnitType.TERRAN_BARRACKS);
	        BO.add(UnitType.TERRAN_ENGINEERING_BAY);
	        BO.add(UnitType.TERRAN_BARRACKS);
	        BO.add(UnitType.TERRAN_BARRACKS);
		}
		else {
			if (enemy.getRace() == Race.TERRAN) {
				BO.add(UnitType.TERRAN_COMMAND_CENTER);
				BO.add(UnitType.TERRAN_BARRACKS);
				BO.add(UnitType.TERRAN_FACTORY); 
				BO.add(UnitType.TERRAN_FACTORY);


				//BO.add(UnitType.TERRAN_STARPORT);
				BO.add(UnitType.TERRAN_FACTORY);
				BO.add(UnitType.TERRAN_ENGINEERING_BAY);
				BO.add(UnitType.TERRAN_ACADEMY); 
				BO.add(UnitType.TERRAN_MISSILE_TURRET);
				BO.add(UnitType.TERRAN_ARMORY);
				BO.add(UnitType.TERRAN_FACTORY); 
				BO.add(UnitType.TERRAN_STARPORT);
				BO.add(UnitType.TERRAN_FACTORY);
				BO.add(UnitType.TERRAN_SCIENCE_FACILITY);
				BO.add(UnitType.TERRAN_ARMORY); 
				BO.add(UnitType.TERRAN_FACTORY); 
				BO.add(UnitType.TERRAN_FACTORY); 
			}
			else {
				BO.add(UnitType.TERRAN_COMMAND_CENTER);
				BO.add(UnitType.TERRAN_BARRACKS);
				BO.add(UnitType.TERRAN_FACTORY);
				BO.add(UnitType.TERRAN_FACTORY);
				BO.add(UnitType.TERRAN_BUNKER);

				BO.add(UnitType.TERRAN_ENGINEERING_BAY);

				BO.add(UnitType.TERRAN_MISSILE_TURRET);
				BO.add(UnitType.TERRAN_MISSILE_TURRET);
				BO.add(UnitType.TERRAN_ACADEMY); 
				BO.add(UnitType.TERRAN_FACTORY);
				BO.add(UnitType.TERRAN_ARMORY);
				BO.add(UnitType.TERRAN_MISSILE_TURRET);
				BO.add(UnitType.TERRAN_FACTORY);
				BO.add(UnitType.TERRAN_STARPORT);
				BO.add(UnitType.TERRAN_FACTORY);
				BO.add(UnitType.TERRAN_FACTORY);
				BO.add(UnitType.TERRAN_SCIENCE_FACILITY);
				BO.add(UnitType.TERRAN_ARMORY); 
				BO.add(UnitType.TERRAN_FACTORY); 
				BO.add(UnitType.TERRAN_FACTORY); 
			}

		} 
		
		return BO;
	}
	
	/* Evaluates unit priorities... shared with macromanager, slightly breaches our abstraction */
	public void setProductionPriorities() {
        myMacro.unitPriorities.clear();
        if (!mechStrat) {
        	myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_MARINE, 1));
        	myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_MEDIC, 4 * UnitUtils.getAllMy(UnitType.TERRAN_MEDIC).size() / (UnitUtils.getAllMy(UnitType.TERRAN_MARINE).size() + 1)));
            if(myMacro.ihavetech(UnitType.TERRAN_CONTROL_TOWER) && needMoreDrops()){
                myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_DROPSHIP, 1));
            }
            if (needTanks()) 
            	myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_SIEGE_TANK_TANK_MODE, 2));
        }
        else {
        	int mcu = myCountUnloaded(UnitType.TERRAN_MARINE);
			if (mcu < 2 
        			|| (!ihavetech(UnitType.TERRAN_ARMORY) && mcu < 6 && needAA)
        			|| (gasStolen && mcu < 12)
        			|| (myMacro.mins > 700 && mcu < 15)) myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_MARINE, 2));
        	if (mcu > 5 && myCountUnloaded(UnitType.TERRAN_MEDIC) < mcu/4.0 && time > 23000) 
        		myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_MEDIC, 2));
        	
        	double goliaths = UnitUtils.getAllMy(UnitType.TERRAN_GOLIATH).size();
        	double tanks = UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE).size() + UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_TANK_MODE).size();
        	
        	double k = goliaths / (goliaths + tanks);
            if(myMacro.ihavetech(UnitType.TERRAN_CONTROL_TOWER) && needMoreDrops()){
                myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_DROPSHIP, 1));
            }
        	if (k < airproportion(knownEnemies) && ihavetech(UnitType.TERRAN_ARMORY)) {
            	myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_GOLIATH, 1));
        	}
        	else {
            	myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_SIEGE_TANK_TANK_MODE, 1));
        	}
        	
        	if (recommendVultures() || myMacro.gas < 80) myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_VULTURE, 3));
        	

        }

    	if (myMacro.gas > 200 && (!mechStrat || needAS) && UnitUtils.getAllMy(UnitType.TERRAN_SCIENCE_VESSEL).size() < 5) {
    		myMacro.unitPriorities.add(new ValuedUnitType(UnitType.TERRAN_SCIENCE_VESSEL, 3));
    	}
	}

    /**
     * @return whether you need more drops
     */
	public boolean needMoreDrops() {
		return (myMicro.droppers.size() + myMicro.idleDropships.size()) < dropswanted && !retreating;
	}
	
	
	/** @return a position to scan (for scouting), or invalid if it's not time to scan */
    public Position scanPos() {
    	TilePosition possexp = myIntel.possibleEnemyExpo();
    	if (possexp != null) mGame.drawTextMap(new Position(possexp), "POSSEXP");
    	
    	int energyToScan = 115;
    	if (!needAS && getValueES(knownEnemies) < 1000 && myMacro.myCCs.size() > 1)
    		energyToScan = 90;
    	
		for (BuildingStatus b : myMacro.myBuildings) {
			if (b.status == BuildingStatus.BUILT && b.type == UnitType.TERRAN_COMSAT_STATION) {
				if (b.myUnit.getEnergy() > energyToScan && (myMacro.enemyBases.size() != 0 || myMicro.enemyBuildings.size() != 0)) {
					int r1 = rgenerator.nextInt(3);
					if (myMacro.enemyBases.size() != 0 && r1 == 0) {
						int r = rgenerator.nextInt(myMacro.enemyBases.size());
						if (myMacro.enemyBases.get(r).getPosition().x() == -1)
							return myMacro.enemyBases.get(r).getLastKnownPosition();
					}

					else if (myMicro.enemyBuildings.size() != 0 && r1 == 1) {
						return myMicro.enemyBuildings.get(rgenerator.nextInt(myMicro.enemyBuildings.size())).getLastKnownPosition();
					}
					else if (possexp != null) {
						return new Position(possexp);
					}
				
					

				}
				else if (b.myUnit.getEnergy() > 105 && (myMacro.enemyBases.size() == 0 && myMicro.enemyBuildings.size() == 0)) {
					return myIntel.oldestBase().getPosition();
				}
			}
		}
		
		return Position.INVALID;
    }
	

	public void orderdrops(int more) {
		dropswanted += more;
	}
	
	
	public double airproportion(List<EnemyUnitStatus> army) {
		double totval = 1;
		double airval = 1;
		for (EnemyUnitStatus en : army) {
			ROUnit e = en.unit;
			totval += e.getType().mineralPrice();
			totval += 2*e.getType().gasPrice();
			if (e.getType().isFlyer()) {
				airval += e.getType().mineralPrice();
				airval += 2*e.getType().gasPrice();
				if (e.getType() == UnitType.TERRAN_SCIENCE_VESSEL || e.getType().groundWeapon() == WeaponType.NONE) {
					airval -= e.getType().gasPrice();
					totval -= e.getType().gasPrice();
				}
			}
		}
		if (totval < 2000) {
			if (heavyAir) return 0.35; 
			return 0.2;
		}
		double r = airval/totval;
		if (r > 0.8) return 0.8;
		if (heavyAir && r < 0.5) return 0.5; 
		if (r > 0.2) return r;
		else return 0.2;

	}
	
	public int defenseNeeded() {
		
		if (time % 200 == 0) defenseMemory = 0;
		/* Detecting when we have to defend with SCVs vs. early cheese.
		 * Returns the number of scvs we should pull (0 means no extra defense needed) */
		int defense = 0;
		
		Region baseRegion = null;
		for (Region r : myBwta.getRegions()) {
			if (r.contains(myMacro.myHome)) {
				baseRegion = r;
				break;
			}
		}

		if (myMicro.allArmy.size() > 15) return 0;
		
		double aval = 0;
		double enemyval = 0;
		for (Unit u : myMicro.allArmy) {
			if (u.isLoaded() || !u.isCompleted())
				continue;
			else {
				aval += u.getType().mineralPrice();
				aval += 1.5*u.getType().gasPrice();
			}
			
		}
		
		
		if (aval < 1500) {
			int w = 0;
			for (ROUnit u : mGame.getAllUnits()) {
				if (!u.isVisible() || !u.getPlayer().isEnemy(me))
					continue;
				
				
				double bunkdist = Double.POSITIVE_INFINITY;
				for (ROUnit bunk : UnitUtils.getAllMy(UnitType.TERRAN_BUNKER)) {
					if (u.getDistance(bunk) < bunkdist)
						bunkdist = u.getDistance(bunk);
				}
					
				if (baseRegion.contains(u.getPosition())) {
					if ((u.getType() == UnitType.PROTOSS_PYLON || u
									.getType() == UnitType.TERRAN_BUNKER))
						defense += 10;
					else if (u.getType().canAttack()
							&& !u.getType().isFlyer() && !u.isCloaked()) {
						enemyval += u.getType().mineralPrice();
						enemyval += u.getType().gasPrice();
						if (u.getType() == UnitType.PROTOSS_ZEALOT)
							enemyval += 50;
						if (u.getDistance(Position.centerOfTile(myMacro.myHome)) < 250 && !u.getType().isWorker())
							enemyval += 200;
					}
					

					if (u.getPlayer() != me
							&& (u.getType() == UnitType.ZERG_DRONE
									|| u.getType() == UnitType.TERRAN_SCV || u
									.getType() == UnitType.PROTOSS_PROBE))
						w++;
						

				}
			}

			
			if (enemyval > aval && enemyval > 100) {
				defense += (enemyval-aval)/50;
				
				if (aval < 150)
					defense += 3;
			}

			
		}
		
		if (defense > defenseMemory)
			defenseMemory = defense;
		return defenseMemory;
	}
	
	
	/* Do we need to counter a harassing worker? If yes, return the worker, if not return null */
	public ROUnit antisparky() {
		double nearestDistance = Double.POSITIVE_INFINITY;
		ROUnit closestEnemy = null;
		if (myMacro.myCCs.size() != 0 && myMacro.myCCs.get(0) != null) {
			closestEnemy = UnitUtils.getClosest(myMacro.myCCs.get(0).myUnit, myMicro.allVisibleEnemies);
			if (closestEnemy != null) nearestDistance = myMacro.myCCs.get(0).myUnit.getTilePosition().getDistance(closestEnemy.getPosition());
		}

		if (myMicro.allArmy.size() == 0 && nearestDistance < 21 && myMacro.numWorkers() != 0) return closestEnemy;
		else return null;
	}
	
	
	/* Offensive Focal point setup.
	 * Kind of a mess, I imagine we'll redo this from scratch.
	 * Right now, basically chooses a point for the army to gather (either near base if it's not time to attack,
	 * or towards the enemy if it is)
	 * */
	public Position computeFocalPoint() {
		Position focalPoint;
		focalPoint = Position.INVALID;

		if (confidence < RETREAT_PROPORTION)
			retreating = true;
		if (confidence >= ATTACK_PROPORTION)
			retreating = false;
		if (retreating) {
			previousFocal = computeDefensiveFocalPoint();
			return previousFocal;
		}
		

		if (!retreating) {
			ROUnit proxybldg = null;
			for (ROUnit bldg : enemyBuildings) {
				if (bldg.getLastKnownPosition() != Position.INVALID && bldg.getLastKnownPosition() != null && 
						(myMacro.baseRegion.contains(bldg.getLastKnownPosition()) || myMacro.natRegion.contains(bldg.getLastKnownPosition()))) {
					proxybldg = bldg;
					break;
				}
			}
			if (proxybldg != null) {
				focalPoint = proxybldg.getLastKnownPosition();
			}
			
			else if (myMacro.enemyBases.size() != 0) {
				focalPoint = myMacro.enemyBases
				.get(myMacro.enemyBases.size() - 1).getLastKnownPosition();
				myMicro.whenattack = myMicro.wao / 3;
			}
			else if (enemyBuildings.size() != 0) {
				focalPoint = enemyBuildings.get(0).getLastKnownPosition();
				int i = 1;
				while (enemyBuildings.size() > i && focalPoint.x() == -1) {
					focalPoint = enemyBuildings.get(i).getLastKnownPosition();
					i++;
				}
				
			}
			
			retreating = false;
			
		}
		
		
		
		

		previousFocal = focalPoint;
		return focalPoint;
	}
	
	/* The focal point for units that are not attacking */
	public Position computeDefensiveFocalPoint() {
		mostRecentAttack++;
		Position focalPoint;
		focalPoint = null;
		TilePosition nextExp = myMacro.nextExpansion(true);
		if (myMicro.dbldg != null && ((myMicro.attackersValue > 700) || Utils.getValue(myMicro.allArmy) < myMicro.attackersValue * 1.3)) {
			mostRecentAttack = 0;
			mostRecentDBldg = myMicro.dbldg;
		}
		
		if (mostRecentDBldg != null && mostRecentAttack < 1000) {
			if (this.expandNeeded() > 0 && nextExp != null) {
				focalPoint = Position.centerOfTile(nextExp);
			}
			else focalPoint = mostRecentDBldg.getLastKnownPosition();	
		}

		else if (myMacro.myCCs.size() != 0) {
			List<TilePosition> bases2 = new ArrayList<TilePosition>();
			for (int a = 1; a < myMacro.myCCs.size(); a++) {
				bases2.add(myMacro.myCCs.get(a).spot);
			}
			myMicro.whenattack = myMicro.wao;
			int i = myMacro.myCCs.size() - 1;
			if (this.expandNeeded() > 0 && nextExp != null) {
				//focalPoint = Utils.biggestChoke(Position.centerOfTile(nextExp));
				bases2.add(nextExp);
				if (attackpath != null) focalPoint = new Position(IntelligenceUtil.get_defend_position(attackpath, bases2));
				else focalPoint = myMacro.natChoke.getCenter();
			}
			else while (i >= 0) {
				if (gasStolen && stealingRefinery != null) {
					focalPoint = stealingRefinery.getPosition();
					break;
				}
				
				if (myMacro.myCCs.get(i).status != BuildingStatus.DEAD) {
					if (i == 0) {
						
						if (myMacro.wall != null) {
							focalPoint = new Position(Utils.closestTile(TilePosition.getTilePositions(myMacro.wall.get(0), 4, 3), myMacro.myCCs.get(0).spot));
						}
						else focalPoint = myMacro.baseChoke.getCenter();
					}
					else if (i == 1) {
						focalPoint =  myMacro.natChoke.getCenter();
					}		
					else {

						if (attackpath != null) focalPoint = new Position(IntelligenceUtil.get_defend_position(attackpath, bases2));
						else focalPoint = myMacro.natChoke.getCenter();
					}
					break;
				}
				i--;
			}
			/*
			if (myMacro.myCCs.size() <= 2 && myMicro.myBunker != null
					&& myMicro.myBunker.getPosition().x() != -1 && focalPoint != null)
				focalPoint = Position.midPoint(new Pair<Position, Position>(
						myMicro.myBunker.getPosition(), focalPoint));
			*/
		}
		else focalPoint = new Position(myMacro.myHome);
		return focalPoint;
	}
	
	
	public Hotspot getHotspot() {
		Hotspot ret = null;
		double bestDistance = Double.POSITIVE_INFINITY;
		Position pos = Position.INVALID;
		
		for (Squad s : myMicro.squads) {
			if (s.acceptsType(UnitType.TERRAN_SIEGE_TANK_TANK_MODE) && s.locked && s.myUnits.size() > 1) {
				pos = UnitUtils.medianPos(s.myUnits);
				break;
			}
		}
		if (pos == Position.INVALID) {
			pos = computeDefensiveFocalPoint();
		}
		for (Hotspot h : myIntel.hotspots) {
			double distance = (h.pos).getDistance(pos);
			if (bestDistance > distance) {
				bestDistance = distance;
				ret = h;
			}
		}
		if (ret == null)
			return new Hotspot(computeFocalPoint(), 0);
		else return ret;
	}

	
	public boolean shouldCancelExpansion() {
        for (int i = 0; i < myMacro.myBuildings.size(); i++) {
            if ((myMacro.myBuildings.get(i).status == BuildingStatus.SCHEDULED)
                    && myMacro.myBuildings.get(i).type == UnitType.TERRAN_COMMAND_CENTER) {
                // if enemy ccs nearby, cancel
            	
            	for (ROUnit u : enemyBuildings) {
            		if (u.getLastKnownTilePosition().getDistance(myMacro.myBuildings.get(i).spot) < 7 && 
            				(u.getType().isResourceDepot() || u.getType().canAttack() || u.getType().canProduce() || u.getType() == UnitType.TERRAN_BUNKER)) {
            			return true;
            		}
            	}
            	
            }
            
            if ((myMacro.myBuildings.get(i).status == BuildingStatus.BUILDING)
                    && myMacro.myBuildings.get(i).type == UnitType.TERRAN_COMMAND_CENTER) {
            	if (myMacro.myBuildings.get(i).myUnit.getHitPoints() < 100)
            		return true;
            }
        }
        
        
        
		return mostRecentAttack <= 500 && (confidence < 0.9 || myMicro.attackersValue > (getValueRO(myArmy)));
	}
	
	
	/* Return building if it needs defending, null otherwise */
	public Unit getBuildingToDefend() {
		int toldist = 450;
		double bd = Double.POSITIVE_INFINITY;
		Unit dbldg = null;
		
		
		
		/*for (BuildingStatus b : myMacro.myBuildings) {
			if (b.myUnit == null
					|| b.myUnit.getType() == UnitType.TERRAN_ENGINEERING_BAY)
				continue;
			double distance = UnitUtils.getClosestDistance(b.myUnit, myMicro.allVisibleEnemies);
			if (distance < toldist && distance < bd) {
				bd = distance;
				dbldg = b.myUnit;
			}
		}
		*/

		double best = 0;
		
		for (BuildingStatus b : myMacro.myBuildings) {
			double value = 0;
			for (ROUnit e : myMicro.allVisibleEnemies) {
				if (b.myUnit != null && (e.isInRange(b.myUnit) || b.myUnit.getDistance(e) < 128)) {
					value += e.getType().mineralPrice();
					value += 2*e.getType().gasPrice();
				}
			}
			
			if (value > best) {
				best = value;
				dbldg = b.myUnit;
			}

		}
		
		
		
		return dbldg;
	}
	
	/* Do we need an expansion? 
	 * 0 is no.
	 * 1 is yes.
	 * 2 is safe expansion (ie, expand with bunker).
	 */
	public int expandNeeded() {
		if (myMacro.nextExpansion(true) == null && time - myMacro.lastInject < 1000 ) return 0;
		int baseMinerals = 0;
		
		for (ROUnit patch: mGame.getMinerals()) {
			for (BuildingStatus cc : myMacro.myCCs) {
				if (cc.myUnit != null && cc.myUnit.getDistance(patch) < 350) {
					baseMinerals += patch.getResources();
					break;
				}
			}
		}
		
		double a = getValueRO(myArmy);
		double b = getValue(knownEnemies, false);
		
		/* Expand if the patches are almost empty, or we have a significant army advantage (and some sort of army has been scouted), or we're being
		*  significantly out-based.
		*/
		if (myMicro.dbldg != null) return 0; // Don't expand if under attack.
		if (baseMinerals < 6000) {
			mGame.drawTextScreen(200, 300, "Expansion requested based on baseMinerals = " + baseMinerals);
			return 1;
		}
        int currentMinerals = mGame.self().minerals();
        if (a > 1.5*b && b > 1500 && currentMinerals > 700) {
			mGame.drawTextScreen(200, 300, "Expansion requested based on army values: mine is " + a + " versus " + b);
			return 1;
		}

        int numCCs = myMacro.myCCs.size();
        if (numCCs > 1 && ((!mechStrat && a > 1200 * numCCs) || (mechStrat && a > 1800 * numCCs))){
            mGame.drawTextScreen(200, 300, "Expansion requested based on army value: mine is " + a + " for "+numCCs +" bases");
            return 1;
        }
		if (numCCs > 2 && ((myMacro.enemyBases.size() >= numCCs + 1 && enemy.getRace() == Race.TERRAN) || (myMacro.enemyBases.size() >= numCCs + 2 && enemy.getRace() == Race.PROTOSS))) {
			mGame.drawTextScreen(200, 300, "Expansion requested based on bases: I have " + numCCs + " versus " + myMacro.enemyBases.size());
			return 1;
		}

		if ((myBldgCount(UnitType.TERRAN_BARRACKS) >= 2 || myBldgCount(UnitType.TERRAN_FACTORY) >= 2)  && numCCs == 1 && 
				((mGame.self().supplyUsed() > 80 && (enemy.getRace() != Race.PROTOSS || !earlyRush)) 
						|| mGame.self().supplyUsed() > 95
						|| (mGame.self().supplyUsed() > 50 && FE && enemy.getRace() != Race.ZERG))) {
		//if ((myBldgCount(UnitType.TERRAN_BARRACKS) >= 2 || myBldgCount(UnitType.TERRAN_FACTORY) >= 2)  && numCCs == 1 && mGame.self().supplyUsed() > 70) {
			mGame.drawTextScreen(200, 300, "2 rax/facts are up, natural expansion requested.");
			return 1;
		}
		
		if (myMacro.mins > 800) {
			mGame.drawTextScreen(200, 300, "Expand because we have so much money");
			return 1;
		}
		
		else return 0;
	}
	
	
	/* Can we actually expand to the next expansion? */
	public boolean canExpand() {
		return (mostRecentAttack > 1000 || myMicro.allArmy.size() > 20);
	}
	
	public int computeLockThreshold() {
		int totalAttack = 0;
		double proportion;
		
		
		
		if (producedArmy > 1000) proportion = Math.max((producedArmy-valueKilled), getValueES(knownEnemies)) / getValueRO(myArmy);
		else proportion = 1;
		
		if (proportion > 1) proportion = 1;
		
		if (proportion < 0.4) proportion = 0.4;
		for (Squad s : myMicro.squads) {
			if (s.locked)
				totalAttack += s.myUnits.size();
		}
		
		if (totalAttack >= 12 || (enemy.getRace() == Race.TERRAN && totalAttack >= 4))
			return 5;
		else if (mechStrat) {
			if (enemy.getRace() == Race.PROTOSS) {
				return (int) Math.ceil(proportion*PROTOSS_MAXSQUAD);
			}
			else {	//terran!
				if (time < 10000)  {
					if (!earlyRush) 
						return 6;
					else return 10;
				}
				else return (int) Math.ceil(proportion*TERRAN_MAXSQUAD);
			}
		}
		else {
			return (int) Math.ceil(proportion*ZERG_MAXSQUAD);
		}
	}
	
	
	
	/* Utilities */
	
	public double armyEval() {
		double a = getValueRO(myArmy);
		double b = getValue(knownEnemies,false);
		double ret = (a-b)/(a);
		return ret;
	}
	
	public double getValueRO(List<ROUnit> army) {
		int minval = 1; // fudge factor for division by 0
		int gasval = 0;
		for (ROUnit e : army) {
			minval += e.getType().mineralPrice();
			gasval += e.getType().gasPrice();
		}
		return minval + gasval*2;
	}
	
	public double getValueES(List<EnemyUnitStatus> army) {
		int minval = 1; // fudge factor for division by 0
		int gasval = 0;
		for (EnemyUnitStatus e : army) {
			minval += e.unit.getType().mineralPrice();
			gasval += e.unit.getType().gasPrice();
		}
		return minval + gasval*2;
	}
	
	public double getValue(List<Unit> army) {
		int minval = 1; // fudge factor for division by 0
		int gasval = 0;
		for (ROUnit e : army) {
			minval += e.getType().mineralPrice();
			gasval += e.getType().gasPrice();
		}
		return minval + gasval*2;
	}
	
	public List<RegionStatus> getRegionStatuses() {
		return myIntel.regions;
	}


	
	public double getValue(List<EnemyUnitStatus> army, boolean worstWorkaroundEver) {
		int minval = 1; // fudge factor for division by 0
		int gasval = 0;
		for (EnemyUnitStatus e : army) {
			minval += e.unit.getType().mineralPrice();
			gasval += e.unit.getType().gasPrice();
		}
		return minval + gasval*2;
	}
	
	public double getWeightedValue(List<EnemyUnitStatus> army) {
		int minval = 1; // fudge factor for division by 0
		int gasval = 0;
		for (EnemyUnitStatus e : army) {
			if (e.unit.getType() == UnitType.ZERG_MUTALISK)
				minval += 150;
			else {
				minval += e.unit.getType().mineralPrice();
				gasval += e.unit.getType().gasPrice();
			}
			
			
		}
		return minval + gasval*2;
	}

	
	public boolean isMainBldg(ROUnit unit) {
		return (unit.getType() == UnitType.PROTOSS_NEXUS
				|| unit.getType() == UnitType.ZERG_HATCHERY
				|| unit.getType() == UnitType.ZERG_LAIR
				|| unit.getType() == UnitType.ZERG_HIVE || unit.getType() == UnitType.TERRAN_COMMAND_CENTER);

	}
	
	public boolean hehastech(UnitType bldg) {
		for (ROUnit u : enemyBuildings) {
			if (u.getType().equals(bldg)) return true;
		}
		return false;
	}
	
	public boolean ihavetech(UnitType bldg) {
		for (BuildingStatus b : myMacro.myBuildings) {
			if (b.myUnit != null && b.myUnit.getType().equals(bldg) && b.myUnit.isCompleted()) return true;
		}
		return false;
	}
	
	public boolean hehascompletedtech(UnitType bldg) {
		for (ROUnit u : enemyBuildings) {
			if (u.getType().equals(bldg) && u.isCompleted()) return true;
		}
		return false;
	}
	
	public boolean hehasunit(UnitType un) {
		for (EnemyUnitStatus u : knownEnemies) {
			if (u.unit.getType() == un) return true;
		}
		return false;
	}
	
	public int enemyCount(UnitType unit) {
		int c = 0;
		for (ROUnit u : enemyBuildings) {
			if (u.getType().equals(unit) && u.getDistance(Position.centerOfTile(myMacro.myHome)) > 600) c++;
		}
		
		for (EnemyUnitStatus es : knownEnemies) {
			if (es.unit.getType().equals(unit)) c++;
		}
		return c;
	}
	
	
	
	public int staticgroundd() {
		return Math.max(enemyCount(UnitType.TERRAN_BUNKER), Math.max(enemyCount(UnitType.PROTOSS_PHOTON_CANNON), enemyCount(UnitType.ZERG_SUNKEN_COLONY)));
	}

	
	public int myCount(UnitType ut) {
		int c = 0;
		for (ROUnit u : myArmy) {
			if (u.getType().equals(ut)) c++;
		}
		return c;
	}
	
	public int myCountUnloaded(UnitType ut) {
		int c = 0;
		for (ROUnit u : myArmy) {
			if (u.getType().equals(ut) && !u.isLoaded()) c++;
		}
		return c;
	}
	
	public int myBldgCount(UnitType ut) {
		int c = 0;
		for (BuildingStatus b : myMacro.myBuildings) {
			if (b.type.equals(ut)) c++;
		}
		return c;
	}
	
	public void setIntelManager(IntelManager im) {
		myIntel = im;
	}
	
	public void updateConfidence() {
		double myVal = getValue(myMicro.allArmy);
		double enemyVal = getWeightedValue(knownEnemies);
		double alpha = 0.01;
		int sunkens = 0;
		int closeSunkens = 0;
		
		if (previousFocal != null && previousFocal != Position.INVALID) 
			outer:
			for (ROUnit bldg : myMicro.enemyBuildings) {
				if (bldg.getType() == UnitType.ZERG_SUNKEN_COLONY) { // We don't worry about cannons/bunkers... siege tanks bro
					TilePosition tp = bldg.getLastKnownTilePosition();
					if (attackpath != null) 
						for (TilePosition tp2 : attackpath) {
							if (tp.getDistance(tp2) < 8) {
								sunkens++;
								 if (UnitUtils.getClosestDistance(bldg, myMicro.allArmy) < 500) {
									 closeSunkens++;
								 }
								continue outer;
							}
						}
				}

			}
		
		if (sunkens > 3) sunkens = 3;
		if (closeSunkens > 3) closeSunkens = 3;
		enemyVal += sunkens*200;
		alpha += 0.008*closeSunkens;
		
		
		confidence = alpha * (myVal / (enemyVal +0.1)) + (1-alpha) * confidence;
		if (confidence > 3) confidence = 3; // Don't get cocky.
		
		if (me.supplyUsed() > 360) confidence = 3;
	}
	
	public boolean recommendVultures() {
    	int vultures =  UnitUtils.getAllMy(UnitType.TERRAN_VULTURE).size();
    	int tanks = UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE).size() + UnitUtils.getAllMy(UnitType.TERRAN_SIEGE_TANK_TANK_MODE).size();
    	
		int smalls = 0;
		int v = 0;
		for (EnemyUnitStatus es : knownEnemies) {
			if (es.unit.getType() == UnitType.PROTOSS_ZEALOT)
				smalls++;
		}
		if (enemy.getRace() == Race.PROTOSS) {
			if (vultures < tanks)
				return true;
			if (smalls > vultures)
				return true;
			
			if (smalls+tanks < tanks*1.5) v = smalls+tanks;
			else v = smalls+tanks;
		}
		else if (enemy.getRace() == Race.TERRAN) {
			if (vultures < tanks/3.0)
				return true;
		}
		return false;
	}
	
	
	public TilePosition bestDropSpot() {
		TilePosition best = null;
		
		if (myMacro.enemyBases.size() != 0) {
			List<TilePosition> eligibles = new ArrayList<TilePosition>();
			for (ROUnit base : myMacro.enemyBases) {
				eligibles.add(base.getLastKnownTilePosition());
			}
			
			double bestThreat = Double.POSITIVE_INFINITY;
			
			for (TilePosition tp : eligibles) {
				double t = dropThreat(tp);
				if (t < bestThreat) {
					bestThreat = t;
					best = tp;
				}
			}
		}
		else if (myMacro.enemyBuildings.size() != 0) {
			best = myMacro.enemyBuildings.get(0).getLastKnownTilePosition();
		}
		return best;
	}
	
	public double dropThreat(TilePosition tp) {
		double threat = 0;
		for (ROUnit bldg : myMacro.enemyBuildings) {
			if ((bldg.getType().canAttack() || bldg.getType() == UnitType.TERRAN_BUNKER)) {
				threat += 15.0/(1+bldg.getLastKnownTilePosition().getDistance(tp));
				
			}
		}

		for (RegionStatus rs : myMicro.regionStatuses) {
			for (ROUnit en : rs.enemies) {
				if (en.getType().canAttack() && !en.getType().isWorker()) {
					threat += 15.0/(1+en.getLastKnownTilePosition().getDistance(tp));
					
				}

			}

		}
		
		return threat;
	}
	
	
	public UnitType getDropType() {
		if (!mechStrat) {
			if (airproportion(knownEnemies) < 0.3) return UnitType.TERRAN_MARINE;
			else return UnitType.TERRAN_NUCLEAR_MISSILE; // THE ULTIMATE PLAN
		}
		else {
			if (myCountUnloaded(UnitType.TERRAN_MARINE) > 5) {
				return UnitType.TERRAN_MARINE;
			}
			else if (myCountUnloaded(UnitType.TERRAN_VULTURE) > 8) return UnitType.TERRAN_VULTURE;
			else return UnitType.TERRAN_MARINE;
		}
	}
	
	public boolean needTanks() {
		if (mechStrat) return false;
		else if (enemyCount(UnitType.ZERG_LURKER) > 3 && needTanks == false) {
			needTanks = true;
			myMacro.BORemove(UnitType.TERRAN_FACTORY);
			myMacro.BOInject(UnitType.TERRAN_FACTORY);
			myMacro.buildOrder.add(UnitType.TERRAN_FACTORY);
		}
		return needTanks;
	}
	


}
