package undermind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.UnitType;
import org.bwapi.proxy.model.WeaponType;

import undermind.intelligence.RegionStatus;
import edu.berkeley.nlp.starcraft.util.Counter;
import edu.berkeley.nlp.starcraft.util.FastPriorityQueue;


public class DropSearch {
	/* A* adapted to drops... Oh man */
	
	
	Counter<TilePosition> banned;
	MicroManager master;
	long time1 = 0;
	Game mGame;
	int mapheight;
	int mapwidth;
	
	Map<TilePosition, Integer> ttdm; // Tile to distance (from nearest unwalkable tile) map
	
	public DropSearch(MicroManager m) {
		mGame = Game.getInstance();
		mapheight = mGame.getMapHeight();
		mapwidth = mGame.getMapWidth();
		ttdm = new HashMap<TilePosition, Integer>();
		master = m;
	}
	
	class Node {
		Node parent;
		TilePosition state;
		double backCost;
		double heuristic;
		
		public Node(Node parent, TilePosition state, double backCost, double heuristic) {
			super();
			this.parent = parent;
			this.state = state;
			this.backCost = backCost;
			this.heuristic = heuristic;
		}
	}
	
	
	
	
	public List<TilePosition> getPath(TilePosition start, TilePosition end) {
		time1 = System.currentTimeMillis();
		Node node  = search(start, end);
		if (node == null) return null;
		List<TilePosition> path = new ArrayList<TilePosition>();
		while (node != null) {
			path.add(node.state);
			node = node.parent;
		}
		Collections.reverse(path);
		return path;
	}
	
	private void computeBanned() {
		banned = new Counter<TilePosition>();
		int tolerance = 9;
		for (ROUnit bldg : master.enemyBuildings) {
			if (bldg.getType() == UnitType.TERRAN_MISSILE_TURRET || bldg.getType() == UnitType.TERRAN_BUNKER 
					|| bldg.getType() == UnitType.ZERG_SPORE_COLONY || bldg.getType() == UnitType.PROTOSS_PHOTON_CANNON) {
				for (int dx = -tolerance-1; dx < tolerance+1; dx++) {
					for (int dy = -tolerance-1; dy < tolerance+1; dy++) {
						TilePosition tilePosition = bldg.getLastKnownTilePosition();
						TilePosition newtp = new TilePosition(tilePosition.x() + dx, tilePosition.y() + dy);
						banned.incrementCount(newtp, 230.0/(1+tilePosition.getDistance(newtp)));
					}
				}

			}
		}
		
		
		for (RegionStatus rs : master.regionStatuses) {
				for (ROUnit en : rs.enemies) {
					if (!en.getType().airWeapon().equals(WeaponType.NONE)) {
						for (int dx = -tolerance; dx < tolerance; dx++) {
							for (int dy = -tolerance; dy < tolerance; dy++) {
								TilePosition tilePosition = en.getLastKnownTilePosition();
								TilePosition newtp = new TilePosition(tilePosition.x() + dx, tilePosition.y() + dy);
								banned.incrementCount(newtp, 25.0/(1+tilePosition.getDistance(newtp)));
							}
						}
					}
						
				}
			
		}
		
		//for (TilePosition b : banned.keySet()) {
			//Game.getInstance().drawTextMap(new Position(b), Math.round((float)banned.getCount(b)) +"");

			//Game.getInstance().drawCircleMap(new Position(b), Math.round((float)banned.getCount(b))/8, Color.RED, true);
		//}
	}
	
	private Node search(TilePosition start, TilePosition end) {
		
		computeBanned();
		FastPriorityQueue<Node> fringe = new FastPriorityQueue<Node>();
		byte[][] gridArray = new byte[Game.getInstance().getMapWidth()][Game.getInstance().getMapHeight()];
		Node startNode = new Node(null, start, 0, computeHeuristic(start, end));
		enqueueNode(startNode, fringe);
		
		int endx = end.x();
		int endy = end.y();
		
		
		while (! fringe.isEmpty()) {
			long time2 = System.currentTimeMillis();
			if (time2 - time1 > 2000) {
				return null;
			}
			Node node = fringe.next();
			TilePosition state = node.state;
			int x = state.x();
			int y = state.y();
			
			if (gridArray[x][y] != 0) continue;
			if (x == endx && y == endy) {
				return node;
			}
			gridArray[x][y] = 1;
			TilePosition[] successors = fastSuccessors(state);
			for (TilePosition pos : successors) {
				if (pos == null) continue;
				int x2 = pos.x();
				int y2 = pos.y();
				if (gridArray[x2][y2] != 0) continue;
				
				Node childNode = new Node(node, pos, node.backCost + transitionCost(state, pos), computeHeuristic(pos, end));
				fringe.setPriority(childNode, -(childNode.backCost*1 + childNode.heuristic));
			}
		}
		return null;
	}
	
	
	private void enqueueNode(Node node, FastPriorityQueue<Node> fringe) {
		//System.out.println("PRIORITY SET " + (node.backCost + node.heuristic) + " " + node.state);
		fringe.setPriority(node, -(node.backCost*1 + node.heuristic));
	}
	
	private double computeHeuristic(TilePosition state, TilePosition end) {
		
		int xd = state.x() - end.x();
		if (xd < 0) xd = -xd;
		int yd = state.y() - end.y();
		if (yd < 0) yd = -yd;

		double r = (xd+yd)*0.75;
		return r;
	}
	
	

	public double transitionCost(TilePosition state, TilePosition pos) {
		double cost = 0.0;
		if (state.x() == pos.x()) {
			if (state.y() == pos.y()) {
				
			}
			else cost += 1;
		}
		else {
			if (state.y() == pos.y()) {
				cost += 1;
			}
			else cost += 1.5;
		}
		

		cost += banned.getCount(pos);
		
		return cost;
	}
	
	public TilePosition[] fastSuccessors(TilePosition state) {
		
		TilePosition[] res = new TilePosition[8];

		
		int k = 0;
		int x = state.x();
		int y = state.y();
		
		
		for (int dx = -1; dx <= 1; ++dx) {
			for (int dy = -1; dy <= 1; ++dy) {
				if (dx == 0 && dy == 0) continue;
				/*
				if (Game.getInstance().unitsOnTile(new TilePosition(x+dx, y+dy)).size() != 0) {
					Set s = Game.getInstance().unitsOnTile(new TilePosition(x+dx, y+dy));
					continue;
				} */
				TilePosition newpos = new TilePosition(x+dx,y+dy);
				if (isWalkable(newpos)) {
					res[k] = newpos;
				}
				k++;
			}
		}
		return res;
		
	}
	
	
	public double getGroundDistance(TilePosition s, TilePosition g) {
		return getPath(s,g).size();
	}
	
	public void drawPath(List<TilePosition> path) {
		for (TilePosition tp : path) {
			mGame.drawCircleMap(Position.centerOfTile(tp), 3, Color.CYAN, true);
		}
	}
	
	public void drawttdm() {
		for (Map.Entry<TilePosition, Integer> ti : ttdm.entrySet()) {
			mGame.drawTextMap(Position.centerOfTile(ti.getKey()), ti.getValue().toString());
		}
	}
	
	public boolean isWalkable(TilePosition tp) {
		if (tp.x() < 0 || tp.x() > mapwidth-1) return false;
		if (tp.y() < 0 || tp.y() > mapheight-1) return false;
		
		//if (banned.contains(tp)) return false;
		
	
		
		return true;
	}

}
