package undermind;

import java.util.Arrays;
import java.util.List;

import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.UnitType;

import undermind.intelligence.IntelManager;
import undermind.macro.MacroManager;
import undermind.macro.WorkerManager;
import undermind.micropacket.Squad;
import edu.berkeley.nlp.starcraft.AbstractCerebrate;
import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.Strategy;
import edu.berkeley.nlp.starcraft.scripting.Command;
import edu.berkeley.nlp.starcraft.scripting.JythonInterpreter;
import edu.berkeley.nlp.starcraft.scripting.Thunk;


/* Gives out calls to the different modules based on game analysis */
public class Dispatcher extends AbstractCerebrate implements Strategy {

	public int lastScan = 0;
	JythonInterpreter jython = new JythonInterpreter();
	public MacroManager myMacro;
	public MicroManager myMicro;
	public GameEvaluator myEval;
    public WorkerManager workerManager;
    public IntelManager intelManager;
	public Game mGame;
	public long frame;
	
	public Dispatcher() {
		mGame = Game.getInstance();
	}
	
	@Override
	public List<Cerebrate> getTopLevelCerebrates() {
		initializeJython();
		myMacro = new MacroManager();
		myMicro = new MicroManager();
		myEval = new GameEvaluator(myMacro, myMicro);
        workerManager = new WorkerManager(myMacro);
        intelManager = new IntelManager(myEval);
        myMacro.setWorkerManager(workerManager);
        myEval.setIntelManager(intelManager);
		return Arrays.<Cerebrate> asList(jython, myEval, myMicro, myMacro, workerManager, intelManager, this);
	}
 

	// Feel free to add command and things here.
	// bindFields will bind all member variables of the object
	// commands should be self explanatory...
	protected void initializeJython() {
		jython.bindFields(this);
		jython.bind("game", mGame);
		jython.bindIntCommand("speed", new Command<Integer>() {
			@Override
			public void call(Integer arg) {
				mGame.printf("Setting speed to %d", arg);
				mGame.setLocalSpeed(arg);
			}
		});
		jython.bindThunk("debug", new Thunk() {
			@Override
			public void call() {
				myMacro.debug = !myMacro.debug;
				myMicro.debug = !myMicro.debug;
			}
		});
		jython.bindThunk("reset", new Thunk() {

			@Override
			public void call() {
				initializeJython();

			}

		});
		jython.bindThunk("freeze", new Thunk() {

			@Override
			public void call() {
				long start = System.currentTimeMillis();
				while(System.currentTimeMillis() - start < 20000) {
					
				}

			}

		});
        jython.bindIntCommand("goto", new Command<Integer>() {

            @Override
            public void call(Integer arg) {
                int id = arg.intValue();
                for(ROUnit u : mGame.getAllUnits()){
                    if(u.getID() == id){
                        mGame.setScreenPosition(u.getLastKnownPosition());
                        mGame.drawCircleMap(u.getLastKnownPosition(), 5, Color.RED, false);
                        return;
                    }
                }
                mGame.printf("Couldn't find unit id %d", id);
            }
        });

	}

	@Override
	public void onStart() {
		mGame.setDrawing(false);
		myMacro.BOset(myEval.initialBuildOrder());
	}
	
	@Override
	public void onFrame() {
		frame++;
		lastScan--;
		
		myEval.setProductionPriorities();
		int defense = myEval.defenseNeeded();
		if (defense != 0) {
			myMacro.defend(defense);
		}
		else myMacro.stopDefend();
		
		myMacro.antisparky(myEval.antisparky());
		
		myMicro.setFocal(myEval.computeFocalPoint());
		myMicro.setDFocal(myEval.computeDefensiveFocalPoint());
		myMicro.setDbldg(myEval.getBuildingToDefend());
		myMicro.setHotspot(myEval.getHotspot());
		
		// Ugly and kinda breaks our abstraction... oh well
		if (myEval.myMicro.pleaseScanHere != null) {
			myMacro.scan(myEval.myMicro.pleaseScanHere);
			myEval.myMicro.pleaseScanHere = null;
		}
		
		
		if (myEval.needAS) {
			myMacro.stealthResponse();
		}


		if (myEval.needAA) {
			myMacro.airResponse();
		}

		if (myEval.gasStolen) {
			myMacro.gasStealResponse();
		}

		if (myEval.earlyRush) {
			myMacro.rushResponse();
		}

		if (myEval.FE) {
			myMacro.FEresponse();
		}
		
		if (frame % 100 == 0 && myEval.canExpand()) {
			int expand = myEval.expandNeeded();
			if (expand == 1) {
				mGame.printf("expanding...");
				myMacro.expand();
			}
			else if (expand == 2) {
				mGame.printf("expanding...");
				myMacro.safeExpand();
			}
		}
		
		if (myEval.shouldCancelExpansion()) {
			myMacro.cancelExpand();
		}
		
		Position scanPos = myEval.scanPos();
		if (scanPos != Position.INVALID && lastScan < 0) {
			myMacro.scan(scanPos);
			lastScan = 700;
		}
        
		Squad.lockThreshold = myEval.computeLockThreshold();
		
		
		myMacro.enemyBuildings = myMicro.enemyBuildings; // Yes, I cheated our abstraction.
		myMicro.regionStatuses = myEval.getRegionStatuses();
		myMicro.mechStrat = myEval.mechStrat;
		myMicro.scouter.nextBL = myEval.myIntel.oldestBase();
		myMicro.reinforcementThreat = myEval.myConvoy.enemies;
		myMicro.suggestedDropSpot = myEval.bestDropSpot();
		myMicro.retreating = myEval.retreating;
		myMicro.stolegas = myEval.gasStolen;
		
		myMicro.confidence = myEval.confidence;
		myMicro.dropType = myEval.getDropType();
		myMacro.lurkers = myEval.needTanks();
		myMicro.lurkers = myEval.needTanks();
		myMicro.posseexp = myEval.myIntel.possibleEnemyExpo();
		myMicro.boccs = myMacro.BOCount(UnitType.TERRAN_COMMAND_CENTER);
	}
	
	
	

	
	
	
	
}
