package edu.berkeley.nlp.starcraft.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import org.bwapi.proxy.model.*;


public class Utils {
	
	public static Game mGame = Game.getInstance();
	public static int mapheight = 0;
	public static int mapwidth = 0;
	public static Bwta myBwta = Bwta.getInstance();

  public static <T> T popFirstFromSet(Collection<T> set, Filter<T> filter) {
    T found = null;
    for (T t : set) {
      if (filter.test(t)) {
        found = t;
        break;
      }
    }
    if (found != null) set.remove(found);
    return found;
  }

  public static <T> T findFirst(Collection<T> set, Filter<T> filter) {
    for (T t : set) {
      if (filter.test(t)) {
        return t;
      }
    }
    return null;
  }

  public static <T> List<T> findAll(Collection<? extends T> set, Filter<? super T> filter) {
    List<T> l = new ArrayList<T>();
    for (T t : set) {
      if (filter.test(t)) l.add(t);
    }
    return l;
  }

  public static <T> int countIf(Collection<T> set, Filter<T> filter) {
    int i = 0;
    for (T t : set) {
      if (filter.test(t)) i++;
    }
    return i;
  }

  public static void copyFileHard(String from, String to) {
    try {
      copyFile(from, to);
    } catch (IOException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
  }

  public static void copyFile(String from, String to) throws IOException {
    FileChannel inChannel = null, outChannel = null;
    inChannel = new FileInputStream(new File(from)).getChannel();
    outChannel = new FileOutputStream(new File(to)).getChannel();
    inChannel.transferTo(0, inChannel.size(), outChannel);
    if (inChannel != null) inChannel.close();
    if (outChannel != null) outChannel.close();
  }

  public static Properties loadPropertiesFile(String propertiesFile) {
    Properties props = new Properties();
    try {
      FileInputStream in = new FileInputStream(propertiesFile);
      props.load(in);
      in.close();
      return props;
    } catch (IOException e) {
      e.printStackTrace();
      throw new RuntimeException(e);
    }
  }

  @SuppressWarnings("unchecked")
  public static <T> T getObjectByClassName(String className) {
    try {
      return (T)Class.forName(className).getConstructor().newInstance();
    } catch (Exception e) {
      Log.getLog("Util").fatal("Instantiation:", e);
      throw new RuntimeException("Failed to instantiate: " + className,e);
    } 

  }

  public static Class<?> getClassByClassName(String className) {
    try {
      return Class.forName(className);
    } catch (ClassNotFoundException e) {
      e.printStackTrace();
    }
    throw new RuntimeException("Failed to load: " + className);
  }

  @SuppressWarnings("unchecked")
  public static Object getEnumValue(Class enumClass, String valueName) {
    try {
      return enumClass.getMethod("valueOf", String.class).invoke(enumClass, valueName);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
  
  public static <T> T randomChoice(Collection<? extends T> col) {
  	int n = (int) (Math.random() * col.size());
  	Iterator<? extends T> it = col.iterator();
  	while(n-- != 0) it.next();
  	return it.next();
  }

	public static boolean isWalkable(TilePosition tp) {
		if (mapheight == 0) mapheight = Game.getInstance().getMapHeight();
		if (mapwidth == 0) mapwidth = Game.getInstance().getMapWidth();
		
		for (int i = 0; i < 4; i++) {
			for (int j = 0; j < 4; j++) {
				if (!Game.getInstance().isWalkable((tp.x())*4+i, (tp.y())*4+j)) {
					return false;
				}
			}
		}
		if (tp.x() < 0 || tp.x() > mapwidth-1) return false;
		if (tp.y() < 0 || tp.y() > mapheight-1) return false;
		
		return true;
	}
	
	public static boolean isTileWalkable(Position p) {
		TilePosition tp = new TilePosition(p);
		if (mapheight == 0) mapheight = Game.getInstance().getMapHeight();
		if (mapwidth == 0) mapwidth = Game.getInstance().getMapWidth();
		
		for (int i = 0; i < 4; i++) {
			for (int j = 0; j < 4; j++) {
				if (!Game.getInstance().isWalkable((tp.x())*4+i, (tp.y())*4+j)) {
					return false;
				}
			}
		}
		if (tp.x() < 0 || tp.x() > mapwidth-1) return false;
		if (tp.y() < 0 || tp.y() > mapheight-1) return false;
		
		return true;
	}
	
	public static TilePosition nearestWalkableTile(TilePosition tp) {
		if (isWalkable(tp)) return tp;
		
		for (int dx = -2; dx < 2; dx++) {
			for (int dy = -2; dy < 2; dy++) {
				TilePosition newpos = new TilePosition(tp.x()+dx, tp.y()+dy);
				if (isWalkable(newpos)) return newpos;
			}	
		}
		
		return null;
		
	}
	
	/* Returns the center of the nearest fully walkable (static map data) tile position */
	public static Position nearestWalkablePosition(TilePosition tp) {
		if (isWalkable(tp)) return Position.centerOfTile(tp);
		
		for (int dx = -2; dx < 2; dx++) {
			for (int dy = -2; dy < 2; dy++) {
				TilePosition newpos = new TilePosition(tp.x()+dx, tp.y()+dy);
				if (isWalkable(newpos)) return Position.centerOfTile(newpos);
			}	
		}
		
		return null;
		
	}
	
	public static TilePosition nearestDroppableTile(TilePosition tp) {
		if (isWalkable(tp) && tileClear(tp)) return tp;
		
		for (int dx = -2; dx < 2; dx++) {
			for (int dy = -2; dy < 2; dy++) {
				TilePosition newpos = new TilePosition(tp.x()+dx, tp.y()+dy);
				if (isWalkable(newpos) && tileClear(newpos)) return newpos;
			}	
		}
		
		return null;
	}
	
	public static boolean tileClear(TilePosition tp) {
		for (ROUnit thing : mGame.unitsOnTile(tp)) {
			if (thing.getType().isBuilding() || thing.getPlayer() != mGame.self()) return false;
		}
		return true;
	}
	
	public static Position nearestChoke(Position p) {
		Position bestpos = null;
		double bestdist = Double.POSITIVE_INFINITY;
		
		for (Chokepoint c : myBwta.getChokepoints()) {
			double d = c.getCenter().getDistance(p);
			if (d < bestdist) {
				bestdist = d;
				bestpos = c.getCenter();
			}
		}
		
		return bestpos;
		
	}
	
	public static Position biggestChoke(Position p) {
		Position bestpos = null;
		double biggest = 0;
		Region region = null;
		for (Region r : myBwta.getRegions()) {
			if (r.contains(p)) {
				region = r;
				break;
				
			}
				
		}
		if (region == null)
			return Position.INVALID;
		
		
		for (Chokepoint c : region.getChokepoints()) {
			double d = c.getWidth();
			if (d > biggest) {
				biggest = d;
				bestpos = c.getCenter();
			}
		}
		
		return bestpos;
		
	}
	

	public static boolean fullVisible(TilePosition seed, UnitType bldg) {
		for (int i = 0; i < bldg.tileWidth(); i++) {
			for (int j = 0; j < bldg.tileHeight(); j++) {
				if (!mGame.isVisible(new TilePosition(seed.x()+i, seed.y()+j)))
					return false;
			}
		}
		
		return true;
	}
	
	public static double getValueRO(Collection<ROUnit> army) {
		int minval = 1; // fudge factor for division by 0
		int gasval = 0;
		for (ROUnit e : army) {
			minval += e.getType().mineralPrice();
			gasval += e.getType().gasPrice();
		}
		return minval + gasval*2;
	}
	
	public static double getValue(Collection<Unit> army) {
		int minval = 1; // fudge factor for division by 0
		int gasval = 0;
		for (ROUnit e : army) {
			minval += e.getType().mineralPrice();
			gasval += e.getType().gasPrice();
		}
		return minval + gasval*2;
	}
	
	public static TilePosition closestTile(Collection<TilePosition> tiles, TilePosition goal) {
		double bestd = Double.POSITIVE_INFINITY;
		TilePosition best = null;
		
		for (TilePosition tp : tiles) {
			double d = tp.getDistance(goal);
			if (d < bestd) {
				bestd = d;
				best = tp;
			}
		}
		return best;
	}
    public static void drawArrowMap(Position start, Position end, Color color){
        mGame.drawLineMap(start, end, color);
        double slope = ((double)(end.y() - start.y()))/((double)(end.x() - start.x()));
        
    }
}
