package edu.berkeley.nlp.starcraft;

import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;

import java.util.ArrayList;


public abstract class AbstractCerebrate implements Cerebrate {
    protected ArrayList<Cerebrate> subordinates = new ArrayList<Cerebrate>();

    public void addSubordinate(Cerebrate subordinate) {
        subordinates.add(subordinate);
    }

    @Override
    public void onDroppedConnection() {
        for (Cerebrate c : subordinates) {
            c.onDroppedConnection();
        }
    }

    @Override
    public void onEnd(boolean isWinnerFlag) {
        for (Cerebrate c : subordinates) {
            c.onEnd(isWinnerFlag);
        }
    }

    @Override
    public void onFrame() {
        for (Cerebrate c : subordinates) {
            c.onFrame();
        }
    }

    @Override
    public void onNukeDetect(Position position) {
        for (Cerebrate c : subordinates) {
            c.onNukeDetect(position);
        }
    }

    @Override
    public void onPlayerLeft(Player player) {
        for (Cerebrate c : subordinates) {
            c.onPlayerLeft(player);
        }
    }

    @Override
    public void onReceiveText(Player player, String text) {
        for (Cerebrate c : subordinates) {
            c.onReceiveText(player, text);
        }
    }

    @Override
    public void onSendText(String text) {
        for (Cerebrate c : subordinates) {
            c.onSendText(text);
        }
    }

    @Override
    public void onStart() {
        for (Cerebrate c : subordinates) {
            c.onStart();
        }
    }

    @Override
    public void onUnitCreate(ROUnit unit) {
        for (Cerebrate c : subordinates) {
            c.onUnitCreate(unit);
        }
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        for (Cerebrate c : subordinates) {
            c.onUnitDestroy(unit);
        }
    }

    @Override
    public void onUnitHide(ROUnit unit) {
        for (Cerebrate c : subordinates) {
            c.onUnitHide(unit);
        }
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
        for (Cerebrate c : subordinates) {
            c.onUnitMorph(unit);
        }
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
        for (Cerebrate c : subordinates) {
            c.onUnitRenegade(unit);
        }
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        for (Cerebrate c : subordinates) {
            c.onUnitShow(unit);
        }
    }
    

}
