/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bwapi.proxy.model.BaseLocation;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.micropacket.EnemyUnit;
import undermind.micropacket.M3chSquad;
import undermind.micropacket.Vulture;

public class VultureSquad {
    M3chSquad msquad = null;
    Set<Vulture> myVultures = new HashSet<Vulture>();
    Game mGame = Game.getInstance();
    Random rgen = new Random();

    public VultureSquad(M3chSquad m3chSquad) {
        this.msquad = m3chSquad;
    }

    public void addUnit(Unit u) {
        this.myVultures.add(new Vulture(u));
    }

    public void removeUnit(Unit u) {
        Vulture tr = null;
        for (Vulture v : this.myVultures) {
            if (v.unit.getID() != u.getID()) continue;
            tr = v;
            break;
        }
        if (tr != null) {
            this.myVultures.remove(tr);
        }
    }

    public void onFrame() {
        for (Vulture vulture : this.myVultures) {
            --vulture.timeNeeded;
            if (vulture.timeNeeded > 0) continue;
            Unit unit = vulture.unit;
            double nearestDistance = Double.POSITIVE_INFINITY;
            ROUnit closestEnemy = UnitUtils.getClosest(unit, this.msquad.everyNearbyUnits());
            Position medianpos = this.msquad.getMedian();
            this.mGame.drawCircleMap(medianpos, 10, Color.BLUE, false);
            double dist = unit.getTilePosition().getDistance(medianpos);
            if (this.shouldPoop(unit, closestEnemy)) {
                vulture.timeNeeded = 13;
                unit.useTech(TechType.SPIDER_MINES, unit.getPosition());
                continue;
            }
            if (dist > 11.0 && medianpos != null && medianpos != Position.INVALID) {
                if (this.msquad.master.time % 20L != 0L) continue;
                unit.move(medianpos);
                continue;
            }
            if (this.msquad.everyNearbyGroundUnits().size() != 0) {
                ROUnit targ = null;
                int bestprio = -1000;
                for (ROUnit ue : this.msquad.everyNearbyUnits()) {
                    if (ue.getDistance(unit) >= 340 || this.getVPriority(ue, unit, false) <= bestprio) continue;
                    bestprio = this.getVPriority(ue, unit, false);
                    targ = ue;
                }
                for (ROUnit ue : this.msquad.master.enemyBuildings) {
                    if (ue.getDistance(unit) >= 250 || this.getVPriority(ue, unit, false) <= bestprio) continue;
                    bestprio = this.getVPriority(ue, unit, false);
                    targ = ue;
                }
                Unit k = unit.getTarget();
                if (targ != null && this.msquad.master.time % 20L == 0L && unit.getTarget() == null && unit.getOrderTarget() == null || targ != null && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID()) {
                    unit.rightClick(targ);
                    continue;
                }
                if (!unit.isIdle()) continue;
                unit.move(medianpos);
                continue;
            }
            if (unit.getTargetPosition() == this.msquad.goal && !unit.isIdle() || !(unit.getTilePosition().getDistance(this.msquad.goal) > 4.0)) continue;
            unit.attackMove(this.msquad.goal);
        }
    }

    private Set<EnemyUnit> doFilter(Set<ROUnit> close_enemies) {
        HashSet<EnemyUnit> ret = new HashSet<EnemyUnit>();
        for (ROUnit rou : close_enemies) {
            Position p = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
            double dist = UnitUtils.getClosestDistance(p, this.msquad.tank_squad.myTanks);
            if (!(dist < 192.0) && !((double)rou.getGroundRange() <= dist)) continue;
            ret.add(new EnemyUnit(rou));
        }
        return ret;
    }

    public void moveTo(Position p) {
        for (Vulture vulture : this.myVultures) {
            vulture.unit.attackMove(p);
        }
    }

    private boolean shouldPoop(Unit vulture, ROUnit closestEnemy) {
        if (closestEnemy == null) {
            return false;
        }
        if (!this.mGame.self().hasResearched(TechType.SPIDER_MINES)) {
            return false;
        }
        int frameNum = Game.getInstance().getFrameCount() % 1;
        Position p = vulture.getPosition();
        this.msquad.myUnits.remove(vulture);
        double dist_friend = UnitUtils.getClosestDistance(p, this.msquad.myUnits);
        this.msquad.myUnits.add(vulture);
        for (BaseLocation bl : Bwta.getInstance().getBaseLocations()) {
            if (!(bl.getPosition().getDistance(vulture.getPosition()) < 600.0)) continue;
            return false;
        }
        Position p2 = closestEnemy.isVisible() ? closestEnemy.getPosition() : closestEnemy.getLastKnownPosition();
        double dist_enemy = vulture.getPosition().getDistance(p2);
        return frameNum == 0 && dist_friend > 120.0 && dist_enemy < 280.0;
    }

    public int getVPriority(ROUnit u, Unit me, boolean harass) {
        int bonus = 0;
        bonus = (int)((double)bonus + 1.0 / (double)(u.getHitPoints() + 2));
        UnitType t = u.getType();
        if (harass) {
            if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) {
                return 1;
            }
            return 0 + bonus;
        }
        if (u.isInRange(me)) {
            bonus = (int)((double)bonus + 0.5);
        }
        if (t == UnitType.PROTOSS_INTERCEPTOR) {
            return -10;
        }
        if (t == UnitType.ZERG_SUNKEN_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) {
            return 1 + bonus;
        }
        if (t.isFlyer()) {
            return -10;
        }
        if (t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) {
            return 2;
        }
        if (t == UnitType.PROTOSS_ZEALOT) {
            return 8;
        }
        if (t == UnitType.PROTOSS_HIGH_TEMPLAR) {
            return 10;
        }
        if (t == UnitType.PROTOSS_DRAGOON) {
            return 4;
        }
        if (u.canAttack(me)) {
            return 4 + bonus;
        }
        if (t.canAttack() || t.isSpellcaster()) {
            return 2 + bonus;
        }
        if (t.isBuilding()) {
            return 1;
        }
        return 0 + bonus;
    }
}

