/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.Utils;
import edu.berkeley.nlp.starcraft.util.Vector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;

public class TileTracker {
    public Map<TilePosition, Integer> barrierTimeStamp = new HashMap<TilePosition, Integer>();

    public Set<TilePosition> getBarrierTiles(TilePosition goal, Set<Unit> myMen) {
        HashSet<TilePosition> barrier_tps = new HashSet<TilePosition>();
        if (goal == null || myMen.size() == 0) {
            return barrier_tps;
        }
        LinkedList<TilePosition> q = new LinkedList<TilePosition>();
        HashSet<TilePosition> seen = new HashSet<TilePosition>();
        for (Unit u : myMen) {
            q.add(new TilePosition(u.getPosition()));
            seen.add(new TilePosition(u.getPosition()));
        }
        while (!q.isEmpty()) {
            TilePosition tp = (TilePosition)q.poll();
            this.updateBarrierTile(tp);
            if (this.shouldAddToBarrier(tp, goal, myMen, barrier_tps)) {
                barrier_tps.add(tp);
            }
            for (TilePosition succ : Arrays.asList(tp.add(0, 1), tp.add(1, 0), tp.add(0, -1), tp.add(-1, 0))) {
                if (!this.shouldContinueExplore(succ, goal, myMen, seen)) continue;
                q.add(succ);
                seen.add(succ);
            }
        }
        return barrier_tps;
    }

    private boolean shouldContinueExplore(TilePosition tp, TilePosition goal, Set<Unit> myMen, Set<TilePosition> seen) {
        if (seen.contains(tp)) {
            return false;
        }
        for (Unit tank : myMen) {
            double sightrange = tank.getType().sightRange();
            Position my_pos = tank.getPosition();
            Position tp_pos = new Position(tp);
            Position goal_pos = new Position(goal);
            if (!(my_pos.getDistance(tp_pos) <= sightrange * 1.5)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldAddToBarrier(TilePosition tp, TilePosition goal, Set<Unit> myMen, Set<TilePosition> seen) {
        if (seen.contains(tp)) {
            return false;
        }
        Game g = Game.getInstance();
        for (Unit tank : myMen) {
            boolean near_sight;
            Vector goal_to_tp;
            double sightrange = tank.getType().sightRange();
            Position my_pos = tank.getPosition();
            Position tp_pos = new Position(tp);
            Position goal_pos = new Position(goal);
            boolean onpath = false;
            Vector my_to_tp = new Vector(my_pos, tp_pos).normalize();
            if (my_to_tp.dot(goal_to_tp = new Vector(goal_pos, tp_pos).normalize()) < -0.6) {
                onpath = true;
            }
            boolean bl = near_sight = tp_pos.getDistance(my_pos) <= 1.3 * sightrange;
            if (g.isVisible(tp) || !onpath || !near_sight || !Utils.isWalkable(tp)) continue;
            return true;
        }
        return false;
    }

    public void drawTiles(Collection<TilePosition> stuff) {
    }

    public void updateBarrierTile(TilePosition tp) {
        if (!Game.getInstance().isVisible(tp) && !this.barrierTimeStamp.containsKey(tp)) {
            this.barrierTimeStamp.put(tp, 0);
        }
        if (Game.getInstance().isVisible(tp) && this.barrierTimeStamp.containsKey(tp)) {
            this.barrierTimeStamp.remove(tp);
            this.barrierTimeStamp.put(tp, Game.getInstance().getFrameCount());
        }
    }

    public TilePosition getOldest(Set<TilePosition> barriers) {
        if (this.barrierTimeStamp.size() > 300) {
            this.cleanUp();
        }
        TilePosition ret = null;
        int frameNum = Integer.MAX_VALUE;
        for (TilePosition tp : barriers) {
            int lastFrame = this.getTime(tp);
            if (lastFrame >= frameNum) continue;
            frameNum = lastFrame;
            ret = tp;
        }
        return ret;
    }

    public void drawStamps() {
        for (TilePosition tp : this.barrierTimeStamp.keySet()) {
            Game.getInstance().drawCircleMap(new Position(tp), 1, Color.ORANGE, true);
        }
    }

    private void cleanUp() {
        HashSet<TilePosition> toRemove = new HashSet<TilePosition>();
        for (TilePosition tp : this.barrierTimeStamp.keySet()) {
            if (this.barrierTimeStamp.get(tp) >= Game.getInstance().getFrameCount() - 300) continue;
            toRemove.add(tp);
        }
        for (TilePosition tp : toRemove) {
            this.barrierTimeStamp.remove(tp);
        }
    }

    public Map<Unit, HashSet<TilePosition>> tank_to_tile_map(Set<TilePosition> tiles, Set<Unit> tanks) {
        HashMap<Unit, HashSet<TilePosition>> ret = new HashMap<Unit, HashSet<TilePosition>>();
        for (Unit tank : tanks) {
            ret.put(tank, new HashSet());
            for (TilePosition tp : tiles) {
                double sightrange = tank.getType().sightRange();
                Position tp_pos = new Position(tp);
                Position tank_pos = tank.getPosition();
                if (!(tp_pos.getDistance(tank_pos) <= sightrange * 1.3)) continue;
                ((HashSet)ret.get(tank)).add(tp);
            }
        }
        return ret;
    }

    public boolean areTilesSafe(Unit tank, Map<Unit, HashSet<TilePosition>> tank_to_tile_map, int slack) {
        HashSet<TilePosition> tiles = tank_to_tile_map.get(tank);
        if (tiles.size() == 0) {
            return true;
        }
        for (TilePosition tp : tiles) {
            if (!this.barrierTimeStamp.containsKey(tp) || Game.getInstance().getFrameCount() - this.barrierTimeStamp.get(tp) <= slack) continue;
            return false;
        }
        return true;
    }

    public int getTime(TilePosition tp) {
        if (this.barrierTimeStamp.containsKey(tp)) {
            return this.barrierTimeStamp.get(tp);
        }
        this.barrierTimeStamp.put(tp, 0);
        return 0;
    }
}

