/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.micropacket.EnemyUnit;
import undermind.micropacket.TargetSelectors;

public class TargetSelectionSandBox
implements Cerebrate {
    Player me = Game.getInstance().self();
    Set<Unit> myMen = new HashSet<Unit>();
    Set<EnemyUnit> theirMen = new HashSet<EnemyUnit>();

    @Override
    public void onFrame() {
        Map<Unit, EnemyUnit> target_map = TargetSelectors.getTarget_ranged_simple(this.myMen, this.theirMen);
        for (Unit myMan : this.myMen) {
            EnemyUnit target = target_map.get(myMan);
            if (target == null) continue;
            myMan.attack(target.getUnit());
        }
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        if (unit.getPlayer() == this.me && unit.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
            Unit marine = UnitUtils.assumeControl(unit);
            this.myMen.add(marine);
        }
        if (!unit.getPlayer().equals(this.me)) {
            this.theirMen.add(new EnemyUnit(unit));
        }
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        if (unit.getPlayer() == this.me && unit.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
            this.myMen.remove(unit);
        }
        if (!unit.getPlayer().equals(this.me)) {
            this.theirMen.remove(unit);
        }
    }

    @Override
    public void onEnd(boolean isWinnerFlag) {
    }

    @Override
    public void onSendText(String text) {
    }

    @Override
    public void onReceiveText(Player player, String text) {
    }

    @Override
    public void onPlayerLeft(Player player) {
    }

    @Override
    public void onNukeDetect(Position position) {
    }

    @Override
    public void onUnitCreate(ROUnit unit) {
    }

    @Override
    public void onUnitHide(ROUnit unit) {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
    }

    @Override
    public void onDroppedConnection() {
    }
}

