/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.micropacket.TileTracker;

public class TankvsTank
implements Cerebrate {
    Player me = Game.getInstance().self();
    Set<Unit> myMen = new HashSet<Unit>();
    Set<ROUnit> theirMen = new HashSet<ROUnit>();
    TileTracker tile_tracker = new TileTracker();
    Position goal;

    @Override
    public void onFrame() {
        this.goal = UnitUtils.avePos(this.theirMen);
        Set<TilePosition> barrier = this.tile_tracker.getBarrierTiles(new TilePosition(this.goal), this.myMen);
        this.tile_tracker.drawTiles(barrier);
        TilePosition oldest = this.tile_tracker.getOldest(barrier);
        if (oldest != null) {
            Game.getInstance().drawCircleMap(new Position(oldest), 3, Color.RED, true);
        }
        int oldest_time = 0;
        if (oldest != null) {
            oldest_time = this.tile_tracker.barrierTimeStamp.get(oldest);
        }
        Map<Unit, HashSet<TilePosition>> tank_to_tile_map = this.tile_tracker.tank_to_tile_map(barrier, this.myMen);
        for (ROUnit enemy : this.theirMen) {
            Game.getInstance().drawCircleMap(enemy.getPosition(), enemy.getGroundRange(), Color.RED, false);
            Game.getInstance().drawCircleMap(enemy.getPosition(), enemy.getType().sightRange(), Color.BLUE, false);
        }
        for (Unit myMan : this.myMen) {
            Game.getInstance().drawCircleMap(myMan.getPosition(), 2, Color.GREEN, true);
            this.drawBox(myMan);
            Game.getInstance().drawCircleMap(myMan.getPosition(), myMan.getGroundRange(), Color.GREEN, false);
        }
        for (Unit tank : this.myMen) {
            if (!this.shouldSiege(tank)) continue;
            Game.getInstance().drawTextMap(tank.getPosition(), "1");
            this.siegeUp(tank);
        }
    }

    boolean shouldSiege(Unit tank) {
        for (ROUnit enemy : this.theirMen) {
            double hit_radius = enemy.getType().diagonalLength();
            if (!(tank.getDistance(enemy.getPosition()) <= 384.0 + hit_radius)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        Unit marine;
        if (unit.getPlayer() == this.me && unit.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
            marine = UnitUtils.assumeControl(unit);
            this.myMen.add(marine);
        }
        if (unit.getPlayer() == this.me && unit.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
            marine = UnitUtils.assumeControl(unit);
            this.myMen.add(marine);
        }
        if (!unit.getPlayer().equals(this.me)) {
            this.theirMen.add(unit);
        }
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        if (unit.getPlayer() == this.me) {
            this.myMen.remove(unit);
        }
        if (!unit.getPlayer().equals(this.me)) {
            this.theirMen.remove(unit);
        }
    }

    @Override
    public void onEnd(boolean isWinnerFlag) {
    }

    @Override
    public void onSendText(String text) {
    }

    @Override
    public void onReceiveText(Player player, String text) {
    }

    @Override
    public void onPlayerLeft(Player player) {
    }

    @Override
    public void onNukeDetect(Position position) {
    }

    @Override
    public void onUnitCreate(ROUnit unit) {
    }

    @Override
    public void onUnitHide(ROUnit unit) {
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
    }

    @Override
    public void onDroppedConnection() {
    }

    private void unsiege_and_forward(Unit tank) {
        if (tank.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
            this.siegeDown(tank);
        } else {
            tank.attackMove(this.goal);
        }
    }

    private int get_rank(Unit tank, ArrayList<Unit> tank_rank) {
        for (int i = 0; i < tank_rank.size(); ++i) {
            if (tank != tank_rank.get(i)) continue;
            Game.getInstance().drawTextMap(tank.getPosition(), "" + i);
            return i;
        }
        return 0;
    }

    private void siegeUp(Unit u) {
        if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
            u.useTech(TechType.TANK_SIEGE_MODE);
        }
    }

    private void siegeDown(Unit u) {
        if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
            u.useTech(TechType.TANK_SIEGE_MODE);
        }
    }

    private void drawBox(Unit u) {
        Position p = u.getPosition();
        Game.getInstance().drawBoxMap(p.x() - 16, p.y() - 16, p.x() + 16, p.y() + 16, Color.WHITE, false);
    }
}

