/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.micropacket.M3chSquad;
import undermind.micropacket.TileTracker;

public class TankSquad {
    double LAG_BUFFER = 3.0;
    int threatLevel = 0;
    double leap_frog_const = 0.9;
    TileTracker tile_tracker = new TileTracker();
    Set<TilePosition> barrier;
    TilePosition mostStaleTile;
    Map<Unit, HashSet<TilePosition>> tank_to_bartile_map;
    Set<TilePosition> tanks_siege_targets_positions = new HashSet<TilePosition>();
    M3chSquad msquad;
    Set<Unit> myTanks = new HashSet<Unit>();

    public TankSquad(M3chSquad mechSquad) {
        this.msquad = mechSquad;
    }

    public void addUnit(Unit u) {
        this.myTanks.add(u);
    }

    public void removeUnit(Unit u) {
        this.myTanks.remove(u);
    }

    void update_leapfrog_const() {
        for (Unit tank : this.myTanks) {
            if (tank.getGroundWeaponCooldown() > 0) {
                this.leap_frog_const = Math.sqrt(this.leap_frog_const + 0.01);
                continue;
            }
            if (Game.getInstance().getFrameCount() % 20 != 0) continue;
            this.leap_frog_const = Math.max(0.0, this.leap_frog_const - 0.005);
        }
    }

    public void onFrame() {
        for (Unit t : this.myTanks) {
            Position position = t.getPosition();
            if (!t.isLoaded() && position != Position.INVALID) continue;
            return;
        }
        this.updateState();
        this.update_leapfrog_const();
        double buffer = Math.min(this.msquad.confidence, 1.0) * 2.0;
        Game.getInstance().drawTextMap(new Position(this.getMedian().x(), this.getMedian().y() + 20), "leap_frog " + this.leap_frog_const);
        Game.getInstance().drawTextMap(new Position(this.getMedian().x(), this.getMedian().y() + 40), "buffer " + buffer);
        this.leapFrogMove();
    }

    void updateState() {
        this.barrier = this.tile_tracker.getBarrierTiles(this.getBarrierGoal(), this.myTanks);
        this.tile_tracker.drawTiles(this.barrier);
        this.set_Ebay();
        this.tank_to_bartile_map = this.tile_tracker.tank_to_tile_map(this.barrier, this.myTanks);
    }

    private void set_Ebay() {
        HashSet<TilePosition> together = new HashSet<TilePosition>();
        together.addAll(this.barrier);
        together.addAll(this.tanks_siege_targets_positions);
        TilePosition oldest = this.tile_tracker.getOldest(together);
        this.msquad.master.pleaseEbayHere = oldest != null ? new Position(oldest) : this.msquad.getAverage();
    }

    private TilePosition getBarrierGoal() {
        if (this.msquad.mover.pathToGoal != null && this.msquad.mover.pathToGoal.size() > 11) {
            Game.getInstance().drawLineMap(new Position(this.msquad.mover.pathToGoal.get(10)), this.msquad.getAverage(), Color.ORANGE);
            return this.msquad.mover.pathToGoal.get(10);
        }
        if (this.msquad.goal != null) {
            return new TilePosition(this.msquad.goal);
        }
        return null;
    }

    public Position getMedian() {
        return UnitUtils.medianPos(this.myTanks);
    }

    HashMap<Unit, HashSet<ROUnit>> tank_to_close_enemies() {
        HashMap<Unit, HashSet<ROUnit>> ret = new HashMap<Unit, HashSet<ROUnit>>();
        for (Unit tank : this.myTanks) {
            HashSet<ROUnit> toAdd = new HashSet<ROUnit>();
            ret.put(tank, toAdd);
            for (ROUnit enemy : this.msquad.everyNearbyGroundUnits()) {
                if (!(tank.getPosition().getDistance(enemy.getPosition()) < 500.0)) continue;
                toAdd.add(enemy);
            }
        }
        return ret;
    }

    ArrayList<Unit> sorted_tank_by_distance_to_goal() {
        HashMap crap = new HashMap();
        ArrayList<Integer> crapp = new ArrayList<Integer>();
        for (Unit tank : this.myTanks) {
            Integer key = (int)tank.getPosition().getDistance(this.msquad.goal);
            if (!crap.containsKey(key)) {
                crap.put(key, new HashSet());
            }
            crapp.add(key);
            ((HashSet)crap.get(key)).add(tank);
        }
        Object[] crappp = new Integer[crapp.size()];
        for (int i = 0; i < crapp.size(); ++i) {
            crappp[i] = (Integer)crapp.get(i);
        }
        Arrays.sort(crappp);
        ArrayList<Unit> ret = new ArrayList<Unit>();
        for (Object i : crappp) {
            for (Unit u : (HashSet)crap.get(i)) {
                ret.add(u);
            }
        }
        return ret;
    }

    public void leapFrogMove() {
        HashMap<Unit, HashSet<ROUnit>> tank_enemy = this.tank_to_close_enemies();
        ArrayList<Unit> tank_rank = this.sorted_tank_by_distance_to_goal();
        for (Unit tank : this.myTanks) {
            if (this.allTooClose(tank_enemy.get(tank), tank) || this.allMelee(tank_enemy.get(tank))) {
                Game.getInstance().drawTextMap(tank.getPosition().add(0, 10), "1");
                this.siegeDown(tank);
                continue;
            }
            if (this.hardSiegeReasonable(tank, tank_enemy.get(tank))) {
                Game.getInstance().drawTextMap(tank.getPosition().add(0, 10), "2");
                this.siegeUp(tank);
                continue;
            }
            int rank = this.get_rank(tank, tank_rank);
            if ((double)rank <= (double)this.myTanks.size() * this.leap_frog_const && this.sufficientlyFar(tank)) {
                Game.getInstance().drawTextMap(tank.getPosition().add(0, 10), "3");
                this.siegeUp(tank);
                continue;
            }
            Game.getInstance().drawTextMap(tank.getPosition().add(0, 10), "4");
            this.unsiege_and_move(tank, this.msquad.goal);
        }
    }

    private boolean allMelee(HashSet<ROUnit> hashSet) {
        if (hashSet.size() == 0) {
            return false;
        }
        for (ROUnit rou : hashSet) {
            if (rou.getGroundRange() <= 96) continue;
            return false;
        }
        return true;
    }

    private boolean sufficientlyFar(Unit tank) {
        return tank.getPosition().getDistance(this.msquad.getAverage()) > 1.0 / (0.5 + this.msquad.confidence) * 200.0;
    }

    boolean shouldSiegeUnit(Unit tank, ROUnit enemy) {
        int range;
        Position p;
        double buffer = Math.min(this.msquad.confidence, 1.3) * (4.0 + this.LAG_BUFFER) - 1.0;
        double hit_radius = enemy.getType().diagonalLength();
        Position position = p = enemy.isVisible() ? enemy.getPosition() : enemy.getLastKnownPosition();
        if (tank.getDistance(p) < 160.0 || enemy.getGroundRange() < 96) {
            return false;
        }
        int n = range = enemy.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE) ? 384 : enemy.getGroundRange();
        if (range < 384) {
            return tank.getDistance(p) <= 384.0 + hit_radius;
        }
        return tank.getDistance(p) <= 384.0 + hit_radius * buffer;
    }

    private ROUnit getClosest(Unit tank) {
        ROUnit ret = null;
        double dist = 2.147483647E9;
        for (ROUnit u : this.msquad.everyNearbyGroundUnits()) {
            Position position = u.isVisible() ? u.getPosition() : u.getLastKnownPosition();
            Position p = position;
            if (!(p.getDistance(tank.getPosition()) < dist)) continue;
            ret = u;
            dist = u.getPosition().getDistance(tank.getPosition());
        }
        return ret;
    }

    private boolean hardSiegeReasonable(Unit tank, HashSet<ROUnit> hashSet) {
        double slack = -400.0 * this.msquad.confidence + 2000.0;
        boolean nearbyUnseenTilesSafe = this.tile_tracker.areTilesSafe(tank, this.tank_to_bartile_map, (int)Math.max(0.0, slack));
        if (!nearbyUnseenTilesSafe) {
            return true;
        }
        for (ROUnit u : hashSet) {
            if (!this.shouldSiegeUnit(tank, u)) continue;
            Position p = u.isVisible() ? u.getPosition() : u.getLastKnownPosition();
            this.tanks_siege_targets_positions.add(new TilePosition(p));
            Game.getInstance().drawLineMap(tank.getPosition(), u.getLastKnownPosition(), Color.RED);
            return true;
        }
        return false;
    }

    private boolean allTooClose(HashSet<ROUnit> enemy, Unit tank) {
        if (enemy.size() == 0) {
            return false;
        }
        boolean ret = true;
        for (ROUnit ene : enemy) {
            Position position = ene.isVisible() ? ene.getPosition() : ene.getLastKnownPosition();
            Position p = position;
            if (!(p.getDistance(tank.getPosition()) > 96.0)) continue;
            ret = false;
        }
        return ret;
    }

    private void unsiege_and_move(Unit tank, Position p) {
        if (tank.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
            this.siegeDown(tank);
        } else {
            tank.attackMove(p);
        }
    }

    private int get_rank(Unit tank, ArrayList<Unit> tank_rank) {
        for (int i = 0; i < tank_rank.size(); ++i) {
            if (tank != tank_rank.get(i)) continue;
            return i;
        }
        return 0;
    }

    private void siegeUp(Unit u) {
        if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
            u.useTech(TechType.TANK_SIEGE_MODE);
        }
    }

    private void siegeDown(Unit u) {
        if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
            u.useTech(TechType.TANK_SIEGE_MODE);
        }
    }

    public void groupSiege() {
        for (Unit tank : this.myTanks) {
            if (tank.getPosition().getDistance(this.msquad.goal) < 150.0) {
                this.siegeUp(tank);
                continue;
            }
            this.unsiege_and_move(tank, this.msquad.goal);
        }
    }

    public Position getAverage() {
        return UnitUtils.avePos(this.myTanks);
    }
}

