/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.Vector;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.Unit;

public class Particle {
    private Random random = new Random();
    public Set<String> fields = new HashSet<String>();
    public Vector net_force = Vector.ZERO;
    public Vector location = null;
    public Vector prev_location = null;
    public Vector goal_location = null;

    public void updateLocation(Unit u) {
        this.location = new Vector(u.getPosition());
    }

    public void updateLocation(Position p) {
        this.location = new Vector(p);
    }

    public Vector getNetForce(Collection<Particle> particles) {
        Vector ret = new Vector(0.0, 0.0);
        for (Particle p : particles) {
            if (p == this) continue;
            ret = ret.add(p.exertField(this));
        }
        this.net_force = ret;
        return ret;
    }

    public Vector exertField(Particle particle) {
        Vector ret = Vector.ZERO;
        for (String func : this.fields) {
            if (func.equals("attract")) {
                ret = ret.add(this.exertAttractionField(particle));
            }
            if (func.equals("beacon")) {
                ret = ret.add(this.exertBeaconField(particle));
            }
            if (func.equals("jitter")) {
                ret = ret.add(this.exertJitterField(particle));
            }
            if (!func.equals("sheep")) continue;
            ret = ret.add(this.exertSheepField(particle));
        }
        return ret;
    }

    public void setAttactionField() {
        this.fields.add("attract");
    }

    public void unsetAttractionField() {
        this.fields.remove("attract");
    }

    public Vector exertAttractionField(Particle particle) {
        double min_dist = 50.0;
        double repulse = 2.5;
        double attract = 100.0;
        double magnify2 = 1.0;
        Vector direction = new Vector(particle.location.toPosition(), this.location.toPosition()).normalize();
        double distance = new Vector(particle.location.toPosition(), this.location.toPosition()).length();
        double strength1 = repulse * (distance - min_dist);
        double strength2 = attract * 1.0 / distance;
        double strength = magnify2 * Math.min(strength1, strength2);
        return direction.scale(strength);
    }

    public void setBeaconField() {
        this.fields.add("beacon");
    }

    public void unsetBeaconField() {
        this.fields.remove("beacon");
    }

    public Vector exertBeaconField(Particle particle) {
        double magnify1 = 50.0;
        Vector direction = new Vector(particle.location.toPosition(), this.location.toPosition()).normalize();
        return direction.scale(magnify1);
    }

    public void setJitterField() {
        this.fields.add("jitter");
    }

    public void unsetJitterField() {
        this.fields.remove("jitter");
    }

    public Vector exertJitterField(Particle particle) {
        boolean fire;
        double magnify1 = -10.0;
        double frequency = 0.01;
        if (this.location.equals(this.prev_location)) {
            magnify1 -= 50.0;
            frequency += 0.01;
            Game.getInstance().drawCircleMap(this.location.toPosition(), 2, Color.RED, true);
        } else {
            this.prev_location = this.location;
        }
        boolean bl = fire = this.random.nextDouble() < frequency;
        if (fire) {
            Vector direction = new Vector(particle.location.toPosition(), this.location.toPosition()).normalize();
            return direction.scale(magnify1);
        }
        return Vector.ZERO;
    }

    public void setSheepField(Position goal) {
        if (goal != null) {
            this.fields.add("sheep");
            this.goal_location = new Vector(goal);
        }
    }

    public void unsetSheepField() {
        this.fields.remove("sheep");
    }

    public Vector exertSheepField(Particle particle) {
        double magnify1 = 150.0;
        if (particle.location == null) {
            Game.getInstance().printf("O M G!!!", null);
        }
        Position p1 = particle.location.toPosition();
        Position p2 = this.location.toPosition();
        double distance = new Vector(p1, p2).length();
        double scaling = 1.0 / Math.sqrt(distance);
        Vector ret = this.net_force.normalize().scale(scaling).scale(magnify1);
        if (this.location.distanceTo(this.goal_location) < particle.location.distanceTo(this.goal_location)) {
            return ret;
        }
        return Vector.ZERO;
    }

    public Vector brownianMotion() {
        double magnify1 = 300.0;
        return new Vector(1.0, 0.0).rotateCCW(Math.PI * 2 * this.random.nextDouble());
    }
}

