/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.Collection;
import java.util.HashMap;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;

public class MicroUtil {
    public static final int ORDERGAP = 30;
    private HashMap<Unit, Integer> lastOrderFrame = new HashMap();

    public void rightClickWrapper(Unit unit, TilePosition pos) {
        int frame = Game.getInstance().getFrameCount();
        if (this.lastOrderFrame.containsKey(unit)) {
            if (this.lastOrderFrame.get(unit) - 30 > frame) {
                this.lastOrderFrame.put(unit, frame);
                unit.rightClick(pos);
            }
        } else {
            this.lastOrderFrame.put(unit, frame);
            unit.rightClick(pos);
        }
    }

    public static boolean shouldStimSimple(Collection<Unit> our_marines, Collection<Unit> our_medics, Collection<ROUnit> enemies) {
        long starttime = System.currentTimeMillis();
        int total = our_marines.size();
        int cand = 0;
        int alreadystimmed = 0;
        Position median = UnitUtils.medianPos(our_marines);
        if (enemies.size() == 0) {
            return false;
        }
        double d = UnitUtils.getClosest(median, enemies).getDistance(median);
        if (d < 300.0) {
            block0: for (Unit marine : our_marines) {
                if (marine.isStimmed()) {
                    ++alreadystimmed;
                }
                for (Unit medic : our_medics) {
                    if (marine.getDistance(medic) >= 80 || marine.getHitPoints() < 30) continue;
                    ++cand;
                    continue block0;
                }
            }
        } else {
            return false;
        }
        if (System.currentTimeMillis() - starttime > 5L) {
            Game.getInstance().printf("Stim took" + (System.currentTimeMillis() - starttime), new Object[0]);
        }
        return cand > total / 2 && (double)alreadystimmed <= (double)total / 2.0;
    }

    private static boolean isThreat(Collection<ROUnit> possible_threats) {
        for (ROUnit u : possible_threats) {
            if (u.getType().isWorker() || !u.getType().canAttack()) continue;
            return true;
        }
        return false;
    }
}

