/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.MicroManager;
import undermind.micropacket.Squad;
import undermind.micropacket.VultureSquad;

public class MechSquad
extends Squad {
    int lastSiege;
    Game mGame;
    Random rgen;
    Position medianpos;
    public static int siegeRange = 12;
    VultureSquad vulture_squad;
    double nearestDistance;
    ROUnit closestEnemy;
    double closestEnemyd;
    Set<Unit> myTanks = new HashSet<Unit>();
    Set<ROUnit> ground_enemies_close_to_tank = new HashSet<ROUnit>();
    Set<ROUnit> air_enemies_close_to_tank = new HashSet<ROUnit>();

    public MechSquad(MicroManager micro) {
        super(micro);
        this.type = "mech";
        this.unitTypes.add(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
        this.unitTypes.add(UnitType.TERRAN_SIEGE_TANK_TANK_MODE);
        this.unitTypes.add(UnitType.TERRAN_GOLIATH);
        this.unitTypes.add(UnitType.TERRAN_VULTURE);
        this.lastSiege = 0;
        this.mGame = Game.getInstance();
        this.rgen = new Random();
    }

    public void synchStates() {
        this.myTanks.clear();
        for (Unit u : this.myUnits) {
            if (!u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) && !u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) continue;
            this.myTanks.add(u);
        }
        HashSet<ROUnit> enemy_air = new HashSet<ROUnit>();
        HashSet<ROUnit> enemy_ground = new HashSet<ROUnit>();
        for (ROUnit rou : this.master.allVisibleEnemies) {
            if (rou.isFlying()) {
                enemy_air.add(rou);
            }
            if (rou.isFlying()) continue;
            enemy_ground.add(rou);
        }
        for (Unit tank : this.myTanks) {
            Object closest_air = UnitUtils.getClosest(tank, enemy_air);
            Object closest_ground = UnitUtils.getClosest(tank, enemy_ground);
            if (closest_air != null && tank.getPosition().getDistance(closest_air.getPosition()) < 416.0) {
                this.air_enemies_close_to_tank.add((ROUnit)closest_air);
            }
            if (closest_ground == null || !(tank.getPosition().getDistance(closest_ground.getPosition()) < 384.0)) continue;
            this.air_enemies_close_to_tank.add((ROUnit)closest_ground);
        }
        ++this.lastSiege;
        this.computeMedianPosition();
        this.mGame.drawTextMap(this.medianpos, "avepos");
    }

    @Override
    public void onFrame() {
        this.synchStates();
        for (Unit unit : this.myUnits) {
            Position p = unit.getPosition();
            if (p == Position.INVALID) {
                this.mGame.printf("WARNING -- dead unit in a squad!", new Object[0]);
                continue;
            }
            this.nearestDistance = Double.POSITIVE_INFINITY;
            this.closestEnemy = UnitUtils.getClosest(unit, this.master.allVisibleEnemies);
            this.closestEnemyd = UnitUtils.getClosestDistance(unit, this.master.allVisibleEnemies);
            if (this.closestEnemy != null && (this.closestEnemy.isCloaked() || this.closestEnemy.isBurrowed())) {
                this.master.pleaseScanHere = this.closestEnemy.getPosition();
            }
            if (this.closestEnemy != null) {
                this.nearestDistance = unit.getTilePosition().getDistance(this.closestEnemy.getPosition());
            }
            if (unit.getType().equals(UnitType.TERRAN_VULTURE)) {
                this.vulture_squad.onFrame();
            }
            this.tankMicro(unit);
            this.goliathMicro(unit);
        }
    }

    public void tankMicro(Unit unit) {
        if (unit.getType() == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || unit.getType() == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) {
            boolean notjustair = false;
            for (ROUnit en : this.master.allVisibleEnemies) {
                if (en.isFlying() || !(unit.getTilePosition().getDistance(en.getTilePosition()) < 16.0)) continue;
                notjustair = true;
                break;
            }
            double distance = Double.POSITIVE_INFINITY;
            if (this.closestEnemy != null) {
                distance = unit.getTilePosition().getDistance(this.closestEnemy.getTilePosition());
            }
            double hdist = Double.POSITIVE_INFINITY;
            if (this.master.hotspot != null && this.master.hotspot.pos != Position.INVALID) {
                hdist = unit.getTilePosition().getDistance(this.master.hotspot.pos);
            }
            if (unit.isIdle() && unit.getTilePosition().getDistance(this.goal) < 6.0 || hdist < (double)siegeRange || this.master.allVisibleEnemies.size() != 0 && this.closestEnemy != null && (!this.closestEnemy.getType().isBuilding() && distance < 15.0 || this.closestEnemy.getType().isBuilding() && (this.closestEnemy.getType().canAttack() || this.closestEnemy.getType() == UnitType.TERRAN_BUNKER || this.closestEnemy.getType().isSpellcaster()) && distance < (double)siegeRange) && notjustair) {
                if (!unit.isSieged()) {
                    unit.siege();
                }
                int k = unit.getHitPoints();
                this.lastSiege = 0;
            } else if (unit.getTargetPosition() != this.goal && unit.getTilePosition().getDistance(this.goal) > 6.0) {
                if (unit.isSieged() && !unit.isAttacking() && unit.isIdle() && this.lastSiege >= 100) {
                    unit.unsiege();
                } else if (!unit.isSieged()) {
                    double dist = unit.getTilePosition().getDistance(this.medianpos);
                    double d2 = unit.getTargetPosition().getDistance(this.medianpos);
                    if (dist > 12.0) {
                        if (d2 > 600.0) {
                            unit.attackMove(this.medianpos);
                        }
                    } else {
                        unit.attackMove(this.goal);
                    }
                }
            }
        }
    }

    public void goliathMicro(Unit unit) {
        if (unit.getType() == UnitType.TERRAN_GOLIATH) {
            if (this.master.allVisibleEnemies.size() != 0 && this.closestEnemy != null && (!this.closestEnemy.getType().isBuilding() && unit.getTilePosition().getDistance(this.closestEnemy.getPosition()) < 7.0 || this.closestEnemy.getType().isBuilding() && (this.closestEnemy.getType().canAttack() || this.closestEnemy.getType() == UnitType.TERRAN_BUNKER) && unit.getTilePosition().getDistance(this.closestEnemy.getPosition()) < 9.0) && (this.closestEnemy.getType().canAttack() || this.closestEnemy.getType().isSpellcaster())) {
                ROUnit targ = null;
                int bestprio = -1000;
                for (ROUnit ue : this.master.allVisibleEnemies) {
                    if (ue.getDistance(unit) >= 450 || this.master.getGPriority(ue, unit, false) <= bestprio || ue.getDistance(unit) >= 300) continue;
                    bestprio = this.master.getGPriority(ue, unit, false);
                    targ = ue;
                }
                for (ROUnit ue : this.master.enemyBuildings) {
                    if (ue.getDistance(unit) >= 550 || this.master.getGPriority(ue, unit, false) <= bestprio || ue.getDistance(unit) >= 300) continue;
                    bestprio = this.master.getGPriority(ue, unit, false);
                    targ = ue;
                }
                Unit k = unit.getTarget();
                if (targ != null && bestprio >= 0 && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID()) {
                    unit.rightClick(targ);
                } else if (targ == null && k == null && unit.getOrderTarget() == null && this.closestEnemyd > 280.0) {
                    unit.attackMove(this.goal);
                }
            } else {
                double dist = unit.getTilePosition().getDistance(this.medianpos);
                double d2 = unit.getTargetPosition().getDistance(this.medianpos);
                Unit closestTank = null;
                double closestTankD = Double.NEGATIVE_INFINITY;
                double orderDistanceToTank = 0.0;
                for (Unit u2 : this.myUnits) {
                    if (u2.getType() != UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE && u2.getType() != UnitType.TERRAN_SIEGE_TANK_TANK_MODE || !((double)u2.getDistance(unit) > closestTankD)) continue;
                    closestTank = u2;
                    closestTankD = u2.getDistance(unit);
                    orderDistanceToTank = unit.getTargetPosition().getDistance(u2.getPosition());
                }
                if (dist > 4.0 && this.medianpos != null && this.medianpos != Position.INVALID) {
                    if (d2 > 70.0) {
                        unit.attackMove(this.medianpos);
                    }
                } else {
                    unit.attackMove(this.goal);
                }
            }
        }
    }

    @Override
    public void addUnit(Unit unit) {
        this.myUnits.add(unit);
    }

    public void computeMedianPosition() {
        this.medianpos = null;
        ArrayList<Unit> alist = new ArrayList<Unit>();
        for (Unit unit : this.myUnits) {
            if (unit.isLoaded() || unit.getType() != UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE && unit.getType() != UnitType.TERRAN_SIEGE_TANK_TANK_MODE) continue;
            alist.add(unit);
        }
        this.medianpos = UnitUtils.medianPos(alist);
        if (this.medianpos == null || this.medianpos == Position.INVALID) {
            ArrayList<Unit> alist2 = new ArrayList<Unit>();
            for (Unit unit : this.myUnits) {
                if (unit.isLoaded()) continue;
                alist2.add(unit);
            }
            this.medianpos = UnitUtils.medianPos(alist2);
        }
    }
}

