/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.HashMap;
import java.util.HashSet;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.micropacket.EnemyUnit;

public class MarineTargetSelection
implements Cerebrate {
    Player me = Game.getInstance().self();
    HashSet<Unit> marines = new HashSet();
    HashMap<ROUnit, EnemyUnit> unit_to_hp_map = new HashMap();
    HashMap<Unit, Integer> cooldown_map = new HashMap();
    Unit tank = null;

    @Override
    public void onStart() {
    }

    @Override
    public void onFrame() {
        if (Game.getInstance().getFrameCount() % 5 == 0) {
            for (ROUnit u : this.unit_to_hp_map.keySet()) {
                this.unit_to_hp_map.get(u).synch();
                this.unit_to_hp_map.get(u).print();
            }
            for (Unit marine : this.marines) {
                Game.getInstance().drawTextMap(marine.getPosition(), "" + marine.getDamagePerShot(marine));
                ROUnit target = this.targetSelectSimple(marine, this.unit_to_hp_map);
                if (!marine.isAttackFrame()) {
                    int cur = this.cooldown_map.get(marine) - 1;
                    this.cooldown_map.remove(marine);
                    this.cooldown_map.put(marine, cur);
                }
                if (target == null || this.cooldown_map.get(marine) > 0) continue;
                Game.getInstance().drawLineMap(marine.getPosition(), target.getPosition(), Color.RED);
                marine.attack(target);
                this.cooldown_map.remove(marine);
                this.cooldown_map.put(marine, 3);
            }
        }
    }

    private ROUnit targetSelectSimple(Unit marine, HashMap<ROUnit, EnemyUnit> unit_to_hp_map2) {
        ROUnit ret = null;
        double bestLife = 2.147483647E9;
        for (ROUnit enemy : unit_to_hp_map2.keySet()) {
            double life;
            if (!marine.isInRange(enemy) || !((life = unit_to_hp_map2.get(enemy).getLife()) > 0.0) || !(life < bestLife)) continue;
            ret = enemy;
            bestLife = life;
        }
        if (ret == null) {
            return ret;
        }
        unit_to_hp_map2.get(ret).getHit(marine);
        return ret;
    }

    @Override
    public void onEnd(boolean isWinnerFlag) {
    }

    @Override
    public void onSendText(String text) {
    }

    @Override
    public void onReceiveText(Player player, String text) {
    }

    @Override
    public void onPlayerLeft(Player player) {
    }

    @Override
    public void onNukeDetect(Position position) {
    }

    @Override
    public void onUnitCreate(ROUnit unit) {
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
        if (unit.getPlayer() == this.me && unit.getType().equals(UnitType.TERRAN_MARINE)) {
            this.marines.remove(unit);
            this.cooldown_map.remove(unit);
        }
        if (!unit.getPlayer().equals(this.me)) {
            this.unit_to_hp_map.remove(unit);
        }
    }

    @Override
    public void onUnitHide(ROUnit unit) {
    }

    @Override
    public void onUnitShow(ROUnit unit) {
        if (unit.getPlayer() == this.me && unit.getType().equals(UnitType.TERRAN_MARINE)) {
            Unit marine = UnitUtils.assumeControl(unit);
            this.marines.add(marine);
            this.cooldown_map.put(marine, 3);
        }
        if (!unit.getPlayer().equals(this.me)) {
            this.unit_to_hp_map.put(unit, new EnemyUnit(unit));
        }
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
    }

    @Override
    public void onDroppedConnection() {
    }
}

