/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.ArrayList;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.MicroManager;
import undermind.micropacket.MarineMovement;
import undermind.micropacket.MedicCombatMovement;
import undermind.micropacket.MicroUtil;
import undermind.micropacket.Squad;

public class MarineSquad
extends Squad {
    MarineMovement mover;
    MedicCombatMovement medic_mover;
    public ArrayList<Unit> marines = new ArrayList();
    public ArrayList<Unit> medics = new ArrayList();
    public ArrayList<Unit> vessels = new ArrayList();
    public ArrayList<Unit> tanks = new ArrayList();
    public long time = 0L;

    public MarineSquad(MicroManager micro) {
        super(micro);
        this.type = "bio";
        this.mover = new MarineMovement();
        this.medic_mover = new MedicCombatMovement();
        this.unitTypes.add(UnitType.TERRAN_MARINE);
        this.unitTypes.add(UnitType.TERRAN_MEDIC);
        if (!this.master.mechStrat) {
            this.unitTypes.add(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
        }
        if (!this.master.mechStrat) {
            this.unitTypes.add(UnitType.TERRAN_SIEGE_TANK_TANK_MODE);
        }
        if (!this.master.mechStrat) {
            this.unitTypes.add(UnitType.TERRAN_SCIENCE_VESSEL);
        }
    }

    @Override
    public void onFrame() {
        ++this.time;
        if (this.goal != null && this.goal != Position.INVALID) {
            this.mover.setGoalPosition(new TilePosition(this.goal));
        }
        Position ave = UnitUtils.avePos(this.myUnits);
        ROUnit closestEnemy = UnitUtils.getClosest(ave, this.master.allVisibleEnemies);
        double closestD = Double.POSITIVE_INFINITY;
        if (closestEnemy != null) {
            closestD = UnitUtils.pairDistance(this.myUnits, this.master.allVisibleEnemies);
        }
        for (ROUnit bldg : this.master.enemyBuildings) {
            double d = bldg.getDistance(ave);
            if (!bldg.isVisible() || !(d < closestD)) continue;
            closestD = d;
            closestEnemy = bldg;
        }
        Unit tr = null;
        for (Unit u : this.myUnits) {
            if (!u.isLoaded()) continue;
            tr = u;
        }
        if (tr != null) {
            this.removeUnit(tr);
        }
        if (closestEnemy == null || closestD > 150.0 || this.master.shouldforceFlee(this.myUnits)) {
            this.mover.onFrame();
            for (Unit t : this.tanks) {
                if (!t.isSieged()) continue;
                t.unsiege();
            }
        } else if (MicroUtil.shouldStimSimple(this.marines, this.medics, this.master.allVisibleEnemies)) {
            for (Unit u : this.marines) {
                if (u.getHitPoints() < 30) continue;
                u.useTech(TechType.STIM_PACKS);
            }
        } else {
            for (Unit u : this.marines) {
                if (!u.isIdle()) continue;
                u.attackMove(closestEnemy.getPosition());
            }
            this.medic_mover.moveMedics(this.marines);
            for (Unit t : this.tanks) {
                if (!(closestD < 320.0) || t.isSieged()) continue;
                t.siege();
            }
        }
        this.doVesselMicro();
    }

    public void doVesselMicro() {
        Position medianpos = UnitUtils.medianPos(this.myUnits);
        if (this.myUnits.size() != 0 && (medianpos == null || medianpos == Position.INVALID)) {
            medianpos = ((Unit)this.myUnits.get(0)).getLastKnownPosition();
        }
        for (Unit v : this.vessels) {
            boolean good = false;
            for (ROUnit e : this.master.allVisibleEnemies) {
                if (!e.isCloaked() || medianpos == null || !(e.getDistance(medianpos) < 450.0)) continue;
                v.move(e.getPosition());
                good = true;
                break;
            }
            if (!good && medianpos != null) {
                v.move(medianpos);
            }
            if (v.getEnergy() <= 110) continue;
            for (Unit u : this.myUnits) {
                if (u.getPlayer() != this.master.mGame.self() || u.getDistance(v) >= 200 || u.getHitPoints() >= u.getType().maxHitPoints() - 20) continue;
                v.useTech(TechType.DEFENSIVE_MATRIX, u);
            }
            if (v.getEnergy() <= 75 || !Game.getInstance().self().hasResearched(TechType.IRRADIATE)) continue;
            ROUnit bestTarget = null;
            int bestValue = 0;
            for (ROUnit e : this.master.allVisibleEnemies) {
                if (e.getDistance(v) >= 450) continue;
                int value = 0;
                if (UnitUtils.getClosestDistance(e, this.myUnits) < 60.0) continue;
                if (e.getType() == UnitType.ZERG_DEFILER || e.getType() == UnitType.ZERG_ULTRALISK) {
                    value += 3;
                }
                if (e.getType() == UnitType.ZERG_LURKER || e.getType() == UnitType.ZERG_MUTALISK) {
                    value += 2;
                }
                for (ROUnit e2 : this.master.allVisibleEnemies) {
                    if (e2.getDistance(e) >= 50 || !e2.getType().isOrganic()) continue;
                    ++value;
                }
                if (value <= bestValue) continue;
                bestValue = value;
                bestTarget = e;
            }
            if (bestTarget == null || bestValue <= 2) continue;
            v.useTech(TechType.IRRADIATE, bestTarget);
        }
    }

    @Override
    public void addUnit(Unit u) {
        this.myUnits.add(u);
        UnitType type = u.getType();
        if (type == UnitType.TERRAN_MARINE) {
            this.marines.add(u);
        } else if (type == UnitType.TERRAN_MEDIC) {
            this.medic_mover.addMedic(u);
            this.medics.add(u);
        }
        if (type == UnitType.TERRAN_MARINE || type == UnitType.TERRAN_MEDIC || type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) {
            this.mover.addMarine(u);
        }
        if (type == UnitType.TERRAN_SCIENCE_VESSEL) {
            this.vessels.add(u);
        }
        if (type == UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE || type == UnitType.TERRAN_SIEGE_TANK_TANK_MODE) {
            this.tanks.add(u);
        }
    }

    @Override
    public void removeUnit(Unit u) {
        Unit removeme = null;
        for (Unit unit : this.myUnits) {
            if (unit.getID() != u.getID()) continue;
            removeme = unit;
            break;
        }
        if (removeme != null) {
            this.vessels.remove(removeme);
            this.myUnits.remove(removeme);
            this.mover.removeMarine(removeme);
            this.marines.remove(removeme);
            this.medics.remove(removeme);
            this.tanks.remove(removeme);
        }
    }
}

