/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Vector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.AStarSearch;
import undermind.micropacket.BeaconParticle;
import undermind.micropacket.Particle;

public class MarineMovement {
    Player me = Game.getInstance().self();
    HashSet<Unit> marines = new HashSet();
    HashMap<Unit, Particle> marine_particle_map = new HashMap();
    Set<Particle> allParticles = new HashSet<Particle>();
    Position center = null;
    TilePosition centerTile = null;
    TilePosition goalTile = null;
    TilePosition curGoalTile = null;
    public AStarSearch pathfinder = new AStarSearch();
    public List<TilePosition> pathToGoal;
    BeaconParticle cursorParticle = new BeaconParticle();

    public MarineMovement() {
        this.allParticles.add(this.cursorParticle);
    }

    public void setGoalPosition(TilePosition p) {
        if (this.centerTile == null || this.centerTile.equals(Position.INVALID) || this.centerTile.x() == -1) {
            return;
        }
        if (this.pathToGoal == null || p != null && !p.equals(this.goalTile)) {
            this.goalTile = p;
            this.pathToGoal = this.pathfinder.getPath(this.centerTile, this.goalTile);
        }
    }

    public void onFrame() {
        for (Unit unit : this.marines) {
        }
        if (this.centerTile != null) {
            Game.getInstance().drawCircleMap(Position.centerOfTile(this.centerTile), 5, Color.ORANGE, true);
        }
        if (this.goalTile != null) {
            Game.getInstance().drawCircleMap(Position.centerOfTile(this.goalTile), 5, Color.BLUE, true);
        }
        if (Game.getInstance().getFrameCount() % 5 == 0) {
            this.updateParticles();
            this.updatePathing();
            this.moveMarines();
        }
    }

    private void updatePathing() {
        HashSet<Unit> realmarines = new HashSet<Unit>();
        for (Unit marine : this.marines) {
            if (!marine.isCompleted()) continue;
            realmarines.add(marine);
        }
        this.center = UnitUtils.avePos(realmarines);
        this.centerTile = this.center.equals(Position.INVALID) ? TilePosition.INVALID : new TilePosition(this.center);
        if (this.pathToGoal == null) {
            return;
        }
        if (this.pathToGoal.size() == 0) {
            return;
        }
        this.curGoalTile = this.pathToGoal.get(0);
        if (this.curGoalTile == null) {
            return;
        }
        this.pathfinder.drawPath(this.pathToGoal);
        if (this.center.getDistance(new Position(this.curGoalTile)) < 150.0 || Game.getInstance().getFrameCount() % 150 == 0) {
            this.pathToGoal.remove(0);
            if (this.pathToGoal.size() == 0) {
                return;
            }
            this.curGoalTile = this.pathToGoal.get(0);
        }
        this.cursorParticle.updateLocation(new Position(this.curGoalTile));
        this.cursorParticle.updateCenter(this.center);
        this.cursorParticle.setParallelField();
    }

    private void updateParticles() {
        for (Unit marine : this.marine_particle_map.keySet()) {
            this.marine_particle_map.get(marine).updateLocation(marine);
            this.marine_particle_map.get(marine).setAttactionField();
            this.marine_particle_map.get(marine).setJitterField();
            this.marine_particle_map.get(marine).setSheepField(this.center);
        }
    }

    public void moveMarines() {
        if (this.curGoalTile == null) {
            return;
        }
        for (Unit marine : this.marines) {
            Vector force = this.marine_particle_map.get(marine).getNetForce(this.allParticles);
            Vector v_toGo = new Vector(marine.getPosition()).add(force);
            Position p_toGo = v_toGo.toPosition();
            Position position = new Position(this.curGoalTile);
            if (marine.getPosition().getDistance(position) > 350.0) {
                p_toGo = new Position(this.curGoalTile);
            }
            Position position2 = new Position(this.curGoalTile);
            if (marine.getPosition().getDistance(position2) > 150.0 && marine.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE)) {
                marine.useTech(TechType.TANK_SIEGE_MODE);
                continue;
            }
            marine.attackMove(p_toGo);
        }
    }

    public void addMarine(Unit marine) {
        Particle particle = new Particle();
        this.marines.add(marine);
        this.marine_particle_map.put(marine, particle);
        this.allParticles.add(particle);
    }

    public void removeMarine(Unit marine) {
        this.marines.remove(marine);
        this.allParticles.remove(this.marine_particle_map.get(marine));
        this.marine_particle_map.remove(marine);
    }
}

