/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.Cerebrate;
import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Vector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Player;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import undermind.AStarSearch;
import undermind.micropacket.BeaconParticle;
import undermind.micropacket.Particle;

public class MarineClusterMovement
implements Cerebrate {
    Player me = Game.getInstance().self();
    HashSet<Unit> marines = new HashSet();
    HashMap<Unit, Particle> marine_particle_map = new HashMap();
    Set<Particle> allParticles = new HashSet<Particle>();
    Position center = null;
    TilePosition centerTile = null;
    TilePosition goalTile = null;
    TilePosition curGoalTile = null;
    public AStarSearch pathfinder = new AStarSearch();
    public List<TilePosition> pathToGoal;
    BeaconParticle cursorParticle = new BeaconParticle();

    public MarineClusterMovement() {
        this.allParticles.add(this.cursorParticle);
    }

    @Override
    public void onStart() {
    }

    public void setGoalPosition(TilePosition p) {
        if (this.centerTile == null) {
            return;
        }
        if (this.pathToGoal == null || p != null && !p.equals(this.goalTile)) {
            this.goalTile = p;
            this.pathToGoal = this.pathfinder.getPath(this.centerTile, this.goalTile);
        }
    }

    @Override
    public void onFrame() {
        if (this.centerTile != null) {
            Game.getInstance().drawCircleMap(Position.centerOfTile(this.centerTile), 2, Color.ORANGE, true);
        }
        if (Game.getInstance().getFrameCount() % 5 == 0) {
            this.updateParticles();
            this.updatePathing();
            this.moveMarines();
        }
    }

    private void updatePathing() {
        HashSet<Unit> realmarines = new HashSet<Unit>();
        for (Unit marine : this.marines) {
            if (!marine.isCompleted()) continue;
            realmarines.add(marine);
        }
        this.center = UnitUtils.closestWalkableAvePos(realmarines);
        this.centerTile = new TilePosition(this.center);
        if (this.pathToGoal == null) {
            return;
        }
        if (this.pathToGoal.size() == 0) {
            return;
        }
        this.curGoalTile = this.pathToGoal.get(0);
        if (this.curGoalTile == null) {
            return;
        }
        this.pathfinder.drawPath(this.pathToGoal);
        Position position = new Position(this.curGoalTile);
        if (this.center.getDistance(position) < 150.0) {
            this.pathToGoal.remove(0);
            if (this.pathToGoal.size() == 0) {
                return;
            }
            this.curGoalTile = this.pathToGoal.get(0);
        }
        this.cursorParticle.updateLocation(new Position(this.curGoalTile));
        this.cursorParticle.updateCenter(this.center);
        this.cursorParticle.setParallelField();
    }

    private void updateParticles() {
        for (Unit marine : this.marine_particle_map.keySet()) {
            this.marine_particle_map.get(marine).updateLocation(marine);
            this.marine_particle_map.get(marine).setAttactionField();
            this.marine_particle_map.get(marine).setJitterField();
            this.marine_particle_map.get(marine).setSheepField(this.center);
        }
    }

    private void moveMarines() {
        if (this.curGoalTile == null) {
            return;
        }
        for (Unit marine : this.marines) {
            Vector force = this.marine_particle_map.get(marine).getNetForce(this.allParticles);
            Vector v_toGo = new Vector(marine.getPosition()).add(force);
            Position p_toGo = v_toGo.toPosition();
            Position position = new Position(this.curGoalTile);
            if (marine.getPosition().getDistance(position) > 400.0) {
                p_toGo = new Position(this.curGoalTile);
            }
            marine.move(p_toGo);
        }
    }

    @Override
    public void onEnd(boolean isWinnerFlag) {
    }

    @Override
    public void onSendText(String text) {
    }

    @Override
    public void onReceiveText(Player player, String text) {
    }

    @Override
    public void onPlayerLeft(Player player) {
    }

    @Override
    public void onNukeDetect(Position position) {
    }

    @Override
    public void onUnitCreate(ROUnit unit) {
    }

    @Override
    public void onUnitDestroy(ROUnit unit) {
    }

    @Override
    public void onUnitHide(ROUnit unit) {
    }

    @Override
    public void onUnitShow(ROUnit unit) {
    }

    @Override
    public void onUnitMorph(ROUnit unit) {
    }

    @Override
    public void onUnitRenegade(ROUnit unit) {
    }

    @Override
    public void onDroppedConnection() {
    }

    public void addMarine(Unit marine) {
        Particle particle = new Particle();
        this.marines.add(marine);
        this.marine_particle_map.put(marine, particle);
        this.allParticles.add(particle);
    }

    public void removeMarine(Unit marine) {
        this.marines.remove(marine);
        this.allParticles.remove(this.marine_particle_map.get(marine));
        this.marine_particle_map.remove(marine);
    }
}

