/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Race;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.MicroManager;
import undermind.intelligence.RegionStatus;
import undermind.micropacket.GoliathSquad;
import undermind.micropacket.MarineMovement;
import undermind.micropacket.Squad;
import undermind.micropacket.TankSquad;
import undermind.micropacket.VultureSquad;

public class M3chSquad
extends Squad {
    public VultureSquad vulture_squad;
    public TankSquad tank_squad;
    public GoliathSquad goliath_squad;
    public ArrayList<Unit> vessels = new ArrayList();
    public MarineMovement mover;
    public Unit sacrificeVulture;
    boolean is_confident = true;
    double confidence = 1.0;
    double alpha = 1.0;

    public M3chSquad(MicroManager micro) {
        super(micro);
        this.type = "mech";
        this.unitTypes.add(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE);
        this.unitTypes.add(UnitType.TERRAN_SIEGE_TANK_TANK_MODE);
        this.unitTypes.add(UnitType.TERRAN_GOLIATH);
        this.unitTypes.add(UnitType.TERRAN_VULTURE);
        this.unitTypes.add(UnitType.TERRAN_SCIENCE_VESSEL);
        this.tank_squad = new TankSquad(this);
        this.vulture_squad = new VultureSquad(this);
        this.goliath_squad = new GoliathSquad(this);
        this.mover = new MarineMovement();
    }

    private boolean isConfident() {
        if (this.is_confident && this.update_and_get_confidence() > 0.2) {
            this.is_confident = false;
        }
        if (!this.is_confident && this.update_and_get_confidence() < 0.1) {
            this.is_confident = true;
        }
        return this.is_confident;
    }

    @Override
    public void onFrame() {
        if (!this.isConfident()) {
            Game.getInstance().drawTextMap(this.getMedian(), "danger " + this.confidence);
            this.tank_squad.onFrame();
            this.vulture_squad.onFrame();
            this.goliath_squad.onFrame();
        } else if (this.goal != null && this.getAverage().getDistance(this.goal) < 150.0) {
            Game.getInstance().drawTextMap(this.getMedian(), "safe, goal reached" + this.confidence);
            this.tank_squad.groupSiege();
            this.vulture_squad.moveTo(this.getAverage());
            this.goliath_squad.moveTo(this.getAverage());
        } else {
            Game.getInstance().drawTextMap(this.getMedian(), "safe, on the move" + this.confidence);
            this.mover.setGoalPosition(new TilePosition(this.goal));
            this.mover.onFrame();
        }
        this.doVesselMicro();
    }

    public Position getAverage() {
        return this.tank_squad.myTanks.size() > 0 ? UnitUtils.avePos(this.tank_squad.myTanks) : UnitUtils.avePos(this.myUnits);
    }

    private double update_and_get_confidence() {
        Set<ROUnit> close_enemies = this.everyNearbyGroundUnits();
        double theirVal = Utils.getValueRO(close_enemies);
        double ourVal = Utils.getValue(this.myUnits);
        double ratio = theirVal / (ourVal + 0.1);
        this.confidence = this.alpha * ratio + (1.0 - this.alpha) * this.confidence;
        return this.confidence;
    }

    public boolean canBust() {
        double theirVal;
        Set<ROUnit> theirMen = this.everyNearbyUnits();
        double myVal = Utils.getValue(this.myUnits);
        return myVal > 8.0 * (theirVal = Utils.getValueRO(theirMen));
    }

    public Position getMedian() {
        return this.tank_squad.myTanks.size() > 0 ? this.tank_squad.getMedian() : UnitUtils.medianPos(this.myUnits);
    }

    public Set<ROUnit> everyNearbyUnits() {
        Position median = this.getMedian();
        HashSet<ROUnit> ret = new HashSet<ROUnit>();
        for (RegionStatus rs : this.master.regionStatuses) {
            for (ROUnit rou : rs.enemies) {
                Position position = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
                Position rou_pos = position;
                if (!(rou_pos.getDistance(median) < 800.0)) continue;
                ret.add(rou);
            }
        }
        return ret;
    }

    public Set<ROUnit> everyNearbyGroundUnits() {
        Set<ROUnit> enemies = this.everyNearbyUnits();
        HashSet<ROUnit> ret = new HashSet<ROUnit>();
        for (ROUnit rou : enemies) {
            if (rou.isFlying()) continue;
            ret.add(rou);
        }
        return ret;
    }

    public Set<ROUnit> everyNearbyAirUnits() {
        Set<ROUnit> enemies = this.everyNearbyUnits();
        HashSet<ROUnit> ret = new HashSet<ROUnit>();
        for (ROUnit rou : enemies) {
            if (!rou.isFlying()) continue;
            ret.add(rou);
        }
        return ret;
    }

    public boolean tankThreat() {
        for (ROUnit u : this.everyNearbyUnits()) {
            if (!u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) && !u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addUnit(Unit u) {
        this.myUnits.add(u);
        this.mover.addMarine(u);
        if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) || u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
            this.tank_squad.addUnit(u);
        }
        if (u.getType().equals(UnitType.TERRAN_VULTURE)) {
            this.vulture_squad.addUnit(u);
        }
        if (u.getType().equals(UnitType.TERRAN_GOLIATH)) {
            this.goliath_squad.addUnit(u);
        }
        if (u.getType() == UnitType.TERRAN_SCIENCE_VESSEL) {
            this.vessels.add(u);
        }
    }

    @Override
    public void removeUnit(Unit u) {
        this.myUnits.remove(u);
        this.mover.removeMarine(u);
        if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) || u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
            this.tank_squad.removeUnit(u);
        }
        if (u.getType().equals(UnitType.TERRAN_VULTURE)) {
            this.vulture_squad.removeUnit(u);
        }
        if (u.getType().equals(UnitType.TERRAN_VULTURE)) {
            this.goliath_squad.removeUnit(u);
        }
        this.vessels.remove(u);
    }

    public void doVesselMicro() {
        Position medianpos = UnitUtils.medianPos(this.myUnits);
        if (this.myUnits.size() != 0 && (medianpos == null || medianpos == Position.INVALID)) {
            medianpos = ((Unit)this.myUnits.get(0)).getLastKnownPosition();
        }
        for (Unit v : this.vessels) {
            boolean good = false;
            for (ROUnit e : this.master.allVisibleEnemies) {
                if (medianpos == null || !(e.getDistance(medianpos) < 450.0) || e.isDetected()) continue;
                v.move(e.getPosition());
                good = true;
                break;
            }
            if (!good && medianpos != null) {
                v.move(medianpos);
            }
            if (v.getEnergy() <= 120) continue;
            for (Unit u : this.myUnits) {
                if (u.getPlayer() != this.master.mGame.self() || u.getDistance(v) >= 200 || u.getHitPoints() >= u.getType().maxHitPoints() - 20) continue;
                v.useTech(TechType.DEFENSIVE_MATRIX, u);
            }
            if (v.getEnergy() <= 75 || !Game.getInstance().self().hasResearched(TechType.EMP_SHOCKWAVE)) continue;
            ROUnit bestTarget = null;
            int bestValue = 0;
            for (ROUnit e : this.master.allVisibleEnemies) {
                if (e.getDistance(v) >= 500) continue;
                int value = 0;
                if (e.getType() == UnitType.PROTOSS_HIGH_TEMPLAR && e.getEnergy() > 50) {
                    value += 3;
                } else if (e.getType().isSpellcaster() && e.getEnergy() > 50) {
                    ++value;
                }
                for (ROUnit e2 : this.master.allVisibleEnemies) {
                    if (e2.getDistance(e) >= 50 || (e2.getType().getRace() != Race.PROTOSS || e2.getShields() <= 30) && !e2.getType().isSpellcaster()) continue;
                    ++value;
                }
                if (value <= bestValue) continue;
                bestValue = value;
                bestTarget = e;
            }
            if (bestTarget == null || bestValue <= 2) continue;
            v.useTech(TechType.EMP_SHOCKWAVE, bestTarget);
        }
    }
}

