/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import java.util.HashSet;
import java.util.Set;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.micropacket.EnemyUnit;
import undermind.micropacket.M3chSquad;

public class GoliathSquad {
    public static int acquisitionBonus = 0;
    Set<Unit> myGoliaths = new HashSet<Unit>();
    M3chSquad msquad;

    public void addUnit(Unit u) {
        this.myGoliaths.add(u);
    }

    public void removeUnit(Unit u) {
        this.myGoliaths.remove(u);
    }

    public GoliathSquad(M3chSquad m3chSquad) {
        this.msquad = m3chSquad;
    }

    public void onFrame() {
        for (Unit unit : this.myGoliaths) {
            double nearestDistance = Double.POSITIVE_INFINITY;
            ROUnit closestEnemy = UnitUtils.getClosest(unit, this.msquad.everyNearbyUnits());
            double closestEnemyd = UnitUtils.getClosestDistance(unit, this.msquad.everyNearbyUnits());
            Position medianpos = this.msquad.getMedian();
            if (this.msquad.everyNearbyUnits().size() != 0 && closestEnemy != null && (!closestEnemy.getType().isBuilding() && unit.getTilePosition().getDistance(closestEnemy.getPosition()) < (double)(7 + acquisitionBonus / 32) || closestEnemy.getType().isBuilding() && (closestEnemy.getType().canAttack() || closestEnemy.getType() == UnitType.TERRAN_BUNKER) && unit.getTilePosition().getDistance(closestEnemy.getPosition()) < 9.0) && (closestEnemy.getType().canAttack() || closestEnemy.getType().isSpellcaster())) {
                ROUnit targ = null;
                int bestprio = -1000;
                for (ROUnit ue : this.msquad.everyNearbyUnits()) {
                    if (ue.getDistance(unit) >= 450 + acquisitionBonus || this.msquad.master.getGPriority(ue, unit, false) <= bestprio || ue.getDistance(unit) >= 300 + acquisitionBonus) continue;
                    bestprio = this.msquad.master.getGPriority(ue, unit, false);
                    targ = ue;
                }
                for (ROUnit ue : this.msquad.master.enemyBuildings) {
                    if (ue.getDistance(unit) >= 550 || this.msquad.master.getGPriority(ue, unit, false) <= bestprio || ue.getDistance(unit) >= 300) continue;
                    bestprio = this.msquad.master.getGPriority(ue, unit, false);
                    targ = ue;
                }
                Unit k = unit.getTarget();
                if (targ != null && this.msquad.master.time % 20L == 0L && unit.getTarget() == null && unit.getOrderTarget() == null || targ != null && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID()) {
                    unit.rightClick(targ);
                    continue;
                }
                if (targ != null || k != null || unit.getOrderTarget() != null || !(closestEnemyd > 280.0)) continue;
                unit.attackMove(this.msquad.goal);
                continue;
            }
            double dist = unit.getTilePosition().getDistance(medianpos);
            double d2 = unit.getTargetPosition().getDistance(medianpos);
            if (dist > 4.0 && medianpos != null && medianpos != Position.INVALID) {
                if (!(d2 > 70.0)) continue;
                unit.attackMove(medianpos);
                continue;
            }
            unit.attackMove(this.msquad.goal);
        }
    }

    private Set<EnemyUnit> doFilter(Set<ROUnit> close_enemies) {
        HashSet<EnemyUnit> ret = new HashSet<EnemyUnit>();
        for (ROUnit rou : close_enemies) {
            Position p = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
            double dist = UnitUtils.getClosestDistance(p, this.msquad.tank_squad.myTanks);
            if (!(dist < 272.0) && !((double)rou.getGroundRange() <= dist) || rou.getType().equals(UnitType.PROTOSS_INTERCEPTOR)) continue;
            ret.add(new EnemyUnit(rou));
        }
        return ret;
    }

    public void moveTo(Position p) {
        for (Unit goliath : this.myGoliaths) {
            goliath.attackMove(p);
        }
    }
}

