/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import org.bwapi.proxy.model.DamageType;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitSizeType;
import org.bwapi.proxy.model.WeaponType;

public class EnemyUnit {
    double hp = 0.0;
    double sh = 0.0;
    double armor_hp = 0.0;
    double armor_sh = 0.0;
    ROUnit unit = null;

    public EnemyUnit(ROUnit unit) {
        this.unit = unit;
        this.synch();
    }

    public ROUnit getUnit() {
        return this.unit;
    }

    public void synch() {
        this.hp = this.unit.getHitPoints();
        this.sh = this.unit.getShields();
        this.armor_hp = this.unit.getArmor();
        this.armor_sh = this.unit.getShieldUpgradeLevel();
    }

    public void print() {
    }

    public double getLife() {
        return this.hp + this.sh;
    }

    public void getHit(Unit u) {
        double[] dmg = this.damageDealt(u);
        this.sh -= dmg[0];
        this.hp -= dmg[1];
    }

    public double[] damageDealt(Unit u) {
        double rawDamage = 0.0;
        WeaponType weapon = null;
        if (this.unit.isFlying()) {
            weapon = u.getType().airWeapon();
        }
        if (!this.unit.isFlying()) {
            weapon = u.getType().groundWeapon();
        }
        rawDamage = weapon.damageAmount();
        if (this.sh > 0.0) {
            double dmg_to_shield1 = Math.max(rawDamage - this.armor_sh, 0.5);
            if (dmg_to_shield1 < this.sh) {
                return new double[]{dmg_to_shield1, 0.0};
            }
            double dmg_to_shield = this.sh;
            double discount = 1.0;
            double remaining_damage = dmg_to_shield1 - dmg_to_shield;
            if (this.unit.getType().size().equals((Object)UnitSizeType.LARGE)) {
                if (weapon.damageType().equals((Object)DamageType.EXPLOSIVE)) {
                    discount = 1.0;
                }
                if (weapon.damageType().equals((Object)DamageType.NORMAL)) {
                    discount = 1.0;
                }
                if (weapon.damageType().equals((Object)DamageType.CONCUSSIVE)) {
                    discount = 0.25;
                }
            }
            if (this.unit.getType().size().equals((Object)UnitSizeType.MEDIUM)) {
                if (weapon.damageType().equals((Object)DamageType.EXPLOSIVE)) {
                    discount = 0.75;
                }
                if (weapon.damageType().equals((Object)DamageType.NORMAL)) {
                    discount = 1.0;
                }
                if (weapon.damageType().equals((Object)DamageType.CONCUSSIVE)) {
                    discount = 0.5;
                }
            }
            if (this.unit.getType().size().equals((Object)UnitSizeType.SMALL)) {
                if (weapon.damageType().equals((Object)DamageType.EXPLOSIVE)) {
                    discount = 0.5;
                }
                if (weapon.damageType().equals((Object)DamageType.NORMAL)) {
                    discount = 1.0;
                }
                if (weapon.damageType().equals((Object)DamageType.CONCUSSIVE)) {
                    discount = 1.0;
                }
            }
            double dmg_to_hp = Math.max(0.5, remaining_damage * discount - this.armor_hp);
            return new double[]{dmg_to_shield, dmg_to_hp};
        }
        return new double[]{0.0, u.getDamagePerShot(this.unit)};
    }
}

