/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.UnitUtils;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.TechType;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.MicroManager;
import undermind.intelligence.RegionStatus;
import undermind.micropacket.Squad;
import undermind.micropacket.Vulture;

public class DroppedUnits
extends Squad {
    public Unit dropship;
    public List<Vulture> vulture_squad;
    public List<Unit> tank_squad;
    public List<Unit> marine_squad;
    public List<Unit> medic_squad;
    public boolean suicidal = false;
    public Random rgen = new Random();

    public DroppedUnits(MicroManager m, Unit drop) {
        super(m);
        this.master = m;
        this.dropship = drop;
        this.tank_squad = new ArrayList<Unit>();
        this.vulture_squad = new ArrayList<Vulture>();
        this.marine_squad = new ArrayList<Unit>();
        this.medic_squad = new ArrayList<Unit>();
    }

    @Override
    public void onFrame() {
        Game.getInstance().drawCircleMap(this.goal, 8, Color.RED, true);
        this.suicidal = Utils.getValueRO(this.everyNearbyUnits()) > Utils.getValue(this.myUnits) * 1.2;
        this.vultureMicro();
        this.tankMicro();
        this.marineMicro();
    }

    public void vultureMicro() {
        for (Vulture vulture : this.vulture_squad) {
            --vulture.timeNeeded;
            if (vulture.timeNeeded > 0) continue;
            Unit unit = vulture.unit;
            if (unit.getSpiderMineCount() > 1) {
                Position minePlace = unit.getPosition();
                boolean tries = false;
                unit.useTech(TechType.SPIDER_MINES, minePlace);
                vulture.timeNeeded = 35;
                continue;
            }
            ROUnit targ = null;
            int bestprio = -1000;
            int tolerance = 250;
            for (ROUnit u : this.master.allVisibleEnemies) {
                if (!(u.getDistance(this.goal) < (double)tolerance) || this.getPriority(u, this.vulture_squad.get((int)0).unit, false) <= bestprio) continue;
                bestprio = this.getPriority(u, this.vulture_squad.get((int)0).unit, false);
                targ = u;
            }
            for (ROUnit u : this.master.enemyBuildings) {
                if (!(u.getDistance(this.goal) < (double)tolerance) || this.getPriority(u, this.vulture_squad.get((int)0).unit, false) <= bestprio) continue;
                bestprio = this.getPriority(u, this.vulture_squad.get((int)0).unit, false);
                targ = u;
            }
            if (targ != null && this.master.time % 20L == 0L && unit.getTarget() == null && unit.getOrderTarget() == null || targ != null && bestprio >= 0 && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID()) {
                unit.rightClick(targ);
                continue;
            }
            if (this.master.time % 20L != 0L || !(unit.getDistance(this.goal) > 450.0) && targ != null) continue;
            unit.move(this.goal);
        }
    }

    public void marineMicro() {
        if (this.marine_squad.size() == 0) {
            return;
        }
        ROUnit targ = null;
        int bestprio = -1000;
        int tolerance = 250;
        for (ROUnit rOUnit : this.master.allVisibleEnemies) {
            if (!(rOUnit.getDistance(this.goal) < (double)tolerance) || this.getPriority(rOUnit, this.marine_squad.get(0), false) <= bestprio) continue;
            bestprio = this.getPriority(rOUnit, this.marine_squad.get(0), false);
            targ = rOUnit;
        }
        for (ROUnit rOUnit : this.master.enemyBuildings) {
            if (!(rOUnit.getDistance(this.goal) < (double)tolerance) || this.getPriority(rOUnit, this.marine_squad.get(0), false) <= bestprio) continue;
            bestprio = this.getPriority(rOUnit, this.marine_squad.get(0), false);
            targ = rOUnit;
        }
        for (Unit unit : this.marine_squad) {
            if (unit.getHitPoints() > 30 && !unit.isStimmed() && this.master.time % 20L == 0L) {
                unit.useTech(TechType.STIM_PACKS);
            }
            if (targ != null && this.master.time % 20L == 0L && unit.getTarget() == null && unit.getOrderTarget() == null || targ != null && bestprio >= 0 && unit.getTarget() != null && unit.getTarget().getID() != targ.getID() && unit.getOrderTarget() != null && unit.getOrderTarget().getID() != targ.getID()) {
                unit.rightClick(targ);
                continue;
            }
            if (this.master.time % 20L != 0L || !(unit.getDistance(this.goal) > 350.0) && targ != null) continue;
            unit.attackMove(this.goal);
        }
        for (Unit unit : this.medic_squad) {
            if (!unit.isIdle()) continue;
            unit.patrol(UnitUtils.getClosest(unit.getPosition(), this.marine_squad).getPosition());
        }
    }

    public void tankMicro() {
        for (Unit t : this.tank_squad) {
            if (t.isSieged()) continue;
            t.siege();
        }
    }

    @Override
    public void addUnit(Unit u) {
        this.myUnits.add(u);
        if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) || u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
            this.tank_squad.add(u);
        }
        if (u.getType().equals(UnitType.TERRAN_VULTURE)) {
            this.vulture_squad.add(new Vulture(u));
        }
        if (u.getType().equals(UnitType.TERRAN_MARINE)) {
            this.marine_squad.add(u);
        }
        if (u.getType().equals(UnitType.TERRAN_MEDIC)) {
            this.medic_squad.add(u);
        }
    }

    @Override
    public void removeUnit(Unit u) {
        if (u == null) {
            return;
        }
        this.myUnits.remove(u);
        if (u.getType().equals(UnitType.TERRAN_SIEGE_TANK_SIEGE_MODE) || u.getType().equals(UnitType.TERRAN_SIEGE_TANK_TANK_MODE)) {
            this.tank_squad.remove(u);
        }
        if (u.getType().equals(UnitType.TERRAN_MEDIC)) {
            this.medic_squad.remove(u);
        }
        if (u.getType().equals(UnitType.TERRAN_VULTURE)) {
            Vulture tr = null;
            for (Vulture v : this.vulture_squad) {
                if (v.unit.getID() != u.getID()) continue;
                tr = v;
                break;
            }
            if (tr != null) {
                this.vulture_squad.remove(tr);
            }
        }
    }

    public Position getMedian() {
        return this.tank_squad.size() > 0 ? UnitUtils.medianPos(this.tank_squad) : UnitUtils.medianPos(this.myUnits);
    }

    public Set<ROUnit> everyNearbyUnits() {
        Position median = this.getMedian();
        HashSet<ROUnit> ret = new HashSet<ROUnit>();
        for (RegionStatus rs : this.master.regionStatuses) {
            for (ROUnit rou : rs.enemies) {
                Position position = rou.isVisible() ? rou.getPosition() : rou.getLastKnownPosition();
                Position rou_pos = position;
                if (!(rou_pos.getDistance(median) < 800.0)) continue;
                ret.add(rou);
            }
        }
        return ret;
    }

    public int getPriority(ROUnit u, Unit me, boolean harass) {
        if (this.suicidal) {
            UnitType t = u.getType();
            if (t.isWorker() || t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) {
                return 10;
            }
            if (t == UnitType.PROTOSS_INTERCEPTOR) {
                return -10;
            }
            if (t.isResourceDepot()) {
                return 6;
            }
            if (t.isBuilding()) {
                return 1;
            }
            if (t == UnitType.ZERG_SUNKEN_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) {
                return -10;
            }
            if (u.canAttack(me)) {
                return 4;
            }
            if (t.canAttack()) {
                return 2;
            }
            return 0;
        }
        UnitType t = u.getType();
        if (t.isWorker() || t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) {
            return 7;
        }
        if (t == UnitType.ZERG_SUNKEN_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) {
            return -10;
        }
        if (t == UnitType.PROTOSS_INTERCEPTOR) {
            return -10;
        }
        if (t.isResourceDepot()) {
            return 5;
        }
        if (u.canAttack(me)) {
            return 8;
        }
        if (t.canAttack()) {
            return 2;
        }
        if (t.isBuilding()) {
            return 1;
        }
        return 0;
    }
}

