/*
 * Decompiled with CFR 0.152.
 */
package undermind.micropacket;

import edu.berkeley.nlp.starcraft.util.Counter;
import edu.berkeley.nlp.starcraft.util.Utils;
import java.util.List;
import org.bwapi.proxy.model.Bwta;
import org.bwapi.proxy.model.Color;
import org.bwapi.proxy.model.Game;
import org.bwapi.proxy.model.Position;
import org.bwapi.proxy.model.ROUnit;
import org.bwapi.proxy.model.Region;
import org.bwapi.proxy.model.TilePosition;
import org.bwapi.proxy.model.Unit;
import org.bwapi.proxy.model.UnitType;
import undermind.MicroManager;
import undermind.intelligence.RegionStatus;
import undermind.micropacket.Squad;

public class DropSquad {
    public Unit dropship;
    public Squad squad;
    public int dropsize = 2;
    public int droptime = 0;
    public boolean beenfull = false;
    public boolean loaded;
    public int oldhp;
    TilePosition originalDropSpot = new TilePosition(1, 1);
    TilePosition dropSpot = new TilePosition(1, 1);
    public static int frags = 0;
    public static double fails = 0.0;
    MicroManager master;
    TilePosition currentGoal;
    List<TilePosition> pathToGoal;
    Region targetRegion;
    Bwta myBwta;

    public DropSquad(Unit d, MicroManager m, Squad s) {
        this.dropship = d;
        this.master = m;
        this.squad = s;
        this.myBwta = Bwta.getInstance();
    }

    public void onFrame() {
        if (this.beenfull) {
            ++this.droptime;
        }
        this.adjustGoal();
        if ((this.pathToGoal == null || this.master.time % 10L == 0L || this.pathToGoal.size() == 0) && this.dropship.getLoadedUnits().size() != 0) {
            this.pathToGoal = this.master.dropSearch.getPath(this.dropship.getTilePosition(), this.dropSpot);
        }
        if (this.pathToGoal != null && this.dropship.getLoadedUnits().size() != 0) {
            this.master.dropSearch.drawPath(this.pathToGoal);
            this.master.mGame.drawCircleMap(new Position(this.dropSpot), 11, Color.PURPLE, false);
        }
        if (this.pathToGoal != null) {
            ROUnit nextBomb = null;
            if (this.dropship.getLoadedUnits().size() != 0) {
                nextBomb = this.dropship.getLoadedUnits().iterator().next();
                if (this.dropship.getLoadedUnits().size() >= this.dropsize) {
                    this.loaded = true;
                    this.beenfull = true;
                }
            } else {
                this.loaded = false;
            }
            if (this.loaded) {
                this.currentGoal = this.pathToGoal.size() > 1 ? this.pathToGoal.get(1) : this.pathToGoal.get(0);
                Game.getInstance().drawCircleMap(Position.centerOfTile(this.currentGoal), 9, Color.RED, false);
                if (this.currentGoal.equals(this.dropSpot)) {
                    this.dropship.unload(nextBomb);
                } else if (this.dropship.getHitPoints() < 20 || this.dropship.getHitPoints() < this.oldhp && this.dropship.getHitPoints() < 70 && this.targetRegion.contains(this.dropship.getTilePosition())) {
                    this.dropship.unload(nextBomb);
                } else if (this.dropship.getLoadedUnits().size() > 0) {
                    if (this.dropship.getTilePosition().getDistance(this.currentGoal) < 6.0) {
                        this.pathToGoal.remove(0);
                        if (this.pathToGoal.size() > 1) {
                            this.currentGoal = this.pathToGoal.get(1);
                        } else if (this.pathToGoal.size() > 0) {
                            this.currentGoal = this.pathToGoal.get(0);
                        }
                    }
                    this.dropship.move(this.currentGoal);
                }
            }
        }
        this.oldhp = this.dropship.getHitPoints();
        for (Unit u : this.squad.myUnits) {
            if (!(u.getTilePosition().getDistance(this.dropSpot) < 8.0)) continue;
            this.squad.onFrame();
            break;
        }
    }

    public void setDropSpot(TilePosition tp) {
        this.originalDropSpot = tp;
        this.dropSpot = tp;
        for (Region r : this.myBwta.getRegions()) {
            if (!r.contains(this.dropSpot)) continue;
            this.targetRegion = r;
            break;
        }
    }

    public TilePosition getDropSpot() {
        return this.dropSpot;
    }

    public int getPriority(ROUnit u, Unit me, boolean harass) {
        UnitType t = u.getType();
        if (t.isWorker() || t == UnitType.TERRAN_SCV || t == UnitType.ZERG_DRONE || t == UnitType.PROTOSS_PROBE) {
            return 10;
        }
        if (t == UnitType.PROTOSS_INTERCEPTOR) {
            return -10;
        }
        if (t == UnitType.ZERG_SUNKEN_COLONY || t == UnitType.PROTOSS_PHOTON_CANNON || t == UnitType.TERRAN_BUNKER || t == UnitType.TERRAN_MISSILE_TURRET) {
            return -1;
        }
        if (u.canAttack(me)) {
            return 4;
        }
        if (t.canAttack()) {
            return 2;
        }
        return 0;
    }

    public void adjustGoal() {
        if (this.dropSpot == null) {
            return;
        }
        TilePosition newpos = this.getBestDrop(this.originalDropSpot);
        if (newpos.getDistance(this.dropSpot) > 3.0) {
            this.dropSpot = newpos;
        }
    }

    public TilePosition getBestDrop(TilePosition tp) {
        Counter<TilePosition> threats = new Counter<TilePosition>();
        int tolerance = 4;
        for (int dx = -tolerance; dx < tolerance; ++dx) {
            for (int dy = -tolerance; dy < tolerance; ++dy) {
                TilePosition newtp = new TilePosition(tp.x() + dx, tp.y() + dy);
                threats.setCount(newtp, 1.0);
            }
        }
        double threat = 0.0;
        for (ROUnit bldg : this.master.enemyBuildings) {
            if (!bldg.getType().canAttack() && bldg.getType() != UnitType.TERRAN_BUNKER) continue;
            for (TilePosition tp2 : threats.keySet()) {
                threats.incrementCount(tp2, 15.0 / (1.0 + bldg.getLastKnownTilePosition().getDistance(tp2)));
            }
        }
        for (RegionStatus rs : this.master.regionStatuses) {
            for (ROUnit en : rs.enemies) {
                if (!en.getType().canAttack() || en.getType().isWorker()) continue;
                for (TilePosition tp2 : threats.keySet()) {
                    threats.incrementCount(tp2, 15.0 / (1.0 + en.getLastKnownTilePosition().getDistance(tp2)));
                }
            }
        }
        TilePosition best = null;
        double lowest = Double.POSITIVE_INFINITY;
        for (TilePosition eligible : threats.keySet()) {
            if (!Utils.isWalkable(eligible) || !Utils.tileClear(eligible) || !(threats.getCount(eligible) < lowest)) continue;
            lowest = threats.getCount(eligible);
            best = eligible;
        }
        if (best == null) {
            best = tp;
        }
        return best;
    }
}

